const system = require("../../../system");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
class TxPushLogService extends ServiceBase {
  constructor() {
    super("common", ServiceBase.getDaoName(TxPushLogService));
    this.orderProductDao = system.getObject("db.order.orderProductDao");
    this.orderInfoDao = system.getObject("db.order.orderInfoDao");

  }

  returnTX(status, componentName, message, data) {
    return {
      "version": 1,
      "componentName": componentName,
      "returnValue": status,
      "returnCode": status,
      "timestamp": Date.now(),
      "returnMessage": message,
      "data": data
    }

  }

  //发货回调
  async createCbsInstance(pobj, req) {
    var self = this;
    if (!pobj.interface.para.dealName) {
      return self.returnTX(-1, "cgateway", "参数错误", null)
    }
    try {
      var loginfo = await this.findOne({ deal_name: pobj.interface.para.dealName, push_action_type: "orderPayNotify" });
      if (loginfo) {
        return self.returnTX(0, "cgateway", "ok", { "flowId": loginfo.flow_id, "resourceIds": [pobj.interface.para.dealName] })
      }
      var flow_id = await Date.now();
      var newobj = {
        flow_id: flow_id,
        deal_name: pobj.interface.para.dealName,
        request_url: "qcloud.PRODUCT_NAME.createResource",
        requestjson: pobj,
        push_url: "/api/action/order/springBoard",
        push_action_type: "orderPayNotify",
        push_status: "2",
      }
      var creatlog = await this.create(newobj);
      if (!creatlog) {
        return self.returnTX(-1, "cgateway", "参数错误", null)
      }
      pobj.logId = creatlog.dataValues.id;
      var pushobj = {
        "actionType": "produceData",// Y 功能名称
        "actionBody": {
          notifyUrl: "",
          actionType: "orderPayNotify",
          pushUrl: "http://brguser-dev.brg.tencentyun.com/api/action/order/springBoard",
          messageBody: pobj,
          identifyCode: "orderPayNotify"
        }
      };
      var a = await this.execPostByTimeOut(req, pushobj, settings.opPushUrl());

      return self.returnTX(0, "cgateway", "ok", { "flowId": creatlog.flow_id, "resourceIds": [pobj.interface.para.dealName] })
    } catch (e) {
      this.execClient.execLogs("txPushLogSve.js/createCbsInstance方法出现异常", { params: orderNum }, "txPushLogSve_createCbsInstance_error", null, e.stack);
      return this.returnTX(-1, "cgateway", "请求失败", null)
    }

  }

  //发货检查
  async queryFlow(pobj) {
    var self = this;
    if (!pobj.interface.para.flowId) {
      return self.returnTX(-1, "cgateway", "参数错误", null)
    }
    var loginfo = await this.findOne({ flow_id: pobj.interface.para.flowId, push_action_type: "orderPayNotify" });
    if (!loginfo) {
      return self.returnTX(-1, "cgateway", "产品不存在", null)
    }
    var orderInfo = await this.orderInfoDao.findOne({ order_num: loginfo.dataValues.deal_name });
    if (!orderInfo) {
      return self.returnTX(-1, "cgateway", "资源不存在", null)
    }
    var status = 2;
    if (orderInfo.status == 320) {
      status = 3;
    }
    if (orderInfo.status == 300) {
      status = 0;
    }
    return self.returnTX(0, "cgateway", "ok", { "status": status })
  }


  //资源拉取
  async queryResources(pobj) {
    var self = this;
    if (!pobj.interface.para.resourceIds[0]) {
      return self.returnTX(-1, "cgateway", "参数错误", null)
    }
    var resources = [];
    for (let i = 0; i < pobj.interface.para.resourceIds.length; i++) {
      var orderProduct = await this.orderProductDao.findOne({ order_num: pobj.interface.para.resourceIds[i] });
      if (!orderProduct) {
        return self.returnTX(-1, "cgateway", "资源不存在", null)
      }
      var resource = {
        "appId": orderProduct.tx_order_snapshot.appId,
        "uin": orderProduct.tx_order_snapshot.ownerUin,
        "resourceId": pobj.interface.para.resourceIds[i],//站内信自定义字段层级和此字段同一层级
        "projectId": 0,
        "autoRenewFlag": 0,
        "region": 1,
        "zoneId": orderProduct.tx_order_snapshot.zoneId,
        "status": orderProduct.status,
        "payMode": 1,		// 必传，1预付费 0后付费
        "isolatedTimestamp": orderProduct.isolated_timestamp || "0000-00-00 00:00:00",
        "createTime": orderProduct.start_time,
        "expireTime": orderProduct.end_time || "0000-00-00 00:00:00",
        "goodsDetail": orderProduct.tx_order_snapshot.goodsDetail
      }
      resources.push(resource);
    }
    return self.returnTX(0, "cgateway", "ok", { "resources": resources })
  }

  //用户所有资源拉取
  async queryUserResources(pobj) {
    var self = this;
    if (!pobj.interface.para.uin) {
      return self.returnTX(-1, "cgateway", "参数错误", null)
    }
    var orderProduct = await this.orderProductDao.findAndCountAll({
      search: {
        user_id: pobj.interface.para.uin
      },
      pageInfo: {
        pageNo: Number(pobj.interface.para.pageNo) || 1,
        pageSize: Number(pobj.interface.para.pageSize) || 1000
      }
    });
    if (orderProduct.count < 1) {
      return self.returnTX(-1, "cgateway", "资源不存在", null)
    }
    var resources=[];
    for (let i = 0; i < orderProduct.rows.length; i++) {
      const resource = {
        "appId": orderProduct.rows[i].tx_order_snapshot.appId,
        "uin": orderProduct.rows[i].tx_order_snapshot.ownerUin,
        "resourceId": orderProduct.rows[i].order_num,//站内信自定义字段层级和此字段同一层级
        "projectId": 0,
        "autoRenewFlag": 0,
        "region": 1,
        "zoneId": orderProduct.rows[i].tx_order_snapshot.zoneId,
        "status": orderProduct.status,
        "payMode": 1,		// 必传，1预付费 0后付费
        "isolatedTimestamp": orderProduct.rows[i].isolated_timestamp || "0000-00-00 00:00:00",
        "createTime": orderProduct.rows[i].start_time,
        "expireTime": orderProduct.rows[i].end_time || "0000-00-00 00:00:00",
        "goodsDetail": orderProduct.rows[i].tx_order_snapshot.goodsDetail
      }
      resources.push(resource);
    }
    return self.returnTX(0, "cgateway", "ok", { "total": orderProduct.count, "resources": resources })
  }

  //隔离资源
  async isolateResource(pobj) {
    var self = this;
    if (!pobj.interface.para.resourceId) {
      return self.returnTX(-1, "mall_logic", "参数错误", null)
    }
    var orderProduct = await this.orderProductDao.findOne({ order_num: pobj.interface.para.resourceId });
    if (!orderProduct) {
      return self.returnTX(-1, "mall_logic", "资源不存在", null)
    }
    if (orderProduct.dataValues.status == 2) {
      return self.returnTX(0, "mall_logic", "ok", null)
    }
    if (orderProduct.dataValues.status == 3) {
      return self.returnTX(-1, "mall_logic", "资源已销毁", null)
    }
    await this.orderProductDao.update({ id: orderProduct.dataValues.id, status: 2, isolated_time: new Date() });
    return self.returnTX(0, "mall_logic", "ok", null)

  }

  //销毁资源
  async destroyResource(pobj) {
    var self = this;
    if (!pobj.interface.para.resourceId) {
      return self.returnTX(-1, "mall_logic", "参数错误", null)
    }
    var orderProduct = await this.orderProductDao.findOne({ order_num: pobj.interface.para.resourceId });
    if (!orderProduct) {
      return self.returnTX(-1, "mall_logic", "资源不存在", null)
    }
    if (orderProduct.dataValues.status == 1) {
      return self.returnTX(-1, "mall_logic", "资源未隔离", null)
    }
    if (orderProduct.dataValues.status == 3) {
      return self.returnTX(0, "mall_logic", "资源已销毁", null)
    }
    var flow_id = await this.getBusUid("f");
    var newobj = {
      flow_id: flow_id,
      deal_name: pobj.interface.para.resourceId,
      request_url: "qcloud.PRODUCT_NAME.destroyResource",
      requestjson: pobj,
      push_url: "",
      push_action_type: "",
      push_status: "2",
    }
    var creatlog = await this.create(newobj);
    if (!creatlog) {
      return self.returnTX(-1, "mall_logic", "请求错误", null)
    }
    await this.orderProductDao.update({ id: orderProduct.dataValues.id, status: 3 });
    return self.returnTX(0, "mall_logic", "ok", { flowId: flow_id })

  }

  //新购参数检查
  async checkCreate(pobj) {
    var self = this;
    if (!pobj.interface || !pobj.interface.para || !pobj.interface.para.goodsDetail) {
      return self.returnTX(-1, "qcloud_domain_register", "参数错误", null)
    }
    if (pobj.interface.para.goodsDetail.goodsNum > 1) {
      return this.returnTX(0, "qcloud_domain_register", "ok", { "status": 2 })
    }

    return this.returnTX(0, "qcloud_domain_register", "ok", { "status": 0 })
  }





}
module.exports = TxPushLogService;
