var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ProductAPI extends APIBase {
    constructor() {
        super();
        this.trademarkTransactionSve = system.getObject("service.tm.trademarktransactionSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "tmBatchUpload": // 2020 0901 lin 新增 标源批传
                opResult = await this.trademarkTransactionSve.tmBatchUpload(pobj, pobj.actionBody);
                break;
            case "tmInfo": // 2020 0903 lin 新增 标原管理
                opResult = await this.trademarkTransactionSve.tmInfo(pobj, pobj.actionBody);
                break;
            case "forceUpdate":
                opResult = await this.trademarkTransactionSve.forceUpdate(pobj, pobj.actionBody);
                break;
            case "tmListInfo": // 2020 0903 lin 新增 标原管理
                opResult = await this.trademarkTransactionSve.tmListInfo(pobj, pobj.actionBody);
                break;
            case "tmDetail": // 2020 0903 lin 新增 标原详情
                opResult = await this.trademarkTransactionSve.tmDetail(pobj, pobj.actionBody);
                break;
            case "tmStatusUpdate": // 2020 0903 lin 新增 状态修改
                opResult = await this.trademarkTransactionSve.tmStatusUpdate(pobj, pobj.actionBody);
                break;
            case "tmInfoUpdate": // 2020 0903 lin 新增 商标信息修改
                opResult = await this.trademarkTransactionSve.tmInfoUpdate(pobj, pobj.actionBody);
                break;
            case "tmInfoDelete": // 2020 0903 lin 新增 标源管理删除
                opResult = await this.trademarkTransactionSve.tmInfoDelete(pobj, pobj.actionBody);
                break;
            case "tmTrademarkTypeUpdate": // 2020 0917 lin 新增 批量设置类型
                opResult = await this.trademarkTransactionSve.tmTrademarkTypeUpdate(pobj, pobj.actionBody);
                break;
            case "createjsonfile": // 2020 0908 lin 新增 json文件生成 
                opResult = await this.trademarkTransactionSve.createjsonfile();
                break;
            case "tmStatusCheck": // 2020 0911 lin 新增 上架状态查询
                opResult = await this.trademarkTransactionSve.tmStatusCheck(pobj, pobj.actionBody);
                break;
            case "tmStatus": // 2020 0911 lin 新增 上架状态查询
                opResult = await this.trademarkTransactionSve.tmStatusCheck(pobj, pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = ProductAPI;