const system = require("../../../system");
const ServiceBase = require("../../sve.base");
var xl = require('xlsx');
class PolicyinfoService extends ServiceBase {
  constructor() {
    super("dbpolicy", ServiceBase.getDaoName(PolicyinfoService));
  }

  //政策统计计数
  async policyTypeCount(pobj){
    var obj = pobj.actionBody;
    var app = pobj.appInfo;
    var paramObj={uapp_id:app.uapp_id};                                                     
    var attributes =["id","policyType","policyTypeName","policyDate","policyCity","policyProvince",
    "policyLinkUrl","policySource","policyName","policyNo"];
    if(obj){
      if(obj.policyProvince){
        paramObj["policyProvince"]=obj.policyProvince;
        if(obj.policyCity){
          paramObj["policyCity"]=obj.policyCity;
        }
      }
      if(obj.policyName){
        paramObj[this.db.Op.or]=[
          {policyName:{ [this.db.Op.like]: "%" + obj.policyName + "%" }},
          {policyContent:{ [this.db.Op.like]: "%" + obj.policyName + "%" }}
        ];
      }
      console.log(paramObj);
    }
    var result = {};
    //"policy_type":{'fzbt':'租金减免','jrdk':'金融贷款','zdfc':'扶持措施','ssjm':'税收优惠','rlzy':'人力资源'},
    var rlzy=await this.findByParams("rlzy",paramObj,attributes);
    var fzbt=await this.findByParams("fzbt",paramObj,attributes);
    var jrdk=await this.findByParams("jrdk",paramObj,attributes);
    var zdfc=await this.findByParams("zdfc",paramObj,attributes);
    var ssjm=await this.findByParams("ssjm",paramObj,attributes);
    result["rlzy"]= rlzy.length || 0;
    result["fzbt"]= fzbt.length || 0;
    result["jrdk"]= jrdk.length || 0;
    result["zdfc"]= zdfc.length || 0;
    result["ssjm"]= ssjm.length || 0;
    return  system.getResultSuccess(result);
  }
    //政策检索
  async policyQuery(pobj){
    var obj = pobj.actionBody;
    var app = pobj.appInfo;
    var paramObj={uapp_id:app.uapp_id};                                                     
    var attributes =["id","policyType","policyTypeName","policyDate","policyCity","policyProvince",
    "policyLinkUrl","policySource","policyName","policyNo"];
    if(obj){
      if(obj.policyProvince){
        paramObj["policyProvince"]=obj.policyProvince;
        if(obj.policyCity){
          paramObj["policyCity"]=obj.policyCity;
        }
      }
      if(obj.policyName){
        paramObj[this.db.Op.or]=[
          {policyName:{ [this.db.Op.like]: "%" + obj.policyName + "%" }},
          {policyContent:{ [this.db.Op.like]: "%" + obj.policyName + "%" }}
        ];
      }
      console.log(paramObj);
    }
    var result = {};
    //"policy_type":{'fzbt':'租金减免','jrdk':'金融贷款','zdfc':'扶持措施','ssjm':'税收优惠','rlzy':'人力资源'},
    result["rlzy"]=await this.findByParams("rlzy",paramObj,attributes);
    result["fzbt"]=await this.findByParams("fzbt",paramObj,attributes);
    result["jrdk"]=await this.findByParams("jrdk",paramObj,attributes);
    result["zdfc"]=await this.findByParams("zdfc",paramObj,attributes);
    result["ssjm"]=await this.findByParams("ssjm",paramObj,attributes);
    return  system.getResultSuccess(result);
  }
  //政策检索(根据政策类型检索)
  async policyTypeQuery(pobj){
    var obj = pobj.actionBody;
    var app = pobj.appInfo;
    var paramObj={uapp_id:app.uapp_id};                                                     
    var attributes =["id","policyType","policyTypeName","policyDate","policyCity","policyProvince",
    "policyLinkUrl","policySource","policyName","policyNo"];
    if(!obj || !obj.policyType){
      return system.getResult(null,"政策类型不能为空");
    }
    if(obj.policyProvince){
      paramObj["policyProvince"]=obj.policyProvince;
      if(obj.policyCity){
        paramObj["policyCity"]=obj.policyCity;
      }
    }
    if(obj.policyName){
      paramObj[this.db.Op.or]=[
        {policyName:{ [this.db.Op.like]: "%" + obj.policyName + "%" }},
        {policyContent:{ [this.db.Op.like]: "%" + obj.policyName + "%" }}
      ];
    }
    console.log(paramObj);
    var result = null;
    //"policy_type":{'fzbt':'租金减免','jrdk':'金融贷款','zdfc':'扶持措施','ssjm':'税收优惠','rlzy':'人力资源'},
    result=await this.findByParams(obj.policyType,paramObj,attributes);
    return  system.getResultSuccess(result);
  }
  async findByParams(type,paramObj,attributes){
    paramObj.policyType=type;
    return await this.dao.model.findAll({
      where:paramObj,raw:true,attributes:attributes,
      order:[["id", "DESC"]]
    });
  }

  async addPolicyByExcel(){
    var workbook = xl.readFile("policy.xls");
    const sheetNames = workbook.SheetNames; // 返回 ['sheet1', 'sheet2']
    const worksheet = workbook.Sheets[sheetNames[0]];
    var dataa =xl.utils.sheet_to_json(worksheet);
    var arr = [];
    var that=this;
    await this.db.transaction(async function (t) {
      for(var i=0;i<dataa.length;i++){
        var data = dataa[i];
        var pobj = {
          uapp_id:26,policyNo:data['政策编号'],policyName:data['政策名称'],
          policySource:data['政策出处'],policyLinkUrl:data['政策链接'],
          policyProvince:data['所属省份'],policyCity:data['所属城市'],
          policyTypeName:data['政策类型'],policyContent:data['备注'] || ""};
        if(data['政策类型']){
          var policy_type ={'租金减免':'fzbt','金融贷款':'jrdk','行政措施':'zdfc','税收优惠':'ssjm','人力资源':'rlzy'};
          var typename = data['政策类型'];
          if(policy_type[typename]){
            pobj["policyType"]=policy_type[typename];
          }
        }
        if(pobj.policyNo){
          var a = await that.dao.create(pobj,t);
          arr.push(pobj);
        }
      }
    })
    console.log(arr[0],"###################################");
    console.log(arr.length,"###################################");
  }
}
module.exports = PolicyinfoService;
// var task = new PolicyinfoService();
// task.addPolicyByExcel().then(d=>{
//   console.log("----------end-------------------------");
// })