const system = require("../../../system");
const Dao = require("../../dao.base");
class OrderReceiptVoucherDao extends Dao {
  constructor() {
    super(Dao.getModelName(OrderReceiptVoucherDao));
  }
  async getItemByOrderNo(orderNo, uapp_id) {
    return await this.model.findOne({
      where: {
        sourceOrderNo: orderNo, uapp_id: uapp_id, auditStatus: "dsh"
      },
      attributes: [
        "id",
        "uapp_id",
        "sourceOrderNo",
        "accountType",
        "accountTypeName",
        "payDate",
        "totalSum",
        "payOrderNo",
        "buyerOpenId",
        "passTradeNo",
        "buyerAliLogonId",
        "certifyFileUrl",
        "wxPayOrderCode",
        "aliPayOrderCode",
        "busPayOrderCode",
        "auditStatusName",
        "auditStatus"],
      raw: true
    });
  }
}
module.exports = OrderReceiptVoucherDao;
