const system = require("../../../system");
const Dao = require("../../dao.base");
class OrderProductDao extends Dao {
  constructor() {
    super(Dao.getModelName(OrderProductDao));
  }
  async getItemByOrderNo(orderNo, uapp_id) {
    return await this.model.findOne({
      where: {
        sourceOrderNo: orderNo, uapp_id: uapp_id
      },
      attributes: [
        "sourceOrderNo",
        "productType_id",
        "pathCode",
        "itemCode",
        "itemName",
        "channelItemCode",
        "channelItemName",
        "serviceItemCode",
        "payAfterJumpH5Url",
        "payAfterJumpPcUrl",
        "picUrl",
        "price",
        "quantity",
        "serviceItemSnapshot"],
      raw: true
    });
  }
  async getItemInfoByOrderNo(orderNo) {
    return await this.model.findOne({
      where: {
        sourceOrderNo: orderNo
      },
      raw: true
    });
  }
  
  /**
   * 根据ids 获取需求
   * @param ids
   * @returns {Promise<void>}
   */
  async getNeedsByIds(ids){
    let needs = await this.findAll({
      where: {
        channelNeedNo: {
          [Op.in]:ids
        }
      },
      attributes: [
        "id",
        "uapp_id",
        "needNo",
        "channelNeedNo",
        "channelUserId",
        "followManUserId",
        "followManMobile",
        "city",
        "province",
        "publishContent",
        "publishName",
        "publishMobile",
        "notes",
        "followContent",
        "disposeNotes",
        "status",
        "typeCode",
        "typeName",
        "channelTypeCode",
        "channelTypeName",
        "publisherOnlyCode",
        "followManName",
        "followManOnlyCode",
        "created_at"
      ],
      raw: true
    })
    return needs;
  }
}
module.exports = OrderProductDao;
