var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class QcAPI extends APIBase {
    constructor() {
        super();
        this.aliyunqcSve = system.getObject("service.qcutils.aliyunqcSve");
        this.baiduqcSve = system.getObject("service.qcutils.baiduqcSve");

        this.baseqcSve = system.getObject("service.qcutils.baseqcSve");
        this.ncSve = system.getObject("service.qcutils.ncSve");
        this.rtSve = system.getObject("service.qcutils.rtSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        if (pobj.actionType == 'getPolicyNeedList' || pobj.actionType == 'submitPolicyNeedNotes') {
            if (!pobj.userInfo) {
                return system.getResult(system.noLogin, "user no login!");
            }
            if (!pobj.appInfo) {
                return system.getResult(system.noLogin, "app is null!");
            }
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        console.log("pobj",pobj)
        var opResult = null;
        switch (action_type) {
            case "receiveProgrammeNo"://接收方案编号(方案推送至阿里后,接收保存方案信息)
                opResult = await this.aliyunqcSve.receiveProgrammeNo(pobj);
                break;
            case "submitIcpProgramme"://icp方案提交
                opResult = await this.baseqcSve.submitIcpProgramme(pobj);
                break;
            // case "submitIcpMaterial"://icp材料提交
            //     opResult = await this.aliyunqcSve.submitIcpMaterial(pobj);
            //     break;
            case "acceptIcpPartnerNotification"://icp通知状态变更
                opResult = await this.baseqcSve.acceptIcpPartnerNotification(pobj);
                break;
            case "abolishIcpProgramme"://服务商icp方案关闭
                opResult = await this.aliyunqcSve.abolishIcpProgramme(pobj);
                break;
            case "getIcpProgrammeDetail"://获取icp方案
                opResult = await this.aliyunqcSve.getIcpProgrammeDetail(pobj);
                break;
            case "getNeedSolutionDetailByUser"://获取方案详情
                opResult = await this.aliyunqcSve.getNeedSolutionDetailByUser(pobj);
                break;
            case "receiveIcpStatusNotify"://接收渠道方案状态变更通知2.3
                opResult = await this.aliyunqcSve.receiveIcpStatusNotify(pobj);
                break;
            case "receiveIcpFeedback"://接收icp用户方案反馈2.2
                opResult = await this.aliyunqcSve.receiveIcpFeedback(pobj);
                break;
            // case "getIcpProgrammeDetail"://获取方案详情（内部调用）
            //     opResult = await this.aliyunqcSve.getIcpProgrammeDetail(pobj);
            //     break;
            case "getProgrammeInfoByChannelNeedNo"://获取需求方案列表
                opResult = await this.aliyunqcSve.getProgrammeInfoByChannelNeedNo(pobj);
                break;

            case "serviceProviderSubmitMaterial"://交付商提交材料信息
                opResult = await this.baseqcSve.serviceProviderSubmitMaterial(pobj);
                break;
            case "serviceProviderNotification"://交付商通知状态变更
                opResult = await this.baseqcSve.serviceProviderNotification(pobj);
                break;
            case "closeOrderDelivery"://交付商关闭交付单
                opResult = await this.aliyunqcSve.closeOrderDelivery(pobj);
                break;
            case "abolishIcpProgrammeByNeed"://前端关闭ICP需求及方案
                opResult = await this.baseqcSve.abolishIcpProgrammeByNeed(pobj);
                break;
            case "receiveIcpConfirmUrl"://前端关闭ICP需求及方案
                opResult = await this.aliyunqcSve.receiveIcpConfirmUrl(pobj);
                break;
            // --------- 网文 ---------
            
            case "ncSubmitMaterial"://交付材料提交(网文)2020-11-11
                opResult = await this.ncSve.ncSubmitMaterial(pobj);
                break;
            case "ncNotification"://状态通知(网文)2020-11-11
                opResult = await this.ncSve.ncNotification(pobj);
                break;
            case "ncSubmitSolution"://提交方案(网文)2020-11-11
                opResult = await this.ncSve.ncSubmitSolution(pobj);
                break;
            case "ncClosePlan"://关闭需求(网文)2020-11-11
                opResult = await this.ncSve.ncClosePlan(pobj);
                break;
            case "ncReceiveProgrammeNo":
                opResult = await this.ncSve.ncReceiveProgrammeNo(pobj);
                break;
           

            // --------- 广电 ---------

            case "rtSubmitMaterial"://交付材料提交(广电)2020-11-11
                opResult = await this.rtSve.rtSubmitMaterial(pobj);
                break;
            case "rtNotification"://状态通知(广电)2020-11-11
                opResult = await this.rtSve.rtNotification(pobj);
                break;
            case "rtSubmitSolution"://提交方案(广电)2020-11-11
                opResult = await this.rtSve.rtSubmitSolution(pobj);
                break;
            case "rtClosePlan"://关闭需求(广电)2020-11-11
                opResult = await this.rtSve.rtClosePlan(pobj);
                break;
            case "rtReceiveProgrammeNo":
                opResult = await this.rtSve.rtReceiveProgrammeNo(pobj);
                break;
            // ----------------------------------------
            case "receiveOrderStatusNotify"://接收订单状态推送 百度icp 2.3
                opResult = await this.baiduqcSve.receiveOrderStatusNotify(pobj);
                break;
            case "icpOrderClose"://关闭ICP订单 百度icp 2.4
                opResult = await this.baiduqcSve.icpOrderClose(pobj);
                break;
            case "addIcpSalesmanInfo"://添加业务员信息，用于直接下单的icp订单
                opResult = await this.baiduqcSve.addIcpSalesmanInfo(pobj);
                break;
            case "tmFeedbackSubmit"://商标用户反馈
                opResult = await this.aliyunqcSve.tmFeedbackSubmit(pobj);
                break;
            // case "eNameCloseOrder"://易名退款
            //     opResult = await this.baiduqcSve.eNameCloseOrder(pobj);
            //     break;
                
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = QcAPI;