var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");

class IcAPI extends APIBase {
    constructor() {
        super();
        this.needinfoSve = system.getObject("service.dbneed.needinfoSve");
        this.needsolutionSve = system.getObject("service.dbneed.needsolutionSve");
        this.needinfoSve2 = system.getObject("service.dbneed.needinfoSve2");
    }

    /**
     * 接口跳转-POST请求
     * action_process  执行的流程
     * action_type     执行的类型
     * action_body     执行的参数
     */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        if (pobj.actionType == 'getPolicyNeedList' || pobj.actionType == 'submitPolicyNeedNotes') {
            if (!pobj.userInfo) {
                return system.getResult(system.noLogin, "user no login!");
            }
            if (!pobj.appInfo) {
                return system.getResult(system.noLogin, "app is null!");
            }
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }

    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "submitNeed"://提交需求
                opResult = await this.needinfoSve.submitNeed(pobj, pobj.actionBody, req);
                break;
            case "submitNeedH5"://工商H5提交需求
                opResult = await this.needinfoSve.submitNeedH5(pobj, pobj.actionBody, req);
                break;
            case "getItemByNeedNo"://获取需求详情
                opResult = await this.needinfoSve.getItemByNeedNo(pobj);
                break;
            case "getItemByChannelNeedNo"://获取需求详情
                opResult = await this.needinfoSve.getItemByChannelNeedNo(pobj);
                break;
            case "getSolutionByChannelSolutionNo"://获取方案详情
                opResult = await this.needinfoSve.getSolutionByChannelSolutionNo(pobj);
                break;
            case "needClose"://需求关闭
                opResult = await this.needinfoSve.needClose(pobj, pobj.actionBody, req);
                break;
            case "getItemByChannelSolutionNo"://渠道方案号获取需求详情
                opResult = await this.needinfoSve.getItemByChannelSolutionNo(pobj, pobj.actionBody, req);
                break;
            case "getSolutionByChannelOrderNo"://渠道订单号获取方案详情
                opResult = await this.needinfoSve.getSolutionByChannelOrderNo(pobj, pobj.actionBody, req);
                break;
            case "getOrderInfoByChannelOrderNo"://渠道订单号获取订单信息
                opResult = await this.needinfoSve.getOrderInfoByChannelOrderNo(pobj, pobj.actionBody, req);
                break;
            case "writeCommunicationLog"://渠道方案号获取需求详情
                opResult = await this.needinfoSve2.writeCommunicationLog(pobj, pobj.actionBody, req);
                break;
            case "submitIcpIntention":// 2020 0827 lin 新增 4.1 提交需求
                opResult = await this.needinfoSve.submitIcpIntention(pobj, pobj.actionBody, req);
                break;
            case "queryIntentionList":// 2020 0827 lin 新增 4.2 需求列表查询
                opResult = await this.needinfoSve.queryIntentionList(pobj, pobj.actionBody, req);
                break;
            case "confirmIcpIntention":// 2020 0827 lin 新增 4.3 用户需求确认
                opResult = await this.needinfoSve.confirmIcpIntention(pobj, pobj.actionBody, req);
                break;
            case "getUnCreated":// 获取需求列表
                opResult = await this.needinfoSve.getUnCreated(pobj, pobj.actionBody, req);
                break;
            case "createSolution"://创建方案
                opResult = await this.needsolutionSve.createNewSolution(pobj);
                break;
            case "queryExpertApplyCommunicationLogs":// 查询需求沟通记录 2020-10-28 laolan
                opResult = await this.needinfoSve2.queryExpertApplyCommunicationLogs(pobj, pobj.actionBody, req);
                break;
            case "queryCommunicationLog":// 查询需求沟通记录
                opResult = await this.needinfoSve2.queryCommunicationLog(pobj, pobj.actionBody, req);
                break;
            case "bulkCreateNeeds":
                opResult = await this.needinfoSve.bulkCreateNeeds(pobj);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

    async getNeedItemByChannelNeedNo(pobj, qobj, req) {
        return await this.needinfoSve.getItemByChannelNeedNo(pobj);
    }
}

module.exports = IcAPI;