const system = require("../../../system");
const moment = require('moment')
/**
 * 阿里云增值电信相关接口（ICP、EDI）
 * created by zhuangbing
 * created at 2020.07.27
 */
class AliyunQcService {
  constructor() {
    this.needsolutionDao = system.getObject("db.dbneed.needsolutionDao");
    this.needinfoDao = system.getObject("db.dbneed.needinfoDao");
    this.orderinfoDao = system.getObject("db.dbcorder.orderinfoDao");
    this.icpSolutionStatusReference = {
      SOLUTION_SUBMIT: "提交服务单",
      UN_PAID: "未支付", PAID: "用户支付", USER_UPLOADED: "用户上传资料", MATERIAL_UNCONFIRM: "服务商递交⽂件"
      , USER_CONFIRMED: "⽤户已确认递交⽂件", ACCOUNT_REGISTERED: "完成账户注册", MATERIAL_SUBMITTED: "完成资料递交",
      GXB_ACCEPT: "⼯信部已受理", GXB_REFUSE: "⼯信部不予受理", GXB_FAIL: "⼯信部未通过", GXB_SUCCESS: "工信部通过"
      , CLOSE: "方案关闭"
    };
    this.ediSolutionStatusReference = {
      SOLUTION_SUBMIT: "服务单通知服务商",
      USER_PAY_PRODUCE: "⽤户⽀付",
      USER_CONFIRM_PRODUCE: "⽤户确认资料",
      USER_REFUSE_PRODUCE: "资料退回修改",
      ABC_CLOSE_PRODUCE: "⼩⼆后台关闭服务单",
      USER_UPLOAD_PRODUCE: "⽤户补充基本资料"
    };
    this.ediProduceStatus = {
      110: "⽤户⽀付",
      30: "待⽤户确认",
      105: "账户已注册",
      35: "待提交审核",
      109: "管局已通过",
      106: "材料已递交⼯信部",
      10: "已⽀付",
      108: "管局不予受理",
      0: "初始状态",
      50: "订单关闭",
      25: "待⽤户提交材料",
      107: "管局已受理"
    };
    this.icpApplicationStatusReference = {
      507: "完成账户注册",
      508: "服务商完成提交资料到⼯信部",
      509: "⼯商部已受理",
      510: "⼯商部不予受理",
      511: "⼯商部通过",
      512: "⼯商部未通过"
    };
    //(文网文状态2020-9-26)
    this.wangwenStatusReference = {
      601: "服务商提交资料",
      602: "完成账户注册",
      603: "服务商完成提交资料到⼯信部",
      604: "⼯商部已受理",
      605: "⼯商部不予受理",
      606: "⼯商部通过",
      607: "⼯商部未通过",
      608: "用户驳回"
    };
    //(文网文状态2020-9-26)
    this.wangwenSolutionStatusReference = {
      "SOLUTION_SUBMIT": "提交服务单",
      "PARTNER_SUBMIT_MATERIAL": "服务商提交资料",
      "CERT_ACCOUNT_REGISTERED": "完成账户注册",
      "CERT_MATERIAL_SUBMITTED": "服务商完成提交资料到⼯信部",
      "CERT_GXB_ACCEPT": "⼯商部已受理",
      "CERT_GXB_SUCCESS": "⼯商部通过",
      "CERT_GXB_FAIL": "⼯商部未通过",
      "CERT_GXB_REFUSE": "⼯商部不予受理"
    };
  }

  //根据需求查看方案列表
  async getProgrammeInfoByChannelNeedNo(pobj) {
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    ab["createUserId"] = user.id;
    if (!ab.needNo) {
      return system.getResultFail(-101, "需求号不能为空");
    }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      where: { channelNeedNo: ab.needNo }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-102, "未知需求信息");
    }
    var ns = await this.needsolutionDao.model.findAll({
      where: { needNo: needinfo.needNo }, raw: true,
      attributes: ["needNo", "solutionNo", "channelSolutionNo", "orderNo", "solutionContent", "status", "statusName"]
    });
    return system.getResultSuccess(ns);
  }
  //获取方案详情（内部调用）
  async getIcpProgrammeDetail(pobj) {
    var ab = pobj.actionBody;
    if (!ab.BizId) {
      return system.getResultFail(-101, "方案编号不能为空");
    }
    //获取方案信息
    var ns = await this.needsolutionDao.model.findAll({
      where: { channelSolutionNo: ab.BizId, isInvalid: 0 }, raw: true
    });
    return system.getResultSuccess(ns);
  }
  //获取方案详情（前端调用）
  async getNeedSolutionDetailByUser(pobj) {
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    // ab["createUserId"]=user.id;
    if (!ab.solutionNo) {
      return system.getResultFail(-101, "方案编号不能为空");
    }
    //获取方案信息
    var ns = await this.needsolutionDao.model.findOne({
      where: { solutionNo: ab.solutionNo, createUserId: user.id }, raw: true
    });
    if (ns && ns.needNo) {
      var needinfo = await this.needinfoDao.model.findOne({
        where: { needNo: ns.needNo }, raw: true,
        attributes: ["publishName", "publishMobile", "channelUserId"]
      });
      ns.needinfo = needinfo;
    }
    return system.getResultSuccess(ns);
  }

  //交付商关闭交付单
  async closeOrderDelivery(pobj) {
    var ab = pobj.actionBody;
    if (!ab.orderNo) {
      return system.getResultFail(-101, "订单号不能为空");
    }
    if (!ab.note) {
      return system.getResultFail(-106, "关闭理由不能为空");
    } else {
      ab.Note = ab.note;
    }
    var ns = await this.needsolutionDao.model.findOne({
      where: { orderNo: ab.orderNo }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-301, "未知方案");
    }
    ab["BizId"] = ns.channelSolutionNo;
    pobj.actionBody = ab;
    return this.abolishIcpProgramme(pobj);
  }
  //服务商方案作废 -- abolishIcpProgramme
  async abolishIcpProgramme(pobj) {
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    if (!ab.BizId) {
      return system.getResultFail(-101, "渠道方案号不能为空");
    }
    if (!ab.Note) {
      return system.getResultFail(-106, "关闭理由不能为空");
    }
    //获取方案信息
    var ns = await this.needsolutionDao.model.findOne({
      where: { channelSolutionNo: ab.BizId, isInvalid: 0 }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-300, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns.needNo }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-400, "未知方案需求");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-401, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    // if (ns.status != "dqr") {
    //   return system.getResultFail(-301, "方案状态错误，只能废弃待确认方案");
    // }
    var solutionContent = ns.solutionContent;
    if (!solutionContent.status || ["USER_UPLOADED", "MATERIAL_UNCONFIRM", "USER_CONFIRMED", "ACCOUNT_REGISTERED", "MATERIAL_SUBMITTED"].indexOf(solutionContent.status) < 0) {
      return system.getResultFail(-302, "方案流程状态错误，不能执行此操作-1");
    }
    solutionContent.serviceProviderNote = ab.Note;
    var solutionFlowList = solutionContent.solutionFlowList || [];
    solutionFlowList.push({
      status: "CLOSE", statusName: this.icpSolutionStatusReference.CLOSE, updated_at: new Date()
    });
    solutionContent.status = "CLOSE";
    solutionContent.statusName = this.icpSolutionStatusReference.CLOSE;
    solutionContent = JSON.stringify(solutionContent);
    await this.needsolutionDao.update({ id: ns.id, status: "yzf", isInvalid: 1, solutionContent: solutionContent });//方案废弃
    //获取方案信息
    var new_ns = await this.needsolutionDao.model.findOne({
      where: { id: ns.id }, raw: true
    });
    return system.getResultSuccess(new_ns);
  }

  //提交icp材料信息
  async submitIcpMaterial(pobj) {
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    // ab["createUserId"] = user.id;
    if (!ab.BizId) {
      return system.getResultFail(-101, "渠道方案编号不能为空");
    }
    if (!ab.material) {
      return system.getResultFail(-102, "材料信息有误");
    }
    //获取方案信息
    var needsolutioninfo = await this.needsolutionDao.model.findOne({
      attributes: ["id", "needNo", "solutionContent"],
      where: { channelSolutionNo: ab.BizId, isInvalid: 0 }, raw: true
    });
    if (!needsolutioninfo || !needsolutioninfo.id) {
      return system.getResultFail(-400, "未知方案");
    }
    // if (!needsolutioninfo.needNo) {
    //   return system.getResultFail(-401, "方案需求信息有误");
    // }
    var solutionContent = needsolutioninfo.solutionContent;
    if (!solutionContent) {
      return system.getResultFail(-402, "方案交付信息有误");
    }
    if (solutionContent.status != "USER_UPLOADED") {
      return system.getResultFail(-403, "用户未上传材料，不能执行此操作");
    }
    //获取需求信息
    // var needinfo = await this.needinfoDao.model.findOne({
    //   where: { needNo: needsolutioninfo.needNo }, raw: true
    // });
    // if (!needinfo || !needinfo.id) {
    //   return system.getResultFail(-201, "未知需求信息");
    // }
    // if (needinfo.status == "ycd" || needinfo.status == "ygb") {
    // if (needinfo.status == "ygb") {
    //   return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    // }
    var material = ab.material;
    if (!material.Domain) {
      return system.getResultFail(-101, "备案域名不能为空");
    }
    //CorporateName 法⼈名称
    if (!material.hasOwnProperty("IncludeForeignInvestment")) {
      return system.getResultFail(-102, "包含外贸参数不能为空");
    }
    if (!material.PartnerBusinessLicense) {
      return system.getResultFail(-103, "营业执照不能为空");
    }
    if (!material.PartnerIdCardList || material.PartnerIdCardList.length < 1) {
      return system.getResultFail(-105, "相关人员身份证不能为空");
    }
    if (!material.PartnerDomainCertificate) {
      return system.getResultFail(-106, "域名证书不能为空");
    }
    solutionContent.material = ab.material;
    var solutionFlowList = solutionContent.solutionFlowList || [];
    solutionFlowList.push({
      status: "MATERIAL_UNCONFIRM", statusName: this.icpSolutionStatusReference.MATERIAL_UNCONFIRM, updated_at: new Date()
    });
    solutionContent.status = "MATERIAL_UNCONFIRM";
    solutionContent.statusName = this.icpSolutionStatusReference.MATERIAL_UNCONFIRM;
    needsolutioninfo.solutionContent = JSON.stringify(solutionContent);
    var self = this;
    return await this.needsolutionDao.db.transaction(async function (t) {
      await self.needsolutionDao.update(needsolutioninfo, t);
      var new_needsolutioninfo = await self.needsolutionDao.model.findOne({
        where: { id: needsolutioninfo.id }, raw: true
      });
      return system.getResultSuccess(new_needsolutioninfo);

    })
  }


  //接收渠道方案状态变更通知
  async receiveIcpStatusNotify(pobj) {
    var ab = pobj.actionBody;
    if (!ab.BizId) {
      return system.getResultFail(-101, "渠道方案号不能为空");
    }
    if (!ab.status) {
      return system.getResultFail(-102, "方案状态不能为空");
    }
    //获取方案信息
    var ns = await this.needsolutionDao.model.findOne({
      where: { channelSolutionNo: ab.BizId, isInvalid: 0 }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-102, "未知方案");
    }
    if (ab.isDirectBuy !== "true") {
      var needinfo = await this.needinfoDao.model.findOne({
        where: {needNo: ns.needNo}, raw: true
      });
      if (!needinfo) {
        return system.getResultFail(-104, "未知方案需求");
      }
      if (needinfo.status == "ygb") {
        return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
      }
    }
    // if (ns.status == "yzf" || ns.status == "ywc") {
    //   return system.getResultFail(-103, "该方案状态为" + ns.statusName + ",不能执行此操作");
    // }
    var solutionContent = ns.solutionContent;
    if (!ab.bizId.startsWith("TM_")) {//非商标
      var checkStatus = {
        ACCOUNT_REGISTERED: "完成账户注册", MATERIAL_SUBMITTED: "完成资料递交",
        GXB_ACCEPT: "⼯信部已受理", GXB_REFUSE: "⼯信部不予受理", GXB_FAIL: "⼯信部未通过", GXB_SUCCESS: "工信部通过"
        , CLOSE: "方案关闭"
      };
      if (solutionContent.status && checkStatus[solutionContent.status]) {
        return system.getResultFail(-111, "方案已进入" + solutionContent.statusName + "流程，不能执行此操作");
      }
      //方案流程列表
      var solutionFlowList = solutionContent.solutionFlowList || [];
      if (ab.status == "1") {//⽤户已支付
        var afterStatusList = [//用户支付后的流程状态
          "USER_UPLOADED", "MATERIAL_UNCONFIRM", "USER_CONFIRMED", "ACCOUNT_REGISTERED",
          "MATERIAL_SUBMITTED", "GXB_ACCEPT", "GXB_REFUSE", "GXB_FAIL", "GXB_SUCCESS", "CLOSE"
        ];
        if (!solutionContent.status || afterStatusList.indexOf(solutionContent.status) < 0) {
          solutionFlowList.push({
            status: "PAID", statusName: this.icpSolutionStatusReference.PAID, updated_at: new Date()
          });
          solutionContent.status = "PAID";
          solutionContent.statusName = this.icpSolutionStatusReference.PAID;
        }
        // 2020 0826 lin修改 n_need_info status为ycd 已成单
        let needObj = {
          id: needinfo.id, status: "ycd"
        }
        await this.needinfoDao.update(needObj);//关闭需求
      } else if (ab.status == "2") {//⽤户已上传
        if (solutionContent.status == "USER_CONFIRMED") {//防止用户确认后又否决
          return system.getResultFail(-112, "操作失败，⽤户已确认递交⽂件");
        }
        solutionFlowList.push({
          status: "USER_UPLOADED", statusName: this.icpSolutionStatusReference.USER_UPLOADED, updated_at: new Date()
        });
        solutionContent.status = "USER_UPLOADED";
        solutionContent.statusName = this.icpSolutionStatusReference.USER_UPLOADED;
      } else if (ab.status == "4") {//⽤户已确认，3为资料未确认(暂时不用做处理)
        if (solutionContent.status != "MATERIAL_UNCONFIRM") {
          return system.getResultFail(-113, "操作失败，服务商递交⽂件后才能执行此操作");
        }
        solutionFlowList.push({
          status: "USER_CONFIRMED", statusName: this.icpSolutionStatusReference.USER_CONFIRMED, updated_at: new Date()
        });
        solutionContent.status = "USER_CONFIRMED";
        solutionContent.statusName = this.icpSolutionStatusReference.USER_CONFIRMED;
      } else if (ab.status == "11") {//⽅案已关闭
        solutionFlowList.push({
          status: "CLOSE", statusName: this.icpSolutionStatusReference.CLOSE, updated_at: new Date()
        });
        solutionContent.status = "CLOSE";
        solutionContent.statusName = this.icpSolutionStatusReference.CLOSE;
      } else {
        return system.getResultFail(-110, "状态错误-2");
      }
      solutionContent.solutionFlowList = solutionFlowList;

      var material = solutionContent.customerMaterial || {};
      if (ab.remark) {
        solutionContent.customerRemark = ab.remark;
      }
      if (ab.newbusinessLicense) {
        material.businessLicense = ab.newbusinessLicense;
        material.aliBusinessLicense = ab.businessLicense;
      }
      if (ab.newidCardUrlList && ab.newidCardUrlList.length > 0) {
        material.idCardUrlList = ab.newidCardUrlList;
        material.aliIdCardUrlList = ab.idCardUrlList;
      }
      if (ab.newuserPlan) {
        material.userPlan = ab.newuserPlan;
        material.aliUserPlan = ab.userPlan;
      }
      if (ab.newuserForeig) {
        material.userForeig = ab.newuserForeig;
        material.aliUserForeig = ab.userForeig;
      }
      if (ab.newuserLaw) {
        material.userLaw = ab.newuserLaw;
        material.aliUserLaw = ab.userLaw;
      }
      if (ab.newuserOtherList && ab.newuserOtherList.length > 0) {
        material.userOtherList = ab.newuserOtherList;
        material.aliUserOtherList = ab.userOtherList;
      }
      solutionContent.customerMaterial = material;
    }else {
      solutionContent.status = ab.status
    }
    var updateObj = {
      id: ns.id, solutionContent: JSON.stringify(solutionContent)
    };
    if (ab.status == "11") {//⽅案已关闭
      updateObj["status"] = "yzf";
      updateObj["isInvalid"] = 1;
    }
    await this.needsolutionDao.update(updateObj);//方案状态修改
    var new_ns = await this.needsolutionDao.model.findOne({
      where: { id: ns.id }, raw: true
    });
    return system.getResultSuccess(ns);
  }
  //接收icp用户方案反馈
  async receiveIcpFeedback(pobj) {
    var ab = pobj.actionBody;
    if (!ab.intentionBizId) {
      return system.getResultFail(-101, "渠道需求编号错误");
    }
    if (!ab.description) {
      return system.getResultFail(-102, "问题描述不能为空");
    }
    if (!ab.hasOwnProperty("intentionStatus")) {
      return system.getResultFail(-103, "需求当前状态不能为空");
    }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      where: { channelNeedNo: ab.intentionBizId }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-104, "未知方案需求");
    }
    // if (needinfo.status == "ycd" || needinfo.status == "ygb") {
    if (needinfo.status == "ygb") {
      return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    //获取方案信息
    var ns = await this.needsolutionDao.model.findOne({
      where: { channelNeedNo: ab.intentionBizId, isInvalid: 0 }, raw: true
    });
    if (!ns) {
      // return system.getResultFail(-106, "未知方案");
      return system.getResultSuccess();
    }
    var intentionStatusList = ["未知", "⽅案待服务商确认", "⽅案待⽤户确认", "处理中", "已完成", "已关闭"];
    var updateObj = {
      id: ns.id
    };
    var solutionContent = ns.solutionContent;
    solutionContent.customerRemark = ab.description;
    solutionContent.needStatus = ab.intentionStatus;
    if (ab.intentionStatus == 1) {
      updateObj["status"] = "ybh";
      updateObj["isInvalid"] = 1;
    } else if (ab.intentionStatus == 2) {
      updateObj["status"] = "dqr";
    } else if (ab.intentionStatus == 3) {
      updateObj["status"] = "dqr";
    } else if (ab.intentionStatus == 4) {
      updateObj["status"] = "dqr";
    } else if (ab.intentionStatus == 5) {
      updateObj["status"] = "yzf";
      updateObj["isInvalid"] = 1;
    } else {
      return system.getResultFail(-107, "需求当前状态错误--" + ab.intentionStatus);
    }
    solutionContent.needStatusName = intentionStatusList[ab.intentionStatus];
    solutionContent = JSON.stringify(solutionContent);
    updateObj["solutionContent"] = solutionContent;
    await this.needsolutionDao.update(updateObj);//方案状态修改
    return system.getResultSuccess(needinfo);
  }

  //接收tm用户方案反馈
  async tmFeedbackSubmit(pobj) {
    try {
      var ab = pobj.actionBody;
      if (!ab.intentionBizId) {
        return system.getResultFail(-101, "渠道需求编号错误");
      }
      if (!ab.description) {
        return system.getResultFail(-102, "问题描述不能为空");
      }
      //获取需求信息
      var needinfo = await this.needinfoDao.model.findOne({
        where: { channelNeedNo: ab.intentionBizId }, raw: true
      });
      if (!needinfo) {
        return system.getResultFail(-104, "未知方案需求");
      }
      if (needinfo.status == "ygb") {
        return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
      }
      //获取方案信息
      var nsList = await this.needsolutionDao.model.findAll({
        where: { channelNeedNo: ab.intentionBizId, isInvalid: 0 }, raw: true
      });
      if (!nsList || nsList.length<1) {
        return system.getResultSuccess();
      }
      
      await this.needsolutionDao.db.transaction(async function (t) {
        var flowObj={
          date:new Date(),flowName:"用户驳回方案，反馈信息"
        };
        await this.updateSolution(nsList, ab, flowObj,t);
      })
      return system.getResultSuccess(needinfo);
    } catch (e) {
      return system.getResultFail(-200,"error异常");
    }
    
  }

  async updateSolution(nsList, ab, flowObj,t) {
    var intentionStatusList = ["未知", "⽅案待服务商确认", "⽅案待⽤户确认", "处理中", "已完成", "已关闭"];
    for (var i = 0; i < nsList.length; i++) {
      var ns = nsList[i];
      var updateObj = {
        id: ns.id
      };
      var solutionContent = ns.solutionContent || {};
      if (typeof solutionContent === 'string') {
        solutionContent = JSON.parse(solutionContent);
      }
      solutionContent.customerRemark = ab.description;
      solutionContent.needStatus = 1;
      updateObj["status"] = "ybh";
      solutionContent.needStatusName = intentionStatusList[1];

      var flowList = solutionContent.flowList || [];
      flowList.push(flowObj);
      solutionContent.flowList = flowList;

      solutionContent = JSON.stringify(solutionContent);
      updateObj["solutionContent"] = solutionContent;
      await this.needsolutionDao.update(updateObj, t);
    }
  }

  //接收方案编号(方案推送至阿里后,接收保存方案信息)
  async receiveProgrammeNo(pobj) {
    var ab = pobj.actionBody;
    if (!ab.solutionBizId) {
      return system.getResultFail(-101, "渠道方案业务编号不能为空");
    }
    if (!ab.solutionNo) {
      return system.getResultFail(-102, "方案业务编号不能为空");
    }
    var ns = await this.needsolutionDao.model.findOne({
      where: { solutionNo: ab.solutionNo, isInvalid: 0 }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-103, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns.needNo }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-104, "未知方案需求");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    await this.needsolutionDao.model.update({ channelSolutionNo: ab.solutionBizId }, { where: { id: ns.id } });//修改方案信息
    return system.getResultSuccess();
  }

  //接收确认方案后阿里返回链接
  async receiveIcpConfirmUrl(pobj) {
    var ab = pobj.actionBody;
    if (!ab.confirmUrl) {
      return system.getResultFail(-101, "confirmUrl不能为空");
    }
    if (!ab.solutionNo) {
      return system.getResultFail(-102, "方案业务编号不能为空");
    }
    var ns = await this.needsolutionDao.model.findOne({
      where: { solutionNo: ab.solutionNo, isInvalid: 0 }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-103, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns.needNo }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-104, "未知方案需求");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    ns.solutionContent.confirmUrl = ab.confirmUrl;
    var solutionContent = JSON.stringify(ns.solutionContent);
    await this.needsolutionDao.model.update({ solutionContent: solutionContent }, { where: { id: ns.id } });//修改方案信息
    return system.getResultSuccess();
  }

  /*
  返回20位业务订单号
  prefix：业务前缀
  */
  async getBusUid(prefix) {
    prefix = (prefix || "");
    if (prefix) {
      prefix = prefix.toUpperCase();
    }
    var prefixlength = prefix.length;
    var subLen = 8 - prefixlength;
    var uidStr = "";
    if (subLen > 0) {
      uidStr = await this.getUidInfo(subLen, 60);
    }
    var timStr = moment().format("YYYYMMDDHHmm");
    return prefix + timStr + uidStr;
  }
  /*
  len：返回长度
  radix：参与计算的长度，最大为62
  */
  async getUidInfo(len, radix) {
    var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
    var uuid = [], i;
    radix = radix || chars.length;
    if (len) {
      for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
    } else {
      var r;
      uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
      uuid[14] = '4';
      for (i = 0; i < 36; i++) {
        if (!uuid[i]) {
          r = 0 | Math.random() * 16;
          uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
        }
      }
    }
    return uuid.join('');
  }

  //接收渠道方案状态变更通知
  async receiveEdiStatusNotify(pobj) {
    var ab = pobj.actionBody;
    if (!ab.BizId) {
      return system.getResultFail(-101, "渠道方案号不能为空");
    }
    if (!ab.operationType) {
      return system.getResultFail(-102, "方案状态不能为空");
    }
    //获取方案信息
    var ns = await this.needsolutionDao.model.findOne({
      // 2020 0929 lin 修改ab.BizId 改为 ab.solutionBizId
      where: { channelSolutionNo: ab.solutionBizId, isInvalid: 0 }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-102, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns.needNo }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-104, "未知方案需求");
    }
    if (needinfo.status == "ygb") {
      return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    var solutionContent = ns.solutionContent;
    var checkStatus = { ABC_CLOSE_PRODUCE: "⼩⼆后台关闭服务单" };
    if (solutionContent.status && checkStatus[solutionContent.status]) {
      return system.getResultFail(-111, "方案已进入" + solutionContent.statusName + "流程，不能执行此操作");
    }
    //方案流程列表
    var solutionFlowList = solutionContent.solutionFlowList || [];
    if (ab.operationType == "USER_PAY_PRODUCE") {//⽤户已支付
      solutionFlowList.push({
        status: "USER_PAY_PRODUCE", statusName: this.ediSolutionStatusReference.USER_PAY_PRODUCE, updated_at: new Date()
      });
      solutionContent.status = "USER_PAY_PRODUCE";
      solutionContent.statusName = this.ediSolutionStatusReference.USER_PAY_PRODUCE;
      // 2020 0826 lin修改 n_need_info status为ycd 已成单
      let needObj = {
        id: needinfo.id, status: "ycd"
      }
      await this.needinfoDao.update(needObj);//关闭需求
    } else if (ab.operationType == "USER_CONFIRM_PRODUCE") {//⽤户确认资料
      solutionFlowList.push({
        status: "USER_CONFIRM_PRODUCE", statusName: this.ediSolutionStatusReference.USER_CONFIRM_PRODUCE, updated_at: new Date()
      });
      solutionContent.status = "USER_CONFIRM_PRODUCE";
      solutionContent.statusName = this.ediSolutionStatusReference.USER_CONFIRM_PRODUCE;
    } else if (ab.operationType == "USER_REFUSE_PRODUCE") {//资料退回修改
      solutionFlowList.push({
        status: "USER_REFUSE_PRODUCE", statusName: this.ediSolutionStatusReference.USER_REFUSE_PRODUCE, updated_at: new Date()
      });
      solutionContent.status = "USER_REFUSE_PRODUCE";
      solutionContent.statusName = this.ediSolutionStatusReference.USER_REFUSE_PRODUCE;
    } else if (ab.operationType == "USER_UPLOAD_PRODUCE") {//⽤户补充基本资料
      solutionFlowList.push({
        status: "USER_UPLOAD_PRODUCE", statusName: this.ediSolutionStatusReference.USER_UPLOAD_PRODUCE, updated_at: new Date()
      });
      solutionContent.status = "USER_UPLOAD_PRODUCE";
      solutionContent.statusName = this.ediSolutionStatusReference.USER_UPLOAD_PRODUCE;
    } else if (ab.operationType == "ABC_CLOSE_PRODUCE") {//⽅案已关闭
      solutionFlowList.push({
        status: "ABC_CLOSE_PRODUCE", statusName: this.ediSolutionStatusReference.ABC_CLOSE_PRODUCE, updated_at: new Date()
      });
      solutionContent.status = "ABC_CLOSE_PRODUCE";
      solutionContent.statusName = this.ediSolutionStatusReference.ABC_CLOSE_PRODUCE;
    } else {
      return system.getResultFail(-110, "状态错误-3");
    }
    solutionContent.solutionFlowList = solutionFlowList;

    var material = solutionContent.customerMaterial || {};
    if (ab.extInfo) {
      // 退回修改理由
      var extInfoJson = JSON.parse(ab.extInfo);
      // var extInfoJson = ab.extInfo
      if(extInfoJson.rejectReason) {
        ab.rejectReason = extInfoJson.rejectReason,
        solutionContent.rejectReason = extInfoJson.rejectReason
      }
      material.businessLicenseArr = extInfoJson.businessLicenseArr;
      material.idCardListArr = extInfoJson.idCardListArr;
    }
    solutionContent.customerMaterial = material;
    solutionContent = JSON.stringify(solutionContent);

    var updateObj = {
      id: ns.id,
      solutionContent: solutionContent,
    };
    // 这里修改进去了
    if(ab.bizId != ns.channelDeliverId) {
      updateObj.channelDeliverId = ab.bizId
    }
    if (ab.operationType == "ABC_CLOSE_PRODUCE") {//⽅案已关闭
      updateObj["status"] = "yzf";
      updateObj["isInvalid"] = 1;
    }
    await this.needsolutionDao.update(updateObj);//方案状态修改
    var new_ns = await this.needsolutionDao.model.findOne({
      where: { id: ns.id }, raw: true
    });
    var orderInfo = await this.orderinfoDao.model.findOne({
      where: {orderNo: new_ns.orderNo}, raw: true
    })
    if(orderInfo) {
      new_ns.channelOrderNo = orderInfo.channelOrderNo
    }
    return system.getResultSuccess(new_ns);
  }


  // ---------------- 文网文 ----------------
  /**
  * 服务商提交服务操作
  * 服务商通知状态变更
  * (交付系统调用)
  * (文网文)
  */
  async serviceSubmitOption(pobj) {
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    if (!ab.orderNo) {
      return system.getResultFail(-101, "订单号不能为空");
    }
    if (!ab.ApplicationStatus) {
      return system.getResultFail(-102, "交付状态不能为空");
    }
    if (!ab.channelType) {
      return system.getResultFail(-103, "渠道来源不能为空");
    }
    //获取方案信息
    var orderinfo = await this.orderinfoDao.model.findOne({
      where: { channelOrderNo: ab.orderNo }, raw: true
    });
    if(orderinfo){
      var orderNo = orderinfo.orderNo;
      if(orderNo){
        var needsolutioninfo = await this.needsolutionDao.model.findOne({
          where: { orderNo: orderNo }, raw: true
        });
      }
    }
    
    if (!needsolutioninfo || !needsolutioninfo.id) {
      return system.getResultFail(-400, "未知方案");
    }
    if (!needsolutioninfo.needNo) {
      return system.getResultFail(-401, "方案需求信息有误");
    }
    var solutionContent = needsolutioninfo.solutionContent;
    if (!solutionContent) {
      return system.getResultFail(-402, "方案交付信息有误");
    }
    // if (solutionContent.applicationStatus && solutionContent.applicationStatus > ab.ApplicationStatus) {
    //   return system.getResultFail(-403, "操作失败，交付流程未按顺序执行");
    // }
    // if (solutionContent.ApplicationStatus && solutionContent.ApplicationStatus == ab.ApplicationStatus) {
    //   return system.getResultFail(-405, "操作失败，该流程状态已提交，不能重复提交");
    // }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: needsolutioninfo.needNo }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-201, "未知需求信息");
    }
    // if (needinfo.status == "ycd" || needinfo.status == "ygb") {
    if (needinfo.status == "ygb") {
      return system.getResultFail(-202, "serviceProviderSubmitMateria" + needinfo.statusName + ",不能执行此操作");
    }
    var solutionFlowList = solutionContent.solutionFlowList || [];
    
    if (ab.ApplicationStatus == 601) {//服务商提交资料
      if (solutionContent.status == "USER_UPLOAD_PRODUCE" || solutionContent.status == "USER_REFUSE_PRODUCE") {
        solutionContent.ApplicationStatus = 601;
      solutionFlowList.push({
        status: "PARTNER_SUBMIT_MATERIAL", statusName: this.wangwenSolutionStatusReference.PARTNER_SUBMIT_MATERIAL, updated_at: new Date()
      });
      solutionContent.status = "PARTNER_SUBMIT_MATERIAL";
      solutionContent.statusName = this.wangwenSolutionStatusReference.PARTNER_SUBMIT_MATERIAL;
      }else{
        return system.getResultFail(-601, "交付流程错误，请先完成账户注册");
      }
    }
    if (ab.ApplicationStatus == 602) {//完成账户注册
      if (solutionContent.status != "USER_CONFIRM_PRODUCE") {
        return system.getResultFail(-602, "交付流程错误，用户确认递交⽂件后才能执行此操作");
      }
      solutionFlowList.push({
        status: "CERT_ACCOUNT_REGISTERED", statusName: this.wangwenSolutionStatusReference.CERT_ACCOUNT_REGISTERED, updated_at: new Date()
      });
      solutionContent.status = "CERT_ACCOUNT_REGISTERED";
      solutionContent.statusName = this.wangwenSolutionStatusReference.CERT_ACCOUNT_REGISTERED;
    }
    if (ab.ApplicationStatus == 603) {//服务商完成提交资料到⼯信部
      if (solutionContent.status != "CERT_ACCOUNT_REGISTERED") {
        return system.getResultFail(-603, "交付流程错误，请先完成资料递交");
      }
      solutionFlowList.push({
        status: "CERT_MATERIAL_SUBMITTED", statusName: this.wangwenSolutionStatusReference.CERT_MATERIAL_SUBMITTED, updated_at: new Date()
      });
      solutionContent.status = "CERT_MATERIAL_SUBMITTED";
      solutionContent.statusName = this.wangwenSolutionStatusReference.CERT_MATERIAL_SUBMITTED;
    }
    if (ab.ApplicationStatus == 604) {//⼯商部已受理
      if (solutionContent.status != "CERT_MATERIAL_SUBMITTED") {
        return system.getResultFail(-604, "交付流程错误，请先完成资料递交");
      }
      solutionFlowList.push({
        status: "CERT_GXB_ACCEPT", statusName: this.wangwenSolutionStatusReference.CERT_GXB_ACCEPT, updated_at: new Date()
      });
      solutionContent.status = "CERT_GXB_ACCEPT";
      solutionContent.statusName = this.wangwenSolutionStatusReference.CERT_GXB_ACCEPT;
    }
    if (ab.ApplicationStatus == 605) {//⼯商部不予受理
      if (solutionContent.status != "PARTNER_SUBMIT_MATERIAL") {
        return system.getResultFail(-605, "交付流程错误，请先完成资料递交");
      }
      solutionFlowList.push({
        status: "CERT_GXB_REFUSE", statusName: this.wangwenSolutionStatusReference.CERT_GXB_REFUSE, updated_at: new Date()
      });
      solutionContent.status = "CERT_GXB_REFUSE";
      needsolutioninfo.status = "ywc";
      solutionContent.statusName = this.wangwenSolutionStatusReference.CERT_GXB_REFUSE;
    }
    if (ab.ApplicationStatus == 606) {//⼯商部通过
      if (solutionContent.status != "CERT_GXB_ACCEPT") {
        return system.getResultFail(-606, "交付流程错误，⼯信部已受理后才能执行此操作");
      }
      solutionFlowList.push({
        status: "CERT_GXB_SUCCESS", statusName: this.wangwenSolutionStatusReference.CERT_GXB_SUCCESS, updated_at: new Date()
      });
      needsolutioninfo.status = "ywc";
      solutionContent.status = "CERT_GXB_SUCCESS";
      solutionContent.statusName = this.wangwenSolutionStatusReference.CERT_GXB_SUCCESS;
    }
    if (ab.ApplicationStatus == 607) {//⼯信部未通过
      if (solutionContent.status != "CERT_GXB_ACCEPT") {
        return system.getResultFail(-607, "交付流程错误，⼯信部已受理后才能执行此操作");
      }
      solutionFlowList.push({
        status: "CERT_GXB_FAIL", statusName: this.wangwenSolutionStatusReference.CERT_GXB_FAIL, updated_at: new Date()
      });
      solutionContent.status = "CERT_GXB_FAIL";
      needsolutioninfo.status = "ywc";
      solutionContent.statusName = this.wangwenSolutionStatusReference.CERT_GXB_FAIL;
    }
    solutionContent.solutionFlowList = solutionFlowList;
    var applicationStatusList = solutionContent.applicationStatusList || [];
    var statusObj = {
      "ApplicationStatus": ab.ApplicationStatus,
      "ApplicationStatusName": this.wangwenSolutionStatusReference[ab.ApplicationStatus],
      "created_at": new Date()
    };
    applicationStatusList.push(statusObj);
    solutionContent.applicationStatusList = applicationStatusList;
    solutionContent.applicationStatus = ab.ApplicationStatus;
    needsolutioninfo.solutionContent = JSON.stringify(solutionContent);
    var self = this;
    return await this.needsolutionDao.db.transaction(async function (t) {
      await self.needsolutionDao.update(needsolutioninfo, t);
      statusObj["BizId"] = ab.BizId;
      return system.getResultSuccess(statusObj);
    })
  }

  //提交方案
  async submitWangwenSolution(pobj) {
    console.log('wangwen提交方案',pobj)
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    ab["createUserId"] = user.id;
    if (!ab.needNo) {
      return system.getResultFail(-101, "渠道需求号不能为空");
    }
    if (!ab.solutionContent) {
      return system.getResultFail(-102, "方案信息有误");
    }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      where: { channelNeedNo: ab.needNo }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-201, "未知需求信息");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能创建方案");
    }
    var bizType = needinfo.typeCode;//ab.solutionContent.bizType;//业务类型
    ab.solutionContent.bizType = bizType;
    if (!bizType) {
      return system.getResultFail(-205, "方案类型错误");
    }
    // if (!bizType || !needinfo.typeCode || bizType != needinfo.typeCode) {
    //   return system.getResultFail(-205, "方案类型错误");
    // }
    if (!needinfo.channelTypeCode) {
      return system.getResultFail(-206, "渠道方案类型错误");
    }
    ab.solutionContent.typeCode = needinfo.typeCode;
    ab.solutionContent.typeName = needinfo.typeName;
    var ns = await this.needsolutionDao.model.findAll({
      where: { channelNeedNo: ab.needNo }, raw: true, order: [["id", 'asc']]
    });
    for (var i = 0; i < ns.length; i++) {
      var fa = ns[i];
      if (fa.status == "dqr" || fa.status == "ywc") {
        return system.getResultFail(-207, "需求方案已存在，不能重复提交");
      }
      if (fa.status == "ybh") {
        ab.channelSolutionNo = fa.channelSolutionNo;
      }
      if (fa.status == "yzf") {
        ab.channelSolutionNo = "";
      }
    }
    var solution = ab.solutionContent.solution;
    if (!solution) {
      return system.getResultFail(-103, "方案交付信息有误");
    }
    if (needinfo.channelTypeCode == "esp.wangwen") {//esp.wangwen
      ab.solutionContent.solution.IcpType = "wangwen";
    } else {
      return system.getResultFail(-208, "需求业务类型有误");
    }
    if (!solution.CompanyName) {
      return system.getResultFail(-105, "企业名称不能为空");
    }
    if (!solution.licenseType) {
      return system.getResultFail(-106, "网文类型不能为空");
    }
    if (!solution.actionType) {
      return system.getResultFail(-106, "办理类型不能为空");
    }
    if (!solution.companyLocation) {
      return system.getResultFail(-107, "区域不能为空");
    }
    if (!solution.solutionPrice) {
      return system.getResultFail(-108, "办理价格不能为空");
    }else{
      solution.solutionPrice = solution.solutionPrice / 100;
    }
    var solutionFlowList = ab.solutionContent.solutionFlowList || [];
    solutionFlowList.push({
      status: "SOLUTION_SUBMIT", statusName: this.wangwenSolutionStatusReference.SOLUTION_SUBMIT, updated_at: new Date()
    });
    ab.solutionContent.status = "SOLUTION_SUBMIT";
    ab.solutionContent.statusName = this.wangwenSolutionStatusReference.SOLUTION_SUBMIT;
    ab.solutionContent.solutionFlowList = solutionFlowList;
    ab["channelNeedNo"] = needinfo.channelNeedNo;
    var solutionNo = await this.getBusUid("ns");
    ab["solutionNo"] = solutionNo;
    ab["status"] = "dqr";
    var customerInfo = {//客户信息
      "publishName": needinfo.publishName,
      "publishMobile": needinfo.publishMobile
    };
    var salesmanInfo = {//业务员信息
      "salesmanName": user.channel_username,
      "salesmanMobile": user.mobile,
      "salesmanId": user.id,
      "salesmanChannelId": user.channel_userid
    };
    ab.solutionContent["customerInfo"] = customerInfo;
    ab.solutionContent["salesmanInfo"] = salesmanInfo;
    ab.solutionContent = JSON.stringify(ab.solutionContent);
    var self = this;
    return await this.needsolutionDao.db.transaction(async function (t) {
      ab["needNo"] = needinfo.needNo;
      var od = await self.needsolutionDao.create(ab, t);
      if (od && od.id) {
        var needObj = {
          id: needinfo.id
        };
        if (!needinfo.followManUserId) {
          needObj = {
            id: needinfo.id,
            followManUserId: user.id,//跟进人id
            followManName: user.channel_username,//跟进人姓名
            followManMobile: user.mobile,//跟进人手机号（合伙人）
            followManOnlyCode: user.channel_userid
          };
        }
        if (!needinfo.followContent) {
          var followContent = [{
            followDate: new Date(),
            content: "wangwen提交方案"
          }];
          followContent = JSON.stringify(followContent);
          needObj["followContent"] = followContent;
        }
        await self.needinfoDao.update(needObj, t);
        needinfo = await self.needinfoDao.model.findOne({
          where: { id: needinfo.id }, raw: true
        });
        return system.getResultSuccess({ needinfo: needinfo, needsolution: od });
      } else {
        return system.getResultFail(-302, "提交方案失败");
      }
    })

  }

  //关闭需求
  async closeNeed(pobj) {
    var ab = pobj.actionBody;
    var app = pobj.appInfo;
    if (!app || !app.uapp_id) {
      return system.getResultFail(-100, "未知渠道");
    }
    if (!ab.needNo) {
      return system.getResultFail(-101, "需求编号不能为空");
    }
    if (!ab.note) {
      return system.getResultFail(-106, "关闭理由不能为空");
    }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      attributes: ["id", "status", "statusName", "needNo"],
      where: { channelNeedNo: ab.needNo }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-201, "未知需求信息");
    }
    if (needinfo.status == "ygb") {
      return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    var updateNeed = await this.needinfoDao.update(needObj);//关闭需求
    if (!updateNeed) {
      return system.getResultFail(-203, "关闭需求失败");
    } else {
      return system.getResultSuccess();
    }
  }

  //提交沟通记录
  async recordLog(pobj) {
    // 查询需求沟通记录
    // 修改channel传过来的参数 为 note/needNo 
    pobj.actionBody.Note = ["noteTime", moment().format("YYYY-MM-DD HH:mm:ss"), "note", pobj.actionBody.note];
    let needRes = await this.needsolutionDao.findOne({ channelNeedNo: pobj.actionBody.needNo });
    console.log('needRes',needRes)
    // 没有需求单直接返回
    if (!needRes) {
      return system.getResult("没有这个需求单");
    }
    // 如果未推送/以推送 修改为已跟进
    if (needRes.status == "wts" || needRes.status == "yts") {
      var sql = "update n_need_info set status=:status, statusName=:statusName where channelNeedNo=:BizId"
      var paramWhere = {
        statusName: '已跟进',
        status: 'ygj',
        BizId: pobj.actionBody.needNo
      };
      var updateRes = await this.orderinfoDao.customUpdate(sql, paramWhere);
      console.log('updateRes',updateRes)
    }
    // 有需求单但没有沟通记录 直接set
    if (!needRes.followContent) {
      var sql = "update n_need_info set followContent=JSON_OBJECT(:followContent) where channelNeedNo=:BizId"
      var paramWhere = {
        followContent: pobj.actionBody.Note,
        BizId: pobj.actionBody.needNo
      };
      var updateRes = await this.orderinfoDao.customUpdate(sql, paramWhere);
      if (updateRes[1]) {
        return system.getResultSuccess();
      }
      return system.getResult("添加记录失败");
      // 有需求单有沟通记录 json_array_append
    } else {
      var sql = "update n_need_info set followContent=json_array_append(followContent, '$', JSON_OBJECT(:Note)) where channelNeedNo=:BizId"
      // var sql = "update n_need_info set followContent=json_array_append(followContent, '$', "+ "\"" + JSON.stringify(pobj.actionBody.Note) + "\""+") where channelNeedNo="+ "\"" +pobj.actionBody.BizId +"\"" +"  "
      var paramWhere = {
        Note: pobj.actionBody.Note,
        BizId: pobj.actionBody.needNo
      };
      var updateRes = await this.orderinfoDao.customUpdate(sql, paramWhere);
      console.log('updateRes',updateRes)
      if (updateRes[1]) {
        return system.getResultSuccess();
      }
      return system.getResult("添加记录失败");
    }
  }


  // ---------------- 食品 ----------------
  /**
  * 服务商提交服务操作
  * 服务商通知状态变更
  * (交付系统调用)
  * (食品)
  */
 async foodServiceSubmitOption(pobj) {
  console.log(pobj)
  var ab = pobj.actionBody;
  var user = pobj.userInfo;
  if (!user || !user.id) {
    return system.getResultFail(-100, "未知用户");
  }
  if (!ab.orderNo) {
    return system.getResultFail(-101, "订单号不能为空");
  }
  if (!ab.ApplicationStatus) {
    return system.getResultFail(-102, "交付状态不能为空");
  }
  if (!ab.channelType) {
    return system.getResultFail(-102, "渠道来源不能为空");
  }
  //获取方案信息
  var orderinfo = await this.orderinfoDao.model.findOne({
    where: { channelOrderNo: ab.orderNo }, raw: true
  });
  if(orderinfo){
    var orderNo = orderinfo.orderNo;
    if(orderNo){
      var needsolutioninfo = await this.needsolutionDao.model.findOne({
        where: { orderNo: orderNo }, raw: true
      });
    }
  }
  if (!needsolutioninfo || !needsolutioninfo.id) {
    return system.getResultFail(-400, "未知方案");
  }
  if (!needsolutioninfo.needNo) {
    return system.getResultFail(-401, "方案需求信息有误");
  }
  var solutionContent = needsolutioninfo.solutionContent;
  if (!solutionContent) {
    return system.getResultFail(-402, "方案交付信息有误");
  }
  // if (solutionContent.applicationStatus && solutionContent.applicationStatus > ab.ApplicationStatus) {
  //   return system.getResultFail(-403, "操作失败，交付流程未按顺序执行");
  // }
  // if (solutionContent.ApplicationStatus && solutionContent.ApplicationStatus == ab.ApplicationStatus) {
  //   return system.getResultFail(-405, "操作失败，该流程状态已提交，不能重复提交");
  // }
  //获取需求信息
  var needinfo = await this.needinfoDao.model.findOne({
    where: { needNo: needsolutioninfo.needNo }, raw: true
  });
  if (!needinfo || !needinfo.id) {
    return system.getResultFail(-201, "未知需求信息");
  }
  // if (needinfo.status == "ycd" || needinfo.status == "ygb") {
  if (needinfo.status == "ygb") {
    return system.getResultFail(-202, "serviceProviderSubmitMateria" + needinfo.statusName + ",不能执行此操作");
  }
  var solutionFlowList = solutionContent.solutionFlowList || [];
  
  if (ab.ApplicationStatus == 601) {//服务商提交资料
    if (solutionContent.status == "USER_UPLOAD_PRODUCE" || solutionContent.status == "USER_REFUSE_PRODUCE") {
      solutionContent.ApplicationStatus = 601;
    solutionFlowList.push({
      status: "PARTNER_SUBMIT_MATERIAL", statusName: this.wangwenSolutionStatusReference.PARTNER_SUBMIT_MATERIAL, updated_at: new Date()
    });
    solutionContent.status = "PARTNER_SUBMIT_MATERIAL";
    solutionContent.statusName = this.wangwenSolutionStatusReference.PARTNER_SUBMIT_MATERIAL;
    }else{
      return system.getResultFail(-601, "交付流程错误，请先完成账户注册");
    }
  }
  if (ab.ApplicationStatus == 602) {//完成账户注册
    if (solutionContent.status != "USER_CONFIRM_PRODUCE") {
      return system.getResultFail(-602, "交付流程错误，用户确认递交⽂件后才能执行此操作");
    }
    solutionFlowList.push({
      status: "CERT_ACCOUNT_REGISTERED", statusName: this.wangwenSolutionStatusReference.CERT_ACCOUNT_REGISTERED, updated_at: new Date()
    });
    solutionContent.status = "CERT_ACCOUNT_REGISTERED";
    solutionContent.statusName = this.wangwenSolutionStatusReference.CERT_ACCOUNT_REGISTERED;
  }
  if (ab.ApplicationStatus == 603) {//服务商完成提交资料到⼯信部
    if (solutionContent.status != "CERT_ACCOUNT_REGISTERED") {
      return system.getResultFail(-603, "交付流程错误，请先完成资料递交");
    }
    solutionFlowList.push({
      status: "CERT_MATERIAL_SUBMITTED", statusName: this.wangwenSolutionStatusReference.CERT_MATERIAL_SUBMITTED, updated_at: new Date()
    });
    solutionContent.status = "CERT_MATERIAL_SUBMITTED";
    solutionContent.statusName = this.wangwenSolutionStatusReference.CERT_MATERIAL_SUBMITTED;
  }
  if (ab.ApplicationStatus == 604) {//⼯商部已受理
    if (solutionContent.status != "CERT_MATERIAL_SUBMITTED") {
      return system.getResultFail(-604, "交付流程错误，请先完成资料递交");
    }
    solutionFlowList.push({
      status: "CERT_GXB_ACCEPT", statusName: this.wangwenSolutionStatusReference.CERT_GXB_ACCEPT, updated_at: new Date()
    });
    solutionContent.status = "CERT_GXB_ACCEPT";
    solutionContent.statusName = this.wangwenSolutionStatusReference.CERT_GXB_ACCEPT;
  }
  if (ab.ApplicationStatus == 605) {//⼯商部不予受理
    if (solutionContent.status != "PARTNER_SUBMIT_MATERIAL") {
      return system.getResultFail(-605, "交付流程错误，请先完成资料递交");
    }
    solutionFlowList.push({
      status: "CERT_GXB_REFUSE", statusName: this.wangwenSolutionStatusReference.CERT_GXB_REFUSE, updated_at: new Date()
    });
    solutionContent.status = "CERT_GXB_REFUSE";
    needsolutioninfo.status = "ywc";
    solutionContent.statusName = this.wangwenSolutionStatusReference.CERT_GXB_REFUSE;
  }
  if (ab.ApplicationStatus == 606) {//⼯商部通过
    if (solutionContent.status != "CERT_GXB_ACCEPT") {
      return system.getResultFail(-606, "交付流程错误，⼯信部已受理后才能执行此操作");
    }
    solutionFlowList.push({
      status: "CERT_GXB_SUCCESS", statusName: this.wangwenSolutionStatusReference.CERT_GXB_SUCCESS, updated_at: new Date()
    });
    needsolutioninfo.status = "ywc";
    solutionContent.status = "CERT_GXB_SUCCESS";
    solutionContent.statusName = this.wangwenSolutionStatusReference.CERT_GXB_SUCCESS;
  }
  if (ab.ApplicationStatus == 607) {//⼯信部未通过
    if (solutionContent.status != "CERT_GXB_ACCEPT") {
      return system.getResultFail(-607, "交付流程错误，⼯信部已受理后才能执行此操作");
    }
    solutionFlowList.push({
      status: "CERT_GXB_FAIL", statusName: this.wangwenSolutionStatusReference.CERT_GXB_FAIL, updated_at: new Date()
    });
    solutionContent.status = "CERT_GXB_FAIL";
    needsolutioninfo.status = "ywc";
    solutionContent.statusName = this.wangwenSolutionStatusReference.CERT_GXB_FAIL;
  }
  solutionContent.solutionFlowList = solutionFlowList;
  var applicationStatusList = solutionContent.applicationStatusList || [];
  var statusObj = {
    "ApplicationStatus": ab.ApplicationStatus,
    "ApplicationStatusName": this.wangwenSolutionStatusReference[ab.ApplicationStatus],
    "created_at": new Date()
  };
  applicationStatusList.push(statusObj);
  solutionContent.applicationStatusList = applicationStatusList;
  solutionContent.applicationStatus = ab.ApplicationStatus;
  needsolutioninfo.solutionContent = JSON.stringify(solutionContent);
  var self = this;
  return await this.needsolutionDao.db.transaction(async function (t) {
    await self.needsolutionDao.update(needsolutioninfo, t);
    statusObj["BizId"] = ab.BizId;
    return system.getResultSuccess(statusObj);
  })
}

//提交方案
async submitFoodSolution(pobj) {
  console.log('food提交方案',pobj)
  var ab = pobj.actionBody;
  var user = pobj.userInfo;
  if (!user || !user.id) {
    return system.getResultFail(-100, "未知用户");
  }
  ab["createUserId"] = user.id;
  if (!ab.needNo) {
    return system.getResultFail(-101, "渠道需求号不能为空");
  }
  if (!ab.solutionContent) {
    return system.getResultFail(-102, "方案信息有误");
  }
  //获取需求信息
  var needinfo = await this.needinfoDao.model.findOne({
    where: { channelNeedNo: ab.needNo }, raw: true
  });
  if (!needinfo || !needinfo.id) {
    return system.getResultFail(-201, "未知需求信息");
  }
  if (needinfo.status == "ycd" || needinfo.status == "ygb") {
    return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能创建方案");
  }
  var bizType = needinfo.typeCode;//ab.solutionContent.bizType;//业务类型
  ab.solutionContent.bizType = bizType;
  if (!bizType) {
    return system.getResultFail(-205, "方案类型错误");
  }
  // if (!bizType || !needinfo.typeCode || bizType != needinfo.typeCode) {
  //   return system.getResultFail(-205, "方案类型错误");
  // }
  if (!needinfo.channelTypeCode) {
    return system.getResultFail(-206, "渠道方案类型错误");
  }
  ab.solutionContent.typeCode = needinfo.typeCode;
  ab.solutionContent.typeName = needinfo.typeName;
  var ns = await this.needsolutionDao.model.findAll({
    where: { channelNeedNo: ab.needNo }, raw: true, order: [["id", 'asc']]
  });
  for (var i = 0; i < ns.length; i++) {
    var fa = ns[i];
    if (fa.status == "dqr" || fa.status == "ywc") {
      return system.getResultFail(-207, "需求方案已存在，不能重复提交");
    }
    if (fa.status == "ybh") {
      ab.channelSolutionNo = fa.channelSolutionNo;
    }
    if (fa.status == "yzf") {
      ab.channelSolutionNo = "";
    }
  }
  var solution = ab.solutionContent.solution;
  if (!solution) {
    return system.getResultFail(-103, "方案交付信息有误");
  }
  if (needinfo.channelTypeCode == "esp.food") {//esp.food
    ab.solutionContent.solution.IcpType = "food";
  } else {
    return system.getResultFail(-208, "需求业务类型有误");
  }
  if (!solution.CompanyName) {
    return system.getResultFail(-105, "企业名称不能为空");
  }
  if (!solution.licenseType) {
    return system.getResultFail(-106, "网文类型不能为空");
  }
  if (!solution.actionType) {
    return system.getResultFail(-106, "办理类型不能为空");
  }
  if (!solution.companyLocation) {
    return system.getResultFail(-107, "区域不能为空");
  }
  if (!solution.solutionPrice) {
    return system.getResultFail(-108, "办理价格不能为空");
  }else{
    solution.solutionPrice = solution.solutionPrice / 100;
  }
  var solutionFlowList = ab.solutionContent.solutionFlowList || [];
  solutionFlowList.push({
    status: "SOLUTION_SUBMIT", statusName: this.wangwenSolutionStatusReference.SOLUTION_SUBMIT, updated_at: new Date()
  });
  ab.solutionContent.status = "SOLUTION_SUBMIT";
  ab.solutionContent.statusName = this.wangwenSolutionStatusReference.SOLUTION_SUBMIT;
  ab.solutionContent.solutionFlowList = solutionFlowList;
  ab["channelNeedNo"] = needinfo.channelNeedNo;
  var solutionNo = await this.getBusUid("ns");
  ab["solutionNo"] = solutionNo;
  ab["status"] = "dqr";
  var customerInfo = {//客户信息
    "publishName": needinfo.publishName,
    "publishMobile": needinfo.publishMobile
  };
  var salesmanInfo = {//业务员信息
    "salesmanName": user.channel_username,
    "salesmanMobile": user.mobile,
    "salesmanId": user.id,
    "salesmanChannelId": user.channel_userid
  };
  ab.solutionContent["customerInfo"] = customerInfo;
  ab.solutionContent["salesmanInfo"] = salesmanInfo;
  ab.solutionContent = JSON.stringify(ab.solutionContent);
  var self = this;
  return await this.needsolutionDao.db.transaction(async function (t) {
    ab["needNo"] = needinfo.needNo;
    var od = await self.needsolutionDao.create(ab, t);
    if (od && od.id) {
      var needObj = {
        id: needinfo.id
      };
      if (!needinfo.followManUserId) {
        needObj = {
          id: needinfo.id,
          followManUserId: user.id,//跟进人id
          followManName: user.channel_username,//跟进人姓名
          followManMobile: user.mobile,//跟进人手机号（合伙人）
          followManOnlyCode: user.channel_userid
        };
      }
      if (!needinfo.followContent) {
        var followContent = [{
          followDate: new Date(),
          content: "food提交方案"
        }];
        followContent = JSON.stringify(followContent);
        needObj["followContent"] = followContent;
      }
      await self.needinfoDao.update(needObj, t);
      needinfo = await self.needinfoDao.model.findOne({
        where: { id: needinfo.id }, raw: true
      });
      return system.getResultSuccess({ needinfo: needinfo, needsolution: od });
    } else {
      return system.getResultFail(-302, "提交方案失败");
    }
  })

}

//关闭需求
async foodCloseNeed(pobj) {
  var ab = pobj.actionBody;
  var app = pobj.appInfo;
  if (!app || !app.uapp_id) {
    return system.getResultFail(-100, "未知渠道");
  }
  if (!ab.needNo) {
    return system.getResultFail(-101, "需求编号不能为空");
  }
  if (!ab.note) {
    return system.getResultFail(-106, "关闭理由不能为空");
  }
  //获取需求信息
  var needinfo = await this.needinfoDao.model.findOne({
    attributes: ["id", "status", "statusName", "needNo"],
    where: { channelNeedNo: ab.needNo }, raw: true
  });
  if (!needinfo || !needinfo.id) {
    return system.getResultFail(-201, "未知需求信息");
  }
  if (needinfo.status == "ygb") {
    return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
  }
  var updateNeed = await this.needinfoDao.update(needObj);//关闭需求
  if (!updateNeed) {
    return system.getResultFail(-203, "关闭需求失败");
  } else {
    return system.getResultSuccess();
  }
}

//提交沟通记录
async foodRecordLog(pobj) {
  // 查询需求沟通记录
  // 修改channel传过来的参数 为 note/needNo 
  pobj.actionBody.Note = ["noteTime", moment().format("YYYY-MM-DD HH:mm:ss"), "note", pobj.actionBody.note];
  let needRes = await this.needsolutionDao.findOne({ channelNeedNo: pobj.actionBody.needNo });
  console.log('needRes',needRes)
  // 没有需求单直接返回
  if (!needRes) {
    return system.getResult("没有这个需求单");
  }
  // 如果未推送/以推送 修改为已跟进
  if (needRes.status == "wts" || needRes.status == "yts") {
    var sql = "update n_need_info set status=:status, statusName=:statusName where channelNeedNo=:BizId"
    var paramWhere = {
      statusName: '已跟进',
      status: 'ygj',
      BizId: pobj.actionBody.needNo
    };
    var updateRes = await this.orderinfoDao.customUpdate(sql, paramWhere);
    console.log('updateRes',updateRes)
  }
  // 有需求单但没有沟通记录 直接set
  if (!needRes.followContent) {
    var sql = "update n_need_info set followContent=JSON_OBJECT(:followContent) where channelNeedNo=:BizId"
    var paramWhere = {
      followContent: pobj.actionBody.Note,
      BizId: pobj.actionBody.needNo
    };
    var updateRes = await this.orderinfoDao.customUpdate(sql, paramWhere);
    if (updateRes[1]) {
      return system.getResultSuccess();
    }
    return system.getResult("添加记录失败");
    // 有需求单有沟通记录 json_array_append
  } else {
    var sql = "update n_need_info set followContent=json_array_append(followContent, '$', JSON_OBJECT(:Note)) where channelNeedNo=:BizId"
    // var sql = "update n_need_info set followContent=json_array_append(followContent, '$', "+ "\"" + JSON.stringify(pobj.actionBody.Note) + "\""+") where channelNeedNo="+ "\"" +pobj.actionBody.BizId +"\"" +"  "
    var paramWhere = {
      Note: pobj.actionBody.Note,
      BizId: pobj.actionBody.needNo
    };
    var updateRes = await this.orderinfoDao.customUpdate(sql, paramWhere);
    console.log('updateRes',updateRes)
    if (updateRes[1]) {
      return system.getResultSuccess();
    }
    return system.getResult("添加记录失败");
  }
}

}
module.exports = AliyunQcService;
