const system = require("../../../system");
const ServiceBase = require("../../sve.base");
class PolicyneedService extends ServiceBase {
  constructor() {
    super("dbpolicy", ServiceBase.getDaoName(PolicyneedService));
    this.policyinfoDao = system.getObject("db.dbpolicy.policyinfoDao");
    this.oplogDao = system.getObject("db.common.oplogDao");
  }
  //提交政策需求
  async submitPolicyNeed(pobj){
    var user = pobj.userInfo;
    var app = pobj.appInfo;
    var obj = pobj.actionBody;
    var paramObj={uapp_id:app.uapp_id};
    if(!obj.contacts){
      return system.getResult(null, "联系人不能为空");
    }  
    if(!obj.mobile){
      return system.getResult(null, "联系电话不能为空");
    }  
    if(obj.policy_id){
      var policyinfo = await this.policyinfoDao.model.findOne({
        where:{id:obj.policy_id},raw:true
      });
      if(policyinfo && policyinfo.id){
        paramObj["policySnapshot"] = JSON.stringify(policyinfo);
        paramObj["policy_id"] = obj.policy_id;
        // paramObj["policyName"] = policyinfo.policyName;
      }
    }
    paramObj["contacts"] = obj.contacts; 
    paramObj["mobile"] = obj.mobile; 
    paramObj["company"] = obj.company; 
    paramObj["industry"] = obj.industry; 
    paramObj["region"] = obj.region; 
    paramObj["applyDate"] = new Date(); 
    if(obj.popularizeUserCode){
      paramObj["popularizeUserCode"] = obj.popularizeUserCode; 
    }  
    var policyNeed = await this.dao.create(paramObj);
    return system.getResultSuccess();
  }

  //需求列表
  async getPolicyNeedList(pobj){
    var user = pobj.userInfo;
    var app = pobj.appInfo;
    var obj = pobj.actionBody || {};
    if(!user || !user.channel_userid){
      return system.getResult(null, "未知用户");
    }
    var pageSize = Number(obj.pageSize || 20);
    var pageIndex = Number(obj.pageIndex || 1);
    var from = pageIndex == 1 ? 0 : Number((pageIndex - 1) * pageSize);
    if (pageSize > 50) {
      pageSize = 50;
    }
    var sql ="select need.*,policy.policyNo,policy.policyName,policy.policyType,policy.policyTypeName,policy.policySource,"+
		"policy.policyLinkUrl,policy.policyDate,policy.policyProvince,policy.policyCity from "+
    "(select created_at,id,uapp_id,contacts,customerIntention,customerIntentionName,company,industry,region,mobile,policy_id,applyDate,opNotes,popularizeUserCode "+
    "from b_policy_need where uapp_id="+app.uapp_id+" and (popularizeUserCode='"+user.channel_userid+"' ";
    var sqlCount ="select count(1) as dataCount from "+
    "(select created_at,id,uapp_id,contacts,customerIntention,customerIntentionName,company,industry,region,mobile,policy_id,applyDate,opNotes,popularizeUserCode "+
    "from b_policy_need where uapp_id="+app.uapp_id+" and (popularizeUserCode='"+user.channel_userid+"' ";
    if(user.channel_userid=="18611219500"){
      sql=sql+" or popularizeUserCode is null or popularizeUserCode='' ";
      sqlCount=sqlCount+" or popularizeUserCode is null or popularizeUserCode='' ";
    }
    sql=sql+" )) as need "+
    "LEFT JOIN "+
    "(select id, policyNo,policyName,policyType,policyTypeName,policySource,policyLinkUrl,"+
    "policyDate,policyProvince,policyCity from b_policy_info) as policy "+
    "on need.policy_id=policy.id where 1=1 ";
    sqlCount=sqlCount+" )) as need "+
    "LEFT JOIN "+
    "(select id, policyNo,policyName,policyType,policyTypeName,policySource,policyLinkUrl,"+
    "policyDate,policyProvince,policyCity from b_policy_info) as policy "+
    "on need.policy_id=policy.id where 1=1 ";
    // var sql = "SELECT * from b_policy_need where popularizeUserCode='"+user.channel_userid+"' and uapp_id="+app.uapp_id;
    if(obj.policyName){
      sql=sql+" and policyName like '%"+obj.policyName+"%'";
      sqlCount=sqlCount+" and policyName like '%"+obj.policyName+"%'";
    }
    if(obj.policyProvince){
      sql=sql+" and policyProvince ='"+obj.policyProvince+"'";
      sqlCount=sqlCount+" and policyProvince ='"+obj.policyProvince+"'";
      if(obj.policyCity){
        sql=sql+" and policyCity ='"+obj.policyCity+"'";
        sqlCount=sqlCount+" and policyCity ='"+obj.policyCity+"'";
      }
    }
    if(obj.policyType){
      sql=sql+" and policyType = '"+obj.policyType+"'";
      sqlCount=sqlCount+" and policyType = '"+obj.policyType+"'";
    }
    if(obj.customerIntention){
      sql=sql+" and customerIntention = '"+obj.customerIntention+"'";
      sqlCount=sqlCount+" and customerIntention = '"+obj.customerIntention+"'";
    }
    if(obj.startDate){
      sql=sql+" and created_at >= '"+obj.startDate+"'";
      sqlCount=sqlCount+" and created_at >= '"+obj.startDate+"'";
    }
    if(obj.endDate){
      sql=sql+" and created_at <= '"+obj.endDate+"'";
      sqlCount=sqlCount+" and created_at <= '"+obj.endDate+"'";
    }
    sql=sql+" order by need.id desc LIMIT " + pageSize + " OFFSET " + from + "";
    console.log(sql);
    // var sqlCount = "SELECT count(1) as dataCount FROM b_policy_need where " +
    //   " uapp_id="+app.uapp_id+" and (popularizeUserCode='"+user.channel_userid+"'";
    // if(user.channel_userid=="18611219500"){
    //   sqlCount=sqlCount+" or popularizeUserCode is null or popularizeUserCode='' ";
    // }
    // sqlCount = sqlCount + ")";
    var tmpResult = await this.customQuery(sql,{});
    var tmpResultCount = await this.customQuery(sqlCount,{});
    // if (!tmpResult || tmpResult.length == 0) {
    //   return system.getResultSuccess(null, "暂无数据");
    // }
    var result = system.getResultSuccess(tmpResult);
    result.dataCount = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return result;
  }

  //需求备注提交
  async submitPolicyNeedNotes(pobj){
    var user = pobj.userInfo;
    var app = pobj.appInfo;
    var obj = pobj.actionBody || {};
    if(!user || !user.channel_userid){
      return system.getResult(null, "未知用户");
    }
    if(!obj.needId){
      return system.getResult(null, "需求id不能为空");
    }
    if(!obj.customerIntention){
      return system.getResult(null, "客户意向不能为空");
    }
    if(!obj.intentionContent){
      return system.getResult(null, "意向内容不能为空");
    }
    
    var policyneed = await this.dao.model.findOne({
      where:{id:obj.needId,uapp_id:app.uapp_id},
      raw:true
    });
    if(!policyneed || !policyneed.id){
      return system.getResult(null, "未知政策需求");
    }
    if(policyneed.popularizeUserCode != user.channel_userid){
      return system.getResult(null, "非法操作，只能修改本人数据");
    }
    var paramObj={id:obj.needId,customerIntention:obj.customerIntention};
    var noteparam={customerIntention:obj.customerIntention,intentionContent:obj.intentionContent,submitDate:new Date()};
    if(policyneed.opNotes){
      var notes = JSON.parse(policyneed.opNotes);
      var noteList = notes.data;
      // noteList.push(noteparam);
      noteList.splice(0,0,noteparam);
      paramObj["opNotes"] = JSON.stringify({data:noteList});
    }else{
      paramObj["opNotes"] = JSON.stringify({data:[noteparam]});
    }
    var newPolicyNeed = await this.dao.update(paramObj);
    return system.getResultSuccess();
  }

  //政策商机（蜂擎）
  async getPolicyBusinessFq(pobj){
    var app = pobj.appInfo;
    var obj = pobj.actionBody || {};
    var pageSize = Number(obj.pageSize || 20);
    var pageIndex = Number(obj.pageIndex || 1);
    var from = pageIndex == 1 ? 0 : Number((pageIndex - 1) * pageSize);
    if (pageSize > 200) {
      pageSize = 200;
    }
    var sql ="select need.created_at,need.region,need.mobile,need.industry,need.contacts,policy.policyNo,policy.policyName,policy.policyType,policy.policyTypeName,"+
		"need.company,need.popularizeUserCode,policy.policyLinkUrl,policy.policyProvince from "+
    "(select created_at,id,contacts,company,industry,region,mobile,policy_id,applyDate,opNotes,popularizeUserCode "+
    "from b_policy_need where 1=1 ";
    var sqlCount ="select count(1) as dataCount from "+
    "(select created_at,id,contacts,company,industry,region,mobile,policy_id,applyDate,opNotes,popularizeUserCode "+
    "from b_policy_need where 1=1 ";
    if(obj.salesmanMobile){
      sql=sql+" and popularizeUserCode='"+obj.salesmanMobile+"' ";
      sqlCount=sqlCount+" and popularizeUserCode='"+obj.salesmanMobile+"' ";
    }
    sql=sql+" ) as need "+
    "LEFT JOIN "+
    "(select id, policyNo,policyName,policyType,policyTypeName,policySource,policyLinkUrl,"+
    "policyDate,policyProvince,policyCity from b_policy_info) as policy "+
    "on need.policy_id=policy.id where 1=1 ";
    sqlCount=sqlCount+" ) as need "+
    "LEFT JOIN "+
    "(select id, policyNo,policyName,policyType,policyTypeName,policySource,policyLinkUrl,"+
    "policyDate,policyProvince,policyCity from b_policy_info) as policy "+
    "on need.policy_id=policy.id where 1=1 ";
    if(obj.policyName){
      sql=sql+" and policyName like '%"+obj.policyName+"%'";
      sqlCount=sqlCount+" and policyName like '%"+obj.policyName+"%'";
    }
    if(obj.policyProvince){
      sql=sql+" and policyProvince ='"+obj.policyProvince+"'";
      sqlCount=sqlCount+" and policyProvince ='"+obj.policyProvince+"'";
      if(obj.policyCity){
        sql=sql+" and policyCity ='"+obj.policyCity+"'";
        sqlCount=sqlCount+" and policyCity ='"+obj.policyCity+"'";
      }
    }
    if(obj.policyType){
      sql=sql+" and policyType = '"+obj.policyType+"'";
      sqlCount=sqlCount+" and policyType = '"+obj.policyType+"'";
    }
    if(obj.customerIntention){
      sql=sql+" and customerIntention = '"+obj.customerIntention+"'";
      sqlCount=sqlCount+" and customerIntention = '"+obj.customerIntention+"'";
    }
    if(obj.startDate){
      sql=sql+" and created_at >= '"+obj.startDate+"'";
      sqlCount=sqlCount+" and created_at >= '"+obj.startDate+"'";
    }
    if(obj.endDate){
      sql=sql+" and created_at <= '"+obj.endDate+"'";
      sqlCount=sqlCount+" and created_at <= '"+obj.endDate+"'";
    }
    sql=sql+" order by need.id desc LIMIT " + pageSize + " OFFSET " + from + "";
    console.log(sql);
    var tmpResult = await this.customQuery(sql,{});
    var tmpResultCount = await this.customQuery(sqlCount,{});
    var result = system.getResultSuccess(tmpResult);
    result.dataCount = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return result;
  }
    //政策需求信息（icompany）
  async getPolicyNeedInfo(pobj){
    var obj = pobj.actionBody || {};
    var pageSize = Number(obj.pageSize || 20);
    var pageIndex = Number(obj.pageIndex || 1);
    var from = pageIndex == 1 ? 0 : Number((pageIndex - 1) * pageSize);
    if (pageSize > 200) {
      pageSize = 200;
    }
    var sql ="select contacts,company,industry,region,mobile,created_at "+
    "from b_policy_need where 1=1 ";
    var sqlCount ="select count(1) as dataCount from b_policy_need where 1=1 ";
    if(obj.contacts){
      sql=sql+" and contacts = '"+obj.contacts+"'";
      sqlCount=sqlCount+" and contacts = '"+obj.contacts+"'";
    }
    if(obj.mobile){
      sql=sql+" and mobile = '"+obj.mobile+"'";
      sqlCount=sqlCount+" and mobile = '"+obj.mobile+"'";
    }
    if(obj.industry){
      sql=sql+" and industry = '"+obj.industry+"'";
      sqlCount=sqlCount+" and industry = '"+obj.industry+"'";
    }
    if(obj.region){
      sql=sql+" and region = '"+obj.region+"'";
      sqlCount=sqlCount+" and region = '"+obj.region+"'";
    }
    if(obj.company){
      sql=sql+" and company = '"+obj.company+"'";
      sqlCount=sqlCount+" and company = '"+obj.company+"'";
    }
    if(obj.startDate){
      sql=sql+" and created_at >= '"+obj.startDate+"'";
      sqlCount=sqlCount+" and created_at >= '"+obj.startDate+"'";
    }
    if(obj.endDate){
      sql=sql+" and created_at <= '"+obj.endDate+"'";
      sqlCount=sqlCount+" and created_at <= '"+obj.endDate+"'";
    }
    sql=sql+" order by created_at desc LIMIT " + pageSize + " OFFSET " + from + "";
    console.log(sql);
    var tmpResult = await this.customQuery(sql,{});
    var tmpResultCount = await this.customQuery(sqlCount,{});
    var result = system.getResultSuccess(tmpResult);
    result.dataCount = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return result;
  }
  //推送政策需求数据至蜂擎系统
  async taskpolicyneed2fq(reqobj) {
    var obj = reqobj.actionBody;
    var limit = obj.limit || 100;
    var pns = await this.dao.model.findAll({
      where:{isPushAlready:false},
      raw:true,
      offset:0,
      limit:limit
    });
    for(var i=0;i<pns.length;i++){
      var pn = pns[i];
      // var needNo=await this.getBusUid("pn");
      var needNo = "PN"+pn.id+"_"+pn.mobile+pn.uapp_id;
      var pobj = {
        "idempotentId": needNo, 
        "idempotentSource": "policyMpm",
        "idempotentSourceName": "政策_政策申请",
        "phone": pn.mobile,
        "customerName": pn.contacts,
        "companyName":[pn.company],
        "city":pn.region,
        "remark": "行业："+pn.industry,
        "operator_phone":pn.popularizeUserCode
      };
      var rtn = "";
      try {
        var rc = system.getObject("util.aliyunClient");
        rtn = await rc.post("https://yunfuapi.gongsibao.com/crm/opportunity/submit", pobj);//线上
        // rtn = await rc.post("https://yunfuapi-dev.gongsibao.com/crm/opportunity/submit",pobj);//开发
        if(rtn && rtn.code=="200"){
          await this.dao.update({id:pn.id,isPushAlready:true});//标记需求数据，已推送
        }
        var logObj = {
          op: "app/base/service/impl/dbpolicy/policyneedSve.js",
          content: JSON.stringify(pobj),
          resultInfo: JSON.stringify(rtn),
          opTitle: "推送政策需求数据至蜂擎系统--成功",
        };
        await this.oplogDao.create(logObj);
      } catch (e) {
        var logObj = {
          op: "app/base/service/impl/dbpolicy/policyneedSve.js",
          content: JSON.stringify(pobj),
          resultInfo: JSON.stringify(e),
          opTitle: "推送政策需求数据至蜂擎系统--异常",
        };
        await this.oplogDao.create(logObj);
      }
    }
    return system.getResultSuccess();
    
  }
}
module.exports = PolicyneedService;
