const ServiceBase = require("../../sve.base");
const System = require('../../../system');
class diagnosisneedbusService extends ServiceBase {
  constructor () {
    super("dbneed", 'diagnosisDao');
    this.solDao = System.getObject('db.dbneed.diagnosisneedsolutionDao')
  }

  async getList (pobj, data, req) {
    let query = {
      offset: ((data.page - 1) * data.pageSize) || 0,
      limit: data.pageSize || 10,
      attributes: [
        'id',
        'diagnosis_no',
        'corporate_type',
        'corporate_type_name',
        'corporate_name',
        "diagnosis_type",
        "diagnosis_type_name",
        "diagnosis_mode",
        "diagnosis_mode_name",
        'publish_name',
        'publish_mobile',
        "diagnosis_result",
        "diagnosis_result_name",
        'status',
        'status_name',
        'updated_at'
      ],
      order: [["updated_at", 'desc']]
    }
    let where = {}
    if (data.diagnosisNo) {
      where.diagnosis_no = { [this.db.Op.like]: `%${data.diagnosisNo}%` }
    }
    if (data.diagnosisTypeName) {
      where.diagnosis_type_name = { [this.db.Op.like]: `%${data.diagnosisTypeName}%` }
    }
    if (data.publishMobile) {
      where.publish_mobile = { [this.db.Op.like]: `%${data.publishMobile}%` }
    }
    if (data.status) {
      where.status = data.status
    }
    if (data.publishName) {
      where.publish_name = { [this.db.Op.like]: `%${data.publishName}%` }
    }
    if (data.stdate && data.endate) {
      where.updated_at = { [this.db.Op.between]: [data.stdate, data.endate] }
    }
    if (data.corporateType) {
      where.corporate_type = data.corporateType
    }
    if (data.diagnosis_mode) {
      where.diagnosis_mode = data.diagnosis_mode
    }
    if (Object.keys(where).length > 0) {
      query.where = where
    }
    try {
      let res = await this.dao.findAndCountAll(query)
      return System.getResultSuccess(res)
    } catch (error) {
      return System.getResultFail(-1, error.message)
    }
  }

  async getDetail (pobj, id) {
    try {
      let res = await this.dao.findById(id)
      if (res) {
        res.auth_result_name = res.diagnosis_result == 'tg' ? '已认证' : '未认证'
      }
      return System.getResultSuccess(res)
    } catch (error) {
      return System.getResultFail(-1, error.message)
    }
  }

  async doEAV (pobj, data, req) {
    let query = {
      status: 'ywc',
      diagnosis_result: data.diagnosisResult,
      notes: data.notes
    }
    try {
      let o = await this.dao.findById(data.id)
      if (o && o.diagnosis_mode != 'rg') {
        return System.getResultFail(-1, '非人工诊断单 不能修改认证结果')
      } else {
        let res = await this.dao.update(query, data.id)
        return System.getResultSuccess(res)
      }
    } catch (error) {
      return System.getResultFail(-1, error.message)
    }
  }

  async addCase (pobj, data, req) {
    try {
      let param = {
        diagnosis_no: data.diagnosisNo,
        solution_content: data.solutionContent,
      }

      if (pobj.userInfo && pobj.userInfo.id) {
        param.creator_id = pobj.userInfo.id,
        param.updator_id = pobj.userInfo.id
      }
      let res =  await this.solDao.create(param)
      return System.getResultSuccess(res)
    } catch (error) {
      return System.getResultFail(-1, error.message)
    }
  }
}
module.exports = diagnosisneedbusService;