const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
const ServiceBase = require("../../sve.base");
const uuidv4 = require('uuid/v4');
class FgbusinesschancService extends ServiceBase {
    constructor() {
        super("dbcorder", "orderinfoDao");
    }

    async create(req, actionBody) {
        var sql = "INSERT INTO  `fg_businesschance` (`companyId` ,`crm_company_name`,`standard_company_name`,`businessId`,`created_at` ,`businessType`) VALUE (:companyId,:crm_company_name,:standard_company_name,:businessId,:created_at,:businessType)";
        await this.customInsert(sql, {
            companyId: actionBody.companyId || null,
            crm_company_name: actionBody.crm_company_name || null,
            standard_company_name: actionBody.standard_company_name || null,
            businessId: actionBody.businessId || null,
            created_at: actionBody.createTime ? new Date(actionBody.createTime) : new Date(),
            businessType: actionBody.businessType
        });
        return system.getResultSuccess();
    };

    // 创建order_refund_fq 记录
    async createOrderRefundFq(req, actionBody) {
        let sql = `INSERT INTO order_refund_fq (${Object.keys(actionBody).join()}) VALUE (:${Object.keys(actionBody).join(",:")})`;
        await this.customInsert(sql, actionBody);
        return system.getResultSuccess();
    }

    // 创建 online_product_classificiation_fq 记录
    async createOnlineProductClassificiationFq(req, actionBody) {
        let selectSql = `SELECT * FROM online_product_classificiation_fq WHERE product_id=:product_id`;
        var list = await this.customQuery(selectSql, {
            product_id: actionBody.product_id
        });
        let sql;
        if (!list || list.length === 0) {
            sql = `INSERT INTO online_product_classificiation_fq (${Object.keys(actionBody).join()}) VALUE (:${Object.keys(actionBody).join(",:")}) `;
            await this.customInsert(sql, actionBody);
        } else {
            let values = [];
            Object.keys(actionBody).forEach((item, index) => {
                values.push(`${item}=:${item}`);
            });
            sql = `UPDATE online_product_classificiation_fq SET ${values.join()} WHERE product_id=:product_id`
            await this.customUpdate(sql, actionBody);
        }

        return system.getResultSuccess();
    }
    // 创建 order_info_fq、pay_fq
    async createOrderInfoAndPayFq(req, actionBody) {
        let sql = `SELECT * FROM order_info_fq WHERE order_pkid =:order_pkid`;
        let list = await this.customQuery(sql, {
            order_pkid: actionBody.orderInfo.order_pkid
        });
        if (!list || list.length === 0) {
            // 插入 order_info_fq
            let data = {};
            let keys = [
                "order_pkid", "order_id",
                "produce_first_type_pkid", "produce_first_type_name",
                "produce_second_type_pkid", "produce_second_type_name",
                "product_id", "product_name", "produce_price", "order_price",
                "order_pay", "order_add_time", "order_update_time", "account_id",
                "account_name", "account_region_province", "account_region_city",
                "account_company_name", "owner_id", "owner_name", "supplier_id",
                "ownership_company", "source", "source_type", "contract_number",
                "contract_amount"];
            keys.forEach((item, index) => {
                if (actionBody.orderInfo[item]) {
                    data[item] = actionBody.orderInfo[item]
                }
            })
            sql = `INSERT INTO order_info_fq (${Object.keys(data).join()}) VALUE (:${Object.keys(data).join(",:")}) `;
            await this.customInsert(sql, data);

        }

        sql = `SELECT * FROM pay_fq WHERE order_no =:order_no`;
        list = await this.customQuery(sql, {
            order_no: actionBody.payInfo.order_no
        });
        if (!list || list.length === 0) {
            // 插入 pay_fq
            let data = {};
            let keys = [
                "order_no", "amount",
                "pay_time", "pay_way_id",
                "pay_way_name", "pay_way_type",
                "pay_period", "transaction_id",
                "transaction_no", "creator_id",
                "creator", "create_time",
                "set_of_books_id", "set_of_books_name",
                "owner_id", "owner_name", "supplier_id",
                "ownership_company", "channel_source",
                "remark", "payment_item_id"
            ];
            keys.forEach((item, index) => {
                if (actionBody.payInfo[item]) {
                    data[item] = actionBody.payInfo[item]
                }
            })
            sql = `INSERT INTO pay_fq (${Object.keys(data).join()}) VALUE (:${Object.keys(data).join(",:")}) `;
            await this.customInsert(sql, data);
        }

        return system.getResultSuccess();
    }
}
module.exports = FgbusinesschancService;