const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("policyinfo", {                                                                                                                                                                      
    uapp_id              :DataTypes.INTEGER,//     
    policyNo             :DataTypes.STRING(64),// 政策编号       
    policyName           :DataTypes.STRING(255),// 政策名称    
    policySource           :DataTypes.STRING(255),// 政策出处    
    policyLinkUrl           :DataTypes.STRING(255),// 政策链接    
    policyProvince           :DataTypes.STRING(100),// 所属省份    
    policyCity           :DataTypes.STRING(100),// 所属城市    
    policyContent           :DataTypes.TEXT('long'),// 政策内容   
    policyDate              :DataTypes.DATE,//  政策日期                                                             
    policyTypeName: DataTypes.STRING(100),//                                                                                                                                
    policyType      :{
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.policy_type),
      set: function (val) {
        this.setDataValue("policyType", val);
        this.setDataValue("policyTypeName", uiconfig.config.pdict.policy_type[val]);
      }
    },//政策类型 'zh':'综合','fzbt':'房租补贴','jrdk':'金融贷款','zdfc':'重点扶持','ssjm':'税收减免',                                                                                                                                                             
    opNotes               :DataTypes.STRING,//  备注   
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'b_policy_info',
      validate: {

      },
      indexes: [      
      ]
    });
}
