const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("diagnosis", {
    uapp_id: DataTypes.INTEGER,
    channel_user_id: DataTypes.STRING, //渠道用户唯一码
    diagnosis_no: DataTypes.STRING, //诊断单号/申请编号
    corporate_name: DataTypes.STRING,//公司名称
    publish_name: DataTypes.STRING,//联系人名字
    publish_mobile: DataTypes.STRING,//联系人手机号
    corporate_type: { //店铺类型 电商诊断：qjd/zmd/zyd，直播诊断：qy/gtgsh/mbfqy/flfw
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.corporate_type),
      set: function (val) {
        this.setDataValue("corporate_type", val);
        this.setDataValue("corporate_type_name", uiconfig.config.pdict.corporate_type[val]);
      }
    },
    corporate_type_name: DataTypes.STRING,//店铺类型名字 电商诊断：旗舰店/专卖店/专营店，直播诊断：企业/个体工商户/民办非企业/法律服务 --暂不用
    diagnosis_type: { //诊断类型 zb/ds
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.diagnosis_type),
      set: function (val) {
        this.setDataValue("diagnosis_type", val);
        this.setDataValue("diagnosis_type_name", uiconfig.config.pdict.diagnosis_type[val]);
      }
    },
    diagnosis_type_name: DataTypes.STRING,//诊断类型名字 直播/电商 --暂不用
    diagnosis_mode: { //诊断方式 zn/rg
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.diagnosis_mode),
      set: function (val) {
        this.setDataValue("diagnosis_mode", val);
        this.setDataValue("diagnosis_mode_name", uiconfig.config.pdict.diagnosis_mode[val]);
      }
    },
    diagnosis_mode_name: DataTypes.STRING,//诊断方式名字 智能评估/人工评估 --暂不用'
    diagnosis_result: { //诊断结果 tg/wtg/rgshz
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.diagnosis_result),
      set: function (val) {
        this.setDataValue("diagnosis_result", val);
        this.setDataValue("diagnosis_result_name", uiconfig.config.pdict.diagnosis_result[val]);
      }
    },
    diagnosis_result_name: DataTypes.STRING,//诊断结果名字 通过/未通过/人工审核中 --暂不用
    diagnosis_result_data: DataTypes.JSON, // 智能诊断结果返回值 人工目前没用到
    status_name: DataTypes.STRING,//状态 dcl/gtz/dqrfa/ygb/ywc
    main_class: DataTypes.JSON,// 主营类目（一级分类-二级分类）
    whether_company: DataTypes.INTEGER,// 是否存在工商信息 20200817 lin 新增 
    qualifications_pic: DataTypes.JSON,// 基础资质json {}
    brand_pic: DataTypes.JSON,// 品牌资质json {}
    industry_pic: DataTypes.JSON,// 行业资质json {}
    notes: DataTypes.STRING,//备注
    status: { //状态 后台用 dcl/gtz/dqrfa/ygb/ywc
      // 2020 0811 lin 修改 目标枚举只有dcl 待处理，ywc已完成
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.diagnosis_status),
      set: function (val) {
        this.setDataValue("status", val);
        this.setDataValue("status_name", uiconfig.config.pdict.diagnosis_status[val]);
      }
    },
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'n_zzzd_need_info',
      validate: {

      },
      indexes: [

      ]
    });
}
