var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class PaymentAPI extends APIBase {
    constructor() {
        super();
        this.needinfoSve = system.getObject("service.dbneed.needinfoSve");
    }

    /**
     * 接口跳转-POST请求
     * actionProcess  执行的流程
     * actionType     执行的类型
     * actionBody     执行的参数
     */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, pobj.actionBody, req);
        return result;
    }
    async opActionProcess(pobj, action_type, action_body, req) {
        var opResult = null;
        switch (action_type) {
            // sy
            case "needinfo2fq"://pc端订单支付二维码生成
                opResult = await this.needinfoSve.needinfo2fq(pobj);
                break;
            // case "flowinfo"://pc端订单支付二维码生成
            //     opResult = await this.needinfoSve.flowinfo(needinfo);
            //     break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
    
}
module.exports = PaymentAPI;