var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class OrderAPI extends APIBase {
    constructor() {
        super();
        this.orderinfoSve = system.getObject("service.dbcorder.orderinfoSve");
        this.usuallycontactsSve = system.getObject("service.dbcorder.usuallycontactsSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            //--------------------------------ali订单交易 订单操作-----开始
            case "tmRefuse":// 2020 0828 lin 新增 ali商标交易 关闭订单接口
                opResult = await this.orderinfoSve.tmRefuse(pobj);
                break;
            //--------------------------------ali订单交易 订单操作-----结束
            case "getNclByCode":
                opResult = await this.orderinfoSve.getNclByCode(pobj);
                break;
            case "getAllNcl":
                opResult = await this.orderinfoSve.getAllNcl(pobj);
                break;
            case "addUsuallyContacts"://增加常用联系人，申请人
                opResult = await this.usuallycontactsSve.addContacts(pobj,pobj.actionBody);
                break;
            case "delUsuallyContacts"://删除常用联系人，申请人
                opResult = await this.usuallycontactsSve.delContacts(pobj,pobj.actionBody);
                break;
            case "updateUsuallyContacts"://修改常用联系人，申请人
                opResult = await this.usuallycontactsSve.updateContacts(pobj,pobj.actionBody);
                break;
            case "getUsuallyContacts"://查询常用联系人，申请人
                opResult = await this.usuallycontactsSve.getContacts(pobj,pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = OrderAPI;