var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class DiagnosisAPI extends APIBase {
    constructor () {
        super();
        this.diagnosisSve = system.getObject("service.dbneed.diagnosisSve");
        this.needSve = system.getObject('service.dbneed.opneedinfoSve')
    }
    /**
      * 接口跳转-POST请求
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard (pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess (pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "manualEvaluation":
                opResult = await this.diagnosisSve.manualEvaluation(pobj, pobj.actionBody, req);
                break;
            case "diagnosisInfo":
                opResult = await this.diagnosisSve.diagnosisInfo(pobj, pobj.actionBody, req);
                break;
            case "diagnosisDetail":
                opResult = await this.diagnosisSve.diagnosisDetail(pobj, pobj.actionBody, req);
                break;
            case "enterpriseInfo":
                opResult = await this.diagnosisSve.enterpriseInfo(pobj, pobj.actionBody, req);
                break;
            case 'opSubmitNeed': // 下需求 2020 0813 lin
                opResult = await this.needSve.opSubmitNeed(pobj, pobj.actionBody, req);
                break
            case 'opNeedList': // 需求列表 20 08 12 liang
                opResult = await this.needSve.opNeedList(pobj, pobj.actionBody, req);
                break
            case 'getItemByNeedNo': // 需求详情 20 08 12 liang
                opResult = await this.needSve.getItemByNeedNo(pobj);
                break
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = DiagnosisAPI;