const system = require("../../../system");
const uuidv4 = require('uuid/v4');
//内部通知调用
class UtilsChannelTmDeliveryService {
  constructor() {
    this.orderinfoDao = system.getObject("db.dbcorder.orderinfoDao");
  }
  //=================================修改渠道交付信息==============start======================================

  async getAliChannelTmDelivery(actionBody) {//查询ali渠道商标交付信息
    var sql = "select * from c_channel_delivery where sourceOrderNo=:sourceOrderNo";
    var paramWhere = { sourceOrderNo: actionBody.orderNo };
    var list = await this.orderinfoDao.customQuery(sql, paramWhere);
    if (!list || list.length == 0 || !list[0].deliveryContent) {
      return system.getResultFail(-130, "get channel delivery data is empty，30250");
    }
    return system.getResultSuccess(list[0].deliveryContent);
  }
  async getAllAliChannelTmDelivery(actionBody) {//查询ali渠道所有商标交付信息
    var sql = "select * from c_channel_delivery";
    var list = await this.orderinfoDao.customQuery(sql);
    if (!list || list.length == 0) {
      return system.getResult(null, "get channel delivery all data is empty，30253");
    }
    return system.getResultSuccess(list);
  }
  async addAliChannelTmApplicant(actionBody) {//新增ali渠道商标交付信息
    var itemResult = await this.getAliChannelTmDelivery(actionBody);
    if (itemResult.status != 0) {
      this.addChannelDelivery(actionBody.deliveryData, actionBody.orderNo)
      return system.getResultSuccess();
    }
    return system.getResult(null, "添加失败，已经存在要添加的数据，30240");
  }
  async updateAliChannelTm(actionBody) {//修改ali渠道商标信息
    this.putChannelDelivery(actionBody.deliveryData, actionBody.orderNo)
  }


  putChannelDelivery(data, orderNo) {//修改交付信息--内部调用
    var sql = "UPDATE `c_channel_delivery`  SET deliveryContent ='" + JSON.stringify(data) + "' where sourceOrderNo='" + orderNo + "'";
    sql = sql.replace('\n', '');
    this.orderinfoDao.customQuery(sql);
  }
  addChannelDelivery(data, orderNo) {//新增渠道交付信息--内部调用   
    var sql = "INSERT INTO  `c_channel_delivery` (`sourceOrderNo`,`deliveryContent`) VALUE('" +
      orderNo + "','" + JSON.stringify(data) + "')";
    this.orderinfoDao.customQuery(sql);
  }

  //=================================修改渠道交付信息==============end======================================


}
module.exports = UtilsChannelTmDeliveryService;