const system = require("../../../system");
const moment = require('moment');
/**
 * 阿里云增值电信相关接口（ICP、EDI）
 * created by zhuangbing
 * created at 2020.07.27
 */
class BaseQcService {
	constructor() {
		this.needsolutionDao = system.getObject("db.dbneed.needsolutionDao");
		this.needinfoDao = system.getObject("db.dbneed.needinfoDao");
		this.orderinfoDao = system.getObject("db.dbcorder.orderinfoDao");
		this.icpSolutionStatusReference = {
			SOLUTION_SUBMIT: "提交服务单",
			UN_PAID: "未支付", PAID: "用户支付", USER_UPLOADED: "用户上传资料", MATERIAL_UNCONFIRM: "服务商递交⽂件"
			, USER_CONFIRMED: "⽤户已确认递交⽂件", ACCOUNT_REGISTERED: "完成账户注册", MATERIAL_SUBMITTED: "完成资料递交",
			GXB_ACCEPT: "⼯信部已受理", GXB_REFUSE: "⼯信部不予受理", GXB_FAIL: "⼯信部未通过", GXB_SUCCESS: "工信部通过"
			, CLOSE: "方案关闭"
		};
		this.ediSolutionStatusReference = {
			SOLUTION_SUBMIT: "服务单通知服务商",
			USER_PAY_PRODUCE: "⽤户⽀付",
			USER_CONFIRM_PRODUCE: "⽤户确认资料",
			USER_REFUSE_PRODUCE: "资料退回修改",
			ABC_CLOSE_PRODUCE: "⼩⼆后台关闭服务单",
			USER_UPLOAD_PRODUCE: "⽤户补充基本资料"
		};
		this.ediProduceStatus = {
			110: "⽤户⽀付",
			30: "待⽤户确认",
			105: "账户已注册",
			35: "待提交审核",
			109: "管局已通过",
			106: "材料已递交⼯信部",
			10: "已⽀付",
			108: "管局不予受理",
			0: "初始状态",
			50: "订单关闭",
			25: "待⽤户提交材料",
			107: "管局已受理"
		};
		this.icpApplicationStatusReference = {
			504: "创建交付订单",
			505: "资料收集完成",
			506: "资料加工完成",
			507: "完成账户注册",
			508: "服务商完成提交资料到⼯信部",
			509: "⼯信部已受理",
			510: "⼯信部不予受理",
			511: "⼯信部通过",
			512: "⼯信部未通过"
		};
	}

	//根据需求关闭ICP方案（关闭需求后调用）
	async abolishIcpProgrammeByNeed(pobj) {
		console.log("abolishIcpProgrammeByNeed+++", pobj)
		var ab = pobj.actionBody;
		var app = pobj.appInfo;
		if (!app || !app.uapp_id) {
			return system.getResultFail(-100, "未知渠道");
		}
		if (!ab.intentionBizId) {
			return system.getResultFail(-101, "需求编号不能为空");
		}
		//获取需求信息
		var needinfo = await this.needinfoDao.model.findOne({
			attributes: ["id", "status", "statusName", "needNo", "uapp_id"],//2020-10-29 laolan xinzeng uapp_id
			where: { channelNeedNo: ab.intentionBizId }, raw: true
		});
		var uappId = {};
		if (!needinfo || !needinfo.id) {
			return system.getResultFail(-201, "未知需求信息");
		} else {
			//2020-12-11 laolan xiugai
			uappId['uapp_id'] = needinfo.uapp_id;
		}
		if (needinfo.status == "ygb" || needinfo.status == "ycd") {
			return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
		}
		//获取方案信息
		var ns = await this.needsolutionDao.model.findOne({
			where: { needNo: needinfo.needNo, isInvalid: 0 }, raw: true
		});

		if (ns && ns.id) {
			if (ns.orderNo) {
				return system.getResultFail(-102, "该需求已生成订单，不能关闭！");
			  }
			if (ns.status == "ywc") {
				return system.getResultFail(-103, "方案状态错误，不能废弃已完成方案-2");
			}
      		var flowStatus = ns.solutionContent && ns.solutionContent.status ? ns.solutionContent.status : "";
			if (flowStatus && [
				"SOLUTION_SUBMIT", "PAID", "USER_UPLOADED", "MATERIAL_UNCONFIRM", "USER_CONFIRMED", "GXB_REFUSE", "CLOSE"
			].indexOf(flowStatus) >= 0) {
				var self = this;
				return await this.needsolutionDao.db.transaction(async function (t) {
					var needObj = {
						id: needinfo.id, status: "ygb", notes: ab.note
					};
					await self.needinfoDao.update(needObj, t);//关闭需求
					if (ns && ns.id) {
						await self.needsolutionDao.model.update({ status: "yzf", isInvalid: 1 }, { where: { id: ns.id }, transaction: t });//方案废弃
						// return system.getResultSuccess(ns.orderNo);
						ns = ns ? ns : {};
						ns = Object.assign(ns, uappId)
						console.log('guanbi ns +++', ns)
						return system.getResultSuccess(ns);
					}
				})
			} else {
				if (flowStatus && ["GXB_REFUSE", "CLOSE"].indexOf(flowStatus) < 0) {
					return system.getResultFail(-104, "⽅案状态为关闭或不予受理才可关闭需求");
				}
			}
		} else {
			return system.getResultSuccess(uappId);
		}
	}

	

	//提交方案
	async submitIcpProgramme(pobj) {
		console.log("pobj++++", pobj)
		var ab = pobj.actionBody;
		var user = pobj.userInfo;
		if (!user || !user.id) {
			return system.getResultFail(-100, "未知用户");
		}
		ab["createUserId"] = user.id;
		if (!ab.needNo) {
			return system.getResultFail(-101, "渠道需求号不能为空");
		}
		if (!ab.solutionContent) {
			return system.getResultFail(-102, "方案信息有误");
		}
		//获取需求信息
		var needinfo = await this.needinfoDao.model.findOne({
			where: { channelNeedNo: ab.needNo }, raw: true
		});
		if (!needinfo || !needinfo.id) {
			return system.getResultFail(-201, "未知需求信息");
		}
		if (needinfo.status == "ycd" || needinfo.status == "ygb") {
			return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能创建方案");
		}
		var bizType = needinfo.typeCode;//ab.solutionContent.bizType;//业务类型
		ab.solutionContent.bizType = bizType;
		if (!bizType) {
			return system.getResultFail(-205, "方案类型错误");
		}
		// if (!bizType || !needinfo.typeCode || bizType != needinfo.typeCode) {
		//   return system.getResultFail(-205, "方案类型错误");
		// }
		if (!needinfo.channelTypeCode) {
			return system.getResultFail(-206, "渠道方案类型错误");
		}
		ab.solutionContent.typeCode = needinfo.typeCode;
		ab.solutionContent.typeName = needinfo.typeName;
		var ns = await this.needsolutionDao.model.findAll({
			where: { channelNeedNo: ab.needNo }, raw: true, order: [["id", 'asc']]
		});
		for (var i = 0; i < ns.length; i++) {
			var fa = ns[i];
			if (fa.status == "dqr" || fa.status == "ywc") {
				return system.getResultFail(-207, "需求方案已存在，不能重复提交");
			}
			if (fa.status == "ybh") {
				ab.channelSolutionNo = fa.channelSolutionNo;
			}
			if (fa.status == "yzf") {
				ab.channelSolutionNo = "";
			}
		}
		var solution = ab.solutionContent.solution;
		if (!solution) {
			return system.getResultFail(-103, "方案交付信息有误");
		}
		//判断属于渠道 18阿里，44百度，52易名
		if(needinfo.uapp_id == 44 || needinfo.uapp_id == 18){
			if (needinfo.channelTypeCode == "7") {//edi
				ab.solutionContent.solution.IcpType = 2;
			} else if (needinfo.channelTypeCode == "5") {//icp
				ab.solutionContent.solution.IcpType = 1;
			} else {
				return system.getResultFail(-207, "需求业务类型有误");
			}
		}
		if(needinfo.uapp_id == 52){
			if (needinfo.channelTypeCode == "7") {//edi
				ab.solutionContent.solution.IcpType = 2;
			} else if (needinfo.channelTypeCode == "5") {//icp
				ab.solutionContent.solution.IcpType = 1;
			} else if (needinfo.channelTypeCode == "icpnb") {//icpnb
				ab.solutionContent.solution.IcpType = 3;
			} else if (needinfo.channelTypeCode == "edinb") {//edinb
				ab.solutionContent.solution.IcpType = 4;
			} else {
				return system.getResultFail(-208, "需求业务类型有误-52");
			}
		}
		if (!solution.CompanyName) {
			return system.getResultFail(-105, "公司名不能为空");
		}
		if (!solution.CompanyAddress) {
			return system.getResultFail(-106, "公司地址不能为空");
		}
		if (!solution.Area) {
			return system.getResultFail(-107, "区域不能为空");
		}
		if (!solution.ActionType) {
			return system.getResultFail(-108, "办理类型不能为空");
		}
		var solutionFlowList = ab.solutionContent.solutionFlowList || [];
		solutionFlowList.push({
			status: "SOLUTION_SUBMIT", statusName: this.icpSolutionStatusReference.SOLUTION_SUBMIT, updated_at: new Date()
		});
		ab.solutionContent.status = "SOLUTION_SUBMIT";
		ab.solutionContent.statusName = this.icpSolutionStatusReference.SOLUTION_SUBMIT;
		ab.solutionContent.solutionFlowList = solutionFlowList;
		ab["channelNeedNo"] = needinfo.channelNeedNo;
		var solutionNo = await this.getBusUid("ns");
		ab["solutionNo"] = solutionNo;
		ab["status"] = "dqr";
		var customerInfo = {//客户信息
			"publishName": needinfo.publishName,
			"publishMobile": needinfo.publishMobile
		};
		var salesmanInfo = {//业务员信息
			"salesmanName": user.channel_username,
			"salesmanMobile": user.mobile,
			"salesmanId": user.id,
			"salesmanChannelId": user.channel_userid
		};
		ab.solutionContent["customerInfo"] = customerInfo;
		ab.solutionContent["salesmanInfo"] = salesmanInfo;
		ab.solutionContent = JSON.stringify(ab.solutionContent);
		var self = this;
		return await this.needsolutionDao.db.transaction(async function (t) {
			ab["needNo"] = needinfo.needNo;
			var od = await self.needsolutionDao.create(ab, t);
			if (od && od.id) {
				var needObj = {
					id: needinfo.id
				};
				if (!needinfo.followManUserId) {
					needObj = {
						id: needinfo.id,
						followManUserId: user.id,//跟进人id
						followManName: user.channel_username,//跟进人姓名
						followManMobile: user.mobile,//跟进人手机号（合伙人）
						followManOnlyCode: user.channel_userid
					};
				}
				if (!needinfo.followContent) {
					var followContent = [{
						followDate: new Date(),
						content: "icp提交方案"
					}];
					followContent = JSON.stringify(followContent);
					needObj["followContent"] = followContent;
				}
				await self.needinfoDao.update(needObj, t);
				needinfo = await self.needinfoDao.model.findOne({
					where: { id: needinfo.id }, raw: true
				});
				return system.getResultSuccess({ needinfo: needinfo, needsolution: od });
			} else {
				return system.getResultFail(-302, "提交方案失败");
			}
		})

	}
	
	//交付商提交材料信息
	async serviceProviderSubmitMaterial(pobj) {
		var ab = pobj.actionBody;
		console.log('ab++', ab)
		if (!ab.orderNo) {
			return system.getResultFail(-101, "订单号不能为空");
		}
		var ns = await this.needsolutionDao.model.findOne({
			where: { orderNo: ab.orderNo }, raw: true
		});
		if (!ns || !ns.id) {
			return system.getResultFail(-301, "未知方案");
		}
		ab["BizId"] = ns.channelSolutionNo;
		pobj.actionBody = ab;
		return this.submitIcpMaterial(pobj);
	}
	//提交icp材料信息
	async submitIcpMaterial(pobj) {
		var ab = pobj.actionBody;
		console.log('ababab++', ab)
		var user = pobj.userInfo;
		if (!user || !user.id) {
			return system.getResultFail(-100, "未知用户");
		}
		// ab["createUserId"] = user.id;
		if (!ab.BizId) {
			return system.getResultFail(-101, "渠道方案编号不能为空");
		}
		if (!ab.material) {
			return system.getResultFail(-102, "材料信息有误");
		}
		//获取方案信息
		var needsolutioninfo = await this.needsolutionDao.model.findOne({
			attributes: ["id", "needNo", "orderNo", "solutionContent"],
			where: { channelSolutionNo: ab.BizId, isInvalid: 0 }, raw: true
		});
		console.log('needsolutioninfo+++', needsolutioninfo)
		if (!needsolutioninfo || !needsolutioninfo.id) {
			return system.getResultFail(-400, "未知方案");
		}
		if (!needsolutioninfo.needNo) {
			return system.getResultFail(-401, "方案需求信息有误");
		}
		var solutionContent = needsolutioninfo.solutionContent;
		if (!solutionContent) {
			return system.getResultFail(-402, "方案交付信息有误");
		}
		//----
		var productType = solutionContent.solution;
		if (productType && productType.IcpType) {
			productType = productType.IcpType
			switch (productType) {
				case "5":
					productType = "ICP"
					break;
				case "7":
					productType = "EDI"
					break;
			}
		}
		//----
		// var orderInfo = await this.orderinfoDao.model.findOne({
		//   attributes: ["uapp_id"],
		//   where: {orderNo: needsolutioninfo.orderNo}, raw: true
		// })
		// if(orderInfo){
		//   var uappId = orderInfo.uapp_id
		// }
		// if(uappId == "18"){//ali
		//   if (solutionContent.status != "USER_UPLOADED") {
		//     return system.getResultFail(-403, "用户未上传材料，不能执行此操作");
		//   }
		// }
		//获取需求信息
		// var needinfo = await this.needinfoDao.model.findOne({
		//   where: { needNo: needsolutioninfo.needNo }, raw: true
		// });
		// if (!needinfo || !needinfo.id) {
		//   return system.getResultFail(-201, "未知需求信息");
		// }
		// // if (needinfo.status == "ycd" || needinfo.status == "ygb") {
		// if (needinfo.status == "ygb") {
		//   return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
		// }
		var material = ab.material;
		if (!material.Domain) {
			return system.getResultFail(-101, "备案域名不能为空");
		}
		//CorporateName 法⼈名称
		if (!material.hasOwnProperty("IncludeForeignInvestment")) {
			return system.getResultFail(-102, "包含外贸参数不能为空");
		}
		if (!material.PartnerBusinessLicense) {
			return system.getResultFail(-103, "营业执照不能为空");
		}
		if (!material.PartnerIdCardList || material.PartnerIdCardList.length < 1) {
			return system.getResultFail(-105, "相关人员身份证不能为空");
		}
		if (!material.PartnerDomainCertificate) {
			return system.getResultFail(-106, "域名证书不能为空");
		}
		solutionContent.material = ab.material;
		var solutionFlowList = solutionContent.solutionFlowList || [];
		solutionFlowList.push({
			status: "MATERIAL_UNCONFIRM", statusName: this.icpSolutionStatusReference.MATERIAL_UNCONFIRM, updated_at: new Date()
		});
		solutionContent.status = "MATERIAL_UNCONFIRM";
		solutionContent.statusName = this.icpSolutionStatusReference.MATERIAL_UNCONFIRM;
		needsolutioninfo.solutionContent = JSON.stringify(solutionContent);
		var self = this;
		return await this.needsolutionDao.db.transaction(async function (t) {
			await self.needsolutionDao.update(needsolutioninfo, t);
			var new_needsolutioninfo = await self.needsolutionDao.model.findOne({
				where: { id: needsolutioninfo.id }, raw: true
			});
			//2020-10-27 laolan start 
			var orderInfo = await self.orderinfoDao.model.findOne({
				where: { orderNo: ab.orderNo }, raw: true
			})
			if (orderInfo) {
				var uappIds = orderInfo.uapp_id;
				new_needsolutioninfo['orderChannelNo'] = orderInfo.channelOrderNo;
				new_needsolutioninfo['uapp_id'] = uappIds;
				new_needsolutioninfo['productType'] = productType;
			}
			console.log('new_needsolutioninfo+++', new_needsolutioninfo)
			//2020-10-27 laolan end
			return system.getResultSuccess(new_needsolutioninfo);

		})
	}
	//交付商通知状态变更
	async serviceProviderNotification(pobj) {
		var ab = pobj.actionBody;
		if (!ab.orderNo) {
			return system.getResultFail(-101, "订单号不能为空");
		}
		if (!ab.status) {
			return system.getResultFail(-102, "交付状态不能为空");
		} else {
			ab["ApplicationStatus"] = ab.status;
		}
		if (ab.officialFileURL) {
			ab["OfficialFileURL"] = ab.officialFileURL;
		}
		//2021-3-18 addNew
		if (ab.certificateNumber) {
			ab["CertificateNumber"] = ab.certificateNumber;
		}
		if (ab.certificateStartTime) {
			ab["CertificateStartTime"] = ab.certificateStartTime;
		}
		if (ab.certificateEndTime) {
			ab["CertificateEndTime"] = ab.certificateEndTime;
		}

		var ns = await this.needsolutionDao.model.findOne({
			where: { orderNo: ab.orderNo }, raw: true
		});
		if (!ns || !ns.id) {
			return system.getResultFail(-301, "未知方案");
		}
		ab["BizId"] = ns.channelSolutionNo;
		ab["solutionNo"] = ns.solutionNo;
		pobj.actionBody = ab;
		return this.acceptIcpPartnerNotification(pobj);
	}
	//服务商通知状态变更
	async acceptIcpPartnerNotification(pobj) {
		console.log('服务商通知状态变更pobj++++', pobj)
		var ab = pobj.actionBody;
		var user = pobj.userInfo;

		if (!user || !user.id) {
			return system.getResultFail(-100, "未知用户");
		}
		// ab["createUserId"] = user.id;
		// if (!ab.BizId) {
		//   return system.getResultFail(-101, "渠道方案编号不能为空");
		// }
		if (!ab.solutionNo) {
			return system.getResultFail(-101, "方案编号不能为空");
		}
		if (!ab.ApplicationStatus) {
			return system.getResultFail(-102, "通知状态不能为空");
		}
		//获取方案信息
		var needsolutioninfo = await this.needsolutionDao.model.findOne({
			attributes: ["id", "status", "solutionContent", "needNo"],
			where: { solutionNo: ab.solutionNo }, raw: true
		});
		if (!needsolutioninfo || !needsolutioninfo.id) {
			return system.getResultFail(-400, "未知方案");
		}
		// if (!needsolutioninfo.needNo) {
		//   return system.getResultFail(-401, "方案需求信息有误");
		// }
		var solutionContent = needsolutioninfo.solutionContent;
		if (!solutionContent) {
			return system.getResultFail(-402, "方案交付信息有误");
		}
		if (solutionContent.applicationStatus && solutionContent.applicationStatus > ab.ApplicationStatus) {
			return system.getResultFail(-403, "操作失败，交付流程未按顺序执行");
		}
		if (solutionContent.ApplicationStatus && solutionContent.ApplicationStatus == ab.ApplicationStatus) {
			return system.getResultFail(-405, "操作失败，该流程状态已提交，不能重复提交");
		}
		//获取需求信息
		// var needinfo = await this.needinfoDao.model.findOne({
		//   where: { needNo: needsolutioninfo.needNo }, raw: true
		// });
		// if (!needinfo || !needinfo.id) {
		//   return system.getResultFail(-201, "未知需求信息");
		// }
		// // if (needinfo.status == "ycd" || needinfo.status == "ygb") {
		// if (needinfo.status == "ygb") {
		//   return system.getResultFail(-202, "serviceProviderSubmitMateria" + needinfo.statusName + ",不能执行此操作");
		// }
		var solutionFlowList = solutionContent.solutionFlowList || [];
		var orderuappId = await this.orderinfoDao.model.findOne({
			attributes: ["uapp_id"],
			where: { orderNo: ab.orderNo }, raw: true
		})
		console.log("orderuappId+++", orderuappId)
		if (orderuappId) {
			var uappId = orderuappId.uapp_id;
		}
		if (uappId != '50') {
			if (!needsolutioninfo.needNo) {
				return system.getResultFail(-401, "方案需求信息有误");
			}
			//获取需求信息
			var needinfo = await this.needinfoDao.model.findOne({
				where: { needNo: needsolutioninfo.needNo }, raw: true
			});
			if (!needinfo || !needinfo.id) {
				return system.getResultFail(-201, "未知需求信息");
			}
			if (needinfo.status == "ygb") {
				return system.getResultFail(-202, "serviceProviderSubmitMateria" + needinfo.statusName + ",不能执行此操作");
			}
		}
		if (ab.ApplicationStatus == 507) {//完成账户注册
			if (uappId == '18') {
				if (solutionContent.status != "USER_CONFIRMED") {
					return system.getResultFail(-508, "交付流程错误，用户确认递交⽂件后才能执行此操作");
				}
			}
			solutionContent.ApplicationStatus = 507;
			solutionFlowList.push({
				file: ab.OfficialFileURL || "",
				status: "ACCOUNT_REGISTERED", statusName: this.icpSolutionStatusReference.ACCOUNT_REGISTERED, updated_at: new Date()
			});
			solutionContent.status = "ACCOUNT_REGISTERED";
			solutionContent.statusName = this.icpSolutionStatusReference.ACCOUNT_REGISTERED;
		}
		if (ab.ApplicationStatus == 508) {//"服务商完成提交资料到⼯信部
			if (solutionContent.status != "ACCOUNT_REGISTERED") {
				return system.getResultFail(-508, "交付流程错误，请先完成账户注册");
			}
			solutionFlowList.push({
				file: ab.OfficialFileURL || "",
				status: "MATERIAL_SUBMITTED", statusName: this.icpSolutionStatusReference.MATERIAL_SUBMITTED, updated_at: new Date()
			});
			solutionContent.status = "MATERIAL_SUBMITTED";
			solutionContent.statusName = this.icpSolutionStatusReference.MATERIAL_SUBMITTED;
		}
		if (ab.ApplicationStatus == 509) {//⼯商部已受理
			if (solutionContent.status != "MATERIAL_SUBMITTED") {
				return system.getResultFail(-509, "交付流程错误，请先完成资料递交");
			}
			solutionFlowList.push({
				file: ab.OfficialFileURL || "",
				status: "GXB_ACCEPT", statusName: this.icpSolutionStatusReference.GXB_ACCEPT, updated_at: new Date()
			});
			solutionContent.status = "GXB_ACCEPT";
			solutionContent.statusName = this.icpSolutionStatusReference.GXB_ACCEPT;
		}
		if (ab.ApplicationStatus == 510) {//⼯商部不予受理
			if (solutionContent.status != "MATERIAL_SUBMITTED") {
				return system.getResultFail(-510, "交付流程错误，请先完成资料递交");
			}
			solutionFlowList.push({
				file: ab.OfficialFileURL || "",
				status: "GXB_REFUSE", statusName: this.icpSolutionStatusReference.GXB_REFUSE, updated_at: new Date()
			});
			solutionContent.status = "GXB_REFUSE";
			needsolutioninfo.status = "ywc";
			solutionContent.statusName = this.icpSolutionStatusReference.GXB_REFUSE;
		}
		if (ab.ApplicationStatus == 511) {//⼯商部通过
			if (solutionContent.status != "GXB_ACCEPT") {
				return system.getResultFail(-511, "交付流程错误，⼯信部已受理后才能执行此操作");
			}
			if(uappId == "18"){
				solutionFlowList.push({
					file: ab.OfficialFileURL || "", status: "GXB_SUCCESS", 
					statusName: this.icpSolutionStatusReference.GXB_SUCCESS, updated_at: new Date(),
					CertificateNumber:ab.CertificateNumber,
					CertificateStartTime:ab.CertificateStartTime,
					CertificateEndTime:ab.CertificateEndTime 
				});
			}else{
				solutionFlowList.push({
					file: ab.OfficialFileURL || "",
					status: "GXB_SUCCESS", statusName: this.icpSolutionStatusReference.GXB_SUCCESS, updated_at: new Date()
				});
			}
			needsolutioninfo.status = "ywc";
			solutionContent.status = "GXB_SUCCESS";
			solutionContent.statusName = this.icpSolutionStatusReference.GXB_SUCCESS;
		}
		if (ab.ApplicationStatus == 512) {//⼯信部未通过
			if (solutionContent.status != "GXB_ACCEPT") {
				return system.getResultFail(-512, "交付流程错误，⼯信部已受理后才能执行此操作");
			}
			solutionFlowList.push({
				file: ab.OfficialFileURL || "",
				status: "GXB_FAIL", statusName: this.icpSolutionStatusReference.GXB_FAIL, updated_at: new Date()
			});
			solutionContent.status = "GXB_FAIL";
			needsolutioninfo.status = "ywc";
			solutionContent.statusName = this.icpSolutionStatusReference.GXB_FAIL;
		}
		solutionContent.solutionFlowList = solutionFlowList;
		var applicationStatusList = solutionContent.applicationStatusList || [];
		if(uappId == "18"){
			var statusObj = {
				"OfficialFileURL": ab.OfficialFileURL || "",
				"ApplicationStatus": ab.ApplicationStatus,
				"ApplicationStatusName": this.icpApplicationStatusReference[ab.ApplicationStatus],
				"created_at": new Date(),
				//2021-3-18 addNew
				"CertificateNumber":ab.CertificateNumber || "",//证书编号
				"CertificateStartTime":ab.CertificateStartTime || "",//证书有效期 开始时间
				"CertificateEndTime":ab.CertificateEndTime || ""//证书有效期 结束时间
			};
		}else{
			var statusObj = {
				"OfficialFileURL": ab.OfficialFileURL || "",
				"ApplicationStatus": ab.ApplicationStatus,
				"ApplicationStatusName": this.icpApplicationStatusReference[ab.ApplicationStatus],
				"created_at": new Date()
			};
		}
		applicationStatusList.push(statusObj);
		solutionContent.applicationStatusList = applicationStatusList;
		solutionContent.applicationStatus = ab.ApplicationStatus;
		needsolutioninfo.solutionContent = JSON.stringify(solutionContent);

		console.log("ab.orderNo+++", ab.orderNo)
		var self = this;
		var orderInfo = await self.orderinfoDao.model.findOne({
			attributes: ["channelOrderNo"],
			where: { orderNo: ab.orderNo }, raw: true
		})
		console.log("orderInfo+++", orderInfo)
		if (orderInfo) {
			var channelOrderNo = orderInfo.channelOrderNo
		}
		return await this.needsolutionDao.db.transaction(async function (t) {
			await self.needsolutionDao.update(needsolutioninfo, t);
			statusObj["BizId"] = ab.BizId;
			//2020-10-27 laolan start 
			statusObj['uapp_id'] = uappId;
			statusObj['channelOrderNo'] = channelOrderNo;
			console.log('statusObj++', statusObj)
			//2020-10-27 laolan start 
			return system.getResultSuccess(statusObj);
		})
	}

	/*
	返回20位业务订单号
	prefix：业务前缀
	*/
	async getBusUid(prefix) {
		prefix = (prefix || "");
		if (prefix) {
			prefix = prefix.toUpperCase();
		}
		var prefixlength = prefix.length;
		var subLen = 8 - prefixlength;
		var uidStr = "";
		if (subLen > 0) {
			uidStr = await this.getUidInfo(subLen, 60);
		}
		var timStr = moment().format("YYYYMMDDHHmm");
		return prefix + timStr + uidStr;
	}
	/*
	len：返回长度
	radix：参与计算的长度，最大为62
	*/
	async getUidInfo(len, radix) {
		var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
		var uuid = [], i;
		radix = radix || chars.length;
		if (len) {
			for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
		} else {
			var r;
			uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
			uuid[14] = '4';
			for (i = 0; i < 36; i++) {
				if (!uuid[i]) {
					r = 0 | Math.random() * 16;
					uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
				}
			}
		}
		return uuid.join('');
	}

	
}
module.exports = BaseQcService;
