var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class PolicyAPI extends APIBase {
    constructor() {
        super();
        // this.utilsProductSve = system.getObject("service.utilsSve.utilsProductSve");
        this.policyinfoSve = system.getObject("service.dbpolicy.policyinfoSve");
        this.policyneedSve = system.getObject("service.dbpolicy.policyneedSve");
        this.policysubscribeSve = system.getObject("service.dbpolicy.policysubscribeSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        // if (!pobj.userInfo) {
        //     return system.getResult(system.noLogin, "user no login!");
        // }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        if(pobj.actionType=='getPolicyNeedList' || pobj.actionType=='submitPolicyNeedNotes' ){
            if (!pobj.userInfo) {
                return system.getResult(system.noLogin, "user no login!");
            }
            if (!pobj.appInfo) {
                return system.getResult(system.noLogin, "app is null!");
            }
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {         
            case "policyQuery"://政策检索
                opResult = await this.policyinfoSve.policyQuery(pobj);
                break;
            case "policyTypeQuery"://政策检索(根据政策类型检索)
                opResult = await this.policyinfoSve.policyTypeQuery(pobj);
                break;
            case "submitPolicyNeed"://政策申请提报
                // opResult = system.getResult(null, "接口开发中");
                opResult = this.policyneedSve.submitPolicyNeed(pobj);
                break;
            case "getPolicyNeedList"://获取政策申请列表
                // opResult = system.getResult(null, "接口开发中");
                opResult = this.policyneedSve.getPolicyNeedList(pobj);
                break;
            case "submitPolicyNeedNotes"://申请信息备注提交
                opResult = this.policyneedSve.submitPolicyNeedNotes(pobj);
                break;
            case "submitPolicysubscribe"://提交政策订阅
                opResult = this.policysubscribeSve.submitPolicysubscribe(pobj);
                break;
            case "delPolicysubscribe"://取消政策订阅
                opResult = this.policysubscribeSve.delPolicysubscribe(pobj);
                break;
            case "getPolicysubscribeList"://获取政策订阅列表
                opResult = this.policysubscribeSve.getPolicysubscribeList(pobj);
                break;
            case "policyTypeCount"://政策类型统计计数
                opResult = this.policyinfoSve.policyTypeCount(pobj);
                break;
            case "policySubscribeQuery"://政策订阅检索列表(通过订阅信息查询订阅的政策信息)
                opResult = this.policysubscribeSve.policySubscribeQuery(pobj);
                break;
            case "getPolicyBusinessFq"://政策商机（蜂擎）
                opResult = this.policyneedSve.getPolicyBusinessFq(pobj);
                break;
            case "getPolicyNeedInfo"://政策需求信息（icompany）
                opResult = this.policyneedSve.getPolicyNeedInfo(pobj);
                break;
            case "taskpolicyneed2fq"://推送政策需求数据至蜂擎系统(任务)
                opResult = this.policyneedSve.taskpolicyneed2fq(pobj);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = PolicyAPI;