var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class LogoOrderAPI extends APIBase {
    constructor() {
        super();
        this.orderinfoSve = system.getObject("service.dbcorder.orderinfoSve");
        this.logoOrderSve = system.getObject("service.dbcorder.logoOrderSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "getPaidLogoListByUser"://获取已购买的logo
                opResult = this.logoOrderSve.getPaidLogoListByUser(pobj);
                break;
            case "getLogoMaterial"://下载logo素材
                opResult = this.logoOrderSve.getLogoMaterial(pobj);
                break;
            case "getCollectibleLogoListByUser"://获取收藏的logo
                opResult = this.logoOrderSve.getCollectibleLogoListByUser(pobj);
                break;
            case "collectLogo"://收藏logo
                opResult = this.logoOrderSve.collectLogo(pobj);
                break;
            case "cancelCollectLogo"://取消收藏
                opResult = this.logoOrderSve.cancelCollectLogo(pobj);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = LogoOrderAPI;