const system = require("../system");
const settings = require("../../config/settings");
// const DocBase = require("./doc.base");
const uuidv4 = require('uuid/v4');
const md5 = require("MD5");
class APIBase {
    constructor() {
        this.execClientNew = system.getObject("util.execClientNew");
        this.logCtl = system.getObject("service.common.oplogSve");
        this.exTime = 2 * 3600;//缓存过期时间，2小时
    }
    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }
    async checkAcck(gname, methodname, pobj, query, req) {
        if (methodname.length > 4) {
            var prefixStr = methodname.substr(0, 4);
            if (prefixStr == "task" || prefixStr == "nbtz") {
                return system.getResultSuccess();
            }
        }//为任务或内部通知的放行
        var method = pobj.actionType;
        if (method && method.length > 4) {
            var prefixStr = method.substr(0, 4);
            if (prefixStr == "task" || prefixStr == "nbtz") {
                return system.getResultSuccess();
            }
        }
        if (["updateTmStatus","bulkCreateNeeds","bulkCreateOrders"].indexOf(methodname) >= 0) {
            return system.getResultSuccess();
        }
        if (!pobj.appInfo) {
            return system.getResult(null, "pobj.appInfo can not be empty ！！");
        }
        return system.getResultSuccess();
    }
    async doexec(gname, methodname, pobj, query, req) {
        req.requestId = this.getUUID();
        this.execClientNew.execLogs("center-order-doexecMethod-receive" + req.path, pobj, "center-order-doexecMethod-receive", tmpResult, null);
        try {
            //验证accesskey或验签
            var isPassResult = await this.checkAcck(gname, methodname, pobj, query, req);
            if (isPassResult.status != 0) {
                isPassResult.requestId = "";
                return isPassResult;
            }
            var result = await this[methodname](pobj, query, req);
            if (!result.requestId) {
                result.requestId = pobj.RequestId ? pobj.RequestId : pobj.requestId || req.requestId;
            }
            this.logCtl.createDb({
                appid: pobj.appInfo ? pobj.appInfo.uapp_id : "",
                appkey: pobj.appInfo ? pobj.appInfo.uapp_key : "",
                requestId: req.requestId,
                op: req.classname + "/" + methodname,
                content: JSON.stringify(pobj),
                resultInfo: JSON.stringify(result),
                clientIp: req.clientIp,
                agent: req.uagent,
                opTitle: "api服务提供方appKey:" + settings.appKey,
            });
            var tmpResult = pobj.actionType && pobj.actionType.indexOf("List") < 0 ? result : { status: result.status, message: result.message, requestId: result.requestId };
            this.execClientNew.execLogs("center-order-doexecMethod-reqPath:" + req.path, pobj, "center-order-doexecMethod", tmpResult, null);
            return result;
        } catch (e) {
            const stackStr = e.stack ? e.stack : JSON.stringify(e);
            console.log(stackStr, "api调用出现异常，请联系管理员..........")
            this.logCtl.createDb({
                appid: pobj.appInfo ? pobj.appInfo.uapp_id : "",
                appkey: pobj.appInfo ? pobj.appInfo.uapp_key : "",
                requestId: req.requestId,
                op: req.classname + "/" + methodname,
                content: JSON.stringify(pobj),
                resultInfo: stackStr,
                clientIp: req.clientIp,
                agent: req.uagent,
                opTitle: "api调用出现异常，请联系管理员error，appKey:" + settings.appKey,
            });
            // this.logCtl.error({
            //     appid: pobj.appInfo ? pobj.appInfo.uapp_id : "",
            //     appkey: pobj.appInfo ? pobj.appInfo.uapp_key : "",
            //     requestId: req.requestId,
            //     op: req.classname + "/" + methodname,
            //     content: e.stack,
            //     clientIp: pobj.clientIp,
            //     agent: req.uagent,
            //     optitle: "api调用出现异常，请联系管理员",
            // });
            this.execClientNew.execLogs("center-order-doexecMethod-reqPath异常:" + req.path, pobj, "center-channel-doexecMethod", null, stackStr);
            var rtnerror = system.getResultFail(-200, "出现异常，error：" + e.stack);
            rtnerror.requestId = req.requestId;
            return rtnerror;
        }
    }
}
module.exports = APIBase;
