var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const fs = require("fs");
const { json } = require("sequelize");
// 2020 0807 lin 新增 需求相关
// 接口文档地址：
class UtilsOpNeedService extends AppServiceBase {
  constructor() {
    super();
    this.centerOrderUrl = settings.centerOrderUrl();
    this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
    this.aliclient = system.getObject("util.aliyunClient");
    this.ossClient = system.getObject("util.ossClient");
    this.restClient = system.getObject("util.restClient");
    this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
    this.opPushQueueUrl = settings.opPushQueueUrl();
  }

  /**
    * 提交需求 h5/pc 通用提交需求接口 如果需求内容是具体sku价格项 则不适用 目前只有鑫创and中小微在用。
    * @param {*} pobj 
    * @param {*} actionBody 
    */
  async opSubmitNeed(pobj, actionBody) {
    var sobj = pobj;
    if (actionBody.type) {
      // 获取商品类型
      sobj.actionType = "getProductTypeInfo";
      var url = settings.centerAppUrl() + "action/opProduct/springBoard";
      var opResult = await this.restPostUrl(sobj, url);
      if (opResult.status != 0) {
        return system.getResultFail(-5015, "产品类型查询失败");
      }
      if (!opResult.data) {
        return system.getResultFail(-5016, "请检查产品类型编码");
      }
      pobj.actionBody.service_product_id = opResult.data.service_product_id;// 获取skuid skuid应在product price表 代表具体价格项
      pobj.actionBody.productId = opResult.data.service_product_id;// productId 注意这里与上面不是相等的值。 productId代表一类产品应在type里
      pobj.actionBody.appName = pobj.appInfo.app_name;
      pobj.actionBody.type_code = opResult.data.type_code;
      pobj.actionBody.type_name = opResult.data.type_name;
      pobj.actionBody.channel_type_code = opResult.data.channel_type_code;
      pobj.actionBody.channel_type_name = opResult.data.channel_type_name;
      pobj.actionBody.phone = pobj.actionBody.mobile;
    }
    // 提交需求
    pobj.actionType = "opSubmitNeed";
    var reqUrl = this.centerOrderUrl + "action/opNeed/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    this.execClientNew.execLogs(`推送蜂擎前创建需求信息->opSubmitNeed->channel(opSubmitNeed)`, pobj, "center-channel-UtilsOpNeedService-opSubmitNeed", result, null);
    if (result.status == 0) {
      pobj.actionBody.idempotentId = result.data.channelNeedNo;
      pobj.actionBody.idempotentSource = opResult.data.channel_type_code;
      pobj.actionBody.intentionBizId = result.data.channelNeedNo;// 这里用来推送后修改需求状态
      this.utilsPushSve.business2Channel(pobj, "pushNeedBusiness");
    }
    return result;
  }

  /**
    * 提交需求 h5/pc 通用
    * @param {*} pobj 
    * @param {*} actionBody 
    */
  async opNeedList(pobj, actionBody) {
    // 获取需求列表
    var reqUrl = this.centerOrderUrl + "action/opNeed/springBoard";
    var opNeedListResult = await this.restPostUrl(pobj, reqUrl);
    return opNeedListResult;
  }

  /**
  * 关闭需求
  * @param {*} pobj 
  * @param {*} actionBody 
  */
  async opNeedClose(pobj, actionBody) {
    if (!actionBody.needNo) {
      return system.getResult(null, "actionBody.channelNeedNo can not be empty，100395");
    }
    if (!actionBody.note) {
      return system.getResult(null, "actionBody.note can not be empty，100395");
    }
    var reqUrl = this.centerOrderUrl + "action/opNeed/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if (result.status != 0) {
      return system.getResult(null, "推送失敗　100388");
    }
    return system.getResultSuccess();
  }

  //查询需求详情
  async getItemByNeedNo(pobj, actionBody) {
    if (!actionBody.needNo) {
      return system.getResult(null, "actionBody.needNo can not be empty，100395");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }

  async getNeedList(pobj, actionBody) {
    // pobj.
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }

  //状态更新
  async icpNotify(pobj) {
    var actionBody = pobj.actionBody;
    var self = this;
    if (!actionBody.bizId) {
      return system.getResult(null, "actionBody.bizId can not be empty，100495");
    }
    actionBody.BizId = actionBody.bizId;
    if (!actionBody.status) {
      return system.getResult(null, "actionBody.status can not be empty，100495");
    }
    if (actionBody.businessLicense) {
      actionBody.newbusinessLicense = await self.opDownFileInfo(actionBody.businessLicense);
    }
    if (actionBody.idCardUrlList) {
      var jsonidCardUrlList = JSON.parse(actionBody.idCardUrlList);
      var newidCardUrlList = [];
      for (var i = 0; i < jsonidCardUrlList.length; i++) {
        var key = jsonidCardUrlList[i];
        newidCardUrlList.push(await self.opDownFileInfo(key));
      }
      actionBody.newidCardUrlList = newidCardUrlList;
    }
    if (actionBody.userPlan) {
      actionBody.newuserPlan = await self.opDownFileInfo(actionBody.userPlan);
    }
    if (actionBody.userForeig) {
      actionBody.newuserForeig = await self.opDownFileInfo(actionBody.userForeig);
    }
    if (actionBody.userLaw) {
      actionBody.newuserLaw = await self.opDownFileInfo(actionBody.userLaw);
    }
    if (actionBody.userOtherList) {
      var jsonuserOtherList = JSON.parse(actionBody.userOtherList);
      var newuserOtherList = [];
      for (var i = 0; i < jsonuserOtherList.length; i++) {
        var key = jsonuserOtherList[i];
        newuserOtherList.push(await self.opDownFileInfo(key));
      }
      actionBody.newuserOtherList = newuserOtherList;
    }
    pobj.actionType = "receiveIcpStatusNotify";
    var url = settings.centerOrderUrl() + "action/qcapi/springBoard";
    var rtn = await this.restPostUrl(pobj, url);
    if (rtn.status == 0 && actionBody.status != 2 && rtn.data) {
      var tmpObj = {
        actionBody: {
          orderNo: rtn.data.orderNo,
          channelNeedNo: rtn.data.channelNeedNo,
          needsolution: rtn.data.solutionContent
        },
        appInfo: pobj.appInfo
      }
      this.utilsPushSve.business2Channel(tmpObj, "pushDeliveryStatusNotify");
      tmpObj.actionBody.orderNo = rtn.data.channelSolutionNo;
      pobj.actionBody.orderNo = rtn.data.orderNo;
      if (actionBody.status == 11) {
        var orderrtn = await self.utilsOrderSve.delOrder(pobj, pobj.actionBody);
        if (orderrtn.status < 0) {
          return system.getResultFail(-5022, "订单关闭失败");
        }
        self.utilsPushSve.business2Channel(tmpObj, "pushOrderICPClose");
      }
    }//通知更新状态
    return rtn;
  }
  /**
   * 推送交付信息至企业宝（交付系统）
   */
  async pushOrderDelivery2Qfb(pobj, needsolution) {

  }

  async opDownFileInfo(docUrl, result) {  //从oss下载到本地并上传到自己oss，之后删除本地文件
    /*docUrl下载链接，全路径，如：https://XXXXXX.pdf?XXXXX */
    try {
      var tmpFileName = docUrl.substring(0, docUrl.lastIndexOf("?"));
      var fileName = tmpFileName.substr(tmpFileName.lastIndexOf("/") + 1, tmpFileName.lenght);
      // 2020 0803 lin 修改;
      var urlJson = this.urlSplit(docUrl);
      if (urlJson["Expires"]) {
        // url中过期时间与服务器时间对比结果为已过期
        if (urlJson["Expires"] < new Date().getTime()) {
          return "http://gsb-zc.oss-cn-beijing.aliyuncs.com/" + fileName;
        }
      }
      //解码后的文件全名:xxx.pdf
      var fileAllName = decodeURIComponent(fileName);//为xxx.pdf
      var saveFilePath = '/tmp/' + fileAllName;
      // 下载文件到指定的路径
      var tmpp = await this.restClient.execDownload("'" + docUrl + "'", saveFilePath);
      //上传 saveFilePath的文件 到ossClient
      var rtn = await this.ossClient.upfile(fileAllName, saveFilePath);
      result = rtn.url;
      //删除本地文件
      fs.unlink(saveFilePath, function (err) { });
    } catch (e) {

    }
    return result;
  }

  async writeCommunicationLog(pobj) {
    if (!pobj.actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100491");
    }
    if (!pobj.actionBody.note) {
      return system.getResult(null, "actionBody.note can not be empty，100492");
    }
    var self = this;
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    await self.aliclient.reqbyget({ action: "WriteCommunicationLog", reqbody: { BizId: pobj.actionBody.intentionBizId, Note: pobj.actionBody.note }, apiVersion: "2019-05-08" });
    return system.getResultSuccess();
  }

  async queryExpertApplyCommunicationLogs(pobj) {
    if (!pobj.actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100493");
    }
    if (!pobj.actionBody.userFeedBack) {
      return system.getResult(null, "actionBody.userFeedBack can not be empty，100494");
    }
    let res = await this.aliclient.reqbyget({
      action: "QueryExpertApplyCommunicationLogs", reqbody: {
        BeginTime: pobj.actionBody.BeginTime ? pobj.actionBody.BeginTime : "",
        EndTime: pobj.actionBody.EndTime ? pobj.actionBody.EndTime : "",
        BizId: pobj.actionBody.intentionBizId,
        UserFeedBack: pobj.actionBody.userFeedBack,
        PageNum: pobj.actionBody.pageNum || 1,
        PageSize: pobj.actionBody.pageSize || 10,
      }, apiVersion: "2019-05-08"
    });
    return system.getResultSuccess(res);
  }

  /**
   * 各渠道需求统计
   * @param pobj
   * @returns {Promise<void>}
   */
  async getStatisticsByUappId(pobj) {
    let url = this.centerOrderUrl + "action/opNeed/springBoard";
    let result = await this.restPostUrl(pobj, url);
    if (result.status != 0) {
      return system.getResultFail(-1);
    }
    let data = result.data;
    let temp = 0;
    let arr = [];
    let reArr = [];
    for (let i = 0; i < data.length; i++) {
      if ((temp != data[i].uapp_id && temp != 0)) {
        let obj = {
          uapp_id: temp,
          data: arr
        }
        reArr.push(obj);
        arr = [];
      }
      let dArr = {
        time: data[i].time,
        count: data[i].count
      }
      arr.push(dArr);
      temp = data[i].uapp_id;
      if (i == data.length - 1) {
        let obj = {
          uapp_id: temp,
          data: arr
        }
        reArr.push(obj);
      }
    }
    reArr.sort((a, b) => {
      return a.uapp_id - b.uapp_id;
    })
    let temp2 = 0;
    let arr2 = [];
    let final = [];
    for (let i = 0; i < reArr.length; i++) {
      if ((temp2 != reArr[i].uapp_id && temp2 != 0)) {
        let o = {
          uapp_id: temp2,
          data: arr2
        };
        final.push(o);
        arr2 = [];
      }
      console.log(reArr[i].data)
      arr2 = arr2.concat(reArr[i].data);
      temp2 = reArr[i].uapp_id;
      if (i == reArr.length - 1) {
        let obj = {
          uapp_id: temp2,
          data: arr2
        }
        final.push(obj);
      }
    }
    return system.getResultSuccess(final);
  }

  /**
   * 需求统计漏斗图
   * @param pobj
   * @returns {Promise<void>}
   */
  async getNeedFunnelStatistics(pobj) {
    let url = this.centerOrderUrl + "action/opNeed/springBoard";
    let result = await this.restPostUrl(pobj, url);
    return result;
  }

  /**
   * 需求统计（产品维度）
   * @param pobj
   * @returns {Promise<void>}
   */
  async getStatisticsByProduct(pobj) {
    let url = this.centerOrderUrl + "action/opNeed/springBoard";
    let result = await this.restPostUrl(pobj, url);
    if (result.status != 0) {
      return system.getResultFail(-1);
    }
    let data = result.data;
    let temp = "";
    let arr = [];
    let reArr = [];
    for (let i = 0; i < data.length; i++) {
      if ((temp != data[i].typeCode && temp != "")) {
        let obj = {
          type_code: temp,
          data: arr
        }
        reArr.push(obj);
        arr = [];
      }
      let dArr = {
        uapp_id: data[i].uapp_id,
        count: data[i].count
      }
      arr.push(dArr);
      temp = data[i].typeCode;
      if (i == data.length - 1) {
        let obj = {
          type_code: temp,
          data: arr
        }
        reArr.push(obj);
      }
    }
    return system.getResultSuccess(reArr);
  }

  /**
   * 需求统计（产品维度） 总数
   * @param pobj
   * @returns {Promise<void>}
   */
  async getStatisticsByChannel(pobj) {
    let url = this.centerOrderUrl + "action/opNeed/springBoard";
    let result = await this.restPostUrl(pobj, url);
    if (result.status != 0) {
      return system.getResultFail(-1);
    }
    let data = result.data;
    let temp = "";
    let arr = [];
    let reArr = [];
    for (let i = 0; i < data.length; i++) {
      if ((temp != data[i].uapp_id && temp != "")) {
        let obj = {
          uapp_id: temp,
          data: arr
        }
        reArr.push(obj);
        arr = [];
      }
      let dArr = {
        typeCode: data[i].typeCode,
        count: data[i].count
      }
      arr.push(dArr);
      temp = data[i].uapp_id;
      if (i == data.length - 1) {
        let obj = {
          uapp_id: temp,
          data: arr
        }
        reArr.push(obj);
      }
    }
    return system.getResultSuccess(reArr);
  }

  /**
   * 获取需求 的产品类型
   * @param pobj
   * @returns {Promise<void>}
   */
  async getNeedProductType(pobj) {
    let url = this.centerOrderUrl + "action/opNeed/springBoard";
    let result = await this.restPostUrl(pobj, url);
    if (result.status != 0) {
      return system.getResultFail(-1);
    }
    return result;
  }

  /**
   * 需求量对比
   * @param pobj
   * @returns {Promise<void>}
   */
  async getNeedComparison(pobj) {
    let url = this.centerOrderUrl + "action/opNeed/springBoard";
    let result = await this.restPostUrl(pobj, url);
    if (result.status != 0) {
      return system.getResultFail(-1);
    }
    return result;
  }

  /**
   * 需求统计（地区维度）
   * @param pobj
   * @returns {Promise<void>}
   */
  async getStatisticsByArea(pobj) {
    let url = this.centerOrderUrl + "action/opNeed/springBoard";
    let result = await this.restPostUrl(pobj, url);
    if (result.status != 0) {
      return system.getResultFail(-1);
    }
    let data = result.data;
    let temp = "";
    let arr = [];
    let reArr = [];
    for (let i = 0; i < data.length; i++) {
      if ((temp != data[i].province && temp != "")) {
        let obj = {
          province: temp,
          data: arr
        }
        reArr.push(obj);
        arr = [];
      }
      let dArr = {
        type_code: data[i].typeCode,
        count: data[i].count
      }
      arr.push(dArr);
      temp = data[i].province;
      if (i == data.length - 1) {
        let obj = {
          province: temp,
          data: arr
        }
        reArr.push(obj);
      }
    }
    return system.getResultSuccess(reArr);
  }

  /**
   * 启服通 展板 需求列表
   * @param pobj
   * @returns {Promise<void>}
   */
  async getNeedComparisonList(pobj) {
    let url = this.centerOrderUrl + "action/opNeed/springBoard";
    let result = await this.restPostUrl(pobj, url);
    return result;
  }


  urlSplit(url) {
    var arr = url.split("?")[1];           //根据？跟个url
    var arr2 = arr[1].split("&");         //根据&重新分割参数
    var jsonarr = {};                    //定义一个json对象放置url  参数
    for (var i = 0; i < arr2.length; i++) {   //循环将参数放到json里面
      jsonarr[arr2[i].substring(0, 1)] = arr2[i].substring(2, 3);
    }
    return jsonarr;
  }
  //2020 0826 lin 测试使用
  async test(pobj, actionBody) {
    pobj.actionType = "receiveIcpStatusNotify";
    var url = settings.centerOrderUrl() + "action/qcapi/springBoard";
    var rtn = await this.restPostUrl(pobj, url);
    return rtn;
  }
}

module.exports = UtilsOpNeedService;


