var system = require("../../../system");
const AppServiceBase = require("../../app.base");
var settings = require("../../../../config/settings");

//此类用来db中配置来进行调用-主要功能是推送交付系统
class UtilsDeliverSystemService extends AppServiceBase {
    constructor() {
        super();
        this.opPushQueueUrl = settings.opPushQueueUrl();
    }

    /**
     * 推送业务信息到交付系统
     * 业务操作的信息不变外加增加组装的一些参数（推送需求商机、关闭需求、订单商机、关闭订单）
     * @param {*} pobj
     */
    async pushBusiness2DeliverSystem(pobj) {//推送业务信息到交付系统
        this.execClientNew.execLogs(`推送资质宝结果->pushBusiness2DeliverSystem`, pobj, "center-channel-utilsDeliverSystemSve-pushBusiness2DeliverSystem", null, null);
        var verifyResult = await this.verifyParam(pobj);
        if (verifyResult.status != 0) {
            return await this.disposePushResultFail(pobj, verifyResult, "deliver->pushBusiness2DeliverSystem->verifyResult", this.pushlogFailType.FQ);
        }
        var interface_params_info = verifyResult.data;
        let params = null
        let headInfo = {}
        if (pobj.appInfo) {
            headInfo["appcode"] = pobj.appInfo.app_code
            params = {
                actionType: interface_params_info.actionType,
                actionBody: pobj.actionBody,
                headData: headInfo
            }
        } else {
            params = {
                actionType: interface_params_info.actionType,
                actionBody: pobj.actionBody
            }
        }
        let url = interface_params_info.opUrl;
        var opQueuePushClientPostRes = await this.opQueuePushClientPost(pobj, url, params);
        return await this.disposePushResult(pobj, opQueuePushClientPostRes, "delivery->pushBusiness2DeliverSystem->result", this.pushlogFailType.FQ);
    }

    //--------------------------------------------------内部辅助方法-------------------start-----------------

    async opQueuePushClientPost(pobj, pushQueueUrl, reqParams) {
        try {
            var rtn = await this.restPostUrl(reqParams, pushQueueUrl);
            this.execClientNew.execLogs(`推送资质宝结果->opQueuePushClientPost->url:` + pushQueueUrl, reqParams, "center-channel-utilsDeliverSystemSve-opQueuePushClientPost", rtn, null);
            if (rtn.status != 1) {
                return system.getResult(null, "推送资质宝失败，失败原因：" + JSON.stringify(rtn));
            }
            return system.getResultSuccess(null, "推送成功");
        } catch (e) {
            const stackStr = e.stack ? e.stack : JSON.stringify(e);
            this.execClientNew.execLogs(`推送操作异常deliver->opQueuePushClientPost`, pobj, "center-channel-utilsDeliverSystemSve-opQueuePushClientPost", null, stackStr);
            return system.getResult(null, "推送操作异常deliver->opQueuePushClientPost->error：" + stackStr);
        }
    }

    async verifyParam(pobj) {//参数信息验证
        var verify = system.getResultSuccess();
        if (!pobj.interface_params) {
            verify = system.getResult(null, "interface_params can not be empty，100400");
        }
        var interface_params_info = JSON.parse(pobj.interface_params);
        if (!interface_params_info || !interface_params_info.opUrl || !interface_params_info.headData) {
            verify = system.getResult(null, "interface_params（opUrl、headData） can not be empty，100430");
        }
        verify.data = interface_params_info;
        return verify;
    }

    //--------------------------------------------------内部辅助方法-------------------end-----------------
}

module.exports = UtilsDeliverSystemService;
