const system = require("../../../system");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
class OplogService extends ServiceBase {
  constructor() {
    super("common", ServiceBase.getDaoName(OplogService));
    this.opLogUrl = settings.apiconfig.opLogUrl();
    this.opLogEsIsAdd = settings.apiconfig.opLogEsIsAdd();
  }
  async error(qobj) {
    this.create(qobj);
  }
  async info(qobj) {
    this.create(qobj);
  }
  async create(qobj) {
    var rc = system.getObject("util.execClient");
    try {
      qobj.optitle = (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "：" + qobj.optitle;
      if (this.opLogEsIsAdd == 1) {
        qobj.content = qobj.content.replace("field list", "字段列表")
        qobj.created_at = (new Date()).getTime();
        //往Es中写入日志
        rc.execPost(qobj, this.opLogUrl);
      } else {
        this.dao.create(qobj);
      }
    } catch (e) {
      qobj.content = e.stack;
      this.dao.create(qobj);
    }
  }
  async createDb(qobj) {
    try {
      qobj.optitle = (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "：" + qobj.optitle;
      this.dao.create(qobj);
    } catch (e) {
      //日志记录
      this.create({
        appid: qobj.appid || "",
        appkey: qobj.appkey || "",
        requestId: qobj.requestId || "",
        op: qobj.op || "",
        content: qobj.content + "-->error：" + e.stack,
        clientIp: qobj.clientIp || "",
        optitle: qobj.optitle || "" + "-->添加日志失败center_channel_log->createDb",
      });
    }
  }
}
module.exports = OplogService;
