var WEBBase = require("../../web.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ProductAPI extends WEBBase {
    constructor() {
        super();
        this.signSve = system.getObject("service.common.signSve");
    }
    /**
      * 优客工厂 
      * 接口跳转-POST请求
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "getAppInfoByAppKey":// 根据优客token获取用户信息，生成userPin返回前端 actionBody
                opResult = await this.signSve.getAppInfoByAppKey(pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = ProductAPI;