var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
const uuidv4 = require('uuid/v4');
/**
 * icp通知接口（百度icp接入）
 * 庄冰 2020.10.22
 */
class Order extends APIBase {
    constructor() {
        super();
        this.gatewaypushlogSve = system.getObject("service.common.gatewaypushlogSve");
    }

    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }
    getResultSuccess(requestId) {
        return {
        "status": 0,
        "msg": "success",
        "data":null,
        "requestId": requestId
        };
    }
    getResultFail(errmsg) {
        var self = this;
        return {
        "status":-1,
        "msg": errmsg,
        "requestId": self.getUUID(),
        "data":null,
        "bizmsg":"empty"
        };
    }

    
    //icp状态变更
    async notify(pobj,obj,req) {
        var self = this;
        if(!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret){
            return self.getResultFail("未知应用或应用未启用");
        }
        if (!pobj.orderNo) {
            return self.getResultFail("orderNo不能为空");
        }
        if(!pobj.isDirectBuy || pobj.isDirectBuy=="0"){
            pobj.isDirectBuy=0;
        }
        pobj.status = 1;
        if (pobj.isDirectBuy==0 && !pobj.bizId) {
            return self.getResultFail("非直接下单bizId不能为空");
        }
        if (pobj.isDirectBuy==1 && !pobj.phone) {
            return self.getResultFail("直接下单phone不能为空");
        }
        if (pobj.isDirectBuy==1 && !pobj.consultType) {
            return self.getResultFail("直接下单consultType不能为空");
        }else{
            if (pobj.consultType=="ICP") {
                pobj.consultType="5";
            }
            if (pobj.consultType=="EDI") {
                pobj.consultType="7";
            }
        }
        pobj.action_type = "icpOrderStatus";
        if (pobj.area) {
            switch (pobj.area) {
                case "BEIJING":
                    pobj.area = "1";
                    break;
                case "SHANGHAI":
                    pobj.area = "2";
                    break;
                case "FUJIAN":
                    pobj.area = "3";
                    break;
                case "GUANGXI":
                    pobj.area = "4";
                    break;
                case "GUANGDONG":
                    pobj.area = "5";
                    break;
                case "ANHUI":
                    pobj.area = "6";
                    break;
                case "HENAN":
                    pobj.area = "7";
                    break;
                case "HUBEI":
                    pobj.area = "8";
                    break;
                case "ZHEJIANG":
                    pobj.area = "9";
                    break;
                case "JIANGSU":
                    pobj.area = "10";
                    break;
                case "SHANDONG":
                    pobj.area = "11";
                    break;
                case "SHANGXI_SHAN":
                    pobj.area = "12";
                    break;
                case "NINGXIA":
                    pobj.area = "13";
                    break;
                case "GANSU":
                    pobj.area = "14";
                    break;
                case "XINJIANG":
                    pobj.area = "15";
                    break;
                case "QINGHAI":
                    pobj.area = "16";
                    break;
                case "TIANJIN":
                    pobj.area = "17";
                    break;
                case "CHONGQING":
                    pobj.area = "18";
                    break;
                case "HEBEI":
                    pobj.area = "19";
                    break;
                case "SHANXI_JIN":
                    pobj.area = "20";
                    break;
                case "LIAONING":
                    pobj.area = "21";
                    break;
                case "JINLIN":
                    pobj.area = "22";
                    break;
                case "HEILONGJIANG":
                    pobj.area = "23";
                    break;
                case "JIANGXI":
                    pobj.area = "24";
                    break;
                case "HUNAN":
                    pobj.area = "25";
                    break;
                case "SICHUAN":
                    pobj.area = "26";
                    break;
                case "GUIZHOU":
                    pobj.area = "27";
                    break;
                case "YUNNAN":
                    pobj.area = "28";
                    break;
                case "NEIMENGGU":
                    pobj.area = "29";
                    break;
                case "XIZANG":
                    pobj.area = "30";
                    break;
                case "HANWAIZI":
                    pobj.area = "31";
                    break;
                case "QUANWAIZI":
                    pobj.area = "31";
                    break;
                case "WAIZI":
                    pobj.area = "31";
                    break;
                case "HAINAN":
                    pobj.area = "34";
                    break;
                default:
                    break;
            }
        }
        if (!pobj.area) {
            return self.getResultFail("area参数错误");
        }
        var param = {
            requestId: req.requestId || self.getUUID(),
            requestUrl: "/icp/order/notify",
            requestjson: JSON.stringify(pobj),//请求地址
            pushUrl: "/action/intentionapi/springBoard",//调用地址
            pushActionType: "icpOrderStatus",//调用参数
            pushtimes: 0,//推送次数
            pushStatus: "wts",//推送状态
        }
        await self.gatewaypushlogSve.create(param);
        return self.getResultSuccess(param.requestId);
    }

    async close(pobj,obj,req){
        var self = this;
        if(!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret){
            return self.getResultFail("未知应用或应用未启用");
        }
        if (!pobj.orderNo) {
            return self.getResultFail("orderNo不能为空");
        }
        pobj.channelOrderNo = pobj.orderNo;
        pobj.action_type = "icpOrderClose";
        var param = {
            requestId: req.requestId || self.getUUID(),
            requestUrl: "/icp/order/close",
            requestjson: JSON.stringify(pobj),//请求地址
            pushUrl: "/action/intentionapi/springBoard",//调用地址
            pushActionType: "icpOrderClose",//调用参数
            pushtimes: 0,//推送次数
            pushStatus: "wts",//推送状态
        }
        await self.gatewaypushlogSve.create(param);
        return self.getResultSuccess(param.requestId);
    }

}
module.exports = Order;