var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class Need extends APIBase {
    constructor() {
        super();
        this.utilsNeedSve = system.getObject("service.utilsSve.utilsNeedSve");
        this.centerorderSve = system.getObject("service.common.centerorderSve");
        this.utilsNeedSve2 = system.getObject("service.utilsSve.utilsNeedSve2");
    }

    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionProcess, pobj.actionType, pobj.actionBody, req);
        return result;
    }
    async opActionProcess(pobj, action_process, action_type, action_body, req) {
        pobj.requestId = req.requestId;
        var self = this;
        var opResult = null;
        switch (action_type) {
            case "submitNeedH5"://提交需求－－－－del
                opResult = await this.utilsNeedSve.submitNeedH5(pobj, pobj.actionBody);
                break;
            //--------------------------------------跟ali合作---------------------------                
            case "submitNeed"://提交需求
                opResult = await this.utilsNeedSve.submitNeed(pobj, pobj.actionBody);
                break;
            case "needClose"://关闭需求
                opResult = await this.utilsNeedSve.needClose(pobj, pobj.actionBody);
                break;
            case "needCloseIcp"://关闭需求
                opResult = await this.utilsNeedSve2.needCloseIcp(pobj, pobj.actionBody);
                break;
            case "needDetailByChannelNo":
                opResult = await this.utilsNeedSve.needDetailByChannelNo(pobj, pobj.actionBody);
                break;
            case "getItemByChannelNeedNo":
                opResult = await this.utilsNeedSve.getItemByChannelNeedNo(pobj,pobj.actionBody);
                break;
            case "getSolutionByChannelSolutionNo":
                opResult = await this.utilsNeedSve.getSolutionByChannelSolutionNo(pobj, pobj.actionBody);
                break;
            case "getItemByNeedNo":
                opResult = await this.utilsNeedSve.getItemByNeedNo(pobj, pobj.actionBody);
                break;
            case "receiveFeedback"://接收方案反馈信息
                opResult = await this.centerorderSve.reqCenterOrderApi(pobj);
                break;
            case "getItemByChannelSolutionNo":
                opResult = await this.utilsNeedSve.getItemByChannelSolutionNo(pobj, pobj.actionBody);
                break;
            case "icpFeedbackSubmit"://icp接收方案反馈信息
                pobj.actionType = "receiveIcpFeedback";
                opResult = await this.utilsNeedSve.reqCenterOrderQcApi(pobj);
                break;
            case "icpNotify"://icp方案更新
                opResult = await this.utilsNeedSve.icpNotify(pobj, pobj.actionBody);
                if (!pobj.actionBody.bizId.startsWith("TM_") && opResult.status == 0 && (pobj.actionBody.status == 1||pobj.actionBody.status == 0)) {
                    opResult = await self.centerorderSve.icppaysuccess(pobj, pobj.actionBody);
                }
                break;
            case "tmNotifySub"://tm建案成功
                opResult = await self.centerorderSve.tmsave(pobj, pobj.actionBody);
                break;
            case "writeCommunicationLog"://icp接收方案反馈信息
                opResult = await this.utilsNeedSve2.writeCommunicationLog(pobj);
                break;
            case "queryExpertApplyCommunicationLogs"://icp接收方案反馈信息
                opResult = await this.utilsNeedSve2.queryExpertApplyCommunicationLogs(pobj);
                break;
            case "getaliicpProduce"://方案询价
                opResult = await this.centerorderSve.getaliicpProduce(pobj);
                break;
            case "submitIcpIntention":// 2020 0827 lin 新增 4.1 提交需求
                opResult = await this.utilsNeedSve.submitIcpIntention(pobj, pobj.actionBody);
                break;
            case "queryIntentionList":// 2020 0827 lin 新增 4.2 需求列表查询
                opResult = await this.utilsNeedSve.queryIntentionList(pobj, pobj.actionBody);
                break;
            case "confirmIcpIntention":// 2020 0827 lin 新增 4.3 用户需求确认
                opResult = await this.utilsNeedSve.confirmIcpIntention(pobj, pobj.actionBody);
                break;
            case "needBatchUpload":// 2020 0914 lin 新增 刷单一条龙服务
                opResult = await this.utilsNeedSve.needBatchUpload(pobj, pobj.actionBody);
                break;
            case "testsymq":
                opResult = await this.utilsNeedSve.testsymq(pobj);
                break;
            //-----------接入百度ICP------start----zhuangbing--2020.10.22----------------------------
            case "submitIcpNeed"://提交需求
                opResult = await this.utilsNeedSve.submitNeed2(pobj, pobj.actionBody);
                break;
            case "icpFeedbackSubmitNew"://icp接收方案反馈信息
                pobj.actionType = "receiveIcpFeedback";
                opResult = await this.utilsNeedSve.reqCenterOrderQcApi(pobj);
                break;
            case "icpNotifyNew"://icp方案更新
                opResult = await this.utilsNeedSve.icpNotifyNew(pobj, pobj.actionBody);
                if (opResult.status == 0 && pobj.actionBody.status == 1) {
                    opResult = await self.centerorderSve.icppaysuccessNew(pobj, pobj.actionBody);
                }
                break;
            case "icpOrderClose"://关闭ICP订单
                opResult = await this.utilsNeedSve.icpOrderClose(pobj, pobj.actionBody);
                break;
            case "getSolutionByChannelOrderNo"://根据渠道订单获取方案信息
                opResult = await this.utilsNeedSve.getSolutionByChannelOrderNo(pobj, pobj.actionBody);
                // opResult = await this.utilsNeedSve.getItemByChannelSolutionNo(pobj, pobj.actionBody);
                // break;
                break;
            case "getOrderInfoByChannelOrderNo"://根据渠道订单订单信息
                opResult = await this.utilsNeedSve.getOrderInfoByChannelOrderNo(pobj, pobj.actionBody);
                break;
            //-----------接入百度ICP------end----------------------------------
            case "importNeeds":
                opResult = await this.utilsNeedSve.importNeeds(pobj,req);
                break;
            case "getymicpProduce"://获取易名的icp产品信息            
                opResult = await this.centerorderSve.getymicpProduce(pobj);
                break;
            //百度商标接入
            case "submitTmNeed"://提交需求
                opResult = await this.utilsNeedSve.submitTmNeed(pobj, pobj.actionBody);
                break;
            case "tmFeedbackSubmit"://商标用户反馈
                opResult = await this.utilsNeedSve.tmFeedbackSubmit(pobj);
                break;
            case "tmStatusNotify"://商标状态通知
                opResult = await this.utilsNeedSve.tmStatusNotify(pobj);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = Need;