var APIBase = require("../../api.base");
var system = require("../../../system");
class AccessAuthAPI extends APIBase {
    constructor() {
        super();
        this.utilsAuthSve = system.getObject("service.utilsSve.utilsAuthSve");
        this.gatewaypushlogSve = system.getObject("service.common.gatewaypushlogSve");
        this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
        this.pushlogSve = system.getObject("service.common.pushlogSve");
        this.aliclient = system.getObject("util.aliyunClient");
        this.utilsTmAliyunSve = system.getObject("service.utilsSve.utilsTmAliyunSve");
        this.utilsTmOrderCallService = system.getObject("service.utilsSve.utilsTmOrderCallSve");
        this.utilsNeedSve = system.getObject("service.utilsSve.utilsNeedSve");
        this.utilsOpOrderSve = system.getObject("service.utilsSve.utilsOpOrderSve");
    }
    async QueryTradeIntentionUserList(pobj, qobj, req) {
      pobj.appInfo={uapp_id:18}
      let endtime = Date.now();
      let starttime = Date.now() - 30 * 60 * 1000;//30分钟(毫秒)
      pobj.actionBody = {
          Begin: starttime,
          End: endtime
      };
      return await this.utilsNeedSve.queryTradeIntentionUserList(pobj);
    }
    async taskAliIcapi() {
        var rtn = await this.gatewaypushlogSve.taskAliIcapi();
        return rtn;
    }
    async taskAgainFqPushInfo(pobj, qobj, req) {//再次推送渠道业务数据
        var rtn = await this.utilsPushSve.business2Channel(pobj, pobj.opType);
        this.pushlogSve.delDbPushfaillogById(Number(pobj.id || 0));
        return rtn;
    }
    async taskAgainPushOneNewBusInfo(pobj, qobj, req) {//再次推送新rpc业务数据
        var rtn = await this.utilsPushSve.againPushBusInfo(pobj);
        this.pushlogSve.delDbPushfaillogById(Number(pobj.id || 0));
        return rtn;
    }
    async taskAgainPushOneOldBusInfo(pobj, qobj, req) {//再次推送老rpc业务数据
        var rtn = await this.aliclient.reqbyget(pobj)
        this.pushlogSve.delDbPushfaillogById(Number(pobj.id || 0));
        return rtn;
    }
    async taskAliTmUpdate(pobj, qobj, req) {//操作阿里商标更新
        var rtn = await this.utilsTmAliyunSve.taskAliTmUpdate();
        return rtn;
    }

    async taskAlijsonfile(pobj, qobj, req) {//操作阿里商标交易上架
        var rtn = await this.utilsTmOrderCallService.createjsonfile();
        return rtn;
    }

    async taskAliRpcAgainPush(pobj, qobj, req) {
        var result = await this.pushlogSve.getFailLogList();
        if (result.status != 0 || !result.data || result.data.length == 0) {
            return system.getResult(null, "push data is empty");
        }
        var self = this;
        for (let index = 0; index < result.data.length; index++) {
            const element = result.data[index];
            if (element) {
                var contentData = JSON.parse(element.content);
                contentData.id = element.id;
                contentData.pushNumber = element.pushNumber + 1;
                if (element.failType == 1) {
                    self.taskAgainPushOneOldBusInfo(contentData);
                }
                else if (element.failType == 2) {
                    self.taskAgainPushOneNewBusInfo(contentData);
                } else if (element.failType == 4) {
                    self.taskAgainFqPushInfo(contentData);
                }//推送渠道（如：FQ）
            }
        }
        return system.getResultSuccess();
    }

    async taskPushPublicService(pobj, qobj, req) {
        var result = await this.pushlogSve.getPublicServiceLogList();
        if (result.status != 0 || !result.data || result.data.length == 0) {
            return system.getResult(null, "PushPublicService data is empty");
        }
        var self = this;
        for (let index = 0; index < result.data.length; index++) {
            const element = result.data[index];
            if (element && element.pushUrl) {
                var contentData = JSON.parse(element.pushContent);
                var opResult = await self.restPostUrl(contentData, element.pushUrl);
                if ((!opResult && opResult.status != 0) || opResult.code != 1) {
                    var tmpPobj = {
                        actionBody: {
                            uapp_key: element.appkey,
                            pushUrl: element.pushUrl,
                            pushContent: contentData,
                            pushNumber: element.pushNumber + 1,
                            resultInfo: opResult
                        }
                    }
                    self.pushlogSve.addPublicServiceLog(tmpPobj, { clientIp: element.clientIp });
                } else {
                    self.logCtl.info({
                        appid: "",
                        appkey: element.appkey,
                        requestId: req.requestId || "",
                        op: req.classname,
                        content: contentData,
                        clientIp: element.clientIp,
                        agent: req.uagent,
                        optitle: "推送公共服务：PushPublicService Success",
                    });
                }
                self.pushlogSve.delPublicServiceLog(element.id);
            }
        }
        return system.getResultSuccess();
    }

    /**
     * 需求商机同步任务
     * @param pobj
     * @param qobj
     * @param req
     * @returns {Promise<{msg: *, data, bizmsg: (*|string), status: number}>}
     */
    async taskSyncNeedBusiness(pobj,qobj,req){
        let result = await this.utilsNeedSve.syncNeedBusiness();
        return result;
    }

    /**
     * 订单商机同步任务
     * @param pobj
     * @param qobj
     * @param req
     * @returns {Promise<{msg: *, data, bizmsg: (*|string), status: number}>}
     */
    async taskSyncOrderBusiness(pobj,qobj,req){
        let result = await this.utilsOpOrderSve.syncOrderBusiness();
        return result;
    }

}
module.exports = AccessAuthAPI;