var WEBBase = require("../../web.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ProductAPI extends WEBBase {
  constructor() {
    super();
    this.utilsProductSve = system.getObject("service.utilsSve.utilsProductSve");
    this.utils360Sve = system.getObject("service.utilsSve.utils360Sve");
  }
  /**
    * 接口跳转-POST请求
    * action_process  执行的流程
    * action_type     执行的类型
    * action_body     执行的参数
    */
  async springBoard(pobj, qobj, req) {
    if (!pobj.actionProcess) {
      return system.getResult(null, "actionProcess参数不能为空");
    }
    if (!pobj.actionType) {
      return system.getResult(null, "actionType参数不能为空");
    }
    var result = await this.opActionProcess(pobj, pobj.actionType, req);
    return result;
  }
  async opActionProcess(pobj, action_type, req) {
    var opResult = null;
    switch (action_type) {
      case "getProductList"://通过产品类别编码路径获取产品列表
        opResult = await this.utilsProductSve.getProductList(pobj, pobj.actionBody);
        break;
      case "getProductListH5"://通过产品类别编码路径获取产品列表
        opResult = await this.utilsProductSve.getProductListH5(pobj, pobj.actionBody);
        break;
      case "getProductDetail"://根据渠道产品编码获取产品详情
        opResult = await this.utilsProductSve.getProductDetail(pobj, pobj.actionBody);
        break;
      case "getProductPrice":
        opResult = await this.utilsProductSve.getProductPrice(pobj, pobj.actionBody)
        break;
      case "getProductRecommend":
        opResult = await this.utilsProductSve.getProductRecommend(pobj, pobj.actionBody);
        break;
      // case "updateProductPrice":
      //     opResult = await this.utilsProductSve.updateProductPrice(pobj,pobj.actionBody);
      //     break;
      case "getGoodsLowestPrice":
        opResult = await this.utils360Sve.getGoodsLowestPrice(pobj.actionBody);
        break;
      case "getRegProducePrice":
        opResult = await this.utilsProductSve.getRegProducePrice(pobj, pobj.actionBody)
        break;
      case "getAllProducts":
        opResult = await this.utilsProductSve.getAllProducts(pobj);
        break;
      case "getAllProductType":// 获取产品大类
        opResult = await this.utilsProductSve.getAllProductType(pobj);
        break;
      case "submitProductType":// 创建产品大类
        opResult = await this.utilsProductSve.submitProductType(pobj);
        break;
      case "editProductType":// 修改产品大类
        opResult = await this.utilsProductSve.editProductType(pobj);
        break;
      default:
        opResult = system.getResult(null, "action_type参数错误");
    }
    return opResult;
  }

  async getProductList(pobj, action_type, req) {
    pobj.actionBody = {
      pathCode: pobj.pathCode
    }
    return await this.utilsProductSve.getProductList(pobj, pobj);
  }


}
module.exports = ProductAPI;