const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  var base = require("../../basemodel/voucherbase")(db, DataTypes);
  return db.define("refundvoucher", Object.assign({//退款单：
    //基类 code: 退款单号（自动生成）
    //基类 creator: 创建者
    //基类 updator:/更新者
    //基类 auditor: 审核者
    //基类 opNotes: 操作备注
    //基类 auditStatusName: //审核状态名称
    //基类 auditStatus: //审核状态:ENUM=audit_status，"dsh": "待审核", "btg": "不通过", "tg": "通过"
    //基类 sourceTypeName: //来源类型名称
    //基类 sourceType: //来源类型:ENUM=source_type，"order": "订单","expensevoucher": "费用单","receiptvoucher": "收款单","refundvoucher": "退款单", "trademark": "商标单"
    //基类 sourceOrderNo: DataTypes.STRING,//来源单号（如：订单号等）
    //基类 channelServiceNo //渠道服务单号
    payuser_id: DataTypes.INTEGER,// 
    busPayOrderCode: DataTypes.STRING(100),//业务支付订单号
    payOrderNo: DataTypes.STRING, //支付凭证流水单号，如：微信支付凭证单号
    refundTypeName: DataTypes.STRING,
    refundType: {//退款类型，"tk": "退款" ,"ptdtk": "平台代退款"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.refund_type),
      set: function (val) {
        this.setDataValue("receiptType", val);
        this.setDataValue("receiptTypeName", uiconfig.config.pdict.refund_type[val]);
      }
    },
    accountType: {
      //帐户类型（ 支付类型）:"cash": "现金", "bank": "银行" ,"wx":"微信","alipay":"支付宝","other":"其它"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.pay_account_type),
      set: function (val) {
        this.setDataValue("accountType", val);
        this.setDataValue("accountTypeName", uiconfig.config.pdict.pay_account_type[val]);
      },
      defaultValue: "other",
    },
    accountTypeName: {//帐户类型名称
      type: DataTypes.STRING,
      defaultValue: "其它",
    },
    payDate: DataTypes.DATE,//支付时间
    totalSum: DataTypes.DECIMAL(12, 3),//订单总额（平台费用+服务费+官费+发票税费+个人利润+平台利润）
    certifyFileUrl: DataTypes.STRING(500), //证明文件Url
    notes: DataTypes.STRING,//备注
    itemCode: DataTypes.STRING(100),//项目操作码
    itemName: DataTypes.STRING(100),//项目名称
    buyerOpenId: DataTypes.STRING,//用户在商户appid下的唯一标识或买家在支付宝的用户id
    passTradeNo: DataTypes.STRING,//通道的统一订单号
    buyerAliLogonId: DataTypes.STRING,//买家支付宝账号
  }, base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'b_refundvoucher',
      validate: {
      }
    });
}
