const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("order", {                                                                                                                                                                      
    app_id              :DataTypes.INTEGER,//     
    orderNo             :DataTypes.STRING(64),//  订单号         
    channelServiceNo    :DataTypes.STRING(64),//  渠道服务单号                                                                                                                                                                                 
    channelOrderNo      :DataTypes.STRING(1024),//  渠道订单号列表，多个以,隔开                                                                                                                                                  
    itemCode             :DataTypes.STRING(64),//                                                                                                                                                                                            
    itemName             :DataTypes.STRING(100),//                                                                                                                                                                                                                                                                                                                                                                            
    channelItemCode      :DataTypes.STRING(64),//  渠道产品编码                                                                                                                                                                        
    channelItemName      :DataTypes.STRING,//  渠道产品名称        
    payTime              :DataTypes.DATE,//  渠道有支付时间则用渠道的支付时间
    salesNum            :DataTypes.INTEGER,//  项目订单数量（即服务项目的倍数，默认值为1）                                                                                                                          
    salesDiliverNum     :DataTypes.INTEGER,//  项目订单交付数量（即与项目订单数量相对应）      
    minitermNum            :DataTypes.INTEGER,// 订单小项数量                                                                                                                         
    minitermDiliverNum     :DataTypes.INTEGER,//  订单小项交付数量                                                                                                                    
    orderType           :{
          type: DataTypes.ENUM,
          values: Object.keys(uiconfig.config.pdict.order_type),
    },//  订单类型，zzdd: 自主订单,dkxd: 代客下单      
    orderPayStatusName: DataTypes.STRING(50),//                                                                                                                                
    orderPayStatus      :{
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.order_pay_status),
      set: function (val) {
        this.setDataValue("orderPayStatus", val);
        this.setDataValue("orderPayStatusName", uiconfig.config.pdict.order_pay_status[val]);
      }
    },// 订单付款状态dfk: 待付款, zfpz: 已上传支付凭证, yfk: 已付款, ddqx: 订单取消, tkclz: 退款处理中, bfytk: 部分已退款, ytk: 已退款,zfshbtg:支付审核不通过
    totalServiceCharge  :DataTypes.DECIMAL(12, 2),//  服务费总额（产品配置的服务费*订单件数）                                                                                                                                
    totalPublicExpense  :DataTypes.DECIMAL(12, 2),//  官费总额（产品配置的官费*订单件数）                                                                                                                                      
    totalDiscounts      :DataTypes.DECIMAL(12, 2),//  优惠总额（（服务费总额+官费总额）-订单总额(产品价格×优惠费率×订单件数)>0则有优惠额度）                                                           
    totalTaxes          :DataTypes.DECIMAL(12, 2),//  税费总额（订单总额-(订单总额/（1+产品费率）)）                                                                                                                        
    totalSum            :DataTypes.DECIMAL(12, 2),//  订单总额(产品价格×优惠费率×订单件数)                                                                                                                                    
    refundSum           :DataTypes.DECIMAL(12, 2),//  退款金额                                                                                                                                        
    totalProfitSum      :DataTypes.DECIMAL(12, 2),//  订单毛利润总额（订单总额-官费总额）                                                                                                                                      
    pfProfitSum         :DataTypes.DECIMAL(12, 2),//  订单平台毛利润总额（订单毛利润总额-订单渠道分成毛利润总额）                                                                                                  
    channelProfitSum    :DataTypes.DECIMAL(12, 2),//  订单渠道分成毛利润总额(（订单总额-官费总额）*渠道利润分成比率)                                                                                               
    pfSettleProfit      :DataTypes.DECIMAL(12, 2),//  平台结算渠道利润,0否，1是                                                                                                                                                                            
    opNotes               :DataTypes.STRING,//  备注                                                                                                                                                                                    
    notes               :DataTypes.STRING,//  备注     
    appPayType          :{
          type: DataTypes.ENUM,
          values: Object.keys(uiconfig.config.pdict.app_pay_type),
    },//  支付类型：00第三方支付，10平台代收款                                                                                                                                                                            
    createuser_id       :DataTypes.INTEGER,//                                                                                                                                                                                            
    updateuser_id       :DataTypes.INTEGER,//  
    owner_id            :DataTypes.INTEGER,//                                                                                                                                                                                          
    creator             :DataTypes.STRING(100),//                                                                                                                                                                                            
    updator             :DataTypes.STRING(100),//     
    owner               :DataTypes.STRING(100),//  
    ownerMoblie          :DataTypes.STRING(20),//                                                                                                                                                                                                   
    invoiceApplyStatus  :DataTypes.STRING(10),//  发票状态:00: 未申请, 10: 已申请,20:已开票                                                                                                                                    
    channelUserId       :DataTypes.STRING(64),         //  渠道用户ID   
    needNo              :DataTypes.STRING(64),         //  需求单号 
    sourceType: DataTypes.STRING(10),//来源类型：00订单，10需求需要用户确认方案   
    picUrl                 :DataTypes.STRING(500),//  产品图片地址                                                                                                                                               
    productType_id         :DataTypes.INTEGER,        //产品类型Id
    productOneType_id      :DataTypes.INTEGER,        //产品大类Id                                                                                                                                    
    serviceItemSnapshot    :DataTypes.TEXT,           //产品快照      
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'b_order',
      validate: {

      },
      indexes: [      
      ]
    });
}
