const system = require("../../../system");
const Dao = require("../../dao.base");
class OrderDao extends Dao {
  constructor() {
    super(Dao.getModelName(OrderDao));
  }
  /**
   * 创建订单
   * @param {*} ordercode 
   * @param {*} orderType 
   * @param {*} user 
   * @param {*} app 
   * @param {*} productItem 
   * @param {*} channelOrder 
   * @param {*} channelUser 
   * @param {*} apply 订单联系人信息
   * @param {*} orderAmount 订单金额信息
   * @param {*} t 
   */
  async addOrder(ordercode, orderType, user, app, productItem, channelOrder, channelUser, apply, orderAmount, t) {
    var sqlWhere = { channelServiceNo: channelOrder.channelServiceNo, app_id: user.app_id };
    var order = await this.findOne(sqlWhere, t);
    if (order) {
      var salesDiliverNum = Number(order.salesNum) - Number(order.salesDiliverNum) - orderAmount.salesNum;
      if (salesDiliverNum < 0) {
        return system.getResult(null, "服务单交付数量有误，数量为:" + order.salesNum + "，已交付数量为：" + order.salesDiliverNum);
      }
      var minitermDiliverNum = Number(order.minitermNum) - Number(order.minitermDiliverNum) - orderAmount.minitermNum;
      if (minitermDiliverNum < 0) {
        return system.getResult(null, "服务单交付小项数量有误，小项数量为:" + order.minitermNum + "，已交付小项数量为：" + order.minitermDiliverNum);
      }
      order.salesDiliverNum = Number(order.salesDiliverNum || "0") + orderAmount.salesNum;
      order.minitermDiliverNum = Number(order.minitermDiliverNum || "0") + orderAmount.minitermNum;
      var sWhere = { where: sqlWhere };
      await this.updateByWhere({ salesDiliverNum: order.salesDiliverNum, minitermDiliverNum: order.minitermDiliverNum }, sWhere, t);
      return system.getResultSuccess(order);
    }
    var myDate = new Date();
    if (app.appPayType == "00") {
      channelOrder.payStatus = channelOrder.payStatus || "yfk";
      channelOrder.payTime = channelOrder.payTime || myDate.toLocaleString();//myDate.toLocaleString()获取日期与时间==="2018-11-5 17:40:21"
    }
    var orderObj = {
      app_id: user.app_id,//                                                                                                                                                                                                
      orderNo: ordercode,// 订单号                                                                                                                                                                                        
      channelServiceNo: channelOrder.channelServiceNo,// 渠道服务单号                                                                                                                                                                               
      channelOrderNo: channelOrder.channelOrderNo,//渠道订单号列表，多个以,隔开    
      payTime: channelOrder.payTime || null,
      itemCode: productItem.itemCode,//                                                                                                                                                                                                 
      itemName: productItem.itemName,//                                                                                                                                                                                                 
      channelItemCode: productItem.channelItemCode,// 渠道产品编码                                                                                                                                                                               
      channelItemName: productItem.channelItemName,// 渠道产品名称                                                                                                                                                                               
      salesNum: channelOrder.quantity,//项目订单数量（即服务项目的倍数，默认值为1）          
      salesDiliverNum: channelOrder.salesDiliverNum,//项目订单交付数量（即与项目订单数量相对应）                                                                                                                             
      minitermNum: channelOrder.nclCount || 10 * channelOrder.quantity,//订单小项数量                                                                                                                                
      minitermDiliverNum: channelOrder.minitermDiliverNum,//订单小项交付数量                                                                                                                                
      orderType: orderType || "dkxd",// 订单类型，zzdd: 自主订单,dkxd: 代客下单                                                                                                                                             
      orderPayStatus: channelOrder.payStatus,// 订单付款状态dfk: 待付款, zfpz: 已上传支付凭证, yfk: 已付款, ddqx: 订单取消, tkclz: 退款处理中, bfytk: 部分已退款, ytk: 已退款,zfshbtg:支付审核不通过  
      totalServiceCharge: orderAmount.totalServiceCharge || 0,// 服务费总额（产品配置的服务费*订单件数）                                                                                                                                       
      totalPublicExpense: orderAmount.totalPublicExpense || 0,// 官费总额（产品配置的官费*订单件数）                                                                                                                                             
      totalDiscounts: orderAmount.totalDiscounts,// 优惠总额（（服务费总额+官费总额）-订单总额(产品价格×优惠费率×订单件数)>0则有优惠额度）                                                                  
      totalTaxes: orderAmount.totalTaxes || 0,// 税费总额（订单总额-(订单总额/（1+产品费率）)）                                                                                                                               
      totalSum: orderAmount.totalSum || 0,// 订单总额(产品价格×优惠费率×订单件数)                                                                                                                                           
      refundSum: 0,// 退款金额                                                                                                                                                                                     
      totalProfitSum: orderAmount.totalProfitSum,// 订单毛利润总额（订单总额-官费总额）                                                                                                                                             
      pfProfitSum: orderAmount.pfProfitSum,// 订单平台毛利润总额（订单毛利润总额-订单渠道分成毛利润总额）                                                                                                         
      channelProfitSum: orderAmount.channelProfitSum || 0,// 订单渠道分成毛利润总额(（订单总额-官费总额）*渠道利润分成比率)                                                                                                      
      pfSettleProfit: 0,// 平台结算渠道利润,0否，1是                                                                                                                                                             
      notes: apply.notes, //备注                                                                                                                                                                                          
      appPayType: app.appPayType,// 支付类型：00第三方支付，10平台代收款                                                                                                                                             
      // payAccountType: app.appPayType == "00" ? "other" : null,// 帐户类型（ 支付类型）:cash: 现金, bank: 银行,wx:微信,alipay:支付,other:其它                                                                                                                           
      // payTime: channelOrder.payStatus == "yfk" ? new Date() : null,//支付时间                                                                                                                                                                                     
      createuser_id: user.id,
      owner_id: user.id,//                                                                                                                                                                                                 
      creator: user.nickname,
      owner: user.nickname,//                                                                                                                                                                                                  
      ownerMoblie: user.userMoblie,//                                                                                                                                                                                                 
      invoiceApplyStatus: "00",// 发票状态:00: 未申请, 10: 已申请,20:已开票                                                                                                                                                                               
      channelUserId: channelUser.channelUserId,// 渠道用户id  
      needNo: channelOrder.needNo || null,//需求单号
      picUrl: productItem.picUrl,//                                                                                                                             
      productType_id: productItem.picUrl,//产品类型Id                                                                                                               
      productOneType_id: productItem.picUrl,//产品大类Id                                                                                                               
      serviceItemSnapshot: JSON.stringify(productItem),//产品快照        
    };
    var order = await this.create(orderObj, t);
    return system.getResultSuccess(order);
  }
  async putOrder(setObj, whereObj, t) {
    return this.updateByWhere(setObj, whereObj, t)
  }
  async getItemByChannelServiceNo(channelServiceNo, appId) {//通过订单号查询订单    
    return this.model.findOne({
      where: {
        channelServiceNo: channelServiceNo,
        app_id: appId
      },
      attributes: ["id",
        "orderNo",
        "channelUserId",
        "channelServiceNo",
        "channelOrderNo",
        "needNo",
        "invoiceApplyStatus",
        "orderType",
        "salesNum",
        "salesDiliverNum",
        "minitermNum",
        "minitermDiliverNum",
        "orderPayStatus",
        "notes",
        "totalServiceCharge",
        "totalPublicExpense",
        "totalTaxes",
        "totalSum",
        "appPayType",
        "payTime",
        "itemCode",
        "itemName"
      ],
      raw: true
    });
  }
}
module.exports = OrderDao;
