var APIBase = require("../../api.base");
var system = require("../../../system");
class AccessAuthAPI extends APIBase {
    constructor() {
        super();
        this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");
    }
    async getToken(pobj, qobj, req) {
        var appkey = pobj.appkey;
        var secret = pobj.secret;
        if (!appkey) {
            return system.getResult(null, "appkey参数不能为空");
        }
        if (!secret) {
            return system.getResult(null, "secret参数不能为空");
        }
        var result = await this.opPlatformUtils.getReqApiAccessKey(appkey, secret);
        if (result && result.status && result.status != 0) {
            return result;
        }
        var resultData = {
            token: result && result.data ? result.data.accessKey : ""
        };
        return system.getResultSuccess(resultData);
    }
    /**
  * 开放平台回调处理
  * @param {*} req 
  */
    async authByCode(pobj, qobj, req) {
        return await this.opPlatformUtils.authByCode(qobj.code);
    }
}
module.exports = AccessAuthAPI;