var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class TmOrderAPI extends APIBase {
    constructor() {
        super();
        this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");
        this.ordertmproductSve = system.getObject("service.dborder.ordertmproductSve");
        this.customerinfoSve = system.getObject("service.dborder.customerinfoSve");
        this.customercontactsSve = system.getObject("service.dborder.customercontactsSve");
        this.trademarkSve = system.getObject("service.dbtrademark.trademarkSve");
        this.zcApiUrl = settings.reqZcApi();
        this.pushFqbossDataUrl = settings.pushFqbossDataUrl();
        this.pushlogSve = system.getObject("service.common.pushlogSve");
        this.toolSve = system.getObject("service.trademark.toolSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = null;
        switch (pobj.actionProcess) {
            case "jd"://京东
                result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody, pobj, req);
                break;
            case "1688"://1688
                result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody, pobj, req);
                break;
            default:
                result = system.getResult(null, "actionProcess参数错误");
                break;
        }
        return result;
    }
    async opActionProcess(action_process, action_type, action_body, pobj, req) {
        action_body.app = req.app;
        action_body.user = req.user;
        var opResult = null;
        if (["subTmOrder", "getTmOrderList", "getTmOrderInfo", "getTmApplyInfo", "getTmNclList", "getNeedInfo",
            "tmConfirm", "updateTmInfo", "updateNclInfo", "updateContacts", "updateCustomerInfo",
            "updateCustomerInfo"].indexOf(action_type) >= 0) {
            if (!action_body.channelUserId) {
                return system.getResult(null, "channelUserId is not empty");
            }
        }
        switch (action_type) {
            // sy
            case "test"://测试
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "decryptStr"://
                opResult = await this.toolSve.decryptStr(req.app, action_body.opStr);
                break;
            case "op1688ChannelPushOrder"://处理渠道订单信息
                opResult = await this.ordertmproductSve.op1688ChannelPushOrder(action_body);
                if (opResult.status == 0) {
                    opResult.data = null;
                    var encryptResult = await this.toolSve.encryptStr(req.app, action_body.channelUserId);
                    if (encryptResult.status == 0 && encryptResult.data && encryptResult.data != "undefined") {
                        opResult.data = encryptResult.data;
                    }
                }
                break;
            case "get1688ChannelOrderInfo"://获取渠道订单信息
                opResult = await this.ordertmproductSve.get1688ChannelOrder(action_body);
                break;
            case "subTmOrder"://商标提报               
                opResult = await this.ordertmproductSve.addTmOrder(action_body);
                if (opResult && opResult.status == 0 && opResult.data) {
                    var returnTms = opResult.data.tm;
                    for (var i = 0; i < pobj.actionBody.nclones.length; i++) {
                        var nclone = pobj.actionBody.nclones[i];
                        for (var j = 0; j < returnTms.length; j++) {
                            var returnTm = returnTms[j];
                            if (returnTm.nclOne && nclone.code && returnTm.nclOne == nclone.code) {
                                pobj.actionBody.nclones[i]["tbCode"] = returnTm.tbCode;
                            }
                        }
                    }
                    pobj.actionBody["deliveryOrderNo"] = opResult.data.deliveryOrderNo;
                    // await this.pushData(opResult, req, pobj);
                    var url = this.pushFqbossDataUrl + "api/channelaccessApi/createChannelOrder"
                    await this.pushData2(opResult, req, pobj, url);
                }
                break;
            case "getTmOrderList"://商标交付列表
                opResult = await this.ordertmproductSve.getTmOrderList(action_body);
                break;
            case "getTmOrderInfo"://商标交付信息
                opResult = await this.ordertmproductSve.getTmOrder(action_body);
                break;
            case "getTmApplyInfo"://商标订单-申请信息
                opResult = await this.ordertmproductSve.getTmApply(action_body);
                break;
            case "getTmNclList"://商标订单-商标尼斯信息
                opResult = await this.ordertmproductSve.getTmNclList(action_body);
                break;
            case "updateTmInfo"://修改商标订单-商标信息修改
                opResult = await this.trademarkSve.updateTmInfo(action_body);
                if (opResult && opResult.status == 0) {
                    // await this.pushData(opResult, req, pobj);
                    var url = this.pushFqbossDataUrl + "api/channelaccessApi/updateChannelTmInfo"
                    await this.pushData2(opResult, req, pobj, url);
                }
                break;
            case "updateNclInfo"://修改商标订单-商标尼斯信息修改
                opResult = await this.trademarkSve.updateNclInfo(action_body);
                if (opResult && opResult.status == 0) {
                    // await this.pushData(opResult, req, pobj);
                    var url = this.pushFqbossDataUrl + "api/channelaccessApi/updateChannelNclInfo"
                    await this.pushData2(opResult, req, pobj, url);
                }
                break;
            case "updateContacts"://修改商标订单-修改商标交付单联系人
                opResult = await this.customercontactsSve.updateContacts(action_body);
                if (opResult && opResult.status == 0) {
                    // await this.pushData(opResult, req, pobj);
                    var url = this.pushFqbossDataUrl + "api/channelaccessApi/updateChannelContacts"
                    await this.pushData2(opResult, req, pobj, url);
                }
                break;
            case "updateCustomerInfo"://修改商标订单-修改申请人信息
                opResult = await this.customerinfoSve.updateCustomerInfo(action_body);
                if (opResult && opResult.status == 0) {
                    // await this.pushData(opResult, req, pobj);
                    var url = this.pushFqbossDataUrl + "api/channelaccessApi/updateChannelCustomerInfo"
                    await this.pushData2(opResult, req, pobj, url);
                }
                break;
            case "updateOfficial"://修改商标订单-修改交官文件
                opResult = await this.customerinfoSve.updateOfficial(action_body);
                if (opResult && opResult.status == 0) {
                    // await this.pushData(opResult, req, pobj);
                    var url = this.pushFqbossDataUrl + "api/channelaccessApi/updateChannelOfficial"
                    await this.pushData2(opResult, req, pobj, url);
                }
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
    //数据推送
    async pushData(opResult, req, pobj) {
        var url = this.zcApiUrl + "action/tmOrder/springBoard";
        var rc = system.getObject("util.execClient");
        var rtn = null;
        var requestId = opResult.requestId || req.requestId;
        if (requestId) {
            rtn = await rc.execPushDataPost("request-id:" + requestId, pobj, url);
        } else {
            rtn = await rc.execPost(pobj, url);
        }
        var returnType = "0";
        if (rtn && rtn.code == 1) {
            returnType = "1";
        }
        this.pushlogSve.createDb({
            appid: req.app.id,
            appkey: req.app.uappKey,
            requestId: opResult.requestId || req.requestId,
            op: url,
            content: JSON.stringify(pobj),
            resultInfo: JSON.stringify(rtn),
            clientIp: req.clientIp,
            returnType: returnType,
            agent: req.uagent,
            opTitle: "数据推送",
        });
    }

    //数据推送fqboss
    async pushData2(opResult, req, pobj, url) {
        var rc = system.getObject("util.execClient");
        var obj = pobj.actionBody;
        var user = obj.user;
        obj["channelUserId"] = user.channelUserId;
        obj["channelCode"] = pobj.actionProcess;
        var rtn = null;
        try {
            var requestId = opResult.requestId || req.requestId;
            if (requestId) {
                rtn = await rc.execPushDataPost("request-id:" + requestId, obj, url);
            } else {
                rtn = await rc.execPost(obj, url);
            }
            var returnType = "0";
            if (rtn.stdout) {
                var j = JSON.parse(rtn.stdout);
                if (j && j.code == 1) {
                    returnType = "1";
                }
            }
            this.pushlogSve.createDb({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: opResult.requestId || req.requestId,
                op: url,
                content: JSON.stringify(obj),
                resultInfo: JSON.stringify(rtn),
                clientIp: req.clientIp,
                returnType: returnType,
                agent: req.uagent,
                opTitle: "数据推送",
            });
        } catch (e) {
            this.pushlogSve.createDb({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: opResult.requestId || req.requestId,
                op: url,
                content: JSON.stringify(obj),
                resultInfo: JSON.stringify(e.stack),
                clientIp: req.clientIp,
                returnType: '0',
                agent: req.uagent,
                opTitle: "数据推送",
            });
        }
    }

}
module.exports = TmOrderAPI;