const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class NeedInfoService extends ServiceBase {
  constructor() {
    super("dbneed", ServiceBase.getDaoName(NeedInfoService));
  }

  async subNeed(obj){
    var user = obj.user;
    var app = obj.app;
    if(!user){
      return system.getResultFail(-100, "未知用户");
    }
    if(!app){
      return system.getResultFail(-101, "未知渠道");
    }
    var needNo=await this.getBusUid("ni");
    var needObj={
      app_id           :app.id,
      needNo           :needNo,
      needDesc         :obj.needDesc,
      needUserMoblie   :obj.needUserMoblie,
      notes            :obj.notes,
      channelUserName  :user.channelUserName,
      auditStatus      :"00",
      createuser_id    :user.id,
      itemCode:obj.itemCode                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
    };
    var need = await this.dao.create(needObj);
    return system.getResultSuccess(need);
  }
}
module.exports=NeedInfoService;
