const system = require("../../../system");
const Dao = require("../../dao.base");
class OrderTmProductDao extends Dao {
  constructor() {
    super(Dao.getModelName(OrderTmProductDao));
  }
  async getTmListByChannelServiceNo(channelServiceNo, appId) {
    return this.model.findAll({
      where: {
        channelServiceNo: channelServiceNo,
        app_id: appId
      },
      raw: true
    });
  }
  async getTmItemByDeliveryOrderNo(deliveryOrderNo) {
    return this.model.findOne({
      where: {
        deliveryOrderNo: deliveryOrderNo
      },
      raw: true
    });
  }
}
module.exports = OrderTmProductDao;
