<a name="menu">目录</a>
1. [商户nameList](#nameList)
1. [新增/修改商户](#saveMerchant)
1. [商户列表](#merchantList)
1. [商户审核](#merchantAudit)
1. [商户签约](#merchantSign)
1. [查看签约](#showSign)
1. [签约列表](#signList)
1. [资金账户列表](#accountList)
1. [充值申请列表](#rechargeList)
1. [充值申请审核](#rechargeAudit)
1. [资金交易列表](#tradeList)
1. [资金流水列表](#processList)



## **<a name="nameList"> 商户nameList</a>**
[返回到目录](#menu)
##### URL
[/web/merchant/merchantCtl/nameList]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {}

```

#### 返回结果
```javascript


{
    "status": 0,
    "msg": "success",
    "data": [
        {
            "id": 110361382269,         // 商户id
            "name": "司机宝"             // 商户名称
        },
        {
            "id": 110361384474,
            "name": "测试公司录入1"
        },
        {
            "id": 110361384475,
            "name": "测试公司录入3"
        },
        {
            "id": 110361384476,
            "name": "546444544"
        }
    ]
}
```

## **<a name="saveMerchant"> 新增/修改商户</a>**
[返回到目录](#menu)
##### URL
[/web/merchant/merchantCtl/saveMerchant]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "id": 110361384475,                             // 商户id，新增时为0, 修改时为当前修改的商户id
        "name": "测试公司录入3",                          // 商户名称
        "taxType": 1,                                   // 纳税人类型 0一般纳税人 1小规模纳税人
        "contactName": "宋毅",                           // 联系人姓名
        "contactMobile": "13338383838",                 // 联系人手机
        "contactEmail": "songyi@gongisbao.com",         // 联系人邮箱

        "taxNo": "sssssssss",                           // 纳税人识别号
        "invoiceAddr": "朝来高科技产业园33333",            // 开票地址
        "invoiceMobile": "13838383838",                 // 开票电话
        "accountName": "宋毅",                           // 开户名称
        "accountPublic": "xxxx对公账户22222",             // 对公账户


        "mailAddr": "来广营",                             // 邮寄地址
        "mailTo": "宋小毅",                               // 收件人
        "mailMobile": "13838383838",                     // 收件电话
        "ownerName": "宋大毅",                            // 客户经理姓名
        "ownerMobile": "13838383838",                     // 客户经理电话
    }

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success"
}

```

## **<a name="merchantList"> 商户列表</a>**
[返回到目录](#menu)
##### URL
[/web/merchant/merchantCtl/allList]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
    {
        "currentPage": 1,           // 当前页
        "pageSize": 10,             // 每页显示条数
        "name": "测试公司",           // 公司名称
        "merchantId": 11111,        // 商户id
        "createdBegin": "",         // 创建时间-开始
        "createdEnd": ""            // 创建时间-结束
    }
```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "count": 1,                                             // 总数
            "rows": [                                               // 商户列表
                {
                    "id": 110361384475,                             // 商户id
                    "name": "测试公司录入3",                          // 商户名称
                    "taxType": 1,                                   // 纳税人类型 0一般纳税人 1小规模纳税人
                    "contactName": "宋毅",                           // 联系人姓名
                    "contactMobile": "13338383838",                 // 联系人手机              
                    "contactEmail": "songyi@gongisbao.com",         // 联系人邮箱

                    "taxNo": "sssssssss",                           // 纳税人识别号
                    "invoiceAddr": "朝来高科技产业园33333",            // 开票地址
                    "invoiceMobile": "13838383838",                 // 开票电话
                    "accountName": "宋毅",                           // 开户名称
                    "accountPublic": "xxxx对公账户22222",             // 对公账户
                    
                    "mailAddr": "来广营",                             // 邮寄地址
                    "mailTo": "宋小毅",                               // 收件人
                    "mailMobile": "13838383838",                     // 收件电话
                    "ownerName": "宋大毅",                            // 客户经理姓名
                    "ownerMobile": "13838383838",                    // 客户经理电话
                    "statusName": "待审核"                            // 商户状态名称
                    "status": 0,                                     // 商户状态 0待审核 1待签约 2签约完成
                    "created_at": "2019-09-23 08:00",                // 创建时间
                },
            ]
        }
    }

```


## **<a name="merchantAudit"> 商户审核</a>**
[返回到目录](#menu)
##### URL
[/web/merchant/merchantCtl/merchantAudit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "id": 110361382269,                 // 商户id
        "ucname": "18600002222"             // 商户登录帐号
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success"
    }

```



## **<a name="merchantSign"> 添加/修改签约</a>**
[返回到目录](#menu)
##### URL
[/web/merchant/merchantsignedCtl/merchantSign]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "merchant_id": 110361382269,                // 商户id
        "nameA": "xxxxx有限公司",                    // 签约主体
        "contractNo": "NO233332222",                // 合同编码
        "beginDate": "2019-08-22",                  // 合同开始时间
        "endDate": "2020-08-22",                    // 合同结束时间
        "serviceRate": "5.23",                      // 服务费率
    }
```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success"
    }

```


## **<a name="showSign"> 查看签约</a>**
[返回到目录](#menu)
##### URL
[/web/merchant/merchantsignedCtl/showSign]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "merchant_id": 110361384474
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "merchant": {
                "id": 110361384475,                             // 商户id
                "name": "测试公司录入3",                          // 商户名称
            },
            "merchantSign": {
                "merchant_id": 110361384474,                    // 商户id
                "nameA": "xxxxx有限公司",                        // 签约主体
                "contractNo": "NO233332222",                    // 合同编码
                "beginDate": "2019-08-22T00:00:00.000Z",        // 合同开始时间
                "endDate": "2020-08-22T00:00:00.000Z",          // 合同结束时间
                "serviceRate": 5.23,                            // 服务费率
                "created_at": "2019-09-23T12:08:38.000Z",       // 创建时间
            }
        }
    }
```

## **<a name="signList"> 签约列表</a>**
[返回到目录](#menu)
##### URL
[/web/merchant/merchantsignedCtl/signList]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "currentPage": 1,           // 页码
        "pageSize": 10,             // 每页条数
        "merchantId": 11111,        // 商户id
        "merchantName": ""          // 商户名称
    }


```

#### 返回结果
```javascript
    {
    "status": 0,
    "msg": "success",
    "data": {
        "count": 2,
        "rows": [
            {
                "merchant": {
                    "id": 110361384475,                             // 商户id
                    "name": "测试公司录入3",                          // 商户名称
                },
                "merchantSign": {
                    "merchant_id": 110361384474,                    // 商户id
                    "nameA": "xxxxx有限公司",                        // 签约主体
                    "contractNo": "NO233332222",                    // 合同编码
                    "beginDate": "2019-08-22T00:00:00.000Z",        // 合同开始时间
                    "endDate": "2020-08-22T00:00:00.000Z",          // 合同结束时间
                    "serviceRate": 5.23,                            // 服务费率
                    "created_at": "2019-09-23T12:08:38.000Z",       // 创建时间
                }
            },
        ]
    }
}
```

## **<a name="accountList"> 资金账户</a>**
[返回到目录](#menu)
##### URL
[/web/merchant/merchantaccountCtl/accountList]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "currentPage": 1,               // 页码
        "pageSize": 10,                 // 每页条数
        "merchantName": ""              // 商户名称
        "merchantId": ""                // 商户id
    }


```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "count": 1,
            "rows": [
                {
                    "id": 1,
                    "merchant_id": 110361382269,                // 商户id
                    "frozen_amt": 120512852,                    // 冻结金额
                    "frozen_amt_y": "1205128.52",               // 冻结金额（元）
                    "available_amt": 4879475646,                // 可用金额
                    "available_amt_y": "48794756.46 "           // 可用余额（元）
                    "created_at": "2019-09-10 13:27",           // 创建时间
                    "merchantName": "司机宝",                    // 企业名称
                }
            ]
        }
    }

```


## **<a name="rechargeList"> 充值申请列表</a>**
[返回到目录](#menu)
##### URL
[/web/merchant/merchantrechargeCtl/rechargeList]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "currentPage": 1,
        "pageSize": 10,
        "merchantName": "  ",           // 商户名称
        "merchantId": ""                // 商户id
        "createdBegin": "",             // 创建时间-开始
        "createdEnd": "",               // 创建时间-结束
        "status": null                  // 状态 0待审核 1已入账 2审核失败
    }


```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "count": 2,
            "rows": [
                {
                    "id": 1,                                    // id, 审核时候传入
                    "merchant_id": 110361382269,                // 商户id
                    "outTradeNo": "2",                          // 充值流水号
                    "voucher": "https://www.baidu.com/1.png",   // 充值凭证
                    "amt": 100000,                              // 充值金额（分）
                    "amt_y": "1000",                            // 充值金额（元）
                    "statusName": "待审核",                      // 审核状态名称
                    "status": 0,                                // 审核状态
                    "remark": "",                               // 审核备注
                    "merchantName": "司机宝"                     // 商户名称
                    "auditUserName": "样情局"                    // 审核人
                },
            ]
        }
    }

```



## **<a name="rechargeAudit"> 充值申请审核</a>**
[返回到目录](#menu)
##### URL
[/web/merchant/merchantrechargeCtl/rechargeAudit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

        {
            "id": 3,                    // 充值id
            "status": 1,                // 审核状态 1已入账 2审核失败
            "remark": "审核备注"         // 审核备注 审核失败时必须填写
        }


```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
    }

```


## **<a name="tradeList"> 资金交易列表</a>**
[返回到目录](#menu)
##### URL
[/web/merchant/merchanttradeCtl/tradeList]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
    {
        "currentPage": 1,
        "pageSize": 10,
        "merchantId":"",                        // 商户id
        "invoiceApplyNo":"456456",              // 发票申请号
        "type":"",                              // 收支类型 1充值 2支出
        "createdBegin":"",                      // 创建时间-开始
        "createdEnd":""                         // 创建时间-结束
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "count": 1,
            "rows": [
                {
                    "id": 7,                                // id
                    "merchant_id": 110361382269,            // 商户id
                    "merchantName": "司机宝",                // 商户名称
                    "invoiceNo": "123123",                  // 发票编号
                    "invoiceApplyNo": "456456",             // 发票申请号
                    "outTradeNo": "2",                      // 充值流水号
                    "amt": 100000,                          // 交易金额（分）
                    "amt_y": "1000"                         // 交易金额（元）
                    "balance": 4879525646,                  // 账户余额
                    "type": 2,                              // 收支类型 1充值 2支出
                    "businessTypeName": "增值费扣款",         // 业务类型名称
                    "businessType": 20,                     // 业务类型 00服务费扣款 10个税扣款 20增值费扣款 30附加费扣款 90充值入账
                    "created_at": "2019-09-24 11:41",       // 创建时间
                }
            ]
        }
    }
```


## **<a name="processList"> 资金流水列表</a>**
[返回到目录](#menu)
##### URL
[/web/merchant/merchanttradeprocessCtl/processList]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
    {
        "currentPage": 1,
        "pageSize": 10,
        "merchantId":"",                        // 商户id
        "invoiceApplyNo":"456456",              // 发票申请号
        "busiType":"",                          // 业务类型 00开票冻结 10解冻扣款 20撤回发票退款 30审核驳回退款
        "createdBegin":"",                      // 创建时间-开始
        "createdEnd":""                         // 创建时间-结束
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "count": 4,
            "rows": [
                {
                    "id": 50,                               // id
                    "merchant_id": 110361382269,            // 商户id
                    "merchantName": "司机宝",                // 商户名号曾
                    "invoiceApplyNo": "100002",             // 发票申请号
                    "amtType": "30",                        // 费用类型 00服务费 10个税 20增值费 30附加费
                    "amtTypeName": "附加费",                 // 费用类型名称
                    "amt": 0,                               // 流水金额（分）
                    "amt_y": "0",                           // 流水金额（元）
                    "frozen_amt": 120519881,                // 账户冻结金额（分）
                    "frozen_amt_y": "1205198.81",           // 账户冻结金额（元）
                    "available_amt": 4879468617,            // 账户可用余额（分）
                    "available_amt_y": "48794686.17"        // 账户可用余额（元）
                    "busiType": "00",                       // 业务类型 00开票冻结 10解冻扣款 20撤回发票退款 30审核驳回退款
                    "busiTypeName":"解冻扣款",               // 业务类型名称
                    "created_at": "2019-09-20 03:16",       // 创建时间
                },
            ]
        }
    }
```


