const System = require("../../../system");
// const ServiceBase = require("../../sve.base");
const querystring = require('querystring');
class PatentycService {
  constructor() {
    this.GsbByChinaPatentSearchApi = System.getObject("api.patent.chinapatentsearch");
    this.GsbByWorldPatentSearchApi = System.getObject("api.patent.wordpatentsearch");
    this.GsbByChinaAffairSearchApi = System.getObject("api.patent.chinaaffairsearch");
    this.GsbByChinaAggApi = System.getObject("api.patent.cpatentaggregations");
    this.GsbByWorldAggApi = System.getObject("api.patent.wpatentaggregations");
    this.CreatepdfUrl = "http://202.106.92.152:82/pv4.1/createPdf.php";
    this.DownpdfUrl = "http://202.106.92.152:82/pv4.1/downPdf.php";
  };

  async obtainreport(obj){//专利价值评价报告
    var pubno = obj.publishnum == null ? "" : obj.publishnum;
    var country = "";
    if (pubno.length >=2){
      country = pubno.substr(0,2);
    }
    if (country){
      if (country == "CN"){
        var params = {
          user:"GaoYQ",
          passwd:"123456",
          appNo:obj.applynum,
          pdfType:"pdfGood",
        };
        var rc = System.getObject("util.restClient");
        var data= querystring.stringify(params);
        var rtn=null;
        try{
          rtn=await rc.execPost2(data,this.CreatepdfUrl);
          var result = JSON.parse(rtn.stdout);
          if (result.code == 0){
            rtn = await rc.execPostRank(data,this.DownpdfUrl);
            var buf = new Buffer(rtn.stdout);
            return {"content":rtn.stdout};
          }
          else{
            return null;
          }
        }catch(e){
          return null;
        }
      }
      else {
        return null;
      }
    }
    else{
      return null;
    }
  };

  async patentrank(obj){//专利价值评价
    var pubno = obj.publishnum == null ? "" : obj.publishnum;
    var country = "";
    if (pubno.length >=2){
      country = pubno.substr(0,2);
    }
    if (country){
      if (country == "CN"){
        var params = {
          user:"GaoYQ",
          passwd:"123456",
          appNo:obj.applynum,
          pdfType:"score",
        };
        var rc = System.getObject("util.restClient");
        var data= querystring.stringify(params);
        var rtn=null;
        try{
          rtn=await rc.execPost2(data,this.CreatepdfUrl);
          var result = JSON.parse(rtn.stdout);
          if (result.code == 0){
              var score=result.result.pvScore.sumScore;
              var desc = "";
              if ( score >0 && score <= 20){
                desc = "创新性差";
              }
              else if ( score >20 && score <= 40){
                desc = "创新性低";
              }
              else if ( score >40 && score <= 60){
                desc = "创新性中等";
              }
              else if ( score >60 && score <= 80){
                desc = "创新性较高";
              }
              else if ( score >80 && score <= 100){
                desc = "创新性高";
              }
              return { value: score, name: desc };
          }
          else{
            return { value: "0", name: "" };
          }
        }catch(e){
          return { value: "0", name: "" };
        }
      }
      else {
        return null;
      }
    }
    else{
      return null;
    }
    
  };

  async prasecountry(china, main, other) {//勾选国别解析，用于世界专利
    var countryA = [];
    if (china) {
      if (china.indexOf("香港") >= 0) {
        countryA.push("HKPATENT")
      }
      if (china.indexOf("台湾") >= 0) {
        countryA.push("TWZL")
      }
      if (china.indexOf("澳门") >= 0) {
        countryA.push("MACZL")
      }
    }

    if (main) {
      if (main.indexOf("EPO") >= 0) {
        countryA.push("EPPATENT")
      }
      if (main.indexOf("WIPO") >= 0) {
        countryA.push("WOPATENT")
      }
      if (main.indexOf("美国") >= 0) {
        countryA.push("USPATENT")
      }
      if (main.indexOf("日本") >= 0) {
        countryA.push("JPPATENT")
      }
      if (main.indexOf("韩国") >= 0) {
        countryA.push("KRPATENT")
      }
      if (main.indexOf("英国") >= 0) {
        countryA.push("GBPATENT")
      }
      if (main.indexOf("法国") >= 0) {
        countryA.push("FRPATENT")
      }
      if (main.indexOf("德国") >= 0) {
        countryA.push("DEPATENT")
      }
      if (main.indexOf("俄罗斯") >= 0) {
        countryA.push("RUPATENT")
      }
      if (main.indexOf("瑞士") >= 0) {
        countryA.push("CHPATENT")
      }

    }

    if (other) {
      if (other.indexOf("奥地利") >= 0) {
        countryA.push("ATPATENT")
      }
      if (other.indexOf("澳大利亚") >= 0) {
        countryA.push("AUPATENT")
      }
      if (other.indexOf("西班牙") >= 0) {
        countryA.push("ESPATENT")
      }
      if (other.indexOf("意大利") >= 0) {
        countryA.push("ITPATENT")
      }
      if (other.indexOf("加拿大") >= 0) {
        countryA.push("CAPATENT")
      }
      if (other.indexOf("瑞典") >= 0) {
        countryA.push("SEPATENT")
      }
    }
    return countryA;
  };

  async praseworldname(dbname) {//根据dbname得到国家名字，用于世界专利
    var mapobj = {
      "HKPATENT": "香港特别行政区",
      "TWZL": "台湾省",
      "MACZL": "澳门特别行政区",
      "EPPATENT": "欧洲专利局",
      "WOPATENT": "世界知识产权组织",
      "USPATENT": "美国",
      "JPPATENT": "日本",
      "KRPATENT": "韩国",
      "GBPATENT": "英国",
      "FRPATENT": "法国",
      "DEPATENT": "德国",
      "RUPATENT": "俄罗斯",
      "CHPATENT": "瑞士",
      "ATPATENT": "奥地利",
      "AUPATENT": "澳大利亚",
      "ESPATENT": "西班牙",
      "ITPATENT": "意大利",
      "CAPATENT": "加拿大",
      "SEPATENT": "瑞典"
    };

    if (mapobj.hasOwnProperty(dbname)) {
      return mapobj[dbname];
    }
    else {
      return null;
    }

  }
  async Arrayobjoper(array1, array2) {//数组对象按key合并去重并按照value排序
    var newarray = []; //盛放去重后数据的新数组
    if (array1.length > 0) {
      if (array2.length <= 0) {
        newarray = newarray.concat(array1);
      }
      else {

        newarray = newarray.concat(array2);
        for (var i = 0; i < array1.length; i++) {
          var a = newarray.findIndex(f => f.key == array1[i].key);
          if (a > -1) {
            newarray[a].doc_count = newarray[a].doc_count + array1[a].doc_count;
          }
          else {
            var key = array1[i].key;
            var count = array1[i].doc_count;
            var newitem = { "key": key, "doc_count": count };
            newarray.push(newitem);
          }
        }
      }
    }
    else {
      if (array2.length > 0) {
        newarray = newarray.concat(array2);
      }
    }

    var compare = function (prop) {
      return function (obj1, obj2) {
        var val1 = obj1[prop];
        var val2 = obj2[prop];
        if (val1 < val2) {
          return 1;
        } else if (val1 > val2) {
          return -1;
        } else {
          return 0;
        }
      }
    }

    return newarray.sort(compare("doc_count"));
  };

  async getpercent(num, total) {//求百分比
    num = parseFloat(num);
    total = parseFloat(total);
    if (isNaN(num) || isNaN(total)) {
      return "-";
    }
    if (total <= 0) {
      return "0%";
    }
    else {
      return (Math.round(num / total * 10000) / 100.00) + "%"
    }

  };

  async getcountryen(cnname) {//国家对应关系
    var mapobj = {
      "阿拉伯联合酋长国": "United Arab Emirates",
      "阿富汗": "Afghanistan",
      "安道尔共和国": "Andorra",
      "安提瓜和巴布达": "Antigua and Barb.",
      "阿尔巴尼亚": "Albania",
      "亚美尼亚": "Armenia",
      "安哥拉": "Angola",
      "阿根廷": "Argentina",
      "奥地利": "Austria",
      "澳大利亚": "Australia",
      "开曼群岛": "Cayman Is.",
      "阿塞拜疆": "Azerbaijan",
      "巴巴多斯": "Barbados",
      "孟加拉国": "Bangladesh",
      "比利时": "Belgium",
      "布基纳法索": "Burkina Faso",
      "保加利亚": "Bulgaria",
      "巴林": "Bahrain",
      "布隆迪": "Burundi",
      "贝宁": "Benin",
      "巴勒斯坦": "Palestine",
      "百慕大群岛": "Bermuda",
      "文莱": "Brunei",
      "玻利维亚": "Bolivia",
      "巴西": "Brazil",
      "巴哈马": "Bahamas",
      "博茨瓦纳": "Botswana",
      "白俄罗斯": "Belarus",
      "伯利兹": "Belize",
      "加拿大": "Canada",
      "中非共和国": "Central African Rep.",
      "刚果": "Congo",
      "瑞士": "Switzerland",
      "智利": "Chile",
      "喀麦隆": "Cameroon",
      "中国": "China",
      "哥伦比亚": "",
      "哥斯达黎加": "Colombia",
      "捷克": "Czech Rep.",
      "古巴": "Cuba",
      "塞浦路斯": "Cyprus",
      "德国": "Germany",
      "吉布提": "Djibouti",
      "丹麦": "Denmark",
      "多米尼加共和国": "Dominican Rep.",
      "阿尔及利亚": "Algeria",
      "厄瓜多尔": "Ecuador",
      "爱沙尼亚": "Estonia",
      "埃及": "Egypt",
      "西班牙": "Spain",
      "埃塞俄比亚": "Ethiopia",
      "芬兰": "Finland",
      "斐济": "Fiji",
      "法国": "France",
      "加蓬": "Gabon",
      "英国": "United Kingdom",
      "格林纳达": "Grenada",
      "格鲁吉亚": "Georgia",
      "法属圭亚那": "Guyana",
      "加纳": "Ghana",
      "冈比亚": "Gambia",
      "几内亚": "Eq. Guinea",
      "希腊": "Greece",
      "危地马拉": "Guatemala",
      "关岛": "Guam",
      "圭亚那": "Guyana",
      "洪都拉斯": "Honduras",
      "海地": "Haiti",
      "匈牙利": "Hungary",
      "印度尼西亚": "Indonesia",
      "爱尔兰": "Ireland",
      "以色列": "Israel",
      "印度": "India",
      "伊拉克": "Iraq",
      "伊朗": "Iran",
      "冰岛": "Iceland",
      "意大利": "Italy",
      "牙买加": "Jamaica",
      "约旦": "Jordan",
      "日本": "Japan",
      "肯尼亚": "Kenya",
      "吉尔吉斯坦": "Kyrgyzstan",
      "柬埔寨": "Cambodia",
      "朝鲜": "Dem. Rep. Korea",
      "韩国": "Korea",
      "科特迪瓦共和国": "Côte d'Ivoire",
      "科威特": "Kuwait",
      "哈萨克斯坦": "Kazakhstan",
      "老挝": "Lao PDR",
      "黎巴嫩": "Lebanon",
      "圣卢西亚": "Saint Lucia",
      "列支敦士登": "Liechtenstein",
      "斯里兰卡": "Sri Lanka",
      "利比里亚": "Liberia",
      "莱索托": "Lesotho",
      "立陶宛": "Lithuania",
      "卢森堡": "Luxembourg",
      "拉脱维亚": "Latvia",
      "利比亚": "Libya",
      "摩洛哥": "Morocco",
      "摩尔多瓦": "Moldova",
      "马达加斯加": "Madagascar",
      "马里": "Mali",
      "缅甸": "Myanmar",
      "蒙古": "Mongolia",
      "蒙特塞拉特岛": "Montserrat",
      "马耳他": "Malta",
      "毛里求斯": "Mauritius",
      "马拉维": "Malawi",
      "墨西哥": "Mexico",
      "马来西亚": "Malaysia",
      "莫桑比克": "Mozambique",
      "纳米比亚": "Namibia",
      "尼日尔": "Niger",
      "尼日利亚": "Nigeria",
      "尼加拉瓜": "Nicaragua",
      "荷兰": "Netherlands",
      "挪威": "Norway",
      "尼泊尔": "Nepal",
      "新西兰": "New Zealand",
      "阿曼": "Oman",
      "巴拿马": "Panama",
      "秘鲁": "Peru",
      "法属玻利尼西亚": "Fr. Polynesia",
      "巴布亚新几内亚": "",
      "菲律宾": "Papua New Guinea",
      "巴基斯坦": "Pakistan",
      "波兰": "Poland",
      "波多黎各": "Puerto Rico",
      "葡萄牙": "Portugal",
      "巴拉圭": "Paraguay",
      "卡塔尔": "Qatar",
      "罗马尼亚": "Romania",
      "俄罗斯": "Russia",
      "沙特阿拉伯": "Saudi Arabia",
      "所罗门群岛": "Solomon Is.",
      "塞舌尔": "Seychelles",
      "苏丹": "Sudan",
      "瑞典": "Sweden",
      "新加坡": "Singapore",
      "斯洛文尼亚": "Slovenia",
      "斯洛伐克": "Slovakia",
      "塞拉利昂": "Sierra Leone",
      "塞内加尔": "Senegal",
      "索马里": "Somalia",
      "苏里南": "Suriname",
      "圣多美和普林西比": "São Tomé and Principe",
      "萨尔瓦多": "El Salvador",
      "叙利亚": "Syria",
      "斯威士兰": "Swaziland",
      "乍得": "Chad",
      "多哥": "Togo",
      "泰国": "Thailand",
      "塔吉克斯坦": "Tajikistan",
      "土库曼斯坦": "Turkmenistan",
      "突尼斯": "Tunisia",
      "汤加": "Tonga",
      "土耳其": "Turkey",
      "特立尼达和多巴哥": "Trinidad and Tobago",
      "坦桑尼亚": "Tanzania",
      "乌克兰": "Ukraine",
      "乌干达": "Uganda",
      "美国": "United States",
      "乌拉圭": "Uruguay",
      "乌兹别克斯坦": "Uzbekistan",
      "圣文森特岛": "St. Vin. and Gren.",
      "委内瑞拉": "Venezuela",
      "越南": "Vietnam",
      "也门": "Yemen",
      "南斯拉夫": "",
      "南非": "South Africa",
      "赞比亚": "Zambia",
      "津巴布韦": "Zimbabwe",
      "香港特别行政区": "Hong Kong",
      "台湾省": "Taiwan, China",
      "澳门": "Macao"
    };

    if (mapobj.hasOwnProperty(cnname)) {
      return mapobj[cnname];
    }
    else {
      return null;
    }

  };

  async getprovincename(cnname) {//省份简称对应关系,全称对简称
    var mapobj = {
      "北京市": "北京",
      "山东省": "山东",
      "广西壮族自治区": "广西",
      "广东省": "广东",
      "内蒙古自治区": "内蒙古",
      "河北省": "河北",
      "黑龙江省": "黑龙江",
      "江苏省": "江苏",
      "天津市": "天津",
      "福建省": "福建",
      "浙江省": "浙江",
      "陕西省": "陕西",
      "安徽省": "安徽",
      "上海市": "上海",
      "贵州省": "贵州",
      "山西省": "山西",
      "重庆市": "重庆",
      "湖北省": "湖北",
      "四川省": "四川",
      "甘肃省": "甘肃",
      "湖南省": "湖南",
      "河南省": "河南",
      "辽宁省": "辽宁",
      "海南省": "海南",
      "江西省": "江西",
      "云南省": "云南",
      "新疆维吾尔自治区": "新疆",
      "宁夏回族自治区": "宁夏",
      "吉林省": "吉林",
      "西藏自治区": "西藏",
      "青海省": "青海",
      "香港": "香港",
      "台湾省": "台湾",
      "澳门": "澳门"
    };

    if (mapobj.hasOwnProperty(cnname)) {
      return mapobj[cnname];
    }
    else {
      return null;
    }

  };

  async getprovincenameorder(cnname) {//省份简称对应关系,简称对全称
    var mapobj = {
      "北京": "北京市",
      "山东": "山东省",
      "广西": "广西壮族自治区",
      "广东": "广东省",
      "内蒙古": "内蒙古自治区",
      "河北": "河北省",
      "黑龙江": "黑龙江省",
      "江苏": "江苏省",
      "天津": "天津市",
      "福建": "福建省",
      "浙江": "浙江省",
      "陕西": "陕西省",
      "安徽": "安徽省",
      "上海": "上海市",
      "贵州": "贵州省",
      "山西": "山西省",
      "重庆": "重庆市",
      "湖北": "湖北省",
      "四川": "四川省",
      "甘肃": "甘肃省",
      "湖南": "湖南省",
      "河南": "河南省",
      "辽宁": "辽宁省",
      "海南": "海南省",
      "江西": "江西省",
      "云南": "云南省",
      "新疆": "新疆维吾尔自治区",
      "宁夏": "宁夏回族自治区",
      "吉林": "吉林省",
      "西藏": "西藏自治区",
      "青海": "青海省",
      "香港": "香港",
      "台湾": "台湾省",
      "澳门": "澳门"
    };

    if (mapobj.hasOwnProperty(cnname)) {
      return mapobj[cnname];
    }
    else {
      return null;
    }

  };

  async getrowdata(lablecname, datalist) {//组合row0，最大为10
    var redata = null;
    if (datalist.length == 1) {
      redata = { lable: lablecname, row0: datalist[0] };
    }
    else if (datalist.length == 2) {
      redata = { lable: lablecname, row0: datalist[0], row1: datalist[1] };
    }
    else if (datalist.length == 3) {
      redata = { lable: lablecname, row0: datalist[0], row1: datalist[1], row2: datalist[2] };
    }
    else if (datalist.length == 4) {
      redata = { lable: lablecname, row0: datalist[0], row1: datalist[1], row2: datalist[2], row3: datalist[3] };
    }
    else if (datalist.length == 5) {
      redata = { lable: lablecname, row0: datalist[0], row1: datalist[1], row2: datalist[2], row3: datalist[3], row4: datalist[4] };
    }
    else if (datalist.length == 6) {
      redata = {
        lable: lablecname, row0: datalist[0], row1: datalist[1], row2: datalist[2],
        row3: datalist[3], row4: datalist[4], row5: datalist[5]
      };
    }
    else if (datalist.length == 7) {
      redata = {
        lable: lablecname, row0: datalist[0], row1: datalist[1], row2: datalist[2],
        row3: datalist[3], row4: datalist[4], row5: datalist[5], row6: datalist[6]
      };
    }
    else if (datalist.length == 8) {
      redata = {
        lable: lablecname, row0: datalist[0], row1: datalist[1], row2: datalist[2],
        row3: datalist[3], row4: datalist[4], row5: datalist[5], row6: datalist[6], row7: datalist[7]
      };
    }
    else if (datalist.length == 9) {
      redata = {
        lable: lablecname, row0: datalist[0], row1: datalist[1], row2: datalist[2],
        row3: datalist[3], row4: datalist[4], row5: datalist[5], row6: datalist[6], row7: datalist[7],
        row8: datalist[8]
      };
    }
    else if (datalist.length == 10) {
      redata = {
        lable: lablecname, row0: datalist[0], row1: datalist[1], row2: datalist[2],
        row3: datalist[3], row4: datalist[4], row5: datalist[5], row6: datalist[6], row7: datalist[7],
        row8: datalist[8], row9: datalist[9]
      };
    }

    return redata;

  }

  async prasecondition(obj, desc) {//解析前端传回的参数
    var search = obj.search;
    var countryA = [];
    var capilist = [];
    var wapilist = [];
    if (search == "simpleall") {//普通检索--全部
      var patenttype = obj.obj.patenttype == null ? "" : obj.obj.patenttype;
      var status = obj.obj.status == null ? "" : obj.obj.status;
      var applydate = obj.obj.applydate == null ? "" : obj.obj.applydate;
      var publishdate = obj.obj.publishdate == null ? "" : obj.obj.publishdate;
      var lable = obj.obj.lable;
      var content = obj.obj.content;
      var china = obj.obj.range.china;
      var main = obj.obj.range.main;
      var other = obj.obj.range.other;

      countryA = [];
      capilist = [];
      wapilist = [];
      if (china) {
        if (china.indexOf("中国大陆") >= 0) {
          var parm = null;
          if (lable == "patentname") {
            parm = {
              "match": {
                "filing_name": content
              }
            }
          }
          else if (lable == "applynum") {
            var filingno = content.replace("CN","").replace("cn","").replace(".","");
            if (filingno.length == 13){
              filingno = filingno.substr(0,12);
            }
            else if (filingno.length == 9){
              filingno = filingno.substr(0,8);
            }
            parm = {
              "wildcard": {
                "filing_no": "*" + filingno + "*"
              }
            }
          }
          else if (lable == "publishnum") {
            parm = {
              "bool": {
                "should": [
                ]
              }
            }
            var parr = {
              "wildcard": {
                "pub_no": "*" + content + "*"
              }
            }
            parm.bool.should.push(parr);

            parr = {
              "wildcard": {
                "gr_no": "*" + content + "*"
              }
            }
            parm.bool.should.push(parr);
          }
          else if (lable == "applier") {
            parm = {
              "query_string": {
                "default_field": "applicant_name",
                "query": "\""+ content +"\""
              }
            }
          }
          else if (lable == "inventor") {
            parm = {
              "query_string": {
                "default_field": "inventor_name",
                "query": "\""+ content +"\""
              }
            }

          }
          capilist.push(parm);

          var isWG = false;
          if (desc == "发明分析") {
            if (patenttype) {
              if (patenttype == "发明申请") {
                parm = {
                  "term": {
                    "pub_type": "发明"
                  }
                }
                capilist.push(parm);
              }
              else {
                isWG = true;//不做查询和聚合
              }

            }
            else {
              parm = {
                "term": {
                  "pub_type": "发明"
                }
              }
              capilist.push(parm);
            }
          }
          else if (desc == "ipc") {
            if (patenttype) {
              if (patenttype != "外观设计") {
                if (patenttype == "发明申请") {
                  parm = {
                    "term": {
                      "pub_type": "发明"
                    }
                  }
                }
                else {
                  parm = {
                    "term": {
                      "pub_type": patenttype
                    }
                  }
                }

                capilist.push(parm);
              }
              else {
                isWG = true;//不做查询和聚合
              }
            }
            else {
              parm = {
                "terms": {
                  "pub_type": ["发明", "实用新型"]
                }
              }
              capilist.push(parm);
            }

          }
          else if (desc == "外观分析") {
            if (patenttype) {
              if (patenttype == "外观设计") {
                parm = {
                  "term": {
                    "pub_type": "外观设计"
                  }
                }
                capilist.push(parm);
              }
              else {
                isWG = true;//不做查询和聚合
              }
            }
            else {
              parm = {
                "term": {
                  "pub_type": "外观设计"
                }
              }
              capilist.push(parm);
            }

          }
          else {
            if (patenttype) {
              if (patenttype == "发明申请") {
                parm = {
                  "term": {
                    "pub_type": "发明"
                  }
                }
              }
              else {
                parm = {
                  "term": {
                    "pub_type": patenttype
                  }
                }
              }

              capilist.push(parm);
            }
          }

          if (status) {
            parm = {
              "term": {
                "pub_status": status
              }
            }
            capilist.push(parm);
          }

          if (applydate) {
            parm = {
              "term": {
                "filing_year": applydate
              }
            }
            capilist.push(parm);
          }

          if (publishdate) {
            parm = {
              "term": {
                "pub_year": publishdate
              }
            }
            capilist.push(parm);
          }

          if (isWG) {
            capilist = [];
          }
        }
      }

      if ((desc != "外观分析" || desc != "发明分析") && (!status && !patenttype)) {
        countryA = await this.prasecountry(china, main, other);
        if (countryA.length > 0) {//调用世界专利检索
          if (!patenttype || !status) {
            var parm = {
              "terms": {
                "db_name": []
              }
            }
            for (var country in countryA) {
              parm.terms.db_name.push(countryA[country]);
            }
            wapilist.push(parm);

            if (lable == "patentname") {
              parm = {
                "match": {
                  "title_name": content.toLowerCase()
                }
              }
            }
            else if (lable == "applynum") {
              parm = {
                "wildcard": {
                  "app_number": "*" + content + "*"
                }
              }
            }
            else if (lable == "publishnum") {
              parm = {
                "wildcard": {
                  "pub_number": "*" + content + "*"
                }
              }
            }
            else if (lable == "applier") {
              parm = {
                "query_string": {
                  "default_field": "applicant_name",
                  "query": "\""+ content.toLowerCase() +"\""
                }
              }
            }
            else if (lable == "inventor") {
              parm = {
                "query_string": {
                  "default_field": "inventor_name",
                  "query": "\""+ content.toLowerCase() +"\""
                }
              }
            }
            wapilist.push(parm);

            if (applydate) {
              parm = {
                "term": {
                  "app_year": applydate
                }
              }
              wapilist.push(parm);
            }

            if (publishdate) {
              parm = {
                "term": {
                  "pub_year": publishdate
                }
              }
              wapilist.push(parm);
            }
          }
        }

      }

    }
    else if (search == "advanceall") {//高级检索--全部
      countryA = [];
      capilist = [];
      wapilist = [];
      var abstract = obj.obj.abstract == null ? "" : obj.obj.abstract;
      var applicant = obj.obj.applier == null ? "" : obj.obj.applier;
      var filingdate1 = obj.obj.applydate1 == null ? "" : obj.obj.applydate1;
      var filingdate2 = obj.obj.applydate2 == null ? "" : obj.obj.applydate2;
      var filingno = obj.obj.applynum == null ? "" : obj.obj.applynum;
      var grdate1 = obj.obj.grantdate1 == null ? "" : obj.obj.grantdate1;
      var grdate2 = obj.obj.grantdate2 == null ? "" : obj.obj.grantdate2;
      var inventor = obj.obj.inventor == null ? "" : obj.obj.inventor;
      var ipc = obj.obj.ipc == null ? "" : obj.obj.ipc;
      var pubdate1 = obj.obj.publishdate1 == null ? "" : obj.obj.publishdate1;
      var pubdate2 = obj.obj.publishdate2 == null ? "" : obj.obj.publishdate2;
      var title = obj.obj.patentname == null ? "" : obj.obj.patentname;
      var priorno = obj.obj.priornum == null ? "" : obj.obj.priornum;
      var pubno = obj.obj.publishnum == null ? "" : obj.obj.publishnum;
      var china = obj.obj.range.china;
      var main = obj.obj.range.main;
      var other = obj.obj.range.other;
      if (china) {
        if (china.indexOf("中国大陆") >= 0) {
          var parm = null;
          if (abstract) {
            parm = {
              "match": {
                "abstr_text": abstract
              }
            }
            capilist.push(parm);
          }

          if (applicant) {
            parm = {
              "term": {
                "applicant_name.raw": applicant
              }
            }
            capilist.push(parm);
          }

          if (filingno) {
            filingno = filingno.replace("CN","").replace("cn","").replace(".","");
            if (filingno.length == 13){
              filingno = filingno.substr(0,12);
            }
            else if (filingno.length == 9){
              filingno = filingno.substr(0,8);
            }
            parm = {
              "term": {
                "filing_no": filingno
              }
            }
            capilist.push(parm);
          }

          if (filingdate1 || filingdate2) {
            parm = {
              "range": {
                "filing_time": {
                }
              }
            };
            if (filingdate1) {
              parm.range.filing_time["gte"] = filingdate1;
            }
            if (filingdate2) {
              parm.range.filing_time["lte"] = filingdate2;
            }
            capilist.push(parm);
          }

          if (grdate1 || grdate2) {
            parm = {
              "range": {
                "gr_time": {

                }
              }
            };
            if (grdate1) {
              parm.range.gr_time["gte"] = grdate1;
            }
            if (grdate2) {
              parm.range.gr_time["lte"] = grdate2;
            }
            capilist.push(parm);
          }

          if (inventor) {
            parm = {
              "term": {
                "inventor_name.raw": inventor
              }
            }
            capilist.push(parm);
          }

          if (ipc) {
            parm = {
              "term": {
                "other_ipc": ipc
              }
            }
            capilist.push(parm);
          }

          if (pubdate1 || pubdate2) {
            parm = {
              "range": {
                "pub_time": {

                }
              }
            };
            if (pubdate1) {
              parm.range.pub_time["gte"] = pubdate1;
            }
            if (pubdate2) {
              parm.range.pub_time["lte"] = pubdate2;
            }
            capilist.push(parm);
          }

          if (title) {
            parm = {
              "match": {
                "filing_name": title
              }
            }
            capilist.push(parm);
          }

          if (priorno) {
            parm = {
              "nested": {
                "path": "prior_info",
                "query": {
                  "bool": {
                    "must": [
                      { "term": { "prior_info.pri_no": priorno } }
                    ]
                  }
                }
              }
            };
            capilist.push(parm);
          }

          if (pubno) {
            parm = {
              "bool": {
                "should": [
                ]
              }
            }

            var parr = {
              "term": {
                "pub_no": pubno
              }
            }
            parm.bool.should.push(parr)

            parr = {
              "term": {
                "gr_no": pubno
              }
            }
            parm.bool.should.push(parr)
            capilist.push(parm);
          }

          if (desc == "ipc") {
            parm = {
              "terms": {
                "pub_type": ["发明", "实用新型"]
              }
            }
            capilist.push(parm);
          }
          else if (desc == "外观分析") {
            parm = {
              "term": {
                "pub_type": "外观设计"
              }
            }
            capilist.push(parm);
          }
        }
      }

      if (desc != "外观分析") {
        countryA = await this.prasecountry(china, main, other);
        if (countryA.length > 0) {//调用世界专利检索
          var parm = {
            "terms": {
              "db_name": []
            }
          }
          for (var country in countryA) {
            parm.terms.db_name.push(countryA[country]);
          }
          wapilist.push(parm);

          if (abstract) {
            parm = {
              "match": {
                "abstr_text": abstract.toLowerCase()
              }
            }
            wapilist.push(parm);
          }

          if (applicant) {
            parm = {
              "term": {
                "applicant_name.raw": applicant.toLowerCase()
              }
            }
            wapilist.push(parm);
          }

          if (filingdate1 || filingdate2) {
            parm = {
              "range": {
                "app_date": {
                }
              }
            };
            if (filingdate1) {
              parm.range.app_date["gte"] = filingdate1;
            }
            if (filingdate2) {
              parm.range.app_date["lte"] = filingdate2;
            }
            wapilist.push(parm);
          }

          if (filingno) {
            parm = {
              "term": {
                "app_number": filingno
              }
            }
            wapilist.push(parm);
          }

          if (inventor) {
            parm = {
              "term": {
                "inventor_name.raw": inventor.toLowerCase()
              }
            }
            wapilist.push(parm);
          }

          if (ipc) {
            parm = {
              "term": {
                "other_ipc": ipc
              }
            }
            wapilist.push(parm);
          }

          if (pubdate1 || pubdate2) {
            parm = {
              "range": {
                "pub_date": {

                }
              }
            };
            if (pubdate1) {
              parm.range.pub_date["gte"] = pubdate1;
            }
            if (pubdate2) {
              parm.range.pub_date["lte"] = pubdate2;
            }
            wapilist.push(parm);
          }

          if (title) {
            parm = {
              "match": {
                "title_name": title.toLowerCase()
              }
            }
            wapilist.push(parm);
          }

          if (priorno) {
            parm = {
              "wildcard": {
                "prior_info": priorno + "*"
              }
            }
            wapilist.push(parm);
          }

          if (pubno) {
            parm = {
              "term": {
                "pub_number": pubno
              }
            }
            wapilist.push(parm);
          }
        }

      }
    }
    else {//其他（包括普通检索--勾选、高级检索--勾选）
      var appnolist = obj.obj.applynumList;
      capilist = [];
      wapilist = [];
      if (appnolist.length > 0) {
        var parm = {
          "terms": {
            "filing_no": []
          }
        }
        for (var appno of appnolist) {
          parm.terms.filing_no.push(appno);
        }
        capilist.push(parm);
        if (desc == "ipc") {
          parm = {
            "terms": {
              "pub_type": ["发明", "实用新型"]
            }
          }
          capilist.push(parm);
        }
        else if (desc == "外观分析") {
          parm = {
            "term": {
              "pub_type": "外观设计"
            }
          }
          capilist.push(parm);
        }

        if (desc != "外观分析") {
          parm = {
            "terms": {
              "app_number": []
            }
          }
          for (var appno of appnolist) {
            parm.terms.app_number.push(appno);
          }
          wapilist.push(parm);
        }
      }
    };
    var rearray = [capilist, wapilist];
    return rearray;
  };

  async applierRank(obj) {//申请人分析-申请人排名
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1) {
      total = parseInt(total1);
    }
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    var wapilist = rearray[1];
    if (capilist.length > 0) {
      var tms = await this.GsbByChinaAggApi.ApplicantAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }

        }
      }
    }

    if (wapilist.length > 0) {
      var tms = await this.GsbByWorldAggApi.ApplicantAggs(wapilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            wbuckets = tms.buckets.types.buckets;
          }
        }
      }
    }

    var newarray = await this.Arrayobjoper(cbuckets, wbuckets);

    if (newarray.length > 0) {
      var arraylen = 20;
      if (newarray.length < 20) {
        arraylen = newarray.length;
      }
      var firstname = "";
      var sceondname = "";
      var thirdname = "";
      var firstcount = 0;
      var sceondcount = 0;
      var thirdcount = 0;
      var firstpercent = "0%";
      var sceondpercent = "0%";
      var thirdpercent = "0%";
      var namearrary = [];
      var countarray = [];
      var echarttable = [];
      var descstr = "";
      if (arraylen >= 3) {
        for (var i = 0; i < arraylen; i++) {
          if (i == 0) {
            firstname = newarray[i].key;
            firstcount = newarray[i].doc_count;
            firstpercent = await this.getpercent(firstcount, total);
          }
          else if (i == 1) {
            sceondname = newarray[i].key;
            sceondcount = newarray[i].doc_count;
            sceondpercent = await this.getpercent(sceondcount, total);
          }
          else if (i == 2) {
            thirdname = newarray[i].key;
            thirdcount = newarray[i].doc_count;
            thirdpercent = await this.getpercent(thirdcount, total);
          }
          namearrary.push(newarray[i].key);
          countarray.push(newarray[i].doc_count);
          echarttable.push({ rank: i + 1, company: newarray[i].key, patent: newarray[i].doc_count });
        }

        descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三个申请人申请的数量最多，分别为" +
          firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
          "、" + thirdpercent + "。";
      }
      else if (arraylen == 2) {
        firstname = newarray[0].key;
        firstcount = newarray[0].doc_count;
        firstpercent = await this.getpercent(firstcount, total);
        sceondname = newarray[1].key;
        sceondcount = newarray[1].doc_count;
        sceondpercent = await this.getpercent(sceondcount, total);
        namearrary.push(newarray[0].key);
        countarray.push(newarray[0].doc_count);
        echarttable.push({ rank: 1, company: newarray[0].key, patent: newarray[0].doc_count });
        namearrary.push(newarray[1].key);
        countarray.push(newarray[1].doc_count);
        echarttable.push({ rank: 2, company: newarray[1].key, patent: newarray[1].doc_count });
        descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两个申请人申请的数量最多，分别为" + firstcount + "件、" + sceondcount
          + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";

      }
      else {
        firstname = newarray[0].key;
        firstcount = newarray[0].doc_count;
        firstpercent = await this.getpercent(firstcount, total);
        namearrary.push(newarray[0].key);
        countarray.push(newarray[0].doc_count);
        echarttable.push({ rank: 1, company: newarray[0].key, patent: newarray[0].doc_count });
        descstr = "从以上图表可以看出，" + firstname + " 这一个申请人申请的数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
      }
      return { echart: { x: namearrary, y: countarray, desc: descstr }, table: echarttable };

    }
    else {
      return null;
    }

  };

  async applierCity(obj) {//申请人分析-申请人归属国分布
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1) {
      total = parseInt(total1);
    }
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    var wapilist = rearray[1];

    if (capilist.length > 0) {
      var tms = await this.GsbByChinaAggApi.AppCountryAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }

        }
      }
    }

    if (wapilist.length > 0) {
      var tms = await this.GsbByWorldAggApi.AppCountryAggs(wapilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            wbuckets = tms.buckets.types.buckets;
          }
        }
      }
    }

    var newarray = await this.Arrayobjoper(cbuckets, wbuckets);
    if (newarray.length > 0) {
      var arraylen = 20;
      if (newarray.length < 20) {
        arraylen = newarray.length;
      }
      var firstname = "";
      var sceondname = "";
      var thirdname = "";
      var firstcount = 0;
      var sceondcount = 0;
      var thirdcount = 0;
      var firstpercent = "0%";
      var sceondpercent = "0%";
      var thirdpercent = "0%";
      var pic1arrary = [];
      var pic2array = [];
      var echarttable = [];
      var descstr = "";
      var xlist = [];
      var ylist = [];
      var maxcount = 0;
      if (arraylen >= 3) {
        for (var i = 0; i < arraylen; i++) {
          if (i == 0) {
            firstname = newarray[i].key;
            firstcount = newarray[i].doc_count;
            maxcount = newarray[i].doc_count;
            firstpercent = await this.getpercent(firstcount, total);
          }
          else if (i == 1) {
            sceondname = newarray[i].key;
            sceondcount = newarray[i].doc_count;
            sceondpercent = await this.getpercent(sceondcount, total);
          }
          else if (i == 2) {
            thirdname = newarray[i].key;
            thirdcount = newarray[i].doc_count;
            thirdpercent = await this.getpercent(thirdcount, total);
          }

          var enname = await this.getcountryen(newarray[i].key);
          if (enname) {
            xlist.push(newarray[i].key);
            ylist.push(newarray[i].doc_count);
            pic1arrary.push({ name: enname, value: newarray[i].doc_count });
            echarttable.push({ rank: i + 1, country: newarray[i].key, patent: newarray[i].doc_count });
          }

        }

        descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三个国家/地区的申请人公开的专利数量最多，分别为" +
          firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
          "、" + thirdpercent + "。";
      }
      else if (arraylen == 2) {
        firstname = newarray[0].key;
        firstcount = newarray[0].doc_count;
        maxcount = newarray[0].doc_count;
        firstpercent = await this.getpercent(firstcount, total);
        var enname = await this.getcountryen(newarray[0].key);
        if (enname) {
          xlist.push(newarray[0].key);
          ylist.push(newarray[0].doc_count);
          pic1arrary.push({ name: enname, value: newarray[0].doc_count });
          echarttable.push({ rank: 1, country: newarray[0].key, patent: newarray[0].doc_count });
        }

        sceondname = newarray[1].key;
        sceondcount = newarray[1].doc_count;
        sceondpercent = await this.getpercent(sceondcount, total);

        enname = await this.getcountryen(newarray[1].key);
        if (enname) {
          xlist.push(newarray[1].key);
          ylist.push(newarray[1].doc_count);
          pic1arrary.push({ name: enname, value: newarray[1].doc_count });
          echarttable.push({ rank: 2, country: newarray[1].key, patent: newarray[1].doc_count });
        }
        descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两个国家/地区的申请人公开的专利数量最多，分别为" + firstcount + "件、" + sceondcount
          + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";

      }
      else {
        firstname = newarray[0].key;
        firstcount = newarray[0].doc_count;
        maxcount = newarray[0].doc_count;
        firstpercent = await this.getpercent(firstcount, total);

        enname = await this.getcountryen(newarray[0].key);
        if (enname) {
          xlist.push(newarray[0].key);
          ylist.push(newarray[0].doc_count);
          pic1arrary.push({ name: enname, value: newarray[0].doc_count });
          echarttable.push({ rank: 1, country: newarray[0].key, patent: newarray[0].doc_count });
        }
        descstr = "从以上图表可以看出，" + firstname + " 这一个国家/地区的申请人公开的专利数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
      }

      if (xlist.length > 0) {
        return { echart: { desc: descstr, max: maxcount, pic1: pic1arrary, pic2: { xlist, ylist } }, table: echarttable };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async applierIpc(obj) {//申请人分析-ipc分布
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1) {
      total = parseInt(total1);
    }
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "ipc");
    var ipctab = obj.ipcTab;
    var capilist = rearray[0];
    var wapilist = rearray[1];


    if (capilist.length > 0 || wapilist.length > 0) {
      var tms = null;
      if (capilist.length > 0) {
        tms = await this.GsbByChinaAggApi.ApplicantAggs(capilist);
        if (tms) {
          if (tms.status == 0) {
            if (tms.buckets.types.buckets) {
              cbuckets = tms.buckets.types.buckets;
            }

          }
        }
      }

      if (wapilist.length > 0) {
        tms = await this.GsbByWorldAggApi.ApplicantAggs(wapilist);
        if (tms) {
          if (tms.status == 0) {
            if (tms.buckets.types.buckets) {
              wbuckets = tms.buckets.types.buckets;
            }
          }
        }
      }

      var apparray = [];//前十申请人
      var newarray = await this.Arrayobjoper(cbuckets, wbuckets);
      if (newarray.length > 0) {
        var arraylen = 10;
        if (newarray.length < 10) {
          arraylen = newarray.length;
        }

        for (var i = 0; i < arraylen; i++) {
          apparray.push(newarray[i].key);
        }

        var parm = {
          "terms": {
            "applicant_name.raw": apparray
          }
        }

        cbuckets = [];
        wbuckets = [];
        newarray = [];
        if (capilist.length > 0) {
          capilist.push(parm);
          if (ipctab == "0") {
            tms = await this.GsbByChinaAggApi.AppIpclcAggs(capilist);
          }
          else if (ipctab == "1") {
            tms = await this.GsbByChinaAggApi.AppIpcscAggs(capilist);
          }
          else if (ipctab == "2") {
            tms = await this.GsbByChinaAggApi.AppIpclgAggs(capilist);
          }
          else if (ipctab == "3") {
            tms = await this.GsbByChinaAggApi.AppIpcAggs(capilist);
          }

          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                cbuckets = tms.buckets.types.buckets;
              }

            }
          }
        }

        if (wapilist.length > 0) {
          wapilist.push(parm);
          if (ipctab == "0") {
            tms = await this.GsbByWorldAggApi.AppIpclcAggs(wapilist);
          }
          else if (ipctab == "1") {
            tms = await this.GsbByWorldAggApi.AppIpcscAggs(wapilist);
          }
          else if (ipctab == "2") {
            tms = await this.GsbByWorldAggApi.AppIpclgAggs(wapilist);
          }
          else if (ipctab == "3") {
            tms = await this.GsbByWorldAggApi.AppIpcAggs(wapilist);
          }

          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                wbuckets = tms.buckets.types.buckets;
              }

            }
          }
        }

        var ipcarray = [];//前十IPC
        newarray = await this.Arrayobjoper(cbuckets, wbuckets);
        if (newarray.length > 0) {
          var arraylen = 10;
          if (newarray.length < 10) {
            arraylen = newarray.length;
          }
          for (var i = 0; i < arraylen; i++) {
            ipcarray.push(newarray[i].key);
          }
          parm = null;
          if (ipctab == "0") {
            parm = {
              "terms": {
                "large class": ipcarray
              }
            }
          }
          else if (ipctab == "1") {
            parm = {
              "terms": {
                "sub_class": ipcarray
              }
            }
          }
          else if (ipctab == "2") {
            parm = {
              "terms": {
                "large_group": ipcarray
              }
            }
          }
          else if (ipctab == "3") {
            parm = {
              "terms": {
                "main_ipc": ipcarray
              }
            }

          }
          //执行申请人IPC聚合
          cbuckets = [];
          wbuckets = [];
          newarray = [];

          if (capilist.length > 0) {
            capilist.push(parm);
            if (ipctab == "0") {
              tms = await this.GsbByChinaAggApi.AppIpclcMutiAggs(capilist);
            }
            else if (ipctab == "1") {
              tms = await this.GsbByChinaAggApi.AppIpcscMutiAggs(capilist);
            }
            else if (ipctab == "2") {
              tms = await this.GsbByChinaAggApi.AppIpclgMutiAggs(capilist);
            }
            else if (ipctab == "3") {
              tms = await this.GsbByChinaAggApi.AppIpcMutiAggs(capilist);
            }

            if (tms) {
              if (tms.status == 0) {
                if (tms.buckets.group_by_appl.buckets) {
                  cbuckets = tms.buckets.group_by_appl.buckets;
                }

              }
            }
          }

          if (wapilist.length > 0) {
            wapilist.push(parm);
            if (ipctab == "0") {
              tms = await this.GsbByWorldAggApi.AppIpclcMutiAggs(wapilist);
            }
            else if (ipctab == "1") {
              tms = await this.GsbByWorldAggApi.AppIpcscMutiAggs(wapilist);
            }
            else if (ipctab == "2") {
              tms = await this.GsbByWorldAggApi.AppIpclgMutiAggs(wapilist);
            }
            else if (ipctab == "3") {
              tms = await this.GsbByWorldAggApi.AppIpcMutiAggs(wapilist);
            }

            if (tms) {
              if (tms.status == 0) {
                if (tms.buckets.group_by_appl.buckets) {
                  wbuckets = tms.buckets.group_by_appl.buckets;
                }

              }
            }
          }

          if (cbuckets.length > 0 || wbuckets.length > 0) {
            var Aipcinfo = new Array();//定义信息数组，并初始化为0
            for (var i = 0; i < apparray.length; i++) {
              Aipcinfo[i] = new Array();
              for (var j = 0; j < ipcarray.length; j++) {
                Aipcinfo[i][j] = 0;
              }
            }

            //聚合结果取数据
            if (cbuckets.length > 0) {
              for (var cb in cbuckets) {
                var a = apparray.indexOf(cbuckets[cb].key);
                if (a > -1) {
                  var ipcbuckets = cbuckets[cb].group_by_ipc.buckets;
                  for (var ipcb in ipcbuckets) {
                    var b = ipcarray.indexOf(ipcbuckets[ipcb].key);
                    if (b > -1) {
                      Aipcinfo[a][b] = ipcbuckets[ipcb].doc_count;
                    }
                  }
                }
              }
            }

            if (wbuckets.length > 0) {
              for (var cb in wbuckets) {
                var a = apparray.indexOf(wbuckets[cb].key);
                if (a > -1) {
                  var ipcbuckets = wbuckets[cb].group_by_ipc.buckets;
                  for (var ipcb in ipcbuckets) {
                    var b = ipcarray.indexOf(ipcbuckets[ipcb].key);
                    if (b > -1) {
                      Aipcinfo[a][b] = Aipcinfo[a][b] + ipcbuckets[ipcb].doc_count;
                    }
                  }
                }
              }
            }

            //拼返回结果
            var echarty = [];
            for (var i = 0; i < ipcarray.length; i++) {
              var ipcname = ipcarray[i];
              var ipc1list = [];
              for (var j = 0; j < apparray.length; j++) {
                ipc1list.push(Aipcinfo[j][i]);
              }
              echarty.push({ ipc: ipcname, data: ipc1list });
            }
            var echarts = { x: apparray, legend: ipcarray, y: echarty };

            echarty = [];
            for (var i = 0; i < ipcarray.length; i++) {
              var ipcname = ipcarray[i];
              var ipc1list = [];
              for (var j = 0; j < apparray.length; j++) {
                ipc1list.push(Aipcinfo[j][i]);
              }
              var lablist = await this.getrowdata(ipcname, ipc1list);
              echarty.push(lablist);
            }
            var tablevalues = { company: apparray, data: echarty };
            return { echart: echarts, table: tablevalues };
          }
          else {
            return null;
          }


        }
        else {
          return null;
        }

      }
      else {
        return null;
      }
    }
    else {
      return null;
    }


  };

  async applierPatenttype(obj) {//申请人分析-申请人专利类型分布
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = await this.GsbByChinaAggApi.AppPubtypeAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.group_by_appl.buckets) {
            cbuckets = tms.buckets.group_by_appl.buckets;
          }

        }
      }

      if (cbuckets.length > 0) {
        var comarray = [];
        var fmlist = [];
        var xxlist = [];
        var wglist = [];
        for (var cb in cbuckets) {
          comarray.push(cbuckets[cb].key);
          var typelist = cbuckets[cb].group_by_pubtype.buckets;
          if (typelist.length > 0) {
            var a = typelist.findIndex(f => f.key == "发明");
            if (a > -1) {
              fmlist.push(typelist[a].doc_count);
            }
            else {
              fmlist.push(0);
            }

            a = typelist.findIndex(f => f.key == "实用新型");
            if (a > -1) {
              xxlist.push(typelist[a].doc_count);
            }
            else {
              xxlist.push(0);
            }

            a = typelist.findIndex(f => f.key == "外观设计");
            if (a > -1) {
              wglist.push(typelist[a].doc_count);
            }
            else {
              wglist.push(0);
            }
          }
        }

        var yvalues = [{ patenttype: "外观设计专利", data: wglist }, { patenttype: "发明申请专利", data: fmlist },
        { patenttype: "实用新型专利", data: xxlist }];
        var echartvalues = { x: comarray, y: yvalues };
        var datavalues = [];
        var lablist = await this.getrowdata("外观设计专利", wglist);
        datavalues.push(lablist);
        lablist = await this.getrowdata("发明申请专利", fmlist);
        datavalues.push(lablist);
        lablist = await this.getrowdata("实用新型专利", xxlist);
        datavalues.push(lablist);

        var tablevalues = { company: comarray, data: datavalues };
        return { echart: echartvalues, table: tablevalues };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }

  };

  async applierPatentStatus(obj) {//申请人分析-申请人专利法律效力
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = await this.GsbByChinaAggApi.AppPubstatusAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.group_by_appl.buckets) {
            cbuckets = tms.buckets.group_by_appl.buckets;
          }

        }
      }

      if (cbuckets.length > 0) {
        var comarray = [];
        var wxlist = [];
        var yxlist = [];
        var zslist = [];
        var maxarray = [];
        for (var cb in cbuckets) {
          comarray.push(cbuckets[cb].key);
          var statuslist = cbuckets[cb].group_by_pubstatus.buckets;
          if (statuslist.length > 0) {
            var a = statuslist.findIndex(f => f.key == "无效");
            if (a > -1) {
              wxlist.push(statuslist[a].doc_count);
              maxarray.push(statuslist[a].doc_count);
            }
            else {
              wxlist.push(0);
            }

            a = statuslist.findIndex(f => f.key == "有效");
            if (a > -1) {
              yxlist.push(statuslist[a].doc_count);
              maxarray.push(statuslist[a].doc_count);
            }
            else {
              yxlist.push(0);
            }

            a = statuslist.findIndex(f => f.key == "在审");
            if (a > -1) {
              zslist.push(statuslist[a].doc_count);
              maxarray.push(statuslist[a].doc_count);
            }
            else {
              zslist.push(0);
            }
          }
        }

        var yarray = [];
        for (var i = 0; i < comarray.length; i++) {
          var tarry1 = [i, 0, wxlist[i]];
          var tarry2 = [i, 1, yxlist[i]];
          var tarry3 = [i, 2, zslist[i]];
          yarray.push(tarry1);
          yarray.push(tarry2);
          yarray.push(tarry3);


        }

        var yvalues = [{ patenttype: "无效", data: wxlist }, { patenttype: "有效", data: yxlist },
        { patenttype: "在审", data: zslist }];
        var maxvalues = Math.max.apply(null, maxarray);
        var echartvalues = { x: comarray, y1: yvalues, y2: yarray, max: maxvalues };
        var datavalues = [];
        var lablist = await this.getrowdata("无效", wxlist);
        datavalues.push(lablist);
        lablist = await this.getrowdata("有效", yxlist);
        datavalues.push(lablist);
        lablist = await this.getrowdata("在审", zslist);
        datavalues.push(lablist);

        var tablevalues = { company: comarray, data: datavalues };
        return { echart: echartvalues, table: tablevalues };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }



  };

  async applierTrend(obj) {//申请人分析-申请人申请趋势分析
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    var wapilist = rearray[1];
    if (capilist.length > 0 || wapilist.length > 0) {
      var yeararray = [];
      var yearbuckets = [];
      var apparray = [];
      var tms = await this.GsbByChinaAggApi.filingyearAggs(yeararray);
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            yearbuckets = tms.buckets.types.buckets;
          }
        }
      }


      if (yearbuckets.length > 0) {
        var arrlen = 10;
        if (yearbuckets.length < 10) {
          arrlen = yearbuckets.length;
        }
        for (var i = 0; i < arrlen; i++) {
          yeararray.push(yearbuckets[i].key);
        }
        yeararray.reverse();

        var parm = null;
        if (capilist.length > 0) {
          parm = {
            "terms": {
              "filing_year": yeararray
            }
          }
          capilist.push(parm);
          tms = await this.GsbByChinaAggApi.ApplicantAggs(capilist);//获取查询结果
          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                cbuckets = tms.buckets.types.buckets;
              }

            }
          }
        }

        if (wapilist.length > 0) {
          parm = {
            "terms": {
              "app_year": yeararray
            }
          }
          wapilist.push(parm);
          tms = await this.GsbByWorldAggApi.ApplicantAggs(wapilist);
          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                wbuckets = tms.buckets.types.buckets;
              }
            }
          }
        }

        var newarray = await this.Arrayobjoper(cbuckets, wbuckets);
        if (newarray.length > 0) {
          var arraylen = 10;
          if (newarray.length < 10) {
            arraylen = newarray.length;
          }

          for (var i = 0; i < arraylen; i++) {
            apparray.push(newarray[i].key);
          }

          parm = {
            "terms": {
              "applicant_name.raw": apparray
            }
          }

          if (capilist.length > 0) {
            capilist.push(parm);
            tms = await this.GsbByChinaAggApi.AppfilingyearAggs(capilist);//获取查询结果
            if (tms) {
              if (tms.status == 0) {
                if (tms.buckets.group_by_appl.buckets) {
                  cbuckets = tms.buckets.group_by_appl.buckets;
                }

              }
            }

          }

          if (wapilist.length > 0) {
            wapilist.push(parm);
            tms = await this.GsbByWorldAggApi.AppfilingyearAggs(wapilist);
            if (tms) {
              if (tms.status == 0) {
                if (tms.buckets.group_by_appl.buckets) {
                  wbuckets = tms.buckets.group_by_appl.buckets;
                }
              }
            }
          }

          if (cbuckets.length > 0 || wbuckets.length > 0) {
            var Ainfo = new Array();//定义信息数组，并初始化为0
            for (var i = 0; i < apparray.length; i++) {
              Ainfo[i] = new Array();
              for (var j = 0; j < yeararray.length; j++) {
                Ainfo[i][j] = 0;
              }
            }

            //去聚合结果取数据
            if (cbuckets.length > 0) {
              for (var cb in cbuckets) {
                var a = apparray.indexOf(cbuckets[cb].key);
                if (a > -1) {
                  var yearbuckets = cbuckets[cb].group_by_filingyear.buckets;
                  for (var yearb in yearbuckets) {
                    var b = yeararray.indexOf(yearbuckets[yearb].key);
                    if (b > -1) {
                      Ainfo[a][b] = yearbuckets[yearb].doc_count;
                    }
                  }
                }
              }
            }

            if (wbuckets.length > 0) {
              for (var cb in wbuckets) {
                var a = apparray.indexOf(wbuckets[cb].key);
                if (a > -1) {
                  var yearbuckets = wbuckets[cb].group_by_filingyear.buckets;
                  for (var yearb in yearbuckets) {
                    var b = yeararray.indexOf(yearbuckets[yearb].key);
                    if (b > -1) {
                      Ainfo[a][b] = Ainfo[a][b] + yearbuckets[yearb].doc_count;
                    }
                  }
                }
              }
            }

            //拼返回结果
            var echarty = [];
            var maxarray = [];
            var tablearray = [];
            var yarray2 = [];
            for (var i = 0; i < apparray.length; i++) {
              var comname = apparray[i];
              var applist = [];
              for (var j = 0; j < yeararray.length; j++) {
                var tarry = [i, j, Ainfo[i][j]];
                yarray2.push(tarry);
                applist.push(Ainfo[i][j]);
                maxarray.push(Ainfo[i][j]);
              }
              echarty.push({ company: comname, data: applist });
              var lablist = await this.getrowdata(comname, applist);
              tablearray.push(lablist);
            }
            var maxvalues = Math.max.apply(null, maxarray);
            var echarts = { x: yeararray, legend: apparray, y1: echarty, y2: yarray2, max: maxvalues };
            var tablevalues = { year: yeararray, data: tablearray };
            return { echart: echarts, table: tablevalues };
          }
          else {
            return null;
          }
        }
        else {
          return null;
        }


      }
      else {
        return null;
      }
    }
    else {
      return null;
    }


  };

  async applierAuthRate(obj) {//申请人分析-申请人发明授权率
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "发明分析");
    var capilist = rearray[0];

    if (capilist.length > 0) {
      var apparray = [];
      var allarray = [];
      var sqarray = [];
      var wsqarray = [];
      var sqparray = [];
      var tms = await this.GsbByChinaAggApi.ApplicantAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length > 0) {
        var arrlen = 10;
        if (cbuckets.length < 10) {
          arrlen = cbuckets.length;
        }
        for (var i = 0; i < arrlen; i++) {
          apparray.push(cbuckets[i].key);
          allarray.push(cbuckets[i].doc_count);
        }

        var parm = {
          "terms": {
            "applicant_name.raw": apparray
          }
        }

        capilist.push(parm);

        tms = await this.GsbByChinaAggApi.AppfmsqAggs(capilist);//获取查询结果
        if (tms) {
          if (tms.status == 0) {
            if (tms.buckets.types.buckets) {
              cbuckets = tms.buckets.types.buckets;
            }

          }
        }

        for (var i = 0; i < apparray.length; i++) {
          sqarray[i] = 0;
          wsqarray[i] = 0;
          sqparray[i] = 0;
        }

        if (cbuckets.length > 0) {
          for (var cb in cbuckets) {
            var b = apparray.indexOf(cbuckets[cb].key);
            if (b > -1) {
              sqarray[b] = cbuckets[cb].doc_count;
            }
          }

          for (var i = 0; i < apparray.length; i++) {
            wsqarray[i] = allarray[i] - sqarray[i];
            var sqp = await this.getpercent(sqarray[i], allarray[i]);
            sqparray[i] = parseFloat(sqp.replace("%", ""));
          }

          //拼返回结果
          var echarty = [];
          var tablearray = [];

          var yarray = [{ patenttype: "未授权", data: wsqarray }, { patenttype: "曾授权", data: sqarray },
          { patenttype: "授权率", data: sqparray }];
          var echarts = { x: apparray, y: yarray };


          var lablist1 = await this.getrowdata("未授权", wsqarray);
          var lablist2 = await this.getrowdata("曾授权", sqarray);
          var lablist3 = await this.getrowdata("授权率", sqparray);
          var dataarray = [lablist1, lablist2, lablist3];
          var tablevalues = { company: apparray, data: dataarray };

          return { echart: echarts, table: tablevalues };
        }
        else {
          return null;
        }

      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async inventorRank(obj) {//发明人分析-发明人排名
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1) {
      total = parseInt(total1);
    }
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    var wapilist = rearray[1];

    if (capilist.length > 0) {
      var tms = await this.GsbByChinaAggApi.InventorAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }

        }
      }
    }

    if (wapilist.length > 0) {
      var tms = await this.GsbByWorldAggApi.InventorAggs(wapilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            wbuckets = tms.buckets.types.buckets;
          }
        }
      }
    }

    if (cbuckets.length > 0 || wbuckets.length > 0) {
      var newarray = await this.Arrayobjoper(cbuckets, wbuckets);
      if (newarray.length > 0) {
        var arraylen = 20;
        if (newarray.length < 20) {
          arraylen = newarray.length;
        }
        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var namearrary = [];
        var countarray = [];
        var echarttable = [];
        var descstr = "";
        if (arraylen >= 3) {
          for (var i = 0; i < arraylen; i++) {
            if (i == 0) {
              firstname = newarray[i].key;
              firstcount = newarray[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
            }
            else if (i == 1) {
              sceondname = newarray[i].key;
              sceondcount = newarray[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
            }
            else if (i == 2) {
              thirdname = newarray[i].key;
              thirdcount = newarray[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
            }
            namearrary.push(newarray[i].key);
            countarray.push(newarray[i].doc_count);
            echarttable.push({ rank: i + 1, inventor: newarray[i].key, patent: newarray[i].doc_count });
          }

          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三个发明人申请的数量最多，分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (arraylen == 2) {
          firstname = newarray[0].key;
          firstcount = newarray[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          sceondname = newarray[1].key;
          sceondcount = newarray[1].doc_count;
          sceondpercent = await this.getpercent(sceondcount, total);
          namearrary.push(newarray[0].key);
          countarray.push(newarray[0].doc_count);
          echarttable.push({ rank: 1, inventor: newarray[0].key, patent: newarray[0].doc_count });
          namearrary.push(newarray[1].key);
          countarray.push(newarray[1].doc_count);
          echarttable.push({ rank: 2, inventor: newarray[1].key, patent: newarray[1].doc_count });
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两个发明人申请的数量最多，分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";

        }
        else {
          firstname = newarray[0].key;
          firstcount = newarray[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          namearrary.push(newarray[0].key);
          countarray.push(newarray[0].doc_count);
          echarttable.push({ rank: 1, inventor: newarray[0].key, patent: newarray[0].doc_count });
          descstr = "从以上图表可以看出，" + firstname + " 这一个发明人申请的数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
        }
        return { echart: { x: namearrary, y: countarray, desc: descstr }, table: echarttable };

      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async mainInventorIpc(obj) {//发明人分析-主要发明人技术构成
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "ipc");
    var ipctab = obj.ipcTab;
    var capilist = rearray[0];
    var wapilist = rearray[1];

    var tms = null;
    //先进行发明人聚合
    if (capilist.length > 0) {
      tms = await this.GsbByChinaAggApi.InventorAggs(capilist);
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }

        }
      }
    }

    if (wapilist.length > 0) {
      tms = await this.GsbByWorldAggApi.InventorAggs(wapilist);
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            wbuckets = tms.buckets.types.buckets;
          }
        }
      }
    }

    var apparray = [];//前十发明人
    var newarray = await this.Arrayobjoper(cbuckets, wbuckets);
    if (newarray.length > 0) {
      var arraylen = 10;
      if (newarray.length < 10) {
        arraylen = newarray.length;
      }

      for (var i = 0; i < arraylen; i++) {
        apparray.push(newarray[i].key);
      }

      var parm = {
        "terms": {
          "inventor_name.raw": apparray
        }
      }

      //执行IPC聚合
      cbuckets = [];
      wbuckets = [];
      newarray = [];
      if (capilist.length > 0) {
        capilist.push(parm);
        tms = await this.GsbByChinaAggApi.AppIpcAggs(capilist);
        if (tms) {
          if (tms.status == 0) {
            if (tms.buckets.types.buckets) {
              cbuckets = tms.buckets.types.buckets;
            }

          }
        }
      }

      if (wapilist.length > 0) {
        wapilist.push(parm);
        tms = await this.GsbByWorldAggApi.AppIpcAggs(wapilist);
        if (tms) {
          if (tms.status == 0) {
            if (tms.buckets.types.buckets) {
              wbuckets = tms.buckets.types.buckets;
            }

          }
        }
      }

      var ipcarray = [];//前十IPC
      newarray = await this.Arrayobjoper(cbuckets, wbuckets);
      if (newarray.length > 0) {
        var arraylen = 10;
        if (newarray.length < 10) {
          arraylen = newarray.length;
        }
        for (var i = 0; i < arraylen; i++) {
          ipcarray.push(newarray[i].key);
        }

        parm = {
          "terms": {
            "main_ipc": ipcarray
          }
        }
        //执行申请人IPC聚合
        cbuckets = [];
        wbuckets = [];
        newarray = [];
        if (capilist.length > 0) {
          capilist.push(parm);
          tms = await this.GsbByChinaAggApi.InvIpcMutiAggs(capilist);
          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.group_by_inv.buckets) {
                cbuckets = tms.buckets.group_by_inv.buckets;
              }

            }
          }
        }

        if (wapilist.length > 0) {
          wapilist.push(parm);
          tms = await this.GsbByWorldAggApi.InvIpcMutiAggs(wapilist);
          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.group_by_inv.buckets) {
                wbuckets = tms.buckets.group_by_inv.buckets;
              }

            }
          }

        }

        if (cbuckets.length > 0 || wbuckets.length > 0) {
          var Aipcinfo = new Array();//定义信息数组，并初始化为0
          for (var i = 0; i < apparray.length; i++) {
            Aipcinfo[i] = new Array();
            for (var j = 0; j < ipcarray.length; j++) {
              Aipcinfo[i][j] = 0;
            }
          }

          //去聚合结果取数据
          if (cbuckets.length > 0) {
            for (var cb in cbuckets) {
              var a = apparray.indexOf(cbuckets[cb].key);
              if (a > -1) {
                var ipcbuckets = cbuckets[cb].group_by_ipc.buckets;
                for (var ipcb in ipcbuckets) {
                  var b = ipcarray.indexOf(ipcbuckets[ipcb].key);
                  if (b > -1) {
                    Aipcinfo[a][b] = ipcbuckets[ipcb].doc_count;
                  }
                }
              }
            }
          }

          if (wbuckets.length > 0) {
            for (var cb in wbuckets) {
              var a = apparray.indexOf(wbuckets[cb].key);
              if (a > -1) {
                var ipcbuckets = wbuckets[cb].group_by_ipc.buckets;
                for (var ipcb in ipcbuckets) {
                  var b = ipcarray.indexOf(ipcbuckets[ipcb].key);
                  if (b > -1) {
                    Aipcinfo[a][b] = Aipcinfo[a][b] + ipcbuckets[ipcb].doc_count;
                  }
                }
              }
            }
          }

          //拼返回结果
          var echarty = [];
          var amaxcount = [];
          var atable = [];
          for (var i = 0; i < ipcarray.length; i++) {
            var ipcname = ipcarray[i];
            var ipc1list = [];
            for (var j = 0; j < apparray.length; j++) {
              ipc1list.push(Aipcinfo[j][i]);
              amaxcount.push(Aipcinfo[j][i]);
            }
            var lablist = await this.getrowdata(ipcname, ipc1list);
            atable.push(lablist);
            echarty.push({ ipc: ipcname, data: ipc1list });
          }
          var yarray = [];
          for (var i = 0; i < apparray.length; i++) {
            for (var j = 0; j < ipcarray.length; j++) {
              var tarray = [i, j, Aipcinfo[i][j]];
              yarray.push(tarray);
            }
          }

          var maxcount = Math.max.apply(null, amaxcount);
          var echarts = { x: apparray, legend: ipcarray, y1: echarty, y2: yarray, max: maxcount };
          var tablevalues = { inventor: apparray, data: atable };

          return { echart: echarts, table: tablevalues };

        }
        else {
          return null;
        }

      }
      else {
        return null;
      }
    }
    else {
      return null;
    }

  };

  async mainInventorPatenttype(obj) {//发明人分析-主要发明人专利类型分布
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = await this.GsbByChinaAggApi.InvPubtypeAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.group_by_inv.buckets) {
            cbuckets = tms.buckets.group_by_inv.buckets;
          }

        }
      }

      if (cbuckets.length > 0) {
        var comarray = [];
        var fmlist = [];
        var xxlist = [];
        var wglist = [];
        for (var cb in cbuckets) {
          comarray.push(cbuckets[cb].key);
          var typelist = cbuckets[cb].group_by_pubtype.buckets;
          if (typelist.length > 0) {
            var a = typelist.findIndex(f => f.key == "发明");
            if (a > -1) {
              fmlist.push(typelist[a].doc_count);
            }
            else {
              fmlist.push(0);
            }

            a = typelist.findIndex(f => f.key == "实用新型");
            if (a > -1) {
              xxlist.push(typelist[a].doc_count);
            }
            else {
              xxlist.push(0);
            }

            a = typelist.findIndex(f => f.key == "外观设计");
            if (a > -1) {
              wglist.push(typelist[a].doc_count);
            }
            else {
              wglist.push(0);
            }
          }
        }

        var yvalues = [{ patenttype: "外观设计专利", data: wglist }, { patenttype: "发明申请专利", data: fmlist },
        { patenttype: "实用新型专利", data: xxlist }];
        var echartvalues = { x: comarray, y: yvalues };
        var datavalues = [];
        var lablist = await this.getrowdata("外观设计专利", wglist);
        datavalues.push(lablist);
        lablist = await this.getrowdata("发明申请专利", fmlist);
        datavalues.push(lablist);
        lablist = await this.getrowdata("实用新型专利", xxlist);
        datavalues.push(lablist);

        var tablevalues = { inventor: comarray, data: datavalues };
        return { echart: echartvalues, table: tablevalues };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }

  };

  async mainInventorPatentstatus(obj) {//发明人分析-主要发明人专利法律效力
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = await this.GsbByChinaAggApi.InvPubstatusAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.group_by_inv.buckets) {
            cbuckets = tms.buckets.group_by_inv.buckets;
          }

        }
      }

      if (cbuckets.length > 0) {
        var comarray = [];
        var wxlist = [];
        var yxlist = [];
        var zslist = [];
        for (var cb in cbuckets) {
          comarray.push(cbuckets[cb].key);
          var statuslist = cbuckets[cb].group_by_pubstatus.buckets;
          if (statuslist.length > 0) {
            var a = statuslist.findIndex(f => f.key == "无效");
            if (a > -1) {
              wxlist.push(statuslist[a].doc_count);
            }
            else {
              wxlist.push(0);
            }

            a = statuslist.findIndex(f => f.key == "有效");
            if (a > -1) {
              yxlist.push(statuslist[a].doc_count);
            }
            else {
              yxlist.push(0);
            }

            a = statuslist.findIndex(f => f.key == "在审");
            if (a > -1) {
              zslist.push(statuslist[a].doc_count);
            }
            else {
              zslist.push(0);
            }
          }
        }

        var yvalues = [{ patenttype: "无效", data: wxlist }, { patenttype: "有效", data: yxlist },
        { patenttype: "在审", data: zslist }];
        var echartvalues = { x: comarray, y: yvalues };
        var datavalues = [];
        var lablist = await this.getrowdata("无效", wxlist);
        datavalues.push(lablist);
        lablist = await this.getrowdata("有效", yxlist);
        datavalues.push(lablist);
        lablist = await this.getrowdata("在审", zslist);
        datavalues.push(lablist);

        var tablevalues = { inventor: comarray, data: datavalues };
        return { echart: echartvalues, table: tablevalues };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }

  };

  async mainInventorApplyTrend(obj) {//发明人分析-主要发明人申请趋势
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    var wapilist = rearray[1];
    if (capilist.length > 0 || wapilist.length > 0) {
      var yeararray = [];
      var yearbuckets = [];
      var apparray = [];
      var tms = await this.GsbByChinaAggApi.filingyearAggs(yeararray);
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            yearbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (yearbuckets.length > 0) {
        var arrlen = 10;
        if (yearbuckets.length < 10) {
          arrlen = yearbuckets.length;
        }
        for (var i = 0; i < arrlen; i++) {
          yeararray.push(yearbuckets[i].key);
        }
        yeararray.reverse();
        var parm = null;

        if (capilist.length > 0) {
          parm = {
            "terms": {
              "filing_year": yeararray
            }
          }
          capilist.push(parm);
          tms = await this.GsbByChinaAggApi.InventorAggs(capilist);//获取查询结果
          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                cbuckets = tms.buckets.types.buckets;
              }

            }
          }
        }

        if (wapilist.length > 0) {
          parm = {
            "terms": {
              "app_year": yeararray
            }
          }
          wapilist.push(parm);
          tms = await this.GsbByWorldAggApi.InventorAggs(wapilist);
          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                wbuckets = tms.buckets.types.buckets;
              }
            }
          }
        }

        var newarray = await this.Arrayobjoper(cbuckets, wbuckets);
        if (newarray.length > 0) {
          cbuckets = [];
          wbuckets = [];
          var arraylen = 10;
          if (newarray.length < 10) {
            arraylen = newarray.length;
          }

          for (var i = 0; i < arraylen; i++) {
            apparray.push(newarray[i].key);
          }

          parm = {
            "terms": {
              "inventor_name.raw": apparray
            }
          }

          if (capilist.length > 0) {
            capilist.push(parm);
            tms = await this.GsbByChinaAggApi.InvfilingyearAggs(capilist);//获取查询结果
            if (tms) {
              if (tms.status == 0) {
                if (tms.buckets.group_by_inv.buckets) {
                  cbuckets = tms.buckets.group_by_inv.buckets;
                }

              }
            }

          }

          if (wapilist.length > 0) {
            wapilist.push(parm);
            tms = await this.GsbByWorldAggApi.InvfilingyearAggs(wapilist);
            if (tms) {
              if (tms.status == 0) {
                if (tms.buckets.group_by_inv.buckets) {
                  wbuckets = tms.buckets.group_by_inv.buckets;
                }
              }
            }
          }

          if (cbuckets.length > 0 || wbuckets.length > 0) {
            var Ainfo = new Array();//定义信息数组，并初始化为0
            for (var i = 0; i < apparray.length; i++) {
              Ainfo[i] = new Array();
              for (var j = 0; j < yeararray.length; j++) {
                Ainfo[i][j] = 0;
              }
            }

            //去聚合结果取数据
            if (cbuckets.length > 0) {
              for (var cb in cbuckets) {
                var a = apparray.indexOf(cbuckets[cb].key);
                if (a > -1) {
                  var yearbuckets = cbuckets[cb].group_by_filingyear.buckets;
                  for (var yearb in yearbuckets) {
                    var b = yeararray.indexOf(yearbuckets[yearb].key);
                    if (b > -1) {
                      Ainfo[a][b] = yearbuckets[yearb].doc_count;
                    }
                  }
                }
              }
            }

            if (wbuckets.length > 0) {
              for (var cb in wbuckets) {
                var a = apparray.indexOf(wbuckets[cb].key);
                if (a > -1) {
                  var yearbuckets = wbuckets[cb].group_by_filingyear.buckets;
                  for (var yearb in yearbuckets) {
                    var b = yeararray.indexOf(yearbuckets[yearb].key);
                    if (b > -1) {
                      Ainfo[a][b] = Ainfo[a][b] + yearbuckets[yearb].doc_count;
                    }
                  }
                }
              }
            }

            //拼返回结果
            var echarty = [];
            var tablearray = [];
            for (var i = 0; i < apparray.length; i++) {
              var comname = apparray[i];
              var applist = [];
              for (var j = 0; j < yeararray.length; j++) {
                applist.push(Ainfo[i][j]);
              }
              echarty.push({ inventor: comname, data: applist });
              var lablist = await this.getrowdata(comname, applist);
              tablearray.push(lablist);
            }
            var echarts = { x: yeararray, legend: apparray, y: echarty };
            var tablevalues = { year: yeararray, data: tablearray };
            return { echart: echarts, table: tablevalues };

          }
          else {
            return null;
          }

        }
        else {
          return null;
        }
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async mainInventorPublicTrend(obj) {//发明人分析-主要发明人公开趋势
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    var wapilist = rearray[1];
    if (capilist.length > 0 || wapilist.length > 0) {
      var yeararray = [];
      var yearbuckets = [];
      var apparray = [];
      var tms = await this.GsbByChinaAggApi.pubyearAggs(yeararray);
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            yearbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (yearbuckets.length > 0) {
        var arrlen = 10;
        if (yearbuckets.length < 10) {
          arrlen = yearbuckets.length;
        }
        for (var i = 0; i < arrlen; i++) {
          yeararray.push(yearbuckets[i].key);
        }
        yeararray.reverse();
        var parm = {
          "terms": {
            "pub_year": yeararray
          }
        }

        if (capilist.length > 0) {
          capilist.push(parm);
          tms = await this.GsbByChinaAggApi.InventorAggs(capilist);//获取查询结果
          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                cbuckets = tms.buckets.types.buckets;
              }

            }
          }
        }

        if (wapilist.length > 0) {
          wapilist.push(parm);
          tms = await this.GsbByWorldAggApi.InventorAggs(wapilist);
          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                wbuckets = tms.buckets.types.buckets;
              }
            }
          }
        }

        var newarray = await this.Arrayobjoper(cbuckets, wbuckets);
        if (newarray.length > 0) {
          cbuckets = [];
          wbuckets = [];
          var arraylen = 10;
          if (newarray.length < 10) {
            arraylen = newarray.length;
          }

          for (var i = 0; i < arraylen; i++) {
            apparray.push(newarray[i].key);
          }

          parm = {
            "terms": {
              "inventor_name.raw": apparray
            }
          }

          if (capilist.length > 0) {
            capilist.push(parm);
            tms = await this.GsbByChinaAggApi.InvPubyearAggs(capilist);//获取查询结果
            if (tms) {
              if (tms.status == 0) {
                if (tms.buckets.group_by_inv.buckets) {
                  cbuckets = tms.buckets.group_by_inv.buckets;
                }

              }
            }

          }

          if (wapilist.length > 0) {
            wapilist.push(parm);
            tms = await this.GsbByWorldAggApi.InvPubyearAggs(wapilist);
            if (tms) {
              if (tms.status == 0) {
                if (tms.buckets.group_by_inv.buckets) {
                  wbuckets = tms.buckets.group_by_inv.buckets;
                }
              }
            }
          }

          if (cbuckets.length > 0 || wbuckets.length > 0) {
            var Ainfo = new Array();//定义信息数组，并初始化为0
            for (var i = 0; i < apparray.length; i++) {
              Ainfo[i] = new Array();
              for (var j = 0; j < yeararray.length; j++) {
                Ainfo[i][j] = 0;
              }
            }

            //去聚合结果取数据
            if (cbuckets.length > 0) {
              for (var cb in cbuckets) {
                var a = apparray.indexOf(cbuckets[cb].key);
                if (a > -1) {
                  var yearbuckets = cbuckets[cb].group_by_pubyear.buckets;
                  for (var yearb in yearbuckets) {
                    var b = yeararray.indexOf(yearbuckets[yearb].key);
                    if (b > -1) {
                      Ainfo[a][b] = yearbuckets[yearb].doc_count;
                    }
                  }
                }
              }
            }

            if (wbuckets.length > 0) {
              for (var cb in wbuckets) {
                var a = apparray.indexOf(wbuckets[cb].key);
                if (a > -1) {
                  var yearbuckets = wbuckets[cb].group_by_pubyear.buckets;
                  for (var yearb in yearbuckets) {
                    var b = yeararray.indexOf(yearbuckets[yearb].key);
                    if (b > -1) {
                      Ainfo[a][b] = Ainfo[a][b] + yearbuckets[yearb].doc_count;
                    }
                  }
                }
              }
            }

            //拼返回结果
            var echarty = [];
            var tablearray = [];
            for (var i = 0; i < apparray.length; i++) {
              var comname = apparray[i];
              var applist = [];
              for (var j = 0; j < yeararray.length; j++) {
                applist.push(Ainfo[i][j]);
              }
              echarty.push({ inventor: comname, data: applist });
              var lablist = await this.getrowdata(comname, applist);
              tablearray.push(lablist);
            }
            var echarts = { x: yeararray, legend: apparray, y: echarty };
            var tablevalues = { year: yeararray, data: tablearray };
            return { echart: echarts, table: tablevalues };

          }
          else {
            return null;
          }
        }
        else {
          return null;
        }
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async countrywidePatnet(obj) {//*区域分析-全国专利分布
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    var wapilist = rearray[1];
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1){
      total = parseInt(total1);
    }
    var tms = null;
    if (capilist.length > 0) {
      tms = await this.GsbByChinaAggApi.ProvinceAggs(capilist);
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }

        }
      }


      if (cbuckets.length > 0) {
        var Aprovince = [];
        var Ay1 = [];
        var Ay2 = [];
        var maxvalues = 0;
        var Atable = [];
        var chinatotal = 0;
        var province3 = [];
        var pcount3 = [];
        var percent3 = [];
        var descvalue = "在所分析的专利中，中国专利申请了";
        maxvalues = cbuckets[0].doc_count;
        for (var i = 0; i < cbuckets.length; i++) {
          var province = await this.getprovincename(cbuckets[i].key);
          chinatotal += cbuckets[i].doc_count;
          Ay1.push({ name: province, value: cbuckets[i].doc_count });
          if (i < 20) {
            Aprovince.push(cbuckets[i].key);
            Ay2.push(cbuckets[i].doc_count);
            Atable.push({ rank: i + 1, city: cbuckets[i].key, patent: cbuckets[i].doc_count });
          }

          if (i < 3) {
            province3.push(cbuckets[i].key);
            pcount3.push(cbuckets[i].doc_count);
            var perc = await this.getpercent(cbuckets[i].doc_count, total);
            percent3.push(perc);

          }
        }
        var tperc = await this.getpercent(chinatotal, total);
        descvalue = descvalue + chinatotal + "件,占所分析专利总量的" + tperc + "。";
        descvalue = descvalue + "从以上图表可以看出，在";
        for (var i = 0; i < province3.length; i++) {
          descvalue = descvalue + province3[i];
          if (i < province3.length - 1) {
            descvalue = descvalue + "、";
          }
        }

        descvalue = descvalue + "这" + province3.length + "个省市的申请人申请的公开的中国专利数量最多，分别为";
        for (var i = 0; i < pcount3.length; i++) {
          descvalue = descvalue + pcount3[i] + "件";
          if (i < pcount3.length - 1) {
            descvalue = descvalue + "、";
          }
        }
        descvalue = descvalue + "，占多分析专利总量的";
        for (var i = 0; i < percent3.length; i++) {
          descvalue = descvalue + percent3[i];
          if (i < percent3.length - 1) {
            descvalue = descvalue + "、";
          }
        }
        descvalue = descvalue + "。";
        var echartvalues = { max: maxvalues, desc: descvalue, x: Aprovince, y1: Ay1, y2: Ay2 };
        return { echart: echartvalues, table: Atable };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    };
  };

  async everyCountryPatent(obj) {//区域分析-各国专利分布
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    var wapilist = rearray[1];
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1){
      total = parseInt(total1);
    }
    if (capilist.length > 0 || wapilist.length > 0) {
      var tms = null;
      if (capilist.length > 0) {
        tms = await this.GsbByChinaAggApi.ApplicantAggs(capilist);
        if (tms) {
          if (tms.status == 0) {
            cbuckets.push({ "key": "中国", "doc_count": tms.data.total })
          }
        }
      }

      if (wapilist.length > 0) {
        tms = await this.GsbByWorldAggApi.CountryAggs(wapilist);
        if (tms) {
          if (tms.status == 0) {
            if (tms.buckets.types.buckets) {
              wbuckets = tms.buckets.types.buckets;
            }
          }
        }
      }

      var newarray = await this.Arrayobjoper(cbuckets, wbuckets);
      if (newarray.length > 0) {
        var arraylen = 20;
        if (newarray.length < 20) {
          arraylen = newarray.length;
        }

        //pinfanhuijieguo
        var descvalue = "从以上图表可以看出，";
        var Acountry = [];
        var Ay1 = [];
        var Ay2 = [];
        var maxvalues = 0;
        var Atable = [];
        maxvalues = newarray[0].doc_count;
        for (var i = 0; i < arraylen; i++) {
          var countryname = null;
          if (newarray[i].key == "中国") {
            countryname = newarray[i].key;
          }
          else {
            countryname = await this.praseworldname(newarray[i].key);
          }

          if (countryname) {
            var countrynmen = await this.getcountryen(countryname);
            Acountry.push(countryname);
            Ay2.push(newarray[i].doc_count);
            Ay1.push({ name: countrynmen, value: newarray[i].doc_count });
            Atable.push({ rank: i + 1, country: countryname, patent: newarray[i].doc_count });
          }
        }

        if (Acountry.length == 1) {
          var per = await this.getpercent(Ay2[0], total);
          descvalue = descvalue + Acountry[0] + "这个国家/地区公开的专利数量最多，为";
          descvalue = descvalue + Ay2[0] + "件，占所分析专利的" + per + "。";
        }
        else if (Acountry.length == 2) {
          var per1 = await this.getpercent(Ay2[0], total);
          var per2 = await this.getpercent(Ay2[1], total);
          descvalue = descvalue + Acountry[0] + "、" + Acountry[1] + "这两个国家/地区公开的专利数量最多，分别为";
          descvalue = descvalue + Ay2[0] + "件、" + Ay2[1] + "件，占所分析专利的" + per1 + "、" + per2 + "。";

        }
        else {
          var per1 = await this.getpercent(Ay2[0], total);
          var per2 = await this.getpercent(Ay2[1], total);
          var per3 = await this.getpercent(Ay2[3], total);
          descvalue = descvalue + Acountry[0] + "、" + Acountry[1] + "、" + Acountry[2] + "这三个国家/地区公开的专利数量最多，分别为";
          descvalue = descvalue + Ay2[0] + "件、" + Ay2[1] + "件、" + Ay2[2] + "件，占所分析专利的" + per1 + "、" + per2 + "、" + per3 + "。";
        }

        var echartvalues = { desc: descvalue, max: maxvalues, x: Acountry, y1: Ay1, y2: Ay2 };
        return { echart: echartvalues, table: Atable };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async foreignApplyInChina(obj) {//区域分析-外国在华申请分布
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    var wapilist = rearray[1];
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1){
      total = parseInt(total1);
    }
    var tms = null;
    if (capilist.length > 0) {
      tms = await this.GsbByChinaAggApi.ForeignCountryAggs(capilist);
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }

        }
      }

      if (cbuckets.length > 0) {
        //pinfanhuijieguo
        var descvalue = "在所分析专利中，外国申请人在华申请有";
        var Acountry = [];
        var Ay1 = [];
        var Ay2 = [];
        var maxvalues = 0;
        var Atable = [];
        var allcount = 0;
        maxvalues = cbuckets[0].doc_count;
        for (var i = 0; i < cbuckets.length; i++) {
          allcount += cbuckets[i].doc_count;
          Acountry.push(cbuckets[i].key);
          Ay2.push(cbuckets[i].doc_count);
          var conen = await this.getcountryen(cbuckets[i].key);
          Ay1.push({ name: conen, value: cbuckets[i].doc_count });
          Atable.push({ rank: i + 1, country: cbuckets[i].key, patent: cbuckets[i].doc_count });
        }

        var allper = await this.getpercent(allcount, total);
        descvalue = descvalue + allcount + "件，占所分析专利总量的" + allper + "，从以上图表可以看出，";
        if (Acountry.length == 1) {
          var per = await this.getpercent(Ay2[0], total);
          descvalue = descvalue + Acountry[0] + "这个国家/地区的申请人在华申请的的专利数量最多，为";
          descvalue = descvalue + Ay2[0] + "件，占所分析专利的" + per + "。";
        }
        else if (Acountry.length == 2) {
          var per1 = await this.getpercent(Ay2[0], total);
          var per2 = await this.getpercent(Ay2[1], total);
          descvalue = descvalue + Acountry[0] + "、" + Acountry[1] + "这两个国家/地区申请人在华申请的的专利数量最多，分别为";
          descvalue = descvalue + Ay2[0] + "件、" + Ay2[1] + "件，占所分析专利的" + per1 + "、" + per2 + "。";

        }
        else {
          var per1 = await this.getpercent(Ay2[0], total);
          var per2 = await this.getpercent(Ay2[1], total);
          var per3 = await this.getpercent(Ay2[3], total);
          descvalue = descvalue + Acountry[0] + "、" + Acountry[1] + "、" + Acountry[2] + "这三个国家/地区申请人在华申请的的专利数量最多，分别为";
          descvalue = descvalue + Ay2[0] + "件、" + Ay2[1] + "件、" + Ay2[2] + "件，占所分析专利的" + per1 + "、" + per2 + "、" + per3 + "。";
        }

        var echartvalues = { desc: descvalue, max: maxvalues, x: Acountry, y1: Ay1, y2: Ay2 };
        return { echart: echartvalues, table: Atable };
      }
      else {
        return null;
      }

    }
    else {
      return null;
    }


  };

  async mainCountryIpc(obj) {//区域分析-主要国家IPC分布
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1){
      total = parseInt(total1);
    }
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "ipc");
    var ipctab = obj.ipcTab;
    var capilist = rearray[0];
    var wapilist = rearray[1];
    if (capilist.length > 0 || wapilist.length > 0) {
      var tms = null;
      //先进行国家聚合
      if (capilist.length > 0) {
        tms = await this.GsbByChinaAggApi.ApplicantAggs(capilist);
        if (tms) {
          if (tms.status == 0) {
            cbuckets.push({ "key": "中国", "doc_count": tms.data.total });
          }
        }
      }

      if (wapilist.length > 0) {
        tms = await this.GsbByWorldAggApi.CountryAggs(wapilist);
        if (tms) {
          if (tms.status == 0) {
            if (tms.buckets.types.buckets) {
              wbuckets = tms.buckets.types.buckets;
            }
          }
        }
      }

      if (cbuckets.length > 0 || wbuckets.length > 0) {
        var apparray = [];//前十国家
        if (cbuckets.length >0){
          apparray.push("中国");
          var arraylen = 10;
          if (wbuckets.length > 0) {
            if (wbuckets.length < 9){
              arraylen = wbuckets.length;
            }
            for (var i = 0; i < arraylen-1; i++) {
              apparray.push(wbuckets[i].key);
            }
          }
        }
        else{
          if (wbuckets.length > 0) {
            var arraylen = 10;
            if (wbuckets.length < 10){
              arraylen = wbuckets.length;
            } 
            for (var i = 0; i < arraylen; i++) {
              apparray.push(wbuckets[i].key);
            }
          }
        }
        var parm = {
          "terms": {
            "db_name": apparray
          }
        }

        if (capilist.length > 0) {
          if (ipctab == "0") {
            tms = await this.GsbByChinaAggApi.AppIpclcAggs(capilist);
          }
          else if (ipctab == "1") {
            tms = await this.GsbByChinaAggApi.AppIpcscAggs(capilist);
          }
          else if (ipctab == "2") {
            tms = await this.GsbByChinaAggApi.AppIpclgAggs(capilist);
          }
          else if (ipctab == "3") {
            tms = await this.GsbByChinaAggApi.AppIpcAggs(capilist);
          }

          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                cbuckets = tms.buckets.types.buckets;
              }

            }
          }
        }

        if (wapilist.length > 0) {
          wapilist.push(parm);
          if (ipctab == "0") {
            tms = await this.GsbByWorldAggApi.AppIpclcAggs(wapilist);
          }
          else if (ipctab == "1") {
            tms = await this.GsbByWorldAggApi.AppIpcscAggs(wapilist);
          }
          else if (ipctab == "2") {
            tms = await this.GsbByWorldAggApi.AppIpclgAggs(wapilist);
          }
          else if (ipctab == "3") {
            tms = await this.GsbByWorldAggApi.AppIpcAggs(wapilist);
          }

          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                wbuckets = tms.buckets.types.buckets;
              }

            }
          }
        }

        var ipcarray = [];//前十IPC
        var newarray = await this.Arrayobjoper(cbuckets, wbuckets);
        if (newarray.length > 0) {
          var arraylen = 10;
          if (newarray.length < 10) {
            arraylen = newarray.length;
          }
          for (var i = 0; i < arraylen; i++) {
            ipcarray.push(newarray[i].key);
          }
          var parm = null;
          if (ipctab == "0") {
            parm = {
              "terms": {
                "large class": ipcarray
              }
            }
          }
          else if (ipctab == "1") {
            parm = {
              "terms": {
                "sub_class": ipcarray
              }
            }
          }
          else if (ipctab == "2") {
            parm = {
              "terms": {
                "large_group": ipcarray
              }
            }
          }
          else if (ipctab == "3") {
            parm = {
              "terms": {
                "main_ipc": ipcarray
              }
            }

          }

          if (parm) {
            if (capilist.length > 0) {
              capilist.push(parm);
            }

            if (wapilist.length > 0) {
              wapilist.push(parm);
            }
          }

          //执行国家IPC聚合
          cbuckets = [];
          wbuckets = [];
          newarray = [];

          if (capilist.length > 0) {
            if (ipctab == "0") {
              tms = await this.GsbByChinaAggApi.AppIpclcAggs(capilist);
            }
            else if (ipctab == "1") {
              tms = await this.GsbByChinaAggApi.AppIpcscAggs(capilist);
            }
            else if (ipctab == "2") {
              tms = await this.GsbByChinaAggApi.AppIpclgAggs(capilist);
            }
            else if (ipctab == "3") {
              tms = await this.GsbByChinaAggApi.AppIpcAggs(capilist);
            }

            if (tms) {
              if (tms.status == 0) {
                if (tms.buckets.types.buckets) {
                  cbuckets = tms.buckets.types.buckets;
                }

              }
            }
          }

          if (wapilist.length > 0) {
            if (ipctab == "0") {
              tms = await this.GsbByWorldAggApi.CountryIpclcMutiAggs(wapilist);
            }
            else if (ipctab == "1") {
              tms = await this.GsbByWorldAggApi.CountryIpcscMutiAggs(wapilist);
            }
            else if (ipctab == "2") {
              tms = await this.GsbByWorldAggApi.CountryIpclgMutiAggs(wapilist);
            }
            else if (ipctab == "3") {
              tms = await this.GsbByWorldAggApi.CountryIpcMutiAggs(wapilist);
            }

            if (tms) {
              if (tms.status == 0) {
                if (tms.buckets.group_by_country.buckets) {
                  wbuckets = tms.buckets.group_by_country.buckets;
                }

              }
            }
          }

          if (cbuckets.length > 0 || wbuckets.length > 0) {
            var Aipcinfo = new Array();//定义信息数组，并初始化为0
            for (var i = 0; i < apparray.length; i++) {
              Aipcinfo[i] = new Array();
              for (var j = 0; j < ipcarray.length; j++) {
                Aipcinfo[i][j] = 0;
              }
            }

            //去聚合结果取数据
            if (cbuckets.length > 0) {
              for (var cb in cbuckets) {
                var a = apparray.indexOf("中国");
                if (a > -1) {
                  var ipcbuckets = cbuckets[cb];                 
                  var b = ipcarray.indexOf(ipcbuckets.key);
                  if (b > -1) {
                    Aipcinfo[a][b] = ipcbuckets.doc_count;
                  }
                  
                }
              }
            }

            if (wbuckets.length > 0) {
              for (var cb in wbuckets) {
                var a = apparray.indexOf(wbuckets[cb].key);
                if (a > -1) {
                  var ipcbuckets = wbuckets[cb].group_by_ipc.buckets;
                  for (var ipcb in ipcbuckets) {
                    var b = ipcarray.indexOf(ipcbuckets[ipcb].key);
                    if (b > -1) {
                      Aipcinfo[a][b] = Aipcinfo[a][b] + ipcbuckets[ipcb].doc_count;
                    }
                  }
                }
              }
            }

            //拼返回结果
            var echarty = [];
            var adata = [];
            var Acountry = [];
            for (var j = 0; j < apparray.length; j++) {
              if (apparray[j] == "中国") {
                Acountry[j] = "中国";
              }
              else {
                var country = await this.praseworldname(apparray[j]);
                Acountry.push(country);
              }
            }
            for (var i = 0; i < ipcarray.length; i++) {
              var ipcname = ipcarray[i];
              var ipc1list = [];
              for (var j = 0; j < apparray.length; j++) {
                ipc1list.push(Aipcinfo[j][i]);
              }
              echarty.push({ lable: ipcname, data: ipc1list });
              var lablist = await this.getrowdata(ipcname, ipc1list);
              adata.push(lablist);
            }
            var echarts = { legend: ipcarray, x: Acountry, y: echarty };
            var tablevalues = { country: Acountry, data: adata };
            return { echart: echarts, table: tablevalues };
          }
          else {
            return null;
          }


        }
        else {
          return null;
        }



      }
      else {
        return null;
      }
    }
    else {
      return null;
    }


  };

  async reportGeneration(obj){//导出报告
    var chose = obj.chose;
    var results = [];
    var rearray = null;
    for (var i=0;i<chose.length;i++){
      var chosename = chose[i].label;
      if (chosename == "申请人排名"){
        rearray = await this.applierRank(obj); 
      }
      else if (chosename == "申请人归属国分布"){
        rearray = await this.applierCity(obj);
      } 
      else if (chosename == "申请人IPC分布"){
        var params = { search: obj.search, ipcTab: "3", obj: obj.obj };
        var retemp = await this.applierIpc(params);
        if (retemp){
          var y1 = retemp.echart.y;
          var ylist = [];
          for (var j=0;j<y1.length;j++){
            ylist.push({lable:y1[j].ipc,data:y1[j].data});
          }
          var echarts = { x: retemp.echart.x, legend: retemp.echart.legend, y: ylist};
          rearray = { echart: echarts, table: retemp.table };
        }
      }
      else if (chosename == "申请人专利类型分布"){
        var retemp = await this.applierPatenttype(obj);
        if (retemp){
          var y1 = retemp.echart.y;
          var ylist = [];
          var legendlist = [];
          for (var j=0;j<y1.length;j++){
            ylist.push({lable:y1[j].patenttype,data:y1[j].data});
            legendlist.push(y1[j].patenttype);
          }
          var echarts = { x: retemp.echart.x, legend: legendlist, y: ylist};
          rearray = { echart: echarts, table: retemp.table };
        }
      }
      else if (chosename == "申请人专利法律效力"){
        rearray = await this.applierPatentStatus(obj);
      }
      else if (chosename == "申请人发明授权率"){
        var retemp = await this.applierAuthRate(obj);
        if (retemp){
          var y1 = retemp.echart.y;
          var ylist = [];
          var legendlist = [];
          for (var j=0;j<y1.length;j++){
            ylist.push({lable:y1[j].patenttype,data:y1[j].data});
            legendlist.push(y1[j].patenttype);
          }
          var echarts = { x: retemp.echart.x, legend: legendlist, y: ylist};
          rearray = { echart: echarts, table: retemp.table };
        }
      }
      else if (chosename == "申请人申请趋势分析"){
        var retemp = await this.applierTrend(obj);
        if (retemp){
          var y1 = retemp.echart.y1;
          var ylist = [];
          for (var j=0;j<y1.length;j++){
            ylist.push({lable:y1[j].company,data:y1[j].data});
          }
          var echarts = { x: retemp.echart.x, legend: retemp.echart.legend, y: ylist, y2: retemp.echart.y2, max: retemp.echart.max };
          rearray = { echart: echarts, table: retemp.table };
        }
      }
      else if (chosename == "发明人排名"){
        rearray = await this.inventorRank(obj);
      }
      else if (chosename == "主要发明人技术构成"){
        var retemp = await this.mainInventorIpc(obj);
        if (retemp){
          var y1 = retemp.echart.y1;
          var ylist = [];
          for (var j=0;j<y1.length;j++){
            ylist.push({lable:y1[j].ipc,data:y1[j].data});
          }
          var echarts = { x: retemp.echart.x, legend: retemp.echart.legend, y: ylist,y2:retemp.echart.y2, max:retemp.echart.max};
          rearray = { echart: echarts, table: retemp.table };
        }
      }
      else if (chosename == "主要发明人专利类型分布"){
        var retemp = await this.mainInventorPatenttype(obj);
        if (retemp){
          var y1 = retemp.echart.y;
          var ylist = [];
          var legendlist = [];
          for (var j=0;j<y1.length;j++){
            ylist.push({lable:y1[j].patenttype,data:y1[j].data});
            legendlist.push(y1[j].patenttype);
          }
          var echarts = { x: retemp.echart.x, legend: legendlist, y: ylist};
          rearray = { echart: echarts, table: retemp.table };
        }
      }
      else if (chosename == "主要发明人专利法律效力"){
        var retemp = await this.mainInventorPatentstatus(obj);
        if (retemp){
          var y1 = retemp.echart.y;
          var ylist = [];
          var legendlist = [];
          for (var j=0;j<y1.length;j++){
            ylist.push({lable:y1[j].patenttype,data:y1[j].data});
            legendlist.push(y1[j].patenttype);
          }
          var echarts = { x: retemp.echart.x, legend: legendlist, y: ylist};
          rearray = { echart: echarts, table: retemp.table };
        }
      }
      else if (chosename == "主要发明人申请趋势"){
        var retemp = await this.mainInventorApplyTrend(obj);
        if (retemp){
          var y1 = retemp.echart.y;
          var ylist = [];
          for (var j=0;j<y1.length;j++){
            ylist.push({lable:y1[j].inventor,data:y1[j].data});
          }
          var echarts = { x: retemp.echart.x, legend: retemp.echart.legend, y: ylist };
          rearray = { echart: echarts, table: retemp.table };
        }

      }
      else if (chosename == "主要发明人公开趋势"){
        var retemp = await this.mainInventorPublicTrend(obj);
        if (retemp){
          var y1 = retemp.echart.y;
          var ylist = [];
          for (var j=0;j<y1.length;j++){
            ylist.push({lable:y1[j].inventor,data:y1[j].data});
          }
          var echarts = { x: retemp.echart.x, legend: retemp.echart.legend, y: ylist };
          rearray = { echart: echarts, table: retemp.table };
        }
      }
      else if (chosename == "全国专利分布"){
        rearray = await this.countrywidePatnet(obj);
      }
      else if (chosename == "各国专利分布"){
        rearray = await this.everyCountryPatent(obj);
      }
      else if (chosename == "外国在华申请分布"){
        rearray = await this.foreignApplyInChina(obj);
      }
      else if (chosename == "主要国家IPC分布"){
        var params = { search: obj.search, ipcTab: "3", obj: obj.obj };
        rearray = await this.mainCountryIpc(params);
      }
      else if (chosename == "主要国家申请趋势"){
        rearray = await this.mainCountryApplyTrend(obj);
      }
      else if (chosename == "专利IPC分析"){
        var params = { search: obj.search, ipcTab: "3", obj: obj.obj };
        rearray = await this.patentIpc(params);
      }
      else if (chosename == "外观设计分类分析"){
        rearray = await this.wgsjPatent(obj);
      }
      else if (chosename == "外国在华专利IPC分布"){
        var params = { search: obj.search, ipcTab: "3", obj: obj.obj };
        rearray = await this.foreignInChinaPatent(params);
      }
      else if (chosename == "技术领先国家IPC分布"){
        var params = { search: obj.search, ipcTab: "3", obj: obj.obj };
        rearray = await this.mainCountryIpc(params);
      }
      else if (chosename == "发明专利IPC分布"){
        var params = { search: obj.search, ipcTab: "3", obj: obj.obj };
        rearray = await this.fmPatentIpc(params);
      }
      else if (chosename == "主要IPC趋势分析"){
        var params = { search: obj.search, ipcTab: "3", obj: obj.obj };
        rearray = await this.mainIpcTrend(params);
      }
      else if (chosename == "申请趋势"){
        rearray = await this.applyTrend(obj);
      }
      else if (chosename == "公开趋势"){
        rearray = await this.publicTrend(obj);
      }
      else if (chosename == "授权趋势"){
        rearray = await this.authorizeTrend(obj);
      }
      else if (chosename == "各专利类型分布"){
        var retemp = await this.patenttypeStatus(obj);
        if (retemp){
          var namearrary = retemp.echart.x;
          var countarray = retemp.echart.y;
          var descstr = retemp.echart.desc;
          var echarttable = retemp.table;
          var arrayy1 = [];
          for (var j=0;j<namearrary.length;j++){
            arrayy1.push({value: countarray[j], name: namearrary[j]});
          }
          rearray = { echart: { legend: namearrary, y1: arrayy1, y2: countarray, desc: descstr }, table: echarttable };
        }
      }
      else if (chosename == "法律效力分布"){
        rearray = await this.statusEffect(obj);
      }
      else if (chosename == "当前法律状态分布"){
        rearray = await this.nowStatus(obj);
      }
      else if (chosename == "授权状态分布"){
        rearray = await this.authStatus(obj);
      }
      else if (chosename == "各专利类型申请趋势"){
        rearray = await this.everyApplyTrend(obj);
      }
      else if (chosename == "各专利类型公开趋势"){
        rearray = await this.everyPublicTrend(obj);
      }
      else if (chosename == "代理机构排名"){
        rearray = await this.agentRank(obj);
      }
      else if (chosename == "代理机构专利申请趋势"){
        rearray = await this.agentApplyTrend(obj);
      }
      else if (chosename == "代理机构专利类型分布"){
        rearray = await this.agentPatenttype(obj);
      }
      else if (chosename == "代理机构发明授权率"){
        rearray = await this.agentFmAuthorize(obj);
      }
      else if (chosename == "代理机构IPC分布"){
        var params = { search: obj.search, ipcTab: "3", obj: obj.obj };
        rearray = await this.agentIpc(params);
      }
      else if (chosename == "代理人排名"){
        rearray = await this.agentPersonRank(obj);
      }
      else if (chosename == "主要代理人专利类型分布"){
        rearray = await this.mainAgentPatenttype(obj);
      }
      if (rearray){
        results.push({chose:chose[i],value:rearray});
      }
    }
    if (results.length > 0){
      return results;
    }
    else{
      return null;
    }
    
  };

  async mainCountryApplyTrend(obj) {//区域分析-主要国家申请趋势
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    var wapilist = rearray[1];
    if (capilist.length > 0 || wapilist.length > 0) {
      var yeararray = [];
      var yearbuckets = [];
      var apparray = [];
      var tms = await this.GsbByChinaAggApi.filingyearAggs(yeararray);
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            yearbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (yearbuckets.length > 0) {
        var arrlen = 10;
        if (yearbuckets.length < 10) {
          arrlen = yearbuckets.length;
        }
        for (var i = 0; i < arrlen; i++) {
          yeararray.push(yearbuckets[i].key);
        }
        yeararray.reverse();

        var parm = null;

        var chinaarray = [];
        if (capilist.length > 0) {
          parm = {
            "terms": {
              "filing_year": yeararray
            }
          }
          capilist.push(parm);
          tms = await this.GsbByChinaAggApi.filingyearAggs(capilist);//获取查询结果
          if (tms) {
            if (tms.status == 0) {
              chinaarray.push({ "key": "中国", "doc_count": tms.data.total });
              cbuckets = tms.buckets.types.buckets;
            }
          }
        }


        if (wapilist.length > 0) {
          parm = {
            "terms": {
              "app_year": yeararray
            }
          }
          wapilist.push(parm);
          tms = await this.GsbByWorldAggApi.CountryAggs(wapilist);
          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                wbuckets = tms.buckets.types.buckets;
              }
            }
          }
        }

        if (chinaarray.length > 0 || wbuckets.length > 0) {
          var apparray = [];//前十国家
          if (chinaarray.length >0){
            apparray.push("中国");
            var arraylen = 10;
            if (wbuckets.length > 0 ) {
              if (wbuckets.length < 9){
                arraylen = wbuckets.length;
              };
              for (var i = 0; i < arraylen-1; i++) {
                apparray.push(wbuckets[i].key);
              }
            }
          }
          else{
            if (wbuckets.length > 0) {
              var arraylen = 10;
              if (wbuckets.length < 10){
                var arraylen = wbuckets.length;
              }
              for (var i = 0; i < arraylen; i++) {
                apparray.push(wbuckets[i].key);
              }
            }
          }

          parm = {
            "terms": {
              "db_name": apparray
            }
          }

          if (wapilist.length > 0) {
            wapilist.push(parm);
            tms = await this.GsbByWorldAggApi.CountryfilingyearAggs(wapilist);
            if (tms) {
              if (tms.status == 0) {
                if (tms.buckets.group_by_country.buckets) {
                  wbuckets = tms.buckets.group_by_country.buckets;
                }
              }
            }
          }

          if (cbuckets.length > 0 || wbuckets.length > 0) {
            var Ainfo = new Array();//定义信息数组，并初始化为0
            for (var i = 0; i < apparray.length; i++) {
              Ainfo[i] = new Array();
              for (var j = 0; j < yeararray.length; j++) {
                Ainfo[i][j] = 0;
              }
            }

            //去聚合结果取数据
            if (cbuckets.length > 0) {
              for (var cb in cbuckets) {
                var a = apparray.indexOf("中国");
                if (a > -1) {
                  var yearbuckets = cbuckets[cb];
                  var b = yeararray.indexOf(yearbuckets.key);
                  if (b > -1) {
                    Ainfo[a][b] = yearbuckets.doc_count;
                  }
                
                }
              }
            }

            if (wbuckets.length > 0) {
              for (var cb in wbuckets) {
                var a = apparray.indexOf(wbuckets[cb].key);
                if (a > -1) {
                  var yearbuckets = wbuckets[cb].group_by_filingyear.buckets;
                  for (var yearb in yearbuckets) {
                    var b = yeararray.indexOf(yearbuckets[yearb].key);
                    if (b > -1) {
                      Ainfo[a][b] = Ainfo[a][b] + yearbuckets[yearb].doc_count;
                    }
                  }
                }
              }
            }

            //拼返回结果
            var echarty = [];
            var tablearray = [];
            var Acountry = [];
            for (var i = 0; i < apparray.length; i++) {
              if (apparray[i] == "中国") {
                Acountry[i] = "中国";
              }
              else {
                var country = await this.praseworldname(apparray[i]);
                Acountry.push(country);
              }
              var comname = Acountry[i];
              var applist = [];
              for (var j = 0; j < yeararray.length; j++) {
                applist.push(Ainfo[i][j]);
              }
              echarty.push({ lable: comname, data: applist });
              var lablist = await this.getrowdata(comname, applist);
              tablearray.push(lablist);
            }
            var echarts = { x: yeararray, legend: Acountry, y: echarty };
            var tablevalues = { year: yeararray, data: tablearray };
            return { echart: echarts, table: tablevalues };
          }
          else {
            return null;
          }
        }
        else {
          return null;
        }
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async patentIpc(obj) {//技术结构分析-专利IPC分析
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1){
      total = parseInt(total1);
    }
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "ipc");
    var ipctab = obj.ipcTab;
    var capilist = rearray[0];
    var wapilist = rearray[1];
    if (capilist.length > 0 || wapilist.length > 0) {
      var tms = null;
      if (capilist.length > 0) {
        if (ipctab == "0") {
          tms = await this.GsbByChinaAggApi.AppIpclcAggs(capilist);
        }
        else if (ipctab == "1") {
          tms = await this.GsbByChinaAggApi.AppIpcscAggs(capilist);
        }
        else if (ipctab == "2") {
          tms = await this.GsbByChinaAggApi.AppIpclgAggs(capilist);
        }
        else if (ipctab == "3") {
          tms = await this.GsbByChinaAggApi.AppIpcAggs(capilist);
        }

        if (tms) {
          if (tms.status == 0) {
            if (tms.buckets.types.buckets) {
              cbuckets = tms.buckets.types.buckets;
            }

          }
        }
      }

      if (wapilist.length > 0) {
        if (ipctab == "0") {
          tms = await this.GsbByWorldAggApi.AppIpclcAggs(wapilist);
        }
        else if (ipctab == "1") {
          tms = await this.GsbByWorldAggApi.AppIpcscAggs(wapilist);
        }
        else if (ipctab == "2") {
          tms = await this.GsbByWorldAggApi.AppIpclgAggs(wapilist);
        }
        else if (ipctab == "3") {
          tms = await this.GsbByWorldAggApi.AppIpcAggs(wapilist);
        }

        if (tms) {
          if (tms.status == 0) {
            if (tms.buckets.types.buckets) {
              wbuckets = tms.buckets.types.buckets;
            }

          }
        }
      }

      var ipcarray = [];//前20IPC
      var newarray = await this.Arrayobjoper(cbuckets, wbuckets);
      if (newarray.length > 0) {
        var arraylen = 20;
        if (newarray.length < 20) {
          arraylen = newarray.length;
        }

        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var namearrary = [];
        var countarray = [];
        var echarttable = [];
        var descstr = "";
        if (arraylen >= 3) {
          for (var i = 0; i < arraylen; i++) {
            if (i == 0) {
              firstname = newarray[i].key;
              firstcount = newarray[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
            }
            else if (i == 1) {
              sceondname = newarray[i].key;
              sceondcount = newarray[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
            }
            else if (i == 2) {
              thirdname = newarray[i].key;
              thirdcount = newarray[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
            }
            namearrary.push(newarray[i].key);
            countarray.push(newarray[i].doc_count);
            echarttable.push({ rank: i + 1, classNum: newarray[i].key, patent: newarray[i].doc_count });
          }

          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三个ipc拥有的专利申请数量最多，分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (arraylen == 2) {
          firstname = newarray[0].key;
          firstcount = newarray[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          sceondname = newarray[1].key;
          sceondcount = newarray[1].doc_count;
          sceondpercent = await this.getpercent(sceondcount, total);
          namearrary.push(newarray[0].key);
          countarray.push(newarray[0].doc_count);
          echarttable.push({ rank: 1, company: newarray[0].key, patent: newarray[0].doc_count });
          namearrary.push(newarray[1].key);
          countarray.push(newarray[1].doc_count);
          echarttable.push({ rank: 2, company: newarray[1].key, patent: newarray[1].doc_count });
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两个ipc拥有的专利申请数量最多，分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";

        }
        else {
          firstname = newarray[0].key;
          firstcount = newarray[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          namearrary.push(newarray[0].key);
          countarray.push(newarray[0].doc_count);
          echarttable.push({ rank: 1, company: newarray[0].key, patent: newarray[0].doc_count });
          descstr = "从以上图表可以看出，" + firstname + " 这一个ipc拥有的专利申请数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
        }
        return { echart: { x: namearrary, y: countarray, desc: descstr }, table: echarttable };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async wgsjPatent(obj) {//技术结构分析-外观设计分类分析
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1){
      total = parseInt(total1);
    }
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "外观分析");
    var capilist = rearray[0];
    var wapilist = rearray[1];
    if (capilist.length > 0 || wapilist.length > 0) {
      var tms = null;
      if (capilist.length > 0) {
        tms = await this.GsbByChinaAggApi.AppIpcAggs(capilist);
        if (tms) {
          if (tms.status == 0) {
            if (tms.buckets.types.buckets) {
              cbuckets = tms.buckets.types.buckets;
            }

          }
        }
      }

      //if (wapilist.length > 0) {
      //  tms = await this.GsbByWorldAggApi.AppIpcAggs(wapilist);
      //  if (tms) {
      //    if (tms.status == 0) {
      //      total += tms.data.total;
      //    }
      //  }
      //}

      if (cbuckets.length > 0) {
        var arraylen = 20;
        if (cbuckets.length < 20) {
          arraylen = cbuckets.length;
        }

        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var namearrary = [];
        var countarray = [];
        var echarttable = [];
        var descstr = "";
        if (arraylen >= 3) {
          for (var i = 0; i < arraylen; i++) {
            if (i == 0) {
              firstname = cbuckets[i].key;
              firstcount = cbuckets[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
            }
            else if (i == 1) {
              sceondname = cbuckets[i].key;
              sceondcount = cbuckets[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
            }
            else if (i == 2) {
              thirdname = cbuckets[i].key;
              thirdcount = cbuckets[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
            }
            namearrary.push(cbuckets[i].key);
            countarray.push(cbuckets[i].doc_count);
            echarttable.push({ rank: i + 1, classNum: cbuckets[i].key, patent: cbuckets[i].doc_count });
          }

          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三个分类号拥有的专利申请数量最多，分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (arraylen == 2) {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          sceondname = cbuckets[1].key;
          sceondcount = cbuckets[1].doc_count;
          sceondpercent = await this.getpercent(sceondcount, total);
          namearrary.push(cbuckets[0].key);
          countarray.push(cbuckets[0].doc_count);
          echarttable.push({ rank: 1, company: cbuckets[0].key, patent: cbuckets[0].doc_count });
          namearrary.push(cbuckets[1].key);
          countarray.push(cbuckets[1].doc_count);
          echarttable.push({ rank: 2, company: cbuckets[1].key, patent: cbuckets[1].doc_count });
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两个分类号拥有的专利申请数量最多，分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";

        }
        else {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          namearrary.push(cbuckets[0].key);
          countarray.push(cbuckets[0].doc_count);
          echarttable.push({ rank: 1, company: cbuckets[0].key, patent: cbuckets[0].doc_count });
          descstr = "从以上图表可以看出，" + firstname + " 这一个分类号拥有的专利申请数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
        }
        return { echart: { x: namearrary, y: countarray, desc: descstr }, table: echarttable };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async foreignInChinaPatent(obj) {//技术结构分析-外国在华专利IPC分布
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1){
      total = parseInt(total1);
    }
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "ipc");
    var ipctab = obj.ipcTab;
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = null;
      var apparray = [];
      tms = await this.GsbByChinaAggApi.ForeignCountryAggs(capilist);
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }

        }
      }

      if (cbuckets.length > 0) {
        var arraylen = 10;
        if (cbuckets.length < 10) {
          arrlen = cbuckets.length;
        }
        for (var i = 0; i < arraylen; i++) {
          apparray.push(cbuckets[i].key);
        }

        var parm = {
          "terms": {
            "country_name": apparray
          }
        }

        capilist.push(parm);
        parm = {
          "bool": {
            "must_not": {
              "term": {
                "country_name": "中国"
              }
            }
          }
        }
        capilist.push(parm);
        //qianshiIPC
        var ipcarray = [];
        if (ipctab == "0") {
          tms = await this.GsbByChinaAggApi.AppIpclcAggs(capilist);
        }
        else if (ipctab == "1") {
          tms = await this.GsbByChinaAggApi.AppIpcscAggs(capilist);
        }
        else if (ipctab == "2") {
          tms = await this.GsbByChinaAggApi.AppIpclgAggs(capilist);
        }
        else if (ipctab == "3") {
          tms = await this.GsbByChinaAggApi.AppIpcAggs(capilist);
        }

        if (tms) {
          if (tms.status == 0) {
            if (tms.buckets.types.buckets) {
              cbuckets = tms.buckets.types.buckets;
            }

          }
        }

        if (cbuckets.length > 0) {
          arraylen = 10;
          if (cbuckets.length < 10) {
            arraylen = cbuckets.length;
          }
          for (var i = 0; i < arraylen; i++) {
            ipcarray.push(cbuckets[i].key);
          }



          if (ipctab == "0") {
            parm = {
              "terms": {
                "large class": ipcarray
              }
            }
            capilist.push(parm);
            tms = await this.GsbByChinaAggApi.ForeignLcAggs(capilist);
          }
          else if (ipctab == "1") {
            parm = {
              "terms": {
                "sub_class": ipcarray
              }
            }
            capilist.push(parm);
            tms = await this.GsbByChinaAggApi.ForeignScAggs(capilist);
          }
          else if (ipctab == "2") {
            parm = {
              "terms": {
                "large_group": ipcarray
              }
            }
            capilist.push(parm);
            tms = await this.GsbByChinaAggApi.ForeignLgAggs(capilist);
          }
          else if (ipctab == "3") {
            parm = {
              "terms": {
                "main_ipc": ipcarray
              }
            }
            capilist.push(parm);
            tms = await this.GsbByChinaAggApi.ForeignIpcAggs(capilist);
          }

          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.group_by_country.buckets) {
                cbuckets = tms.buckets.group_by_country.buckets;
              }

            }
          }

          if (cbuckets.length > 0) {
            var Aipcinfo = new Array();//定义信息数组，并初始化为0
            for (var i = 0; i < apparray.length; i++) {
              Aipcinfo[i] = new Array();
              for (var j = 0; j < ipcarray.length; j++) {
                Aipcinfo[i][j] = 0;
              }
            }

            for (var cb in cbuckets) {
              var a = apparray.indexOf(cbuckets[cb].key);
              if (a > -1) {
                var ipcbuckets = cbuckets[cb].group_by_ipc.buckets;
                for (var ipcb in ipcbuckets) {
                  var b = ipcarray.indexOf(ipcbuckets[ipcb].key);
                  if (b > -1) {
                    Aipcinfo[a][b] = ipcbuckets[ipcb].doc_count;
                  }
                }
              }
            }

            //拼返回结果
            var echarty = [];
            var tablearray = [];
            for (var i = 0; i < ipcarray.length; i++) {
              var ipcname = ipcarray[i];
              var ipc1list = [];
              for (var j = 0; j < apparray.length; j++) {
                ipc1list.push(Aipcinfo[j][i]);
              }
              echarty.push({ lable: ipcname, data: ipc1list });
              var lablist = await this.getrowdata(ipcname, ipc1list);
              tablearray.push(lablist);
            }
            var echarts = { legend: ipcarray, x: apparray, y: echarty };
            var tablevalues = { country: apparray, data: tablearray };

            return { echart: echarts, table: tablevalues };

          }
          else {
            return null;
          }
        }
        else {
          return null;
        }
      }
      else {
        return null;
      }

    }
    else {
      return null;
    }
  };

  async fmPatentIpc(obj) {//技术结构分析-发明专利IPC分布
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1){
      total = parseInt(total1);
    }
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "发明分析");
    var ipctab = obj.ipcTab;
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = null;
      if (ipctab == "0") {
        tms = await this.GsbByChinaAggApi.AppIpclcAggs(capilist);
      }
      else if (ipctab == "1") {
        tms = await this.GsbByChinaAggApi.AppIpcscAggs(capilist);
      }
      else if (ipctab == "2") {
        tms = await this.GsbByChinaAggApi.AppIpclgAggs(capilist);
      }
      else if (ipctab == "3") {
        tms = await this.GsbByChinaAggApi.AppIpcAggs(capilist);
      }

      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }

        }
      }

      if (cbuckets.length > 0) {
        var arraylen = 20;
        if (cbuckets.length < 20) {
          arraylen = cbuckets.length;
        }

        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var namearrary = [];
        var countarray = [];
        var echarttable = [];
        var descstr = "";
        if (arraylen >= 3) {
          for (var i = 0; i < arraylen; i++) {
            if (i == 0) {
              firstname = cbuckets[i].key;
              firstcount = cbuckets[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
            }
            else if (i == 1) {
              sceondname = cbuckets[i].key;
              sceondcount = cbuckets[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
            }
            else if (i == 2) {
              thirdname = cbuckets[i].key;
              thirdcount = cbuckets[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
            }
            namearrary.push(cbuckets[i].key);
            countarray.push(cbuckets[i].doc_count);
            echarttable.push({ rank: i + 1, classNum: cbuckets[i].key, patent: cbuckets[i].doc_count });
          }

          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三个ipc拥有的专利申请数量最多，分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (arraylen == 2) {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          sceondname = cbuckets[1].key;
          sceondcount = cbuckets[1].doc_count;
          sceondpercent = await this.getpercent(sceondcount, total);
          namearrary.push(cbuckets[0].key);
          countarray.push(cbuckets[0].doc_count);
          echarttable.push({ rank: 1, company: cbuckets[0].key, patent: cbuckets[0].doc_count });
          namearrary.push(cbuckets[1].key);
          countarray.push(cbuckets[1].doc_count);
          echarttable.push({ rank: 2, company: cbuckets[1].key, patent: cbuckets[1].doc_count });
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两个ipc拥有的专利申请数量最多，分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";

        }
        else {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          namearrary.push(cbuckets[0].key);
          countarray.push(cbuckets[0].doc_count);
          echarttable.push({ rank: 1, company: cbuckets[0].key, patent: cbuckets[0].doc_count });
          descstr = "从以上图表可以看出，" + firstname + " 这一个ipc拥有的专利申请数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
        }
        return { echart: { x: namearrary, y: countarray, desc: descstr }, table: echarttable };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async mainIpcTrend(obj) {//技术结构分析-主要IPC趋势分析
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "ipc");
    var ipctab = obj.ipcTab;
    var capilist = rearray[0];
    var wapilist = rearray[1];
    if (capilist.length > 0 || wapilist.length > 0) {
      var yeararray = [];
      var yearbuckets = [];
      var tms = await this.GsbByChinaAggApi.filingyearAggs(yeararray);
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            yearbuckets = tms.buckets.types.buckets;
          }
        }
      }


      if (yearbuckets.length > 0) {
        var arrlen = 10;
        if (yearbuckets.length < 10) {
          arrlen = yearbuckets.length;
        }
        for (var i = 0; i < arrlen; i++) {
          yeararray.push(yearbuckets[i].key);
        }
        yeararray.reverse();


        var parm = null;
        cbuckets = [];
        wbuckets = [];
        if (capilist.length > 0) {
          parm = {
            "terms": {
              "filing_year": yeararray
            }
          }
          capilist.push(parm);
          if (ipctab == "0") {
            tms = await this.GsbByChinaAggApi.AppIpclcAggs(capilist);
          }
          else if (ipctab == "1") {
            tms = await this.GsbByChinaAggApi.AppIpcscAggs(capilist);
          }
          else if (ipctab == "2") {
            tms = await this.GsbByChinaAggApi.AppIpclgAggs(capilist);
          }
          else if (ipctab == "3") {
            tms = await this.GsbByChinaAggApi.AppIpcAggs(capilist);
          }
          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                cbuckets = tms.buckets.types.buckets;
              }

            }
          }
        }

        if (wapilist.length > 0) {
          parm = {
            "terms": {
              "app_year": yeararray
            }
          }
          wapilist.push(parm);
          if (ipctab == "0") {
            tms = await this.GsbByWorldAggApi.AppIpclcAggs(capilist);
          }
          else if (ipctab == "1") {
            tms = await this.GsbByWorldAggApi.AppIpcscAggs(capilist);
          }
          else if (ipctab == "2") {
            tms = await this.GsbByWorldAggApi.AppIpclgAggs(capilist);
          }
          else if (ipctab == "3") {
            tms = await this.GsbByWorldAggApi.AppIpcAggs(capilist);
          }

          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                wbuckets = tms.buckets.types.buckets;
              }
            }
          }
        }

        var ipcarray = [];//前十IPC
        var newarray = await this.Arrayobjoper(cbuckets, wbuckets);
        if (newarray.length > 0) {
          arrlen = 10;
          if (newarray.length < 10) {
            arrlen = arrlen.length;
          }
          for (var i = 0; i < arrlen; i++) {
            ipcarray.push(newarray[i].key);
          }

          if (ipctab == "0") {
            parm = {
              "terms": {
                "large class": ipcarray
              }
            }
          }
          else if (ipctab == "1") {
            parm = {
              "terms": {
                "sub_class": ipcarray
              }
            }
          }
          else if (ipctab == "2") {
            parm = {
              "terms": {
                "large_group": ipcarray
              }
            }
          }
          else if (ipctab == "3") {
            parm = {
              "terms": {
                "main_ipc": ipcarray
              }
            }

          }

          cbuckets = [];
          wbuckets = [];
          if (capilist.length > 0) {
            capilist.push(parm);
            if (ipctab == "0") {
              tms = await this.GsbByChinaAggApi.IpcLcFilingyearAggs(capilist);
            }
            else if (ipctab == "1") {
              tms = await this.GsbByChinaAggApi.IpcScFilingyearAggs(capilist);
            }
            else if (ipctab == "2") {
              tms = await this.GsbByChinaAggApi.IpcLgFilingyearAggs(capilist);
            }
            else if (ipctab == "3") {
              tms = await this.GsbByChinaAggApi.IpcFilingyearAggs(capilist);
            }
            if (tms) {
              if (tms.status == 0) {
                if (tms.buckets.group_by_ipc.buckets) {
                  cbuckets = tms.buckets.group_by_ipc.buckets;
                }

              }
            }
          }

          if (wapilist.length > 0) {
            wapilist.push(parm);
            if (ipctab == "0") {
              tms = await this.GsbByWorldAggApi.IpcLcFilingyearAggs(capilist);
            }
            else if (ipctab == "1") {
              tms = await this.GsbByWorldAggApi.IpcScFilingyearAggs(capilist);
            }
            else if (ipctab == "2") {
              tms = await this.GsbByWorldAggApi.IpcLgFilingyearAggs(capilist);
            }
            else if (ipctab == "3") {
              tms = await this.GsbByWorldAggApi.IpcFilingyearAggs(capilist);
            }

            if (tms) {
              if (tms.status == 0) {
                if (tms.buckets.group_by_ipc.buckets) {
                  wbuckets = tms.buckets.group_by_ipc.buckets;
                }
              }
            }
          }

          if (cbuckets.length > 0 || wbuckets.length > 0) {
            var Aipcinfo = new Array();//定义信息数组，并初始化为0
            for (var i = 0; i < ipcarray.length; i++) {
              Aipcinfo[i] = new Array();
              for (var j = 0; j < yeararray.length; j++) {
                Aipcinfo[i][j] = 0;
              }
            }

            //去聚合结果取数据
            if (cbuckets.length > 0) {
              for (var cb in cbuckets) {
                var a = ipcarray.indexOf(cbuckets[cb].key);
                if (a > -1) {
                  var ipcbuckets = cbuckets[cb].group_by_year.buckets;
                  for (var ipcb in ipcbuckets) {
                    var b = yeararray.indexOf(ipcbuckets[ipcb].key);
                    if (b > -1) {
                      Aipcinfo[a][b] = ipcbuckets[ipcb].doc_count;
                    }
                  }
                }
              }
            }

            if (wbuckets.length > 0) {
              for (var cb in wbuckets) {
                var a = ipcarray.indexOf(wbuckets[cb].key);
                if (a > -1) {
                  var ipcbuckets = wbuckets[cb].group_by_year.buckets;
                  for (var ipcb in ipcbuckets) {
                    var b = yeararray.indexOf(ipcbuckets[ipcb].key);
                    if (b > -1) {
                      Aipcinfo[a][b] = Aipcinfo[a][b] + ipcbuckets[ipcb].doc_count;
                    }
                  }
                }
              }
            }

            //拼返回结果
            var echarty = [];
            var tabarray = [];
            for (var i = 0; i < ipcarray.length; i++) {
              var ipcname = ipcarray[i];
              var ipc1list = [];
              for (var j = 0; j < yeararray.length; j++) {
                ipc1list.push(Aipcinfo[i][j]);
              }
              echarty.push({ lable: ipcname, data: ipc1list });
              var lablist = await this.getrowdata(ipcname, ipc1list);
              tabarray.push(lablist);
            }
            var echarts = { legend: ipcarray, x: yeararray, y: echarty };

            var tablevalues = { year: yeararray, data: tabarray };

            return { echart: echarts, table: tablevalues };


          }
          else {
            return null;
          }
        }
        else {
          return null;
        }
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async applyTrend(obj) {//趋势分析-申请趋势
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1){
      total = parseInt(total1);
    }
    var capilist = rearray[0];
    var wapilist = rearray[1];
    if (capilist.length > 0 || wapilist.length > 0) {
      var tms = null;
      var yeararray = [];
      var yearbuckets = [];
      tms = await this.GsbByChinaAggApi.filingyearAggs(yeararray);
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            yearbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (yearbuckets.length > 0) {
        var arrlen = 20;
        if (yearbuckets.length < 20) {
          arrlen = yearbuckets.length;
        }
        for (var i = 0; i < arrlen; i++) {
          yeararray.push(yearbuckets[i].key);
        }
        yeararray.reverse();

        var parm = null;
        if (capilist.length > 0) {
          parm = {
            "terms": {
              "filing_year": yeararray
            }
          }
          capilist.push(parm);
          tms = await this.GsbByChinaAggApi.filingyearAggs(capilist);

          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                cbuckets = tms.buckets.types.buckets;
              }

            }
          }
        }


        if (wapilist.length > 0) {
          parm = {
            "terms": {
              "app_year": yeararray
            }
          }
          wapilist.push(parm);
          tms = await this.GsbByWorldAggApi.filingyearAggs(capilist);

          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                wbuckets = tms.buckets.types.buckets;
              }
            }
          }
        }

        var newarray = await this.Arrayobjoper(cbuckets, wbuckets);
        var compare = function (prop) {
          return function (obj1, obj2) {
            var val1 = obj1[prop];
            var val2 = obj2[prop];
            if (val1 < val2) {
              return -1;
            } else if (val1 > val2) {
              return 1;
            } else {
              return 0;
            }
          }
        }

        var sortarray = [];
        sortarray = sortarray.concat(newarray);
        newarray.sort(compare("key"));
        if (newarray.length > 0) {
          var arraylen = 20;
          if (newarray.length < 20) {
            arraylen = newarray.length;
          }

          var firstname = "";
          var sceondname = "";
          var thirdname = "";
          var firstcount = 0;
          var sceondcount = 0;
          var thirdcount = 0;
          var firstpercent = "0%";
          var sceondpercent = "0%";
          var thirdpercent = "0%";
          var namearrary = [];
          var countarray = [];
          var echarttable = [];
          var descstr = "";
          for (var i = 0; i < arraylen; i++) {
            namearrary.push(newarray[i].key);
            countarray.push(newarray[i].doc_count);
          }

          if (arraylen >= 3) {
            for (var i = 0; i < arraylen; i++) {
              if (i == 0) {
                firstname = sortarray[i].key;
                firstcount = sortarray[i].doc_count;
                firstpercent = await this.getpercent(firstcount, total);
              }
              else if (i == 1) {
                sceondname = sortarray[i].key;
                sceondcount = sortarray[i].doc_count;
                sceondpercent = await this.getpercent(sceondcount, total);
              }
              else if (i == 2) {
                thirdname = sortarray[i].key;
                thirdcount = sortarray[i].doc_count;
                thirdpercent = await this.getpercent(thirdcount, total);
              }
              echarttable.push({ rank: i + 1, year: sortarray[i].key, patent: sortarray[i].doc_count });
            }

            descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三年申请的数量最多，分别为" +
              firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
              "、" + thirdpercent + "。";
          }
          else if (arraylen == 2) {
            firstname = sortarray[0].key;
            firstcount = sortarray[0].doc_count;
            echarttable.push({ rank: 1, year: sortarray[0].key, patent: sortarray[0].doc_count });
            firstpercent = await this.getpercent(firstcount, total);
            sceondname = sortarray[1].key;
            sceondcount = sortarray[1].doc_count;
            echarttable.push({ rank: 2, year: sortarray[1].key, patent: sortarray[1].doc_count });
            sceondpercent = await this.getpercent(sceondcount, total);
            descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两年申请的数量最多，分别为" + firstcount + "件、" + sceondcount
              + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";

          }
          else {
            firstname = sortarray[0].key;
            firstcount = sortarray[0].doc_count;
            echarttable.push({ rank: 1, year: sortarray[0].key, patent: sortarray[0].doc_count });
            firstpercent = await this.getpercent(firstcount, total);
            descstr = "从以上图表可以看出，" + firstname + " 这一年申请的数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
          }

          return { echart: { x: namearrary, data: countarray, desc: descstr }, table: echarttable };
        }
        else {
          return null;
        }
      }
      else {
        return null;
      }


    }
  };

  async publicTrend(obj) {//趋势分析-公开趋势
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1){
      total = parseInt(total1);
    }
    var capilist = rearray[0];
    var wapilist = rearray[1];
    if (capilist.length > 0 || wapilist.length > 0) {
      var tms = null;
      var yeararray = [];
      var yearbuckets = [];
      tms = await this.GsbByChinaAggApi.pubyearAggs(yeararray);
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            yearbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (yearbuckets.length > 0) {
        var arrlen = 20;
        if (yearbuckets.length < 20) {
          arrlen = yearbuckets.length;
        }
        for (var i = 0; i < arrlen; i++) {
          yeararray.push(yearbuckets[i].key);
        }
        yeararray.reverse();

        var parm = {
          "terms": {
            "pub_year": yeararray
          }
        }
        if (capilist.length > 0) {
          capilist.push(parm);
          tms = await this.GsbByChinaAggApi.pubyearAggs(capilist);

          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                cbuckets = tms.buckets.types.buckets;
              }

            }
          }
        }


        if (wapilist.length > 0) {
          wapilist.push(parm);
          tms = await this.GsbByWorldAggApi.pubyearAggs(capilist);

          if (tms) {
            if (tms.status == 0) {
              if (tms.buckets.types.buckets) {
                wbuckets = tms.buckets.types.buckets;
              }
            }
          }
        }

        var newarray = await this.Arrayobjoper(cbuckets, wbuckets);
        var compare = function (prop) {
          return function (obj1, obj2) {
            var val1 = obj1[prop];
            var val2 = obj2[prop];
            if (val1 < val2) {
              return -1;
            } else if (val1 > val2) {
              return 1;
            } else {
              return 0;
            }
          }
        }

        var sortarray = [];
        sortarray = sortarray.concat(newarray);
        newarray.sort(compare("key"));
        if (newarray.length > 0) {
          var arraylen = 20;
          if (newarray.length < 20) {
            arraylen = newarray.length;
          }

          var firstname = "";
          var sceondname = "";
          var thirdname = "";
          var firstcount = 0;
          var sceondcount = 0;
          var thirdcount = 0;
          var firstpercent = "0%";
          var sceondpercent = "0%";
          var thirdpercent = "0%";
          var namearrary = [];
          var countarray = [];
          var echarttable = [];
          var descstr = "";
          for (var i = 0; i < arraylen; i++) {
            namearrary.push(newarray[i].key);
            countarray.push(newarray[i].doc_count);
          }

          if (arraylen >= 3) {
            for (var i = 0; i < arraylen; i++) {
              if (i == 0) {
                firstname = sortarray[i].key;
                firstcount = sortarray[i].doc_count;
                firstpercent = await this.getpercent(firstcount, total);
              }
              else if (i == 1) {
                sceondname = sortarray[i].key;
                sceondcount = sortarray[i].doc_count;
                sceondpercent = await this.getpercent(sceondcount, total);
              }
              else if (i == 2) {
                thirdname = sortarray[i].key;
                thirdcount = sortarray[i].doc_count;
                thirdpercent = await this.getpercent(thirdcount, total);
              }
              echarttable.push({ rank: i + 1, year: sortarray[i].key, patent: sortarray[i].doc_count });
            }

            descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三年申请的数量最多，分别为" +
              firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
              "、" + thirdpercent + "。";
          }
          else if (arraylen == 2) {
            firstname = sortarray[0].key;
            firstcount = sortarray[0].doc_count;
            echarttable.push({ rank: 1, year: sortarray[0].key, patent: sortarray[0].doc_count });
            firstpercent = await this.getpercent(firstcount, total);
            sceondname = sortarray[1].key;
            sceondcount = sortarray[1].doc_count;
            echarttable.push({ rank: 2, year: sortarray[1].key, patent: sortarray[1].doc_count });
            sceondpercent = await this.getpercent(sceondcount, total);
            descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两年申请的数量最多，分别为" + firstcount + "件、" + sceondcount
              + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";

          }
          else {
            firstname = sortarray[0].key;
            firstcount = sortarray[0].doc_count;
            echarttable.push({ rank: 1, year: sortarray[0].key, patent: sortarray[0].doc_count });
            firstpercent = await this.getpercent(firstcount, total);
            descstr = "从以上图表可以看出，" + firstname + " 这一年申请的数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
          }

          return { echart: { x: namearrary, data: countarray, desc: descstr }, table: echarttable };
        }
        else {
          return null;
        }
      }
      else {
        return null;
      }
    }
  };

  async authorizeTrend(obj) {//趋势分析-授权趋势
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "发明分析");
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1){
      total = parseInt(total1);
    }
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = await this.GsbByChinaAggApi.GryearAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length > 0) {
        var sortarray = [];
        sortarray = sortarray.concat(cbuckets);//yuanshishunxu

        var compare = function (prop) {
          return function (obj1, obj2) {
            var val1 = obj1[prop];
            var val2 = obj2[prop];
            if (val1 < val2) {
              return 1;
            } else if (val1 > val2) {
              return -1;
            } else {
              return 0;
            }
          }
        }

        cbuckets.sort(compare("doc_count"));//anzhipaixu

        var compare2 = function (prop) {
          return function (obj1, obj2) {
            var val1 = obj1[prop];
            var val2 = obj2[prop];
            if (val1 < val2) {
              return -1;
            } else if (val1 > val2) {
              return 1;
            } else {
              return 0;
            }
          }
        }
        sortarray.sort(compare2("key"))

        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var namearrary = [];
        var countarray = [];
        var echarttable = [];
        var descstr = "";
        for (var i = 0; i < sortarray.length; i++) {
          namearrary.push(sortarray[i].key);
          countarray.push(sortarray[i].doc_count);
        }

        if (cbuckets.length >= 3) {
          for (var i = 0; i < cbuckets.length; i++) {
            if (i == 0) {
              firstname = cbuckets[i].key;
              firstcount = cbuckets[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
            }
            else if (i == 1) {
              sceondname = cbuckets[i].key;
              sceondcount = cbuckets[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
            }
            else if (i == 2) {
              thirdname = cbuckets[i].key;
              thirdcount = cbuckets[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
            }
            echarttable.push({ rank: i + 1, year: cbuckets[i].key, patent: cbuckets[i].doc_count });
          }

          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三年授权的数量最多，分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (cbuckets.length == 2) {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          echarttable.push({ rank: 1, year: cbuckets[0].key, patent: cbuckets[0].doc_count });
          firstpercent = await this.getpercent(firstcount, total);
          sceondname = cbuckets[1].key;
          sceondcount = cbuckets[1].doc_count;
          echarttable.push({ rank: 2, year: cbuckets[1].key, patent: cbuckets[1].doc_count });
          sceondpercent = await this.getpercent(sceondcount, total);
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两年授权的数量最多，分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";

        }
        else {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          echarttable.push({ rank: 1, year: cbuckets[0].key, patent: cbuckets[0].doc_count });
          firstpercent = await this.getpercent(firstcount, total);
          descstr = "从以上图表可以看出，" + firstname + " 这一年授权的数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
        }

        return { echart: { x: namearrary, data: countarray, desc: descstr }, table: echarttable };



      }
      else {
        return null;
      }
    }
    else {
      return null;
    }


  };

  async patenttypeStatus(obj) {//法律状态分析-各专利类型分布
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1){
      total = parseInt(total1);
    }
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = await this.GsbByChinaAggApi.PubTypeAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length > 0) {
        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var namearrary = [];
        var countarray = [];
        var echarttable = [];
        var descstr = "";
        if (cbuckets.length >= 3) {
          for (var i = 0; i < cbuckets.length; i++) {
            var pubname = cbuckets[i].key;
            if (pubname == "发明") {
              pubname = "发明申请"
            }
            if (i == 0) {
              firstname = pubname;
              firstcount = cbuckets[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
            }
            else if (i == 1) {
              sceondname = pubname;
              sceondcount = cbuckets[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
            }
            else if (i == 2) {
              thirdname = pubname;
              thirdcount = cbuckets[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
            }
            namearrary.push(pubname);
            countarray.push(cbuckets[i].doc_count);
            echarttable.push({ rank: i + 1, type: pubname, patent: cbuckets[i].doc_count });
          }

          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + "分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (cbuckets.length == 2) {
          var pubname = cbuckets[0].key;
          if (pubname == "发明") {
            pubname = "发明申请"
          }
          firstname = pubname;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          namearrary.push(pubname);
          countarray.push(cbuckets[0].doc_count);
          echarttable.push({ rank: 1, type: pubname, patent: cbuckets[0].doc_count });
          pubname = cbuckets[1].key;
          if (pubname == "发明") {
            pubname = "发明申请"
          }
          sceondname = pubname;
          sceondcount = cbuckets[1].doc_count;
          namearrary.push(pubname);
          countarray.push(cbuckets[1].doc_count);
          echarttable.push({ rank: 2, type: pubname, patent: cbuckets[1].doc_count });
          sceondpercent = await this.getpercent(sceondcount, total);
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";

        }
        else {
          var pubname = cbuckets[0].key;
          if (pubname == "发明") {
            pubname = "发明申请"
          }
          firstname = pubname;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          namearrary.push(pubname);
          countarray.push(cbuckets[0].doc_count);
          echarttable.push({ rank: 1, type: pubname, patent: cbuckets[0].doc_count });
          descstr = "从以上图表可以看出，" + firstname + "为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
        }

        return { echart: { x: namearrary, y: countarray, desc: descstr }, table: echarttable };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async statusEffect(obj) {//法律状态分析-法律效力分布
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1){
      total = parseInt(total1);
    }
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = await this.GsbByChinaAggApi.PubstatusAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length > 0) {
        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var namearrary = [];
        var countarray = [];
        var echarttable = [];
        var arrayy1 = [];
        var descstr = "";
        if (cbuckets.length >= 3) {
          for (var i = 0; i < cbuckets.length; i++) {
            if (i == 0) {
              firstname = cbuckets[i].key;
              firstcount = cbuckets[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
            }
            else if (i == 1) {
              sceondname = cbuckets[i].key;
              sceondcount = cbuckets[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
            }
            else if (i == 2) {
              thirdname = cbuckets[i].key;
              thirdcount = cbuckets[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
            }
            namearrary.push(cbuckets[i].key);
            countarray.push(cbuckets[i].doc_count);
            arrayy1.push({ value: cbuckets[i].doc_count, name: cbuckets[i].key });
            echarttable.push({ rank: i + 1, status: cbuckets[i].key, patent: cbuckets[i].doc_count });
          }

          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + "专利件数分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析的专利总量的百分比分别是：" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (cbuckets.length == 2) {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          namearrary.push(cbuckets[0].key);
          countarray.push(cbuckets[0].doc_count);
          arrayy1.push({ value: cbuckets[0].doc_count, name: cbuckets[0].key });
          echarttable.push({ rank: 1, status: cbuckets[0].key, patent: cbuckets[0].doc_count });
          sceondname = cbuckets[1].key;;
          sceondcount = cbuckets[1].doc_count;
          namearrary.push(cbuckets[1].key);
          countarray.push(cbuckets[1].doc_count);
          arrayy1.push({ value: cbuckets[1].doc_count, name: cbuckets[1].key });
          echarttable.push({ rank: 2, status: cbuckets[1].key, patent: cbuckets[1].doc_count });
          sceondpercent = await this.getpercent(sceondcount, total);
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "专利件数分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析的专利总量的百分比分别是：" + firstpercent + "、" + sceondpercent + "。";
        }
        else {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          namearrary.push(cbuckets[0].key);
          countarray.push(cbuckets[0].doc_count);
          arrayy1.push({ value: cbuckets[0].doc_count, name: cbuckets[0].key });
          echarttable.push({ rank: 1, status: cbuckets[0].key, patent: cbuckets[0].doc_count });
          descstr = "从以上图表可以看出，" + firstname + "专利件数为" + firstcount + "件，占所分析的专利总量的百分比是：" + firstpercent + "。";

        }

        return { echart: { legend: namearrary, y1: arrayy1, y2: countarray, desc: descstr }, table: echarttable };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async nowStatus(obj) {//法律状态分析-当前法律状态分布
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1){
      total = parseInt(total1);
    }
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = await this.GsbByChinaAggApi.PubstatusnowAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length > 0) {
        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var namearrary = [];
        var countarray = [];
        var echarttable = [];
        var arrayy1 = [];
        var descstr = "";
        if (cbuckets.length >= 3) {
          for (var i = 0; i < cbuckets.length; i++) {
            if (i == 0) {
              firstname = cbuckets[i].key;
              firstcount = cbuckets[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
            }
            else if (i == 1) {
              sceondname = cbuckets[i].key;
              sceondcount = cbuckets[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
            }
            else if (i == 2) {
              thirdname = cbuckets[i].key;
              thirdcount = cbuckets[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
            }
            namearrary.push(cbuckets[i].key);
            countarray.push(cbuckets[i].doc_count);
            arrayy1.push({ value: cbuckets[i].doc_count, name: cbuckets[i].key });
            echarttable.push({ rank: i + 1, type: cbuckets[i].key, patent: cbuckets[i].doc_count });
          }

          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + "这三种当前状态下拥有的专利的数据量最多，分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析的专利总量的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (cbuckets.length == 2) {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          namearrary.push(cbuckets[0].key);
          countarray.push(cbuckets[0].doc_count);
          arrayy1.push({ value: cbuckets[0].doc_count, name: cbuckets[0].key });
          echarttable.push({ rank: 1, type: cbuckets[0].key, patent: cbuckets[0].doc_count });
          sceondname = cbuckets[1].key;;
          sceondcount = cbuckets[1].doc_count;
          namearrary.push(cbuckets[1].key);
          countarray.push(cbuckets[1].doc_count);
          arrayy1.push({ value: cbuckets[1].doc_count, name: cbuckets[1].key });
          echarttable.push({ rank: 2, type: cbuckets[1].key, patent: cbuckets[1].doc_count });
          sceondpercent = await this.getpercent(sceondcount, total);
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "这两种当前状态下拥有的专利的数据量最多，分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析的专利总量的：" + firstpercent + "、" + sceondpercent + "。";
        }
        else {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          namearrary.push(cbuckets[0].key);
          countarray.push(cbuckets[0].doc_count);
          arrayy1.push({ value: cbuckets[0].doc_count, name: cbuckets[0].key });
          echarttable.push({ rank: 1, type: cbuckets[0].key, patent: cbuckets[0].doc_count });
          descstr = "从以上图表可以看出，" + firstname + "这种当前状态下拥有的专利的数据量最多，为" + firstcount + "件，占所分析的专利总量的：" + firstpercent + "。";

        }

        return { echart: { x: namearrary, y: countarray, desc: descstr }, table: echarttable };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async authStatus(obj) {//法律状态分析-授权状态分布
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "发明分析");
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1){
      total = parseInt(total1);
    }
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var sqtotal = 0;
      var fsqtotal = 0;
      var tms = await this.GsbByChinaAggApi.GryearAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          sqtotal = tms.data.total;
        }
      }

      tms = await this.GsbByChinaAggApi.FmpubyearAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          fsqtotal = tms.data.total;
        }
      }

      if (total) {
        var persq = await this.getpercent(sqtotal, total);
        var perfsq = await this.getpercent(fsqtotal, total);
        var descvalue = "从以上图表可以看出，曾授权、未授权的专利件数分别有" + sqtotal + " 、" + fsqtotal
          + "件，占所分析专利总量的" + persq + " 、" + perfsq + " 。";
        var yarray1 = [{ value: sqtotal, name: "曾授权" }, { value: fsqtotal, name: "未授权" }];
        var echavalues = { desc: descvalue, legend: ["曾授权", "未授权"], y1: yarray1, y2: [sqtotal, fsqtotal] };
        var tablearr = [{ rank: 1, name: "曾授权", patent: sqtotal }, { rank: 2, name: "未授权", patent: fsqtotal }];

        return { echart: echavalues, table: tablearr };
      }
      else {
        return null;
      }

    }
    else {
      return null;
    }
  };

  async everyApplyTrend(obj) {//法律状态分析-各专利类型申请趋势
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = null;
      var yeararray = [];
      var yearbuckets = [];
      var apparray = [];
      var tms = await this.GsbByChinaAggApi.filingyearAggs(yeararray);
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            yearbuckets = tms.buckets.types.buckets;
          }
        }
      }
      if (yearbuckets.length > 0) {
        var arrlen = 10;
        if (yearbuckets.length < 10) {
          arrlen = yearbuckets.length;
        }
        for (var i = 0; i < arrlen; i++) {
          yeararray.push(yearbuckets[i].key);
        }
        yeararray.reverse();

        var parm = {
          "terms": {
            "filing_year": yeararray
          }
        }
        capilist.push(parm);
        tms = await this.GsbByChinaAggApi.pubtypeFilingyearAggs(capilist);//获取查询结果
        if (tms) {
          if (tms.status == 0) {
            if (tms.buckets.group_by_type.buckets) {
              cbuckets = tms.buckets.group_by_type.buckets;
            }

          }
        }

        if (cbuckets.length > 0) {
          var fmlist = [];
          var xxlist = [];
          var wglist = [];
          var countarray = [];
          for (var cb in cbuckets) {
            var countlist = cbuckets[cb].group_by_year.buckets;
            for (var i = 0; i < yeararray.length; i++) {
              var a = countlist.findIndex(f => f.key == yeararray[i])
              if (a > -1) {
                if (cbuckets[cb].key == "发明") {
                  fmlist.push(countlist[a].doc_count);
                }
                else if (cbuckets[cb].key == "实用新型") {
                  xxlist.push(countlist[a].doc_count);
                }
                else if (cbuckets[cb].key == "外观设计") {
                  wglist.push(countlist[a].doc_count);
                }

              }
              else {
                if (cbuckets[cb].key == "发明") {
                  fmlist.push(0);
                }
                else if (cbuckets[cb].key == "实用新型") {
                  xxlist.push(0);
                }
                else if (cbuckets[cb].key == "外观设计") {
                  wglist.push(0);
                }
              }
            }
          }

          var yvalues = [{ lable: "外观设计专利", data: wglist }, { lable: "发明申请专利", data: fmlist },
          { lable: "实用新型专利", data: xxlist }];
          var legendvalues = ["外观设计专利", "发明申请专利", "实用新型专利"];
          var echartvalues = { x: yeararray, legend: legendvalues, y: yvalues };
          var datavalues = [];
          var lablist = await this.getrowdata("外观设计专利", wglist);
          datavalues.push(lablist);
          lablist = await this.getrowdata("发明申请专利", fmlist);
          datavalues.push(lablist);
          lablist = await this.getrowdata("实用新型专利", xxlist);
          datavalues.push(lablist);

          var tablevalues = { year: yeararray, data: datavalues };
          return { echart: echartvalues, table: tablevalues };

        }
        else {
          return null;
        }
      }
      else {
        return null;
      }

    }
    else {
      return null;
    }
  };

  async everyPublicTrend(obj) {//法律状态分析-各专利类型公开趋势
    var cbuckets = [];
    var wbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = null;
      var yeararray = [];
      var yearbuckets = [];
      var apparray = [];
      var tms = await this.GsbByChinaAggApi.pubyearAggs(yeararray);
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            yearbuckets = tms.buckets.types.buckets;
          }
        }
      }
      if (yearbuckets.length > 0) {
        var arrlen = 10;
        if (yearbuckets.length < 10) {
          arrlen = yearbuckets.length;
        }
        for (var i = 0; i < arrlen; i++) {
          yeararray.push(yearbuckets[i].key);
        }
        yeararray.reverse();

        var parm = {
          "terms": {
            "pub_year": yeararray
          }
        }
        capilist.push(parm);
        tms = await this.GsbByChinaAggApi.pubtypePubyearAggs(capilist);//获取查询结果
        if (tms) {
          if (tms.status == 0) {
            if (tms.buckets.group_by_type.buckets) {
              cbuckets = tms.buckets.group_by_type.buckets;
            }

          }
        }

        if (cbuckets.length > 0) {
          var fmlist = [];
          var xxlist = [];
          var wglist = [];
          var countarray = [];
          for (var cb in cbuckets) {
            var countlist = cbuckets[cb].group_by_year.buckets;
            for (var i = 0; i < yeararray.length; i++) {
              var a = countlist.findIndex(f => f.key == yeararray[i])
              if (a > -1) {
                if (cbuckets[cb].key == "发明") {
                  fmlist.push(countlist[a].doc_count);
                }
                else if (cbuckets[cb].key == "实用新型") {
                  xxlist.push(countlist[a].doc_count);
                }
                else if (cbuckets[cb].key == "外观设计") {
                  wglist.push(countlist[a].doc_count);
                }

              }
              else {
                if (cbuckets[cb].key == "发明") {
                  fmlist.push(0);
                }
                else if (cbuckets[cb].key == "实用新型") {
                  xxlist.push(0);
                }
                else if (cbuckets[cb].key == "外观设计") {
                  wglist.push(0);
                }
              }
            }
          }

          var yvalues = [{ lable: "外观设计专利", data: wglist }, { lable: "发明申请专利", data: fmlist },
          { lable: "实用新型专利", data: xxlist }];
          var legendvalues = ["外观设计专利", "发明申请专利", "实用新型专利"];
          var echartvalues = { x: yeararray, legend: legendvalues, y: yvalues };
          var datavalues = [];
          var lablist = await this.getrowdata("外观设计专利", wglist);
          datavalues.push(lablist);
          lablist = await this.getrowdata("发明申请专利", fmlist);
          datavalues.push(lablist);
          lablist = await this.getrowdata("实用新型专利", xxlist);
          datavalues.push(lablist);

          var tablevalues = { year: yeararray, data: datavalues };
          return { echart: echartvalues, table: tablevalues };

        }
        else {
          return null;
        }
      }
      else {
        return null;
      }

    }
    else {
      return null;
    }
  };

  async agentRank(obj) {//代理人/机构分析-代理机构排名
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var total = 0;
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = await this.GsbByChinaAggApi.AgencyAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          total += tms.data.total;
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length > 0) {
        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var namearrary = [];
        var countarray = [];
        var echarttable = [];
        var arrayy1 = [];
        var descstr = "";
        if (cbuckets.length >= 3) {
          for (var i = 0; i < cbuckets.length; i++) {
            if (i == 0) {
              firstname = cbuckets[i].key;
              firstcount = cbuckets[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
            }
            else if (i == 1) {
              sceondname = cbuckets[i].key;
              sceondcount = cbuckets[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
            }
            else if (i == 2) {
              thirdname = cbuckets[i].key;
              thirdcount = cbuckets[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
            }
            namearrary.push(cbuckets[i].key);
            countarray.push(cbuckets[i].doc_count);
            arrayy1.push({ value: cbuckets[i].doc_count, name: cbuckets[i].key });
            echarttable.push({ rank: i + 1, agentName: cbuckets[i].key, patent: cbuckets[i].doc_count });
          }

          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + "这三个代理机构代理的专利申请的数据量最多，分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析的专利的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (cbuckets.length == 2) {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          namearrary.push(cbuckets[0].key);
          countarray.push(cbuckets[0].doc_count);
          arrayy1.push({ value: cbuckets[0].doc_count, name: cbuckets[0].key });
          echarttable.push({ rank: 1, agentName: cbuckets[0].key, patent: cbuckets[0].doc_count });
          sceondname = cbuckets[1].key;;
          sceondcount = cbuckets[1].doc_count;
          namearrary.push(cbuckets[1].key);
          countarray.push(cbuckets[1].doc_count);
          arrayy1.push({ value: cbuckets[1].doc_count, name: cbuckets[1].key });
          echarttable.push({ rank: 2, agentName: cbuckets[1].key, patent: cbuckets[1].doc_count });
          sceondpercent = await this.getpercent(sceondcount, total);
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "这两个代理机构代理的专利申请的数据量最多，分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析的专利的：" + firstpercent + "、" + sceondpercent + "。";
        }
        else {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          namearrary.push(cbuckets[0].key);
          countarray.push(cbuckets[0].doc_count);
          arrayy1.push({ value: cbuckets[0].doc_count, name: cbuckets[0].key });
          echarttable.push({ rank: 1, agentName: cbuckets[0].key, patent: cbuckets[0].doc_count });
          descstr = "从以上图表可以看出，" + firstname + "代理的专利申请的数据量最多，为" + firstcount + "件，占所分析的专利的：" + firstpercent + "。";

        }

        return { echart: { x: namearrary, y: countarray, desc: descstr }, table: echarttable };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async agentApplyTrend(obj) {  //代理人/机构分析-代理机构专利申请趋势
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var yeararray = [];
      var yearbuckets = [];
      var tms = await this.GsbByChinaAggApi.filingyearAggs(yeararray);
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            yearbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (yearbuckets.length > 0) {
        var arrlen = 10;
        if (yearbuckets.length < 10) {
          arrlen = yearbuckets.length;
        }
        for (var i = 0; i < arrlen; i++) {
          yeararray.push(yearbuckets[i].key);
        }
        yeararray.reverse();

        var parm = {
          "terms": {
            "filing_year": yeararray
          }
        }
        capilist.push(parm);

        tms = await this.GsbByChinaAggApi.AgencyFilingyearAggs(capilist);//获取查询结果
        if (tms) {
          if (tms.status == 0) {
            if (tms.buckets.group_by_agency.buckets) {
              cbuckets = tms.buckets.group_by_agency.buckets;
            }

          }
        }

        if (cbuckets.length > 0) {
          //拼返回结果
          var echarty = [];
          var tablearray = [];
          var apparray = [];

          for (var i = 0; i < cbuckets.length; i++) {
            apparray.push(cbuckets[i].key);
            var applist = [];
            var countlist = cbuckets[i].group_by_year.buckets;
            for (var j = 0; j < yeararray.length; j++) {
              var a = countlist.findIndex(f => f.key == yeararray[j]);
              if (a > -1) {
                applist.push(countlist[a].doc_count);
              }
              else {
                applist.push(0);
              }

            }
            echarty.push({ lable: cbuckets[i].key, data: applist });
            var lablist = await this.getrowdata(cbuckets[i].key, applist);
            tablearray.push(lablist);
          }
          var echarts = { x: yeararray, legend: apparray, y: echarty };
          var tablevalues = { year: yeararray, data: tablearray };
          return { echart: echarts, table: tablevalues };
        }
        else {
          return null;
        }

      }
      else {
        return null;
      }
    }
    else {
      return null;
    }

  };

  async agentPatenttype(obj) {  //代理人/机构分析-代理机构专利类型分布
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = await this.GsbByChinaAggApi.AgencyPubtypeAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.group_by_agency.buckets) {
            cbuckets = tms.buckets.group_by_agency.buckets;
          }

        }
      }

      if (cbuckets.length > 0) {
        var comarray = [];
        var fmlist = [];
        var xxlist = [];
        var wglist = [];
        for (var cb in cbuckets) {
          comarray.push(cbuckets[cb].key);
          var typelist = cbuckets[cb].group_by_type.buckets;
          if (typelist.length > 0) {
            var a = typelist.findIndex(f => f.key == "发明");
            if (a > -1) {
              fmlist.push(typelist[a].doc_count);
            }
            else {
              fmlist.push(0);
            }

            a = typelist.findIndex(f => f.key == "实用新型");
            if (a > -1) {
              xxlist.push(typelist[a].doc_count);
            }
            else {
              xxlist.push(0);
            }

            a = typelist.findIndex(f => f.key == "外观设计");
            if (a > -1) {
              wglist.push(typelist[a].doc_count);
            }
            else {
              wglist.push(0);
            }
          }
        }

        var yvalues = [{ lable: "外观设计专利", data: wglist }, { lable: "发明申请专利", data: fmlist },
        { lable: "实用新型专利", data: xxlist }];
        var legendvalues = ["外观设计专利", "发明申请专利", "实用新型专利"];
        var echartvalues = { x: comarray, legend: legendvalues, y: yvalues };
        var datavalues = [];
        var lablist = await this.getrowdata("外观设计专利", wglist);
        datavalues.push(lablist);
        lablist = await this.getrowdata("发明申请专利", fmlist);
        datavalues.push(lablist);
        lablist = await this.getrowdata("实用新型专利", xxlist);
        datavalues.push(lablist);

        var tablevalues = { agency: comarray, data: datavalues };
        return { echart: echartvalues, table: tablevalues };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async agentFmAuthorize(obj) {//代理人/机构分析-代理机构发明授权率
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "发明分析");
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var apparray = [];
      var allarray = [];
      var sqarray = [];
      var wsqarray = [];
      var sqparray = [];
      var tms = await this.GsbByChinaAggApi.AgencyAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length > 0) {
        var arrlen = 10;
        if (cbuckets.length < 10) {
          arrlen = cbuckets.length;
        }

        var maxvalue = cbuckets[0].doc_count;
        for (var i = 0; i < arrlen; i++) {
          apparray.push(cbuckets[i].key);
          allarray.push(cbuckets[i].doc_count);
        }

        var parm = {
          "terms": {
            "agency_name.raw": apparray
          }
        }
        capilist.push(parm);
        tms = await this.GsbByChinaAggApi.AgencyfmsqAggs(capilist);//获取查询结果
        if (tms) {
          if (tms.status == 0) {
            if (tms.buckets.types.buckets) {
              cbuckets = tms.buckets.types.buckets;
            }

          }
        }

        if (cbuckets.length > 0) {
          for (var i = 0; i < apparray.length; i++) {
            sqarray[i] = 0;
            wsqarray[i] = 0;
            sqparray[i] = 0;
          }

          for (var cb in cbuckets) {
            var b = apparray.indexOf(cbuckets[cb].key);
            if (b > -1) {
              sqarray[b] = cbuckets[cb].doc_count;
            }
          }

          for (var i = 0; i < apparray.length; i++) {
            wsqarray[i] = allarray[i] - sqarray[i];
            var sqp = await this.getpercent(sqarray[i], allarray[i]);
            sqparray[i] = parseFloat(sqp.replace("%", ""));
          }

          //拼返回结果
          var echarty = [];
          var tablearray = [];
          var legendvalue = ["未授权", "曾授权", "授权率"];
          var yarray = [{ lable: "未授权", data: wsqarray }, { lable: "曾授权", data: sqarray },
          { lable: "授权率", data: sqparray }];
          var echarts = { max: maxvalue, x: apparray, legend: legendvalue, y: yarray };


          var lablist1 = await this.getrowdata("未授权", wsqarray);
          var lablist2 = await this.getrowdata("曾授权", sqarray);
          var lablist3 = await this.getrowdata("授权率", sqparray);
          var dataarray = [lablist1, lablist2, lablist3];
          var tablevalues = { agency: apparray, data: dataarray };

          return { echart: echarts, table: tablevalues };
        }
        else {
          return null;
        }
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async agentIpc(obj) {//代理人/机构分析-代理机构IPC分布
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "ipc");
    var ipctab = obj.ipcTab;
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = null;
      if (ipctab == "0") {
        tms = await this.GsbByChinaAggApi.AppIpclcAggs(capilist);
      }
      else if (ipctab == "1") {
        tms = await this.GsbByChinaAggApi.AppIpcscAggs(capilist);
      }
      else if (ipctab == "2") {
        tms = await this.GsbByChinaAggApi.AppIpclgAggs(capilist);
      }
      else if (ipctab == "3") {
        tms = await this.GsbByChinaAggApi.AppIpcAggs(capilist);
      }

      var ipcbuckets = [];
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            ipcbuckets = tms.buckets.types.buckets;
          }
        }
      }

      var ipcarray = [];
      if (ipcbuckets.length > 0) {
        var arrlen = 10;
        if (ipcbuckets.length < 10) {
          arrlen = ipcbuckets.length;
        }
        for (var i = 0; i < arrlen; i++) {
          ipcarray.push(ipcbuckets[i].key);
        }

        var parm = null;
        if (ipctab == "0") {
          parm = {
            "terms": {
              "large class": ipcarray
            }
          }
        }
        else if (ipctab == "1") {
          parm = {
            "terms": {
              "sub_class": ipcarray
            }
          }
        }
        else if (ipctab == "2") {
          parm = {
            "terms": {
              "large_group": ipcarray
            }
          }
        }
        else if (ipctab == "3") {
          parm = {
            "terms": {
              "main_ipc": ipcarray
            }
          }

        }
        capilist.push(parm);

        if (ipctab == "0") {
          tms = await this.GsbByChinaAggApi.AgencyLcAggs(capilist);
        }
        else if (ipctab == "1") {
          tms = await this.GsbByChinaAggApi.AgencyScAggs(capilist);
        }
        else if (ipctab == "2") {
          tms = await this.GsbByChinaAggApi.AgencyLgAggs(capilist);
        }
        else if (ipctab == "3") {
          tms = await this.GsbByChinaAggApi.AgencyIpcAggs(capilist);
        }
        if (tms) {
          if (tms.status == 0) {
            if (tms.buckets.group_by_agency.buckets) {
              cbuckets = tms.buckets.group_by_agency.buckets;
            }

          }
        }

        if (cbuckets.length > 0) {
          //拼返回结果
          var echarty = [];
          var tablearray = [];
          var apparray = [];
          var appipcarray = [];
          for (var i = 0; i < cbuckets.length; i++) {
            apparray.push(cbuckets[i].key);
            var applist = [];
            var countlist = cbuckets[i].group_by_ipc.buckets;
            for (var j = 0; j < ipcarray.length; j++) {
              var a = countlist.findIndex(f => f.key == ipcarray[j]);
              if (a > -1) {
                applist.push(countlist[a].doc_count);
              }
              else {
                applist.push(0);
              }
            }
            appipcarray.push(applist);
          }
          for (var i = 0; i < ipcarray.length; i++) {
            var applist1 = [];
            for (var j = 0; j < apparray.length; j++) {
              applist1.push(appipcarray[i][j]);
            }
            echarty.push({ lable: ipcarray[i], data: applist1 });
            var lablist = await this.getrowdata(ipcarray[i], applist1);
            tablearray.push(lablist);
          }


          var echarts = { x: apparray, legend: ipcarray, y: echarty };
          var tablevalues = { agency: apparray, data: tablearray };
          return { echart: echarts, table: tablevalues };
        }
        else {
          return null;
        }

      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async agentPersonRank(obj) {//代理人/机构分析-代理人排名
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var total1 = obj.obj.total == null ? "" : obj.obj.total;
    var total = 0;
    if (total1){
      total = parseInt(total1);
    }
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = await this.GsbByChinaAggApi.AgentAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length > 0) {
        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var namearrary = [];
        var countarray = [];
        var echarttable = [];
        var arrayy1 = [];
        var descstr = "";
        if (cbuckets.length >= 3) {
          for (var i = 0; i < cbuckets.length; i++) {
            if (i == 0) {
              firstname = cbuckets[i].key;
              firstcount = cbuckets[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
            }
            else if (i == 1) {
              sceondname = cbuckets[i].key;
              sceondcount = cbuckets[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
            }
            else if (i == 2) {
              thirdname = cbuckets[i].key;
              thirdcount = cbuckets[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
            }
            namearrary.push(cbuckets[i].key);
            countarray.push(cbuckets[i].doc_count);
            arrayy1.push({ value: cbuckets[i].doc_count, name: cbuckets[i].key });
            echarttable.push({ rank: i + 1, agent: cbuckets[i].key, patent: cbuckets[i].doc_count });
          }

          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + "这三个代理人代理的专利申请的数据量最多，分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析的专利的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (cbuckets.length == 2) {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          namearrary.push(cbuckets[0].key);
          countarray.push(cbuckets[0].doc_count);
          arrayy1.push({ value: cbuckets[0].doc_count, name: cbuckets[0].key });
          echarttable.push({ rank: 1, agent: cbuckets[0].key, patent: cbuckets[0].doc_count });
          sceondname = cbuckets[1].key;;
          sceondcount = cbuckets[1].doc_count;
          namearrary.push(cbuckets[1].key);
          countarray.push(cbuckets[1].doc_count);
          arrayy1.push({ value: cbuckets[1].doc_count, name: cbuckets[1].key });
          echarttable.push({ rank: 2, agent: cbuckets[1].key, patent: cbuckets[1].doc_count });
          sceondpercent = await this.getpercent(sceondcount, total);
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "这两个代理人代理的专利申请的数据量最多，分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析的专利的：" + firstpercent + "、" + sceondpercent + "。";
        }
        else {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          namearrary.push(cbuckets[0].key);
          countarray.push(cbuckets[0].doc_count);
          arrayy1.push({ value: cbuckets[0].doc_count, name: cbuckets[0].key });
          echarttable.push({ rank: 1, agent: cbuckets[0].key, patent: cbuckets[0].doc_count });
          descstr = "从以上图表可以看出，" + firstname + "代理的专利申请的数据量最多，为" + firstcount + "件，占所分析的专利的：" + firstpercent + "。";

        }

        return { echart: { x: namearrary, y: countarray, desc: descstr }, table: echarttable };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async mainAgentPatenttype(obj) {//代理人/机构分析-主要代理人专利类型分布
    var cbuckets = [];
    var rearray = await this.prasecondition(obj, "");
    var capilist = rearray[0];
    if (capilist.length > 0) {
      var tms = await this.GsbByChinaAggApi.AgentPubtypeAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.group_by_agency.buckets) {
            cbuckets = tms.buckets.group_by_agency.buckets;
          }

        }
      }

      if (cbuckets.length > 0) {
        var comarray = [];
        var fmlist = [];
        var xxlist = [];
        var wglist = [];
        for (var cb in cbuckets) {
          comarray.push(cbuckets[cb].key);
          var typelist = cbuckets[cb].group_by_type.buckets;
          if (typelist.length > 0) {
            var a = typelist.findIndex(f => f.key == "发明");
            if (a > -1) {
              fmlist.push(typelist[a].doc_count);
            }
            else {
              fmlist.push(0);
            }

            a = typelist.findIndex(f => f.key == "实用新型");
            if (a > -1) {
              xxlist.push(typelist[a].doc_count);
            }
            else {
              xxlist.push(0);
            }

            a = typelist.findIndex(f => f.key == "外观设计");
            if (a > -1) {
              wglist.push(typelist[a].doc_count);
            }
            else {
              wglist.push(0);
            }
          }
        }

        var yvalues = [{ lable: "外观设计专利", data: wglist }, { lable: "发明申请专利", data: fmlist },
        { lable: "实用新型专利", data: xxlist }];
        var legendvalues = ["外观设计专利", "发明申请专利", "实用新型专利"];
        var echartvalues = { x: comarray, legend: legendvalues, y: yvalues };
        var datavalues = [];
        var lablist = await this.getrowdata("外观设计专利", wglist);
        datavalues.push(lablist);
        lablist = await this.getrowdata("发明申请专利", fmlist);
        datavalues.push(lablist);
        lablist = await this.getrowdata("实用新型专利", xxlist);
        datavalues.push(lablist);

        var tablevalues = { agency: comarray, data: datavalues };
        return { echart: echartvalues, table: tablevalues };
      }
      else {
        return null;
      }
    }
    else {
      return null;
    }
  };

  async aliplace(obj){//区域专利监控-中间地图-国别/省/二级市
    var year=obj.year==null?"":obj.year;
    var areaname=obj.areaname==null?"":obj.areaname;
    var capilistall = [];
    var capilistsq = [];
    var params={"term": {
      "country_name": "中国"
    }
  }
  
  var status2={
    "term":{
      "pub_type":"发明"
    }
  }
  capilistall.push(params);
  capilistall.push(status2);
  capilistsq.push(params);
  if(year){
    var parm = {
      "term": {
        "pub_year": year
      }
    }
    var parm2 = {
      "term": {
        "gr_year": year
      }
    }
    capilistall.push(parm);
    capilistsq.push(parm2);
  }
  if(areaname){
    if (obj.type == 2){
      areaname = await this.getprovincenameorder(areaname);
      var parm = {
        "term": {
          "province_name": areaname
        }
      }
      capilistall.push(parm);
      capilistsq.push(parm);
    }
    else if (obj.type == 3){
      var parm = {
        "term": {
          "city_name": areaname
        }
      }
      capilistall.push(parm);
      capilistsq.push(parm);
    }
    else if (obj.type == 4){
      var parm = {
        "term": {
          "county_name": areaname
        }
      }
      capilistall.push(parm);
      capilistsq.push(parm);
    }
  }
  var tms = await this.GsbByChinaAggApi.provincePubstatusAggs(capilistall,areaname,obj.type);//获取查询结果
  var tmssq = await this.GsbByChinaAggApi.provincePubstatusAggs(capilistsq,areaname,obj.type);//获取查询结果
  //外观设计授权量
   var sqtype={
    "term":{
      "pub_type":"外观设计"
    }
   }
   capilistsq.push(sqtype);
  var tmssqwg = await this.GsbByChinaAggApi.provincePubstatusAggs(capilistsq,areaname,obj.type);//获取查询结果
  //实用新型授权量
  capilistsq[capilistsq.length-1].term.pub_type="实用新型"
  var tmssqsy = await this.GsbByChinaAggApi.provincePubstatusAggs(capilistsq,areaname,obj.type);//获取查询结果
  var sqsumwg=Number(tmssqwg.data.total);
  var sqsumsy=Number(tmssqsy.data.total);

  var allsum=Number(tms.data.total);
  var sqsum=Number(tmssq.data.total);
  var sources=[];
  var self=this;
  var tmslist=tms.buckets.group_by_country.buckets;
  console.log(tmslist);
  for(var j=0;j<tmslist.length;j++){
    var nname=tmslist[j].key;
    if(obj.type==1)
    {
      nname=await self.getprovincename(tmslist[j].key);
    }
    var source={
      "areaname":nname,
      "y_applynum":tmslist[j].doc_count,
      "y_registnum":""
    }
    var index=tmssq.buckets.group_by_country.buckets.findIndex(b=>b.key==tmslist[j].key);
    if(index>-1)
    {
      source.y_registnum=tmssq.buckets.group_by_country.buckets[index].doc_count;
    }
    sources.push(source);
  }
  var asum=sqsum;
  var gsum=allsum;
  var tsources=[];
  var gsources=[]
  var le=10;
  if(tms.buckets.group_by_country.buckets.length<10){
    le=tms.buckets.group_by_country.buckets.length;
  }
  for(var i=0;i<le;i++){
    //授权统计
    var num=Number(tmssq.buckets.group_by_country.buckets[i].doc_count)
    var l=await this.getpercent(num, sqsum);
    var tsource={
      "areaname":tmssq.buckets.group_by_country.buckets[i].key,
      "y_applynum":tmssq.buckets.group_by_country.buckets[i].doc_count,
      "y_percent":l,
      "y_percentnum":l.substr(0,l.length-1)
    }
    tsources.push(tsource);
    asum=asum-num;
    //公开统计
    var gnum=Number(tms.buckets.group_by_country.buckets[i].doc_count)
    var gl=await this.getpercent(gnum, sqsum);
    var gsource={
      "areaname":tms.buckets.group_by_country.buckets[i].key,
      "y_applynum":tms.buckets.group_by_country.buckets[i].doc_count,
      "y_percent":gl
    }
    gsources.push(gsource);
    gsum=gsum-gnum;
  }
  //授权统计
  var l2=await this.getpercent(asum, sqsum);
  var ts={
    "areaname":"其他",
    "y_applynum":asum,
    "y_percent":l2,
    "y_percentnum":l2.split("%")[0]
  }
  tsources.push(ts);
  //公开统计
  var gl2=await this.getpercent(asum, sqsum);
  var gts={
    "areaname":"其他",
    "y_applynum":gsum,
    "y_percent":gl2
  }
  gsources.push(gts);
  var analyse="从以上图表可以看出，" + gsources[0].areaname + "、" + gsources[1].areaname + "、" + gsources[2].areaname　+ "、" + gsources[3].areaname  + " 这四个省拥有的专利公开数量最多，分别为" +
  gsources[0].y_applynum + "件、" + gsources[1].y_applynum + "件、" +gsources[2].y_applynum + "件、" + gsources[3].y_applynum + "件，占所分析专利的" + gsources[0].y_percent + "、" + gsources[1].y_percent + "、" + gsources[2].y_percent + "、" + gsources[3].y_percent + "。";
  var analysesq="从以上图表可以看出，" + tsources[0].areaname + "、" + tsources[1].areaname + "、" + tsources[2].areaname　+ "、" + tsources[3].areaname  + " 这四个省拥有的专利授权数量最多，分别为" +
  tsources[0].y_applynum + "件、" + tsources[1].y_applynum + "件、" +　tsources[2].y_applynum + "件、" + tsources[3].y_applynum + "件，占所分析专利的" + tsources[0].y_percent + "、" + tsources[1].y_percent + "、" + tsources[2].y_percent + "、" + tsources[3].y_percent + "。";
  return {"allsum":allsum,
          "sqsum":sqsum,
          "tdata":tsources,
          "jdata":sources,
          "analyse":analyse,
          "analysesq":analysesq,
          "sqsumwg":sqsumwg,//外观设计
          "sqsumsy":sqsumsy　//实用新型
          }
};

  async aliIpcPub(obj){//区域专利监控-专利IPC分布-公开量
    var year=obj.year==null?"":obj.year;
    var type = obj.type==null?"":obj.type;
    var province=obj.areaname==null?"":obj.areaname;
    var capilist = [];
    var parm = {
      "terms": {
        "pub_type": ["发明"]
      }
    }
    capilist.push(parm);

    parm = {
      "term": {
        "country_name": "中国"
      }
    }

    capilist.push(parm);

    if (year){
      parm = {
        "term": {
          "pub_year": year
        }
      }
      capilist.push(parm);
    }
    
    if (type == "2"){//省份      
      if (province){
        var prov = await this.getprovincenameorder(province);
        parm = {
          "term": {
            "province_name": prov
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "3"){//二级县
      if (province){
        parm = {
          "term": {
            "city_name": province
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "4"){//三级县市
      if (province){
        parm = {
          "term": {
            "county_name": province
          }
        }
        capilist.push(parm);
      }
    }

    if (capilist.length > 0){
      var tms = await this.GsbByChinaAggApi.AppIpcAggs(capilist);
      var cbuckets = [];
      var total = 0;
      if (tms) {
        if (tms.status == 0) {
          total = tms.data.total;
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }

        }
      }

      if (cbuckets.length > 0){
        //var ipcarray = [];//前20IPC
        var arraylen = 20;
        if (cbuckets.length < 20) {
          arraylen = cbuckets.length;
        }

        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var dataarrary = [];
        var descstr = "";
        if (arraylen >= 3) {
          for (var i = 0; i < arraylen; i++) {
            if (i == 0) {
              firstname = cbuckets[i].key;
              firstcount = cbuckets[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
            }
            else if (i == 1) {
              sceondname = cbuckets[i].key;
              sceondcount = cbuckets[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
            }
            else if (i == 2) {
              thirdname = cbuckets[i].key;
              thirdcount = cbuckets[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
            }
            dataarrary.push({code:cbuckets[i].key,num:cbuckets[i].doc_count});
          }

          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三个ipc拥有的专利公开数量最多，分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (arraylen == 2) {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          dataarrary.push({code:cbuckets[0].key,num:cbuckets[0].doc_count})
          sceondname = cbuckets[1].key;
          sceondcount = cbuckets[1].doc_count;
          sceondpercent = await this.getpercent(sceondcount, total);
          dataarrary.push({code:cbuckets[1].key,num:cbuckets[1].doc_count})
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两个ipc拥有的专利公开数量最多，分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";

        }
        else {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          dataarrary.push({code:cbuckets[0].key,num:cbuckets[0].doc_count})
          descstr = "从以上图表可以看出，" + firstname + " 这一个ipc拥有的专利公开数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
        }
        return { data:dataarrary,analyse:descstr};

      }
      else{
        return null;
      }
    }
    else{
      return null;
    }
  };

  async aliIpcGr(obj){//区域专利监控-专利IPC分布-授权量
    var year=obj.year==null?"":obj.year;
    var type = obj.type==null?"":obj.type;
    var province=obj.areaname==null?"":obj.areaname;
    var capilist = [];
    var parm = {
      "terms": {
        "pub_type": ["发明", "实用新型"]
      }
    }
    capilist.push(parm);

    parm = {
      "term": {
        "country_name": "中国"
      }
    }
    capilist.push(parm);

    if (year){
      parm = {
        "term": {
          "gr_year": year
        }
      }
      capilist.push(parm);
    }
    
    if (type == "2"){//省份      
      if (province){
        var prov = await this.getprovincenameorder(province);
        parm = {
          "term": {
            "province_name": prov
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "3"){//二级县
      if (province){
        parm = {
          "term": {
            "city_name": province
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "4"){//三级县市
      if (province){
        parm = {
          "term": {
            "county_name": province
          }
        }
        capilist.push(parm);
      }
    }

    if (capilist.length > 0){
      var tms = await this.GsbByChinaAggApi.AppIpcAggs(capilist);
      var cbuckets = [];
      var total = 0;
      if (tms) {
        if (tms.status == 0) {
          total = tms.data.total;
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }

        }
      }

      if (cbuckets.length > 0){
        //var ipcarray = [];//前20IPC
        var arraylen = 20;
        if (cbuckets.length < 20) {
          arraylen = cbuckets.length;
        }

        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var dataarrary = [];
        var descstr = "";
        if (arraylen >= 3) {
          for (var i = 0; i < arraylen; i++) {
            if (i == 0) {
              firstname = cbuckets[i].key;
              firstcount = cbuckets[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
            }
            else if (i == 1) {
              sceondname = cbuckets[i].key;
              sceondcount = cbuckets[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
            }
            else if (i == 2) {
              thirdname = cbuckets[i].key;
              thirdcount = cbuckets[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
            }
            dataarrary.push({code:cbuckets[i].key,num:cbuckets[i].doc_count});
          }

          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三个ipc拥有的专利授权数量最多，分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (arraylen == 2) {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          dataarrary.push({code:cbuckets[0].key,num:cbuckets[0].doc_count})
          sceondname = cbuckets[1].key;
          sceondcount = cbuckets[1].doc_count;
          sceondpercent = await this.getpercent(sceondcount, total);
          dataarrary.push({code:cbuckets[1].key,num:cbuckets[1].doc_count})
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两个ipc拥有的专利授权数量最多，分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";

        }
        else {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          dataarrary.push({code:cbuckets[0].key,num:cbuckets[0].doc_count})
          descstr = "从以上图表可以看出，" + firstname + " 这一个ipc拥有的专利授权数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
        }
        return { data:dataarrary,analyse:descstr};

      }
      else{
        return null;
      }
    }
    else{
      return null;
    }
  };

  async aliIpc(obj) {//区域专利监控-专利IPC分布
    var reList = [];
    var refiling = await this.aliIpcPub(obj);
    reList.push(refiling);
    var repub = await this.aliIpcGr(obj);
    reList.push(repub);
    return reList;
  };

  async aliCategoryPub(obj){//区域专利监控-门类-公开量
    var year=obj.year==null?"":obj.year;
    var type = obj.type==null?"":obj.type;
    var province=obj.areaname==null?"":obj.areaname;
    var capilist = [];
    var parm = {
      "terms": {
        "pub_type": ["发明"]
      }
    }
    capilist.push(parm);

    parm = {
      "term": {
        "country_name": "中国"
      }
    }

    capilist.push(parm);

    if (year){
      parm = {
        "term": {
          "pub_year": year
        }
      }
      capilist.push(parm);
    }

    if (type == "2"){//省份      
      if (province){
        var prov = await this.getprovincenameorder(province);
        parm = {
          "term": {
            "province_name": prov
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "3"){//二级县
      if (province){
        parm = {
          "term": {
            "city_name": province
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "4"){//三级县市
      if (province){
        parm = {
          "term": {
            "county_name": province
          }
        }
        capilist.push(parm);
      }
    }

    if (capilist.length > 0){
      var tms = await this.GsbByChinaAggApi.CategoryNameAggs(capilist);
      var cbuckets = [];
      var total = 0;
      if (tms) {
        if (tms.status == 0) {
          total = tms.data.total;
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }

        }
      }

      if (cbuckets.length > 0){
        var arraylen = 20;
        if (cbuckets.length < 20) {
          arraylen = cbuckets.length;
        }

        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var dataarrary = [];
        var descstr = "";
        var percent = "0%";
        if (arraylen >= 3) {
          for (var i = 0; i < arraylen; i++) {
            if (i == 0) {
              firstname = cbuckets[i].key;
              firstcount = cbuckets[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
              percent = firstpercent;
            }
            else if (i == 1) {
              sceondname = cbuckets[i].key;
              sceondcount = cbuckets[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
              percent =  sceondpercent;
            }
            else if (i == 2) {
              thirdname = cbuckets[i].key;
              thirdcount = cbuckets[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
              percent = thirdpercent;
            }
            else{
              percent = await this.getpercent(cbuckets[i].doc_count, total);
            }
            dataarrary.push({"areaname":cbuckets[i].key,"y_applynum":cbuckets[i].doc_count,"y_percent":percent,"y_percentnum":percent.substr(0,percent.length-1)});
          }

          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三个行业拥有的专利公开数量最多，分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (arraylen == 2) {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          dataarrary.push({"areaname":cbuckets[0].key,"y_applynum":cbuckets[0].doc_count,"y_percent":firstpercent,"y_percentnum":firstpercent.substr(0,firstpercent.length-1)});
          sceondname = cbuckets[1].key;
          sceondcount = cbuckets[1].doc_count;
          sceondpercent = await this.getpercent(sceondcount, total);
          dataarrary.push({"areaname":cbuckets[1].key,"y_applynum":cbuckets[1].doc_count,"y_percent":sceondpercent,"y_percentnum":sceondpercent.substr(0,sceondpercent.length-1)});
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两个行业拥有的专利公开数量最多，分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";

        }
        else {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          dataarrary.push({"areaname":cbuckets[0].key,"y_applynum":cbuckets[0].doc_count,"y_percent":firstpercent,"y_percentnum":firstpercent.substr(0,firstpercent.length-1)});
          descstr = "从以上图表可以看出，" + firstname + " 这一个行业拥有的专利公开数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
        }
        return { data:dataarrary,analyse:descstr};
      }
      else{
        return null;
      }

    }
    else{
      return null;
    }

  };

  async aliCategoryGr(obj){//区域专利监控-门类-授权量
    var year=obj.year==null?"":obj.year;
    var type = obj.type==null?"":obj.type;
    var province=obj.areaname==null?"":obj.areaname;
    var capilist = [];
    var parm = {
      "terms": {
        "pub_type": ["发明", "实用新型"]
      }
    }
    capilist.push(parm);

    parm = {
      "term": {
        "country_name": "中国"
      }
    }

    capilist.push(parm);

    if (year){
      parm = {
        "term": {
          "gr_year": year
        }
      }
      capilist.push(parm);
    }

    if (type == "2"){//省份      
      if (province){
        var prov = await this.getprovincenameorder(province);
        parm = {
          "term": {
            "province_name": prov
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "3"){//二级县
      if (province){
        parm = {
          "term": {
            "city_name": province
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "4"){//三级县市
      if (province){
        parm = {
          "term": {
            "county_name": province
          }
        }
        capilist.push(parm);
      }
    }

    if (capilist.length > 0){
      var tms = await this.GsbByChinaAggApi.CategoryNameAggs(capilist);
      var cbuckets = [];
      var total = 0;
      if (tms) {
        if (tms.status == 0) {
          total = tms.data.total;
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }

        }
      }

      if (cbuckets.length > 0){
        var arraylen = 20;
        if (cbuckets.length < 20) {
          arraylen = cbuckets.length;
        }

        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var dataarrary = [];
        var descstr = "";
        var percent = "0%";
        if (arraylen >= 3) {
          for (var i = 0; i < arraylen; i++) {
            if (i == 0) {
              firstname = cbuckets[i].key;
              firstcount = cbuckets[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
              percent = firstpercent;
            }
            else if (i == 1) {
              sceondname = cbuckets[i].key;
              sceondcount = cbuckets[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
              percent =  sceondpercent;
            }
            else if (i == 2) {
              thirdname = cbuckets[i].key;
              thirdcount = cbuckets[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
              percent = thirdpercent;
            }
            else{
              percent = await this.getpercent(cbuckets[i].doc_count, total);
            }
            dataarrary.push({"areaname":cbuckets[i].key,"y_applynum":cbuckets[i].doc_count,"y_percent":percent,"y_percentnum":percent.substr(0,percent.length-1)});
          }

          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三个行业拥有的专利公开数量最多，分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (arraylen == 2) {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          dataarrary.push({"areaname":cbuckets[0].key,"y_applynum":cbuckets[0].doc_count,"y_percent":firstpercent,"y_percentnum":firstpercent.substr(0,firstpercent.length-1)});
          sceondname = cbuckets[1].key;
          sceondcount = cbuckets[1].doc_count;
          sceondpercent = await this.getpercent(sceondcount, total);
          dataarrary.push({"areaname":cbuckets[1].key,"y_applynum":cbuckets[1].doc_count,"y_percent":sceondpercent,"y_percentnum":sceondpercent.substr(0,sceondpercent.length-1)});
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两个行业拥有的专利公开数量最多，分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";

        }
        else {
          firstname = cbuckets[0].key;
          firstcount = cbuckets[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          dataarrary.push({"areaname":cbuckets[0].key,"y_applynum":cbuckets[0].doc_count,"y_percent":firstpercent,"y_percentnum":firstpercent.substr(0,firstpercent.length-1)});
          descstr = "从以上图表可以看出，" + firstname + " 这一个行业拥有的专利公开数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
        }
        return { data:dataarrary,analyse:descstr};
      }
      else{
        return null;
      }
    }
    else{
      return null;
    }
  };

  async aliCategory(obj) {//区域专利监控-门类
    var refiling = await this.aliCategoryPub(obj);
    var analyse = "";
    var sources = [];
    if (refiling){
      analyse = refiling.analyse;
      if (refiling.data){
        for (var i=0;i<refiling.data.length;i++){
          var sou = {"areaname":refiling.data[i]["areaname"],"y_applynum":refiling.data[i]["y_applynum"],"y_registnum":""};
          sources.push(sou);
        }
      }
    }
    var repub = await this.aliCategoryGr(obj);
    var analysesq = "";
    var tsources = null;
    if (repub){
      analysesq = repub.analyse;
      tsources = repub.data;
    }
    if (tsources){
      for (var i=0;i<sources.length;i++){
        var index = tsources.findIndex(b=>b["areaname"] == sources[i]["areaname"]);
        if (index > -1){
          sources[i]["y_registnum"] = tsources[index]["y_applynum"];
        }
        
      }
    }
    return {"allsum":0,
            "sqsum":0,
            "analyse":analyse,
            "analysesq":analysesq,
            "tdata":tsources,
            "jdata":sources,
            "sqsumwg":0,
            "sqsumsy":0
           }
  };

  async aliGaode(obj){//区域专利监控-高德结果返回
    var applicant = obj.name==null?"":obj.name;
    var location = obj.location==null?"":obj.location;
    var capilist = [];
    var parm = null;
    var nameinfo = null;
    var locationlist = [];
    if (applicant){
      parm = {
        "term": {
          "applicant_name.raw": applicant
        }
      }
      capilist.push(parm);
      var tms = await this.GsbByChinaAggApi.ApplicantAggs(capilist);
      var total = 0;
      var cbuckets = [];
      if (tms) {
        if (tms.status == 0) {
          total = tms.data.total;
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }

        }
      }
      if (total >0){
        nameinfo = {name:applicant,num:total};
      }
    }
    capilist = [];
    if (location){
      parm =  {
        "geo_distance" : {
        "distance" : "1km",             
        "location" : {
            "lat" : location.lat,
            "lon" : location.lng
        }
       }
      }
      capilist.push(parm);
      var tms = await this.GsbByChinaAggApi.ApplicantAggs(capilist);
      var cbuckets = [];
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }

        }
      }

      if (cbuckets.length > 0){
        var arraylen = 10;
        if (cbuckets.length < 10) {
          arraylen = cbuckets.length;
        }

        for (var i = 0; i < arraylen; i++) {
          locationlist.push({name:cbuckets[i].key,num:cbuckets[i].doc_count});
        }
      }
    }

    return {
      "nameinfo":nameinfo,
      "locationlist":locationlist
    }

  };

  async aliApplicantPub(obj){//区域专利监控-申请人分布详情-公开量
    var year=obj.year==null?"":obj.year;
    var type = obj.type==null?"":obj.type;
    var province=obj.areaname==null?"":obj.areaname;
    var capilist = [];
    var parm = {
      "term": {
        "country_name": "中国"
      }
    }
    capilist.push(parm);

    parm = {
      "term": {
        "pub_type": "发明"
      }
    }
    capilist.push(parm);

    if (year){
      parm = {
        "term": {
          "pub_year": year
        }
      }
      capilist.push(parm);
    }

    if (type == "2"){//省份
      if (province){
        var prov = await this.getprovincenameorder(province);
        parm = {
          "term": {
            "province_name": prov
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "3"){//二级县
      if (province){
        parm = {
          "term": {
            "city_name": province
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "4"){//三级县市
      if (province){
        parm = {
          "term": {
            "county_name": province
          }
        }
        capilist.push(parm);
      }
    }

    var tms = await this.GsbByChinaAggApi.ApplicantAggs(capilist);//获取查询结果
    var cbuckets = [];
    var total;
    if (tms) {
      if (tms.status == 0) {
        total = tms.data.total;
        if (tms.buckets.types.buckets) {
          cbuckets = tms.buckets.types.buckets;
        }

      }
    }

    if (cbuckets.length > 0) {
      var arraylen = 20;
      if (cbuckets.length < 20) {
        arraylen = cbuckets.length;
      }

      var firstname = "";
      var sceondname = "";
      var thirdname = "";
      var firstcount = 0;
      var sceondcount = 0;
      var thirdcount = 0;
      var firstpercent = "0%";
      var sceondpercent = "0%";
      var thirdpercent = "0%";
      var dataarrary = [];
      var descstr = "";
      if (arraylen >= 3) {
        for (var i = 0; i < arraylen; i++) {
          if (i == 0) {
            firstname = cbuckets[i].key;
            firstcount = cbuckets[i].doc_count;
            firstpercent = await this.getpercent(firstcount, total);
          }
          else if (i == 1) {
            sceondname = cbuckets[i].key;
            sceondcount = cbuckets[i].doc_count;
            sceondpercent = await this.getpercent(sceondcount, total);
          }
          else if (i == 2) {
            thirdname = cbuckets[i].key;
            thirdcount = cbuckets[i].doc_count;
            thirdpercent = await this.getpercent(thirdcount, total);
          }
          dataarrary.push({entname:cbuckets[i].key,num:cbuckets[i].doc_count});
        }

        descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三个申请人公开的数量最多，分别为" +
          firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
          "、" + thirdpercent + "。";
      }
      else if (arraylen == 2) {
        firstname = cbuckets[0].key;
        firstcount = cbuckets[0].doc_count;
        firstpercent = await this.getpercent(firstcount, total);
        sceondname = cbuckets[1].key;
        sceondcount = cbuckets[1].doc_count;
        sceondpercent = await this.getpercent(sceondcount, total);
        dataarrary.push({entname:cbuckets[0].key,num:cbuckets[0].doc_count});
        dataarrary.push({entname:cbuckets[1].key,num:cbuckets[1].doc_count});
        descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两个申请人公开的数量最多，分别为" + firstcount + "件、" + sceondcount
          + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";

      }
      else {
        firstname = cbuckets[0].key;
        firstcount = cbuckets[0].doc_count;
        firstpercent = await this.getpercent(firstcount, total);
        dataarrary.push({entname:cbuckets[0].key,num:cbuckets[0].doc_count});
        descstr = "从以上图表可以看出，" + firstname + " 这一个申请人公开的数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
      }
      return { data:dataarrary,analyse:descstr};
    }
    else{
      return null;
    }
  };

  async aliApplicantGr(obj){//区域专利监控-申请人分布详情-授权量
    var year=obj.year==null?"":obj.year;
    var type = obj.type==null?"":obj.type;
    var province=obj.areaname==null?"":obj.areaname;
    var capilist = [];
    var parm = {
      "term": {
        "country_name": "中国"
      }
    }
    capilist.push(parm);
    if (year){
      parm = {
        "term": {
          "gr_year": year
        }
      }
      capilist.push(parm);
    }

    if (type == "2"){//省份
      if (province){
        var prov = await this.getprovincenameorder(province);
        parm = {
          "term": {
            "province_name": prov
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "3"){//二级县
      if (province){
        parm = {
          "term": {
            "city_name": province
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "4"){//三级县市
      if (province){
        parm = {
          "term": {
            "county_name": province
          }
        }
        capilist.push(parm);
      }
    }

    var tms = await this.GsbByChinaAggApi.ApplicantAggs(capilist);//获取查询结果
    var cbuckets = [];
    var total = 0;
    if (tms) {
      if (tms.status == 0) {
        total = tms.data.total;
        if (tms.buckets.types.buckets) {
          cbuckets = tms.buckets.types.buckets;
        }

      }
    }

    if (cbuckets.length > 0) {
      var arraylen = 20;
      if (cbuckets.length < 20) {
        arraylen = cbuckets.length;
      }

      var firstname = "";
      var sceondname = "";
      var thirdname = "";
      var firstcount = 0;
      var sceondcount = 0;
      var thirdcount = 0;
      var firstpercent = "0%";
      var sceondpercent = "0%";
      var thirdpercent = "0%";
      var dataarrary = [];
      var descstr = "";
      if (arraylen >= 3) {
        for (var i = 0; i < arraylen; i++) {
          if (i == 0) {
            firstname = cbuckets[i].key;
            firstcount = cbuckets[i].doc_count;
            firstpercent = await this.getpercent(firstcount, total);
          }
          else if (i == 1) {
            sceondname = cbuckets[i].key;
            sceondcount = cbuckets[i].doc_count;
            sceondpercent = await this.getpercent(sceondcount, total);
          }
          else if (i == 2) {
            thirdname = cbuckets[i].key;
            thirdcount = cbuckets[i].doc_count;
            thirdpercent = await this.getpercent(thirdcount, total);
          }
          dataarrary.push({entname:cbuckets[i].key,num:cbuckets[i].doc_count});
        }

        descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三个申请人授权的数量最多，分别为" +
          firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
          "、" + thirdpercent + "。";
      }
      else if (arraylen == 2) {
        firstname = cbuckets[0].key;
        firstcount = cbuckets[0].doc_count;
        firstpercent = await this.getpercent(firstcount, total);
        sceondname = cbuckets[1].key;
        sceondcount = cbuckets[1].doc_count;
        sceondpercent = await this.getpercent(sceondcount, total);
        dataarrary.push({entname:cbuckets[0].key,num:cbuckets[0].doc_count});
        dataarrary.push({entname:cbuckets[1].key,num:cbuckets[1].doc_count});
        descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两个申请人授权的数量最多，分别为" + firstcount + "件、" + sceondcount
          + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";

      }
      else {
        firstname = cbuckets[0].key;
        firstcount = cbuckets[0].doc_count;
        firstpercent = await this.getpercent(firstcount, total);
        dataarrary.push({entname:cbuckets[0].key,num:cbuckets[0].doc_count});
        descstr = "从以上图表可以看出，" + firstname + " 这一个申请人授权的数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
      }
      return { data:dataarrary,analyse:descstr};
    }
    else{
      return null;
    }
  };

  async aliApplicant(obj) {//区域专利监控-申请人分布详情
    var reList = [];
    var refiling = await this.aliApplicantPub(obj);
    reList.push(refiling);
    var repub = await this.aliApplicantGr(obj);
    reList.push(repub);
    return reList;
  };

  async aliPubstatusnow(obj){//区域专利监控-法律状态分布详情
    var year=obj.year==null?"":obj.year;
    var type = obj.type==null?"":obj.type;
    var province=obj.areaname==null?"":obj.areaname;
    var capilist = [];
    var parm = {
      "term": {
        "country_name": "中国"
      }
    }
    capilist.push(parm);

    if (year){
      parm = {
        "term": {
          "pub_year": year
        }
      }
      capilist.push(parm);
    }

    if (type == "2"){//省份
      if (province){
        var prov = await this.getprovincenameorder(province);
        parm = {
          "term": {
            "province_name": prov
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "3"){//二级县
      if (province){
        parm = {
          "term": {
            "city_name": province
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "4"){//三级县市
      if (province){
        parm = {
          "term": {
            "county_name": province
          }
        }
        capilist.push(parm);
      }
    }

    var tms = await this.GsbByChinaAggApi.PubstatusnowAggs(capilist);//获取查询结果
    var cbuckets =[];
    var total = 0;
    if (tms) {
      if (tms.status == 0) {
        total = tms.data.total;
        if (tms.buckets.types.buckets) {
          cbuckets = tms.buckets.types.buckets;
        }
      }
    }

    if (cbuckets.length > 0) {
      var firstname = "";
      var sceondname = "";
      var thirdname = "";
      var firstcount = 0;
      var sceondcount = 0;
      var thirdcount = 0;
      var firstpercent = "0%";
      var sceondpercent = "0%";
      var thirdpercent = "0%";
      var dataarrary = [];
      var descstr = "";
      if (cbuckets.length >= 3) {
        for (var i = 0; i < cbuckets.length; i++) {
          if (i == 0) {
            firstname = cbuckets[i].key;
            firstcount = cbuckets[i].doc_count;
            firstpercent = await this.getpercent(firstcount, total);
          }
          else if (i == 1) {
            sceondname = cbuckets[i].key;
            sceondcount = cbuckets[i].doc_count;
            sceondpercent = await this.getpercent(sceondcount, total);
          }
          else if (i == 2) {
            thirdname = cbuckets[i].key;
            thirdcount = cbuckets[i].doc_count;
            thirdpercent = await this.getpercent(thirdcount, total);
          }
          dataarrary.push({statusname:cbuckets[i].key,num: cbuckets[i].doc_count});
        }

        descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + "这三种当前状态下拥有的专利的数据量最多，分别为" +
          firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析的专利总量的" + firstpercent + "、" + sceondpercent +
          "、" + thirdpercent + "。";
      }
      else if (cbuckets.length == 2) {
        firstname = cbuckets[0].key;
        firstcount = cbuckets[0].doc_count;
        firstpercent = await this.getpercent(firstcount, total);
        dataarrary.push({statusname:cbuckets[0].key,num: cbuckets[0].doc_count});
        sceondname = cbuckets[1].key;;
        sceondcount = cbuckets[1].doc_count;
        sceondpercent = await this.getpercent(sceondcount, total);
        dataarrary.push({statusname:cbuckets[1].key,num: cbuckets[1].doc_count});
        descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "这两种当前状态下拥有的专利的数据量最多，分别为" + firstcount + "件、" + sceondcount
          + "件，占所分析的专利总量的：" + firstpercent + "、" + sceondpercent + "。";
      }
      else {
        firstname = cbuckets[0].key;
        firstcount = cbuckets[0].doc_count;
        firstpercent = await this.getpercent(firstcount, total);
        dataarrary.push({statusname:cbuckets[0].key,num: cbuckets[0].doc_count});
        descstr = "从以上图表可以看出，" + firstname + "这种当前状态下拥有的专利的数据量最多，为" + firstcount + "件，占所分析的专利总量的：" + firstpercent + "。";

      }

      return { data: dataarrary,analyse:descstr};
    }
    else {
      return null;
    }
  };


  async aliAgencyPub(obj){//区域专利监控首页 - 代理机构排名详情-公开量
    var year=obj.year==null?"":obj.year;
    var type = obj.type==null?"":obj.type;
    var province=obj.areaname==null?"":obj.areaname;
    var capilist = [];
    var parm = {
      "term": {
        "country_name": "中国"
      }
    }
    capilist.push(parm);

    parm = {
      "term": {
        "pub_type": "发明"
      }
    }
    capilist.push(parm);

    if (year){
      parm = {
        "term": {
          "pub_year": year
        }
      }
      capilist.push(parm);
    }

    if (type == "2"){//省份
      if (province){
        var prov = await this.getprovincenameorder(province);
        parm = {
          "term": {
            "province_name": prov
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "3"){//二级县
      if (province){
        parm = {
          "term": {
            "city_name": province
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "4"){//三级县市
      if (province){
        parm = {
          "term": {
            "county_name": province
          }
        }
        capilist.push(parm);
      }
    }

    var total =0;
    var cbuckets = [];
    var tms = await this.GsbByChinaAggApi.AgencyAggs(capilist);//获取查询结果
    if (tms) {
      if (tms.status == 0) {
        total = tms.data.total;
        if (tms.buckets.types.buckets) {
          cbuckets = tms.buckets.types.buckets;
        }
      }
    }

    if (cbuckets.length > 0) {
      var firstname = "";
      var sceondname = "";
      var thirdname = "";
      var firstcount = 0;
      var sceondcount = 0;
      var thirdcount = 0;
      var firstpercent = "0%";
      var sceondpercent = "0%";
      var thirdpercent = "0%";
      var dataarrary = [];
      var descstr = "";
      if (cbuckets.length >= 3) {
        for (var i = 0; i < cbuckets.length; i++) {
          if (i == 0) {
            firstname = cbuckets[i].key;
            firstcount = cbuckets[i].doc_count;
            firstpercent = await this.getpercent(firstcount, total);
          }
          else if (i == 1) {
            sceondname = cbuckets[i].key;
            sceondcount = cbuckets[i].doc_count;
            sceondpercent = await this.getpercent(sceondcount, total);
          }
          else if (i == 2) {
            thirdname = cbuckets[i].key;
            thirdcount = cbuckets[i].doc_count;
            thirdpercent = await this.getpercent(thirdcount, total);
          }
          dataarrary.push({agencyname:cbuckets[i].key,num:cbuckets[i].doc_count});
        }

        descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + "这三个代理机构代理的专利公开的数据量最多，分别为" +
          firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析的专利的" + firstpercent + "、" + sceondpercent +
          "、" + thirdpercent + "。";
      }
      else if (cbuckets.length == 2) {
        firstname = cbuckets[0].key;
        firstcount = cbuckets[0].doc_count;
        firstpercent = await this.getpercent(firstcount, total);
        dataarrary.push({agencyname:cbuckets[0].key,num:cbuckets[0].doc_count});
        sceondname = cbuckets[1].key;;
        sceondcount = cbuckets[1].doc_count;
        sceondpercent = await this.getpercent(sceondcount, total);
        dataarrary.push({agencyname:cbuckets[1].key,num:cbuckets[1].doc_count});
        descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "这两个代理机构代理的专利公开的数据量最多，分别为" + firstcount + "件、" + sceondcount
          + "件，占所分析的专利的：" + firstpercent + "、" + sceondpercent + "。";
      }
      else {
        firstname = cbuckets[0].key;
        firstcount = cbuckets[0].doc_count;
        firstpercent = await this.getpercent(firstcount, total);
        dataarrary.push({agencyname:cbuckets[0].key,num:cbuckets[0].doc_count});
        descstr = "从以上图表可以看出，" + firstname + "代理的专利公开的数据量最多，为" + firstcount + "件，占所分析的专利的：" + firstpercent + "。";

      }
      return { data:dataarrary,analyse:descstr};
    }
    else {
      return null;
    }

  };
  
  async aliAgencyGr(obj){//区域专利监控首页 - 代理机构排名详情-授权量
    var year=obj.year==null?"":obj.year;
    var type = obj.type==null?"":obj.type;
    var province=obj.areaname==null?"":obj.areaname;
    var capilist = [];

    var parm = {
      "term": {
        "country_name": "中国"
      }
    }
    capilist.push(parm);

    if (year){
      parm = {
        "term": {
          "gr_year": year
        }
      }
      capilist.push(parm);
    }

    if (type == "2"){//省份
      if (province){
        var prov = await this.getprovincenameorder(province);
        parm = {
          "term": {
            "province_name": prov
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "3"){//二级县
      if (province){
        parm = {
          "term": {
            "city_name": province
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "4"){//三级县市
      if (province){
        parm = {
          "term": {
            "county_name": province
          }
        }
        capilist.push(parm);
      }
    }

    var total =0;
    var cbuckets = [];
    var tms = await this.GsbByChinaAggApi.AgencyAggs(capilist);//获取查询结果
    if (tms) {
      if (tms.status == 0) {
        total = tms.data.total;
        if (tms.buckets.types.buckets) {
          cbuckets = tms.buckets.types.buckets;
        }
      }
    }

    if (cbuckets.length > 0) {
      var firstname = "";
      var sceondname = "";
      var thirdname = "";
      var firstcount = 0;
      var sceondcount = 0;
      var thirdcount = 0;
      var firstpercent = "0%";
      var sceondpercent = "0%";
      var thirdpercent = "0%";
      var dataarrary = [];
      var descstr = "";
      if (cbuckets.length >= 3) {
        for (var i = 0; i < cbuckets.length; i++) {
          if (i == 0) {
            firstname = cbuckets[i].key;
            firstcount = cbuckets[i].doc_count;
            firstpercent = await this.getpercent(firstcount, total);
          }
          else if (i == 1) {
            sceondname = cbuckets[i].key;
            sceondcount = cbuckets[i].doc_count;
            sceondpercent = await this.getpercent(sceondcount, total);
          }
          else if (i == 2) {
            thirdname = cbuckets[i].key;
            thirdcount = cbuckets[i].doc_count;
            thirdpercent = await this.getpercent(thirdcount, total);
          }
          dataarrary.push({agencyname:cbuckets[i].key,num:cbuckets[i].doc_count});
        }

        descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + "这三个代理机构代理的专利授权的数据量最多，分别为" +
          firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析的专利的" + firstpercent + "、" + sceondpercent +
          "、" + thirdpercent + "。";
      }
      else if (cbuckets.length == 2) {
        firstname = cbuckets[0].key;
        firstcount = cbuckets[0].doc_count;
        firstpercent = await this.getpercent(firstcount, total);
        dataarrary.push({agencyname:cbuckets[0].key,num:cbuckets[0].doc_count});
        sceondname = cbuckets[1].key;;
        sceondcount = cbuckets[1].doc_count;
        sceondpercent = await this.getpercent(sceondcount, total);
        dataarrary.push({agencyname:cbuckets[1].key,num:cbuckets[1].doc_count});
        descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "这两个代理机构代理的专利授权的数据量最多，分别为" + firstcount + "件、" + sceondcount
          + "件，占所分析的专利的：" + firstpercent + "、" + sceondpercent + "。";
      }
      else {
        firstname = cbuckets[0].key;
        firstcount = cbuckets[0].doc_count;
        firstpercent = await this.getpercent(firstcount, total);
        dataarrary.push({agencyname:cbuckets[0].key,num:cbuckets[0].doc_count});
        descstr = "从以上图表可以看出，" + firstname + "代理的专利授权的数据量最多，为" + firstcount + "件，占所分析的专利的：" + firstpercent + "。";

      }
      return { data:dataarrary,analyse:descstr};
    }
    else {
      return null;
    }


  };

  async aliAgency(obj){//区域专利监控首页 - 代理机构排名详情
    var reList = [];
    var refiling = await this.aliAgencyPub(obj);
    reList.push(refiling);
    var repub = await this.aliAgencyGr(obj);
    reList.push(repub);
    return reList;
  };

  async aliTrendPub(obj){//区域专利监控首页 - 趋势详情-公开
    var year=obj.year==null?"":obj.year;
    var type = obj.type==null?"":obj.type;
    var province=obj.areaname==null?"":obj.areaname;
    var capilist = [];
    var parm = {
      "term": {
        "country_name": "中国"
      }
    }
    capilist.push(parm);

    parm = {
      "term": {
        "pub_type": "发明"
      }
    }
    capilist.push(parm);

    if (year){
      parm = {
        "term": {
          "pub_year": year
        }
      }
      capilist.push(parm);
    }

    if (type == "2"){//省份
      if (province){
        var prov = await this.getprovincenameorder(province);
        parm = {
          "term": {
            "province_name": prov
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "3"){//二级县
      if (province){
        parm = {
          "term": {
            "city_name": province
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "4"){//三级县市
      if (province){
        parm = {
          "term": {
            "county_name": province
          }
        }
        capilist.push(parm);
      }
    }

    //若没选年用年聚合，否者用月聚合
    if (year){
      var total = 0;
      var buckets = [];
      var tms = await this.GsbByChinaAggApi.pubmonthAggs(capilist);
      if (tms) {
        if (tms.status == 0) {
          total = tms.data.total;
          if (tms.buckets.types.buckets) {
            buckets = tms.buckets.types.buckets;
          }
        }
      }

      if (buckets.length > 0){
        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var dataarrary = [];
        var descstr = "";
  
        var doc_countarray = await this.Arrayobjoper(buckets, dataarrary);
  
        if (doc_countarray.length >= 3) {
          for (var i = 0; i < doc_countarray.length; i++) {
            if (i == 0) {
              firstname = doc_countarray[i].key;
              firstcount = doc_countarray[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
            }
            else if (i == 1) {
              sceondname = doc_countarray[i].key;
              sceondcount = doc_countarray[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
            }
            else if (i == 2) {
              thirdname = doc_countarray[i].key;
              thirdcount = doc_countarray[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
            }
          }
  
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三月公开的数量最多，分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (doc_countarray.length == 2) {
          firstname = doc_countarray[0].key;
          firstcount = doc_countarray[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          sceondname = doc_countarray[1].key;
          sceondcount = doc_countarray[1].doc_count;
          sceondpercent = await this.getpercent(sceondcount, total);
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两月公开的数量最多，分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";
  
        }
        else {
          firstname = doc_countarray[0].key;
          firstcount = doc_countarray[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          descstr = "从以上图表可以看出，" + firstname + " 这一月公开的数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
        }
  
        for (var i = 0; i < buckets.length; i++) {
          dataarrary.push({year:buckets[i].key,num:buckets[i].doc_count});
        }
        return { data:dataarrary,analyse:descstr};
      }
      else{
        return null;
      }

    }
    else{
      var total = 0;
      var buckets = [];
      var tms = await this.GsbByChinaAggApi.pubyearAggs(capilist);
      if (tms) {
        if (tms.status == 0) {
          total = tms.data.total;
          if (tms.buckets.types.buckets) {
            buckets = tms.buckets.types.buckets;
          }
        }
      }
  
      if (buckets.length > 0){
        var compare = function (prop) {
          return function (obj1, obj2) {
            var val1 = obj1[prop];
            var val2 = obj2[prop];
            if (val1 < val2) {
              return -1;
            } else if (val1 > val2) {
              return 1;
            } else {
              return 0;
            }
          }
        }
  
        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var dataarrary = [];
        var descstr = "";
  
        var doc_countarray = await this.Arrayobjoper(buckets, dataarrary);
  
        if (doc_countarray.length >= 3) {
          for (var i = 0; i < doc_countarray.length; i++) {
            if (i == 0) {
              firstname = doc_countarray[i].key;
              firstcount = doc_countarray[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
            }
            else if (i == 1) {
              sceondname = doc_countarray[i].key;
              sceondcount = doc_countarray[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
            }
            else if (i == 2) {
              thirdname = doc_countarray[i].key;
              thirdcount = doc_countarray[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
            }
          }
  
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三年公开的数量最多，分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (doc_countarray.length == 2) {
          firstname = doc_countarray[0].key;
          firstcount = doc_countarray[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          sceondname = doc_countarray[1].key;
          sceondcount = doc_countarray[1].doc_count;
          sceondpercent = await this.getpercent(sceondcount, total);
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两年公开的数量最多，分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";
  
        }
        else {
          firstname = doc_countarray[0].key;
          firstcount = doc_countarray[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          descstr = "从以上图表可以看出，" + firstname + " 这一年公开的数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
        }
  
  
        var sortarray = [];
        sortarray = sortarray.concat(buckets);
        buckets.sort(compare("key"));
        for (var i = 0; i < buckets.length; i++) {
          dataarrary.push({year:buckets[i].key,num:buckets[i].doc_count});
        }
        return { data:dataarrary,analyse:descstr};
      }
      else{
        return null;
      }
    }
 
  };

  async aliTrendGr(obj){//区域专利监控首页 - 趋势详情-授权
    var year=obj.year==null?"":obj.year;
    var type = obj.type==null?"":obj.type;
    var province=obj.areaname==null?"":obj.areaname;
    var capilist = [];

    var parm = {
      "term": {
        "country_name": "中国"
      }
    }
    capilist.push(parm);

    if (year){
      parm = {
        "term": {
          "gr_year": year
        }
      }
      capilist.push(parm);
    }

    if (type == "2"){//省份
      if (province){
        var prov = await this.getprovincenameorder(province);
        parm = {
          "term": {
            "province_name": prov
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "3"){//二级县
      if (province){
        parm = {
          "term": {
            "city_name": province
          }
        }
        capilist.push(parm);
      }
    }
    else if (type == "4"){//三级县市
      if (province){
        parm = {
          "term": {
            "county_name": province
          }
        }
        capilist.push(parm);
      }
    }

    if (year){
      var total = 0;
      var buckets = [];
      var tms = await this.GsbByChinaAggApi.grmonthAggs(capilist);
      if (tms) {
        if (tms.status == 0) {
          total = tms.data.total;
          if (tms.buckets.types.buckets) {
            buckets = tms.buckets.types.buckets;
          }
        }
      }

      if (buckets.length > 0){
        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var dataarrary = [];
        var descstr = "";
  
        var doc_countarray = await this.Arrayobjoper(buckets, dataarrary);
  
        if (doc_countarray.length >= 3) {
          for (var i = 0; i < doc_countarray.length; i++) {
            if (i == 0) {
              firstname = doc_countarray[i].key;
              firstcount = doc_countarray[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
            }
            else if (i == 1) {
              sceondname = doc_countarray[i].key;
              sceondcount = doc_countarray[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
            }
            else if (i == 2) {
              thirdname = doc_countarray[i].key;
              thirdcount = doc_countarray[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
            }
          }
  
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三月授权的数量最多，分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (doc_countarray.length == 2) {
          firstname = doc_countarray[0].key;
          firstcount = doc_countarray[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          sceondname = doc_countarray[1].key;
          sceondcount = doc_countarray[1].doc_count;
          sceondpercent = await this.getpercent(sceondcount, total);
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两月授权的数量最多，分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";
  
        }
        else {
          firstname = doc_countarray[0].key;
          firstcount = doc_countarray[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          descstr = "从以上图表可以看出，" + firstname + " 这一月授权的数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
        }
  
        for (var i = 0; i < buckets.length; i++) {
          dataarrary.push({year:buckets[i].key,num:buckets[i].doc_count});
        }
        return { data:dataarrary,analyse:descstr};
      }
      else{
        return null;
      }
    }
    else{
      var total = 0;
      var buckets = [];
      var tms = await this.GsbByChinaAggApi.GryearAggs(capilist);
      if (tms) {
        if (tms.status == 0) {
          total = tms.data.total;
          if (tms.buckets.types.buckets) {
            buckets = tms.buckets.types.buckets;
          }
        }
      }
  
      if (buckets.length > 0){
        var compare = function (prop) {
          return function (obj1, obj2) {
            var val1 = obj1[prop];
            var val2 = obj2[prop];
            if (val1 < val2) {
              return -1;
            } else if (val1 > val2) {
              return 1;
            } else {
              return 0;
            }
          }
        }
  
        var firstname = "";
        var sceondname = "";
        var thirdname = "";
        var firstcount = 0;
        var sceondcount = 0;
        var thirdcount = 0;
        var firstpercent = "0%";
        var sceondpercent = "0%";
        var thirdpercent = "0%";
        var dataarrary = [];
        var descstr = "";
  
        var doc_countarray = await this.Arrayobjoper(buckets, dataarrary);
  
        if (doc_countarray.length >= 3) {
          for (var i = 0; i < doc_countarray.length; i++) {
            if (i == 0) {
              firstname = doc_countarray[i].key;
              firstcount = doc_countarray[i].doc_count;
              firstpercent = await this.getpercent(firstcount, total);
            }
            else if (i == 1) {
              sceondname = doc_countarray[i].key;
              sceondcount = doc_countarray[i].doc_count;
              sceondpercent = await this.getpercent(sceondcount, total);
            }
            else if (i == 2) {
              thirdname = doc_countarray[i].key;
              thirdcount = doc_countarray[i].doc_count;
              thirdpercent = await this.getpercent(thirdcount, total);
            }
          }
  
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + "、" + thirdname + " 这三年授权的数量最多，分别为" +
            firstcount + "件、" + sceondcount + "件、" + thirdcount + "件，占所分析专利的" + firstpercent + "、" + sceondpercent +
            "、" + thirdpercent + "。";
        }
        else if (doc_countarray.length == 2) {
          firstname = doc_countarray[0].key;
          firstcount = doc_countarray[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          sceondname = doc_countarray[1].key;
          sceondcount = doc_countarray[1].doc_count;
          sceondpercent = await this.getpercent(sceondcount, total);
          descstr = "从以上图表可以看出，" + firstname + "、" + sceondname + " 这两年授权的数量最多，分别为" + firstcount + "件、" + sceondcount
            + "件，占所分析专利的" + firstpercent + "、" + sceondpercent + "。";
  
        }
        else {
          firstname = doc_countarray[0].key;
          firstcount = doc_countarray[0].doc_count;
          firstpercent = await this.getpercent(firstcount, total);
          descstr = "从以上图表可以看出，" + firstname + " 这一年授权的数量最多，为" + firstcount + "件，占所分析专利的" + firstpercent + "。";
        }
  
        var sortarray = [];
        sortarray = sortarray.concat(buckets);
        buckets.sort(compare("key"));
        for (var i = 0; i < buckets.length; i++) {
          dataarrary.push({year:buckets[i].key,num:buckets[i].doc_count});
        }
        return { data:dataarrary,analyse:descstr};
      }
      else{
        return null;
      }
    }

   
  };

  async aliTrend(obj){//区域专利监控首页 - 趋势详情
    var reList = [];
    var refiling = await this.aliTrendPub(obj);
    reList.push(refiling);
    var repub = await this.aliTrendGr(obj);
    reList.push(repub);
    return reList;
  };

  async aliBusinessDecision(obj){//企业决策
    var year=obj.year==null?"":obj.year;
    var applicant=obj.entName==null?"":obj.entName;
    var capilist = [];
    //用于授权聚合参数
    var grlist = [];
    var parm = null;

    if (applicant){
      parm = {
        "term": {
          "applicant_name.raw": applicant
        }
      }
      capilist.push(parm);
      grlist.push(parm);
    }

    if (year){
      parm = {
        "term": {
          "pub_year": year
        }
      }
      capilist.push(parm);

      parm = {
        "term": {
          "gr_year": year
        }
      }
      grlist.push(parm);
    }

    if (capilist.length > 0){
      var reProfile = null;//企业专利概况
      var reTypestatistic = [];//专利类型统计
      var reStatestatistic = [];//企业专利法律状态分布
      var reApplytrend = null;//企业专利趋势
      var applylist = [];//企业专利公开趋势
      var empowerlist = [];//企业专利授权趋势
      var reDistribution = [];//专利产业布局
      var reIpc = [];//企业技术构成分析
      var reTitle = [];//标题，最多20个
      var total = 0;
      var cbuckets = [];
      var tms = await this.GsbByChinaAggApi.PubstatusAggs(capilist);//获取查询结果
      if (tms) {
        if (tms.status == 0) {
          total = tms.data.total;
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length > 0){
        var youxiao = 0;
        var wuxiao =0;
        var pub =0;
        for (var i = 0; i < cbuckets.length; i++) {
          if (cbuckets[i].key =="在审"){
            pub = cbuckets[i].doc_count;
          }
          else if (cbuckets[i].key == "有效"){
            youxiao = cbuckets[i].doc_count;
          }
          else if (cbuckets[i].key == "无效"){
            wuxiao = cbuckets[i].doc_count;
          }
        }

        reProfile = {sum:total,pubnum:pub,validnum:youxiao,unvalidnum:wuxiao}
      }

      total = 0;
      cbuckets = [];
      tms = await this.GsbByChinaAggApi.KeyWordAggs(capilist);//获取查询结果;
      if (tms){
        if (tms.status == 0) {
          total = tms.data.total;
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length >0){
        for (var i = 0; i < cbuckets.length; i++) {
          reTitle.push({name:cbuckets[i].key,value:cbuckets[i].doc_count});
        }
        
      }


      total =0;
      cbuckets = [];
      tms = await this.GsbByChinaAggApi.PubTypeAggs(capilist);//获取查询结果
      if (tms){
        if (tms.status == 0) {
          total = tms.data.total;
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length >0){
        for (var i = 0; i < cbuckets.length; i++) {
          reTypestatistic.push({typename:cbuckets[i].key,value:cbuckets[i].doc_count});
        }
        
      }

      total = 0;
      cbuckets = [];
      tms = await this.GsbByChinaAggApi.PubstatusnowAggs(capilist);//获取查询结果
      if (tms){
        if (tms.status == 0) {
          total = tms.data.total;
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length >0){
        for (var i = 0; i < cbuckets.length; i++) {
          reStatestatistic.push({statename:cbuckets[i].key,value:cbuckets[i].doc_count});
        }
        
      }

      total = 0;
      cbuckets =[];
      tms = await this.GsbByChinaAggApi.AppIpcAggs(capilist);
      if (tms){
        if (tms.status == 0) {
          total = tms.data.total;
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length >0){
        for (var i = 0; i < cbuckets.length; i++) {
          reIpc.push({code:cbuckets[i].key,num:cbuckets[i].doc_count});
        }
        
      }

      //专利产业布局
      total = 0;
      cbuckets = [];
      tms = await this.GsbByChinaAggApi.CategoryNameAggs(capilist);//获取查询结果;
      if (tms){
        if (tms.status == 0) {
          total = tms.data.total;
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length >0){
        for (var i = 0; i < cbuckets.length; i++) {
          reDistribution.push({industryname:cbuckets[i].key,value:cbuckets[i].doc_count});
        }
        
      }


      //企业专利公开趋势
      parm = {
        "term": {
          "pub_type": "发明"
        }
      }
      capilist.push(parm);

      var compare = function (prop) {
        return function (obj1, obj2) {
          var val1 = obj1[prop];
          var val2 = obj2[prop];
          if (val1 < val2) {
            return -1;
          } else if (val1 > val2) {
            return 1;
          } else {
            return 0;
          }
        }
      }

      //若没选年用年聚合，否者用月聚合
      if (!year){
        var minyear = 0;
        var maxyear = 0;
  
        total = 0;
        cbuckets = [];
        tms = await this.GsbByChinaAggApi.pubyearAggs(capilist);
        if (tms) {
          if (tms.status == 0) {
            total = tms.data.total;
            if (tms.buckets.types.buckets) {
              cbuckets = tms.buckets.types.buckets;
            }
          }
        }
  
        if (cbuckets.length >0){
          var sortarray = [];
          sortarray = sortarray.concat(cbuckets);
          cbuckets.sort(compare("key"));
          minyear = parseInt(cbuckets[0].key);
          maxyear = parseInt(cbuckets[cbuckets.length-1].key);
        }
  
        //企业专利授权趋势
        total = 0;
        var grbuckets = [];
        tms = await this.GsbByChinaAggApi.GryearAggs(grlist);
        if (tms) {
          if (tms.status == 0) {
            total = tms.data.total;
            if (tms.buckets.types.buckets) {
              grbuckets = tms.buckets.types.buckets;
            }
          }
        }
  
        if (grbuckets.length >0){
          var sortarray = [];
          sortarray = sortarray.concat(grbuckets);
          grbuckets.sort(compare("key")); 
          var tyear = parseInt(grbuckets[0].key);
          if (tyear < minyear){
            minyear = tyear;
          }
          tyear = parseInt(grbuckets[grbuckets.length-1].key);
          if (tyear > maxyear){
            maxyear = tyear;
          }
        }
  
        //处理公开年和授权年
        var yeararry = []; 
        var countarray = [];
        var grcountarray = [];
        for (var year = minyear;year <= maxyear;year++){
          yeararry.push(year.toString());
          countarray.push(0);
          grcountarray.push(0);
        }
  
        for (var cb in cbuckets) {
          var a = yeararry.indexOf(cbuckets[cb].key);
          if (a > -1){
            countarray[a] = cbuckets[cb].doc_count
          }
        }
  
        for (var gr in grbuckets){
          var a = yeararry.indexOf(grbuckets[gr].key);
          if (a > -1){
            grcountarray[a] = grbuckets[gr].doc_count
          }
        }
  
        for (var i = 0; i < yeararry.length; i++) {
          applylist.push({data:yeararry[i],value:countarray[i]});
          empowerlist.push({data:yeararry[i],value:grcountarray[i]});
        }
        reApplytrend = {apply:applylist,empower:empowerlist};        
      }
      else{    
        var maxmonth =12;
        total = 0;
        cbuckets = [];
        tms = await this.GsbByChinaAggApi.pubmonthAggs(capilist);
        if (tms) {
          if (tms.status == 0) {
            total = tms.data.total;
            if (tms.buckets.types.buckets) {
              cbuckets = tms.buckets.types.buckets;
            }
          }
        }        

        if (cbuckets.length >0 && cbuckets.length <12){
          maxmonth = parseInt(cbuckets[cbuckets.length-1].key.replace(year.toString() + "-",""));
        }

        //企业专利授权趋势
        total = 0;
        var grbuckets = [];
        tms = await this.GsbByChinaAggApi.grmonthAggs(grlist);
        if (tms) {
          if (tms.status == 0) {
            total = tms.data.total;
            if (tms.buckets.types.buckets) {
              grbuckets = tms.buckets.types.buckets;
            }
          }
        }

        if (grbuckets.length >0 && grbuckets.length <12){
          var month = parseInt(grbuckets[grbuckets.length-1].key.replace(year.toString() + "-",""));
          if (maxmonth < month){
            maxmonth = month;
          } 
        }

        //处理month
        var montharry = []; 
        var countarray = [];
        var grcountarray = [];
        for (var month = 1;month <= maxmonth;month++){
          if (month<=9){
            montharry.push(year.toString() + "-0" + month.toString());
          }
          else{
            montharry.push(year.toString() + "-" + month.toString());
          }
          countarray.push(0);
          grcountarray.push(0);
        }

        for (var cb in cbuckets) {
          var a = montharry.indexOf(cbuckets[cb].key);
          if (a > -1){
            countarray[a] = cbuckets[cb].doc_count
          }
        }
  
        for (var gr in grbuckets){
          var a = montharry.indexOf(grbuckets[gr].key);
          if (a > -1){
            grcountarray[a] = grbuckets[gr].doc_count
          }
        }
  
        for (var i = 0; i < montharry.length; i++) {
          applylist.push({data:montharry[i],value:countarray[i]});
          empowerlist.push({data:montharry[i],value:grcountarray[i]});
        }
        reApplytrend = {apply:applylist,empower:empowerlist}; 
      }


      return {
        title:reTitle,
        profile:reProfile,
        typestatistic:reTypestatistic,
        statestatistic:reStatestatistic,
        applytrend:reApplytrend,
        distribution:reDistribution,
        ipc:reIpc
      }
    }
    else{
      return null;
    }
  };



}
module.exports = PatentycService;
