const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class AapUserService extends ServiceBase {
  constructor() {
    super("dbapp", ServiceBase.getDaoName(AapUserService));
    this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");
  }
  async loginUser(channelUserId, channelUserName, userMoblie, nickname, orgName, orgPath) {
    if (!channelUserId) {
      return system.getResult(null, "channelUserId不能为空");
    }
    var params = {
      channelUserId: channelUserId,
      channelUserName: channelUserName,
      userMoblie: userMoblie,
      nickname: nickname,
      orgName: orgName,
      orgPath: orgPath
    }
    var userItem = await this.cacheManager["ApiUserCache"].cache(channelUserId, { status: true }, 3000, params);
    if (!userItem) {
      return system.getResult(null, "用户注册失败");
    }
    return system.getResultSuccess(userItem);
  }
}
module.exports = AapUserService;
