const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("tmofficial", {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
    tmRegistNum      :DataTypes.STRING(50),     //注册号                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
    officialTypeName :DataTypes.STRING(50),     //                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
    officialType     : {
          type: DataTypes.ENUM,
          values: Object.keys(uiconfig.config.pdict.official_type),
          set: function (val) {
            this.setDataValue("officialType", val);
            this.setDataValue("officialTypeName", uiconfig.config.pdict.official_type[val]);
          }
    },     //商标官文类型：1: 商标注册申请书, 2: 商标注册申请补正通知书, 3: 商标注册申请受理通知书, 4: 商标注册申请不予受理通知书, 
          //5: 商标注册同日申请补送使用证据通知书,6: 商标注册同日申请协商通知书商标注册同日申请抽签通知书, 
          //7: 商标驳回通知书, 8: 商标部分驳回通知书, 9: 商标注册申请初步审定公告通知书,                                                                                                                                                                                                                                                                                                                                 
          //10: 商标异议答辩通知书, 11: 异议裁定书, 12: 纸质版商标注册证, 13: 电子版商标注册证                                                                                                                                                                                                                                                                                                                                                                                                               
    officialFileName :DataTypes.STRING(200),     //    官文文件名称                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
    officialFileUrl  :DataTypes.STRING(255),    //     官文文件地址                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
    notes            :DataTypes.STRING ,        //                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
    name             :DataTypes.STRING(1000),     //暂时没有用                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
    code             :DataTypes.STRING(64),     //官文单号（自动生成）                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
    app_id           :DataTypes.INTEGER,        //                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
    createuser_id    :DataTypes.INTEGER,        //                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
    updateuser_id    :DataTypes.INTEGER,        //       
    
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'b_tmofficial',
      validate: {

      },
      indexes: [
     
      ]
    });
}
