const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("customerinfo", {
    customerTypeName   :DataTypes.STRING(50),   //                              
    customerType       : {
          type: DataTypes.ENUM,
          values: Object.keys(uiconfig.config.pdict.customer_type),
          set: function (val) {
            this.setDataValue("customerType", val);
            this.setDataValue("customerTypeName", uiconfig.config.pdict.customer_type[val]);
          },
          defaultValue: "0",
    },   //申请企业类型：  ent:企业，person:个人   
    identityCardPic    :DataTypes.STRING(500),  //  身份证图片              
    identityCardPdf    :DataTypes.STRING(500),  //  身份证pdf  
    businessLicensePic :DataTypes.STRING(500),  //  营业执照图片           
    businessLicensePdf :DataTypes.STRING(500),  //  营业执照pdf
    name               :DataTypes.STRING(1000), //   公司名称或个人名称  
    code               :DataTypes.STRING(100),  //  公司统一社会代码     
    app_id             :DataTypes.INTEGER,      //                               
    deliveryOrderNo    :DataTypes.STRING(64),   // 交付订单号                   
    applyAddr          :DataTypes.STRING,       // 申请地址                 
    applyArea          :DataTypes.STRING(50),   // 存储省市编码           
    province           :DataTypes.STRING(50),   // 省                          
    city               :DataTypes.STRING(50),   // 市                          
    identityCardNo     :DataTypes.STRING(50),   // 身份证号                 
    notes              :DataTypes.STRING,       // 备注                       
    createuser_id      :DataTypes.INTEGER,      //                              
    updateuser_id      :DataTypes.INTEGER,      //                              
    owner_id           :DataTypes.INTEGER,      // 拥有者   
    zipCode            :DataTypes.STRING(20),    //          
    
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'b_customerinfo',
      validate: {

      },
      indexes: [
     
      ]
    });
}
