const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("moneyaccount", {
    app_id: DataTypes.INTEGER,      // 是否显示
    balance: {//余额
      type: DataTypes.DECIMAL(12, 3),
      defaultValue: 0.00,
    },

    accountType: {
      //帐户类型:"cash": "现金", "bank": "银行" ,"wx":"微信","alipay":"支付宝","other":"其它"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.pay_account_type),
      set: function (val) {
        this.setDataValue("accountType", val);
        this.setDataValue("accountTypeName", uiconfig.config.pdict.pay_account_type[val]);
      },
      defaultValue: "other",
    },
    accountTypeName: {//帐户类型名称
      type: DataTypes.STRING(50),
      defaultValue: "其它",
    },
    payeeName: {
      type: DataTypes.STRING(100),
    },//收款人姓名         
    certificateNo: DataTypes.STRING(100),//帐号
    bankAddr: DataTypes.STRING(500),  //银行地址      
    description: DataTypes.STRING,//描述
    isOfflinePay: {//是否支持线下支付,0否，1是
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    transferRate: {//商户收款费率,千分率，如：值为5，计算时除以1000（第三方公司收款账户有此值）
      type: DataTypes.DECIMAL(12, 2),
      defaultValue: 5.00,
    },
    bankToPtTransferRate: {//银行收平台费率,千分率，如：值为2.6，计算时除以1000（平台公司收款账户有此值）
      type: DataTypes.DECIMAL(12, 2),
      defaultValue: 0,
    },
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'b_moneyaccount',
      validate: {

      },
      indexes: [
      ]
    });
}