const system = require("../../../system");
const Dao = require("../../dao.base");
class CustomerContactsDao extends Dao {
  constructor() {
    super(Dao.getModelName(CustomerContactsDao));
  }
  async findOneByMobile(mobile, customerinfoId) {
    return this.model.findOne({
      where: {
        mobile: mobile,
        customerinfo_id: customerinfoId
      },
      attributes: ["id",
        "deliveryOrderNo",
        "mobile",
        "email",
        "tel",
        "fax",
        "name",
        "code",
        "app_id"],
      raw: true
    });
  }
  async findOneByCustomerinfoId(customerinfoId) {
    return this.model.findOne({
      where: {
        customerinfo_id: customerinfoId
      },
      attributes: ["id",
        "deliveryOrderNo",
        "mobile",
        "email",
        "tel",
        "fax",
        "name",
        "code",
        "app_id"],
      raw: true
    });
  }
}
module.exports = CustomerContactsDao;
