const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class ApiAppKeyCheckCache extends CacheBase {
  constructor() {
    super();
    this.appDao = system.getObject("db.dbapp.appDao");
  }
  desc() {
    return "应用中来访访问appid缓存";
  }
  prefix() {
    return settings.cacheprefix + "_verify_appKey:";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    var item = await this.appDao.getItemByAppKey(inputkey);
    if (!item) {
      return system.getResult(null, "返回数据为空！");
    }
    if (item.status != 1) {
      return system.getResultFail(system.waitAuditSelfApp, "渠道应用处于待审核等待启用状态");
    }
    return system.getResultSuccess(item);
  }
}
module.exports = ApiAppKeyCheckCache;
