var System=require("../../../system");
var settings=require("../../../../config/settings");
const ApiBase = require("../../api.base");
var pinyin = require("pinyin");
class tmqueryApi extends ApiBase{
  constructor(){
    super();
    this.zcApiUrl = settings.reqZcApi();
    this.ichemingUrl=settings.apiconfig.ichemingUrl();
    this.GsbByTmSearchApi=System.getObject("api.trademark.tmsearch");
    this.utilstmSve=System.getObject("service.trademark.utilstmSve");
    // this.utilscontent=System.getObject("service.trademark.utilscontentfilterSve");
    // this.gsbicsearch = System.getObject("api.trademark.gsbicsearch");
    this.tm_type={P:"普通商标",J:"集体商标",Z:"证明商标",T:"特殊商标"};
    this.tm_status={1:"申请中",2:"已初审",3:"已注册",4:"已无效",5:"其他"};
    // this.imageQueryUrl=settings.apiconfig.imageQueryUrl();
    this.tm_gjfl={1:"01类 化学原料",2:"02类 颜料油漆",3:"03类 日化用品",4:"04类 燃料油脂",5:"05类 医药",6:"06类 金属材料",7:"07类 机械设备",8:"08类 手工器械",9:"09类 科学仪器",
                  10:"10类 医疗器械",11:"11类 灯具空调",12:"12类 运输工具",13:"13类 军火烟火",14:"14类 珠宝钟表",15:"15类 乐器",16:"16类 办公用品",17:"17类 橡胶制品",18:"18类 皮革皮具",19:"19类 建筑材料",20:"20类 家具",21:"21类 厨房洁具",22:"22类 绳网袋蓬",23:"23类 纱线丝",24:"24类 布料床单",
                  25:"25类 服装鞋帽",26:"26类 钮扣拉链",27:"27类 地毯席垫",28:"28类 健身器材",29:"29类 食品",30:"30类 方便食品",31:"31类 农林生鲜",32:"32类 啤酒饮料",33:"33类 酒",34:"34类 烟草烟具",35:"35类 广告销售",36:"36类 金融物管",37:"37类 建筑修理",38:"38类 通讯服务",
                  39:"39类 运输贮藏",40:"40类 材料加工",41:"41类 教育娱乐",42:"42类 科技服务",43:"43类 餐饮住宿",44:"44类 医疗园艺",45:"45类 社会服务"};
  }
  convertDate(time){
     if(time==null){
       return "";
     }
     var date =  new Date(Number(time*1000));
     var y = 1900+date.getYear();
     var m = "0"+(date.getMonth()+1);
     var d = "0"+date.getDate();
     return y+"-"+m.substring(m.length-2,m.length)+"-"+d.substring(d.length-2,d.length);
  }
  convertDate1(time){
     if(time==null){
       return "";
     }
     var date =  new Date(Number(time*1000));
     var y = 1900+date.getYear();
     var m = "0"+(date.getMonth()+4);
     var d = "0"+date.getDate();
     return y+"-"+m.substring(m.length-2,m.length)+"-"+d.substring(d.length-2,d.length);
  }
  //商标群组信息 参数：data = {reg_num：注册号-精确,nclone_code:大类号-精确}
  async getSbqz(data){
    var tms=await this.utilstmSve.getGroupNclNumList(data);
    var that=this;
    var sbqz="";
    if(tms.status == 0&&tms.data.exist.length>0){
      tms.data.exist.forEach(function(c){
        sbqz+=c.code+";";
      });
    }
    return sbqz;
  }

  async findTrademarkNameIndex(query,obj){//根据商标名称模糊查询,首次查询,
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/findTrademarkNameIndex";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(obj,url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }

  async findTrademarkName(query,obj){//根据商标名称模糊查询
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/findTrademarkName";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(obj,url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }

  async findTrademarkNameAccurate(query,obj){//通过商标名来进行精准查询
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/findTrademarkNameAccurate";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(obj,url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }

  async findTrademarkzchAccurate(query,obj){//通过商标号来进行精准查询
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/findTrademarkzchAccurate";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(obj,url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }

  async findTrademarkzcr(query,obj){//通过注册人模糊查询
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/findTrademarkzcr";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(obj,url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }

  async imagequery(query,obj){//图像检索
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/imagequery";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(obj,url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }
  async findImageSearch(query,obj){ //图像检索查询，
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/findImageSearch";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(obj,url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }

  async tradeMarkDetail(query,obj){//商标详情
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/tradeMarkDetail";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(obj,url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }

  async nclFuwuSearch(query,obj){
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/nclFuwuSearch";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(obj,url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }

  async gettwoNcl(query,obj){
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/gettwoNcl";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(obj,url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }

  async noticequery(query,obj){
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/noticequery";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(obj,url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }

  async getNclDetail(query,obj){
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/getNclDetail";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(obj,url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }

  async aibynclone(obj,pobj){
    var tmName=pobj.tmName;
    var nclonecode=pobj.nclonecode;
    var result={};
    if( tmName == null || tmName == '' || tmName == 'undefined' )
    {
      result={code:-1,msg:"参数错误",data:null};
    }
    var rate = await this.GsbByTmSearchApi.tmncloneSearch(pobj);
    result={code:1,msg:"成功",data:rate};
    return System.getResult2(result,null);
  }

  async rediscache(query,obj){
    var result={redislist:[]};
    var openId=obj.user.openId
    var mark=obj.mark;
    var data={
      openId:openId,
      mark:mark
    };
    var rediscache =await this.GsbByTmSearchApi.opCache(data);
    console.log(rediscache);
    if(rediscache.code==1){
      result.redislist=rediscache.data.reverse();
    }
    return System.getResult2(result,null);
  }

  async noticesearch(query,obj){
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/noticesearch";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(obj,url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }
  async noticezcggsearch(query,obj){
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/noticezcggsearch";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(obj,url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }
  async sbzuixinsearch(){
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/sbzuixinsearch";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost({},url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }
  async noticequeryTMZCSQ(query,obj){
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/noticequeryTMZCSQ";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(obj,url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }
  //企业核名
  async icheming(query,obj){
    var result={};
    var cityname=obj.cityname;
    var keyword=obj.keyword;
    var btname=obj.btname;
    var orgname=obj.orgname;
    var sitcity=obj.sitcity;
    var heming ={
      "cityname":cityname,
      "keyword":keyword,
      "btname":btname,
      "orgname":orgname,
      "sitcity":sitcity
    }
    var url=this.ichemingUrl;
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(heming,url);
      var data=JSON.parse(rtn.stdout);
      console.log("heming++++++++++++++++++++++++++++++++++++++++++++++++++++++");
      console.log(data);
      return System.getResult2(data,null);
    }catch(e){
      console.log(e);
      return System.getResult2(result,null);
    }
    return System.getResult2(result,null);
  }

  async getCompanyInfoNoUser(queryobj, obj, req) {
    var url=this.zcApiUrl+"api/trademark/tmqueryApi/getCompanyInfoNoUser";
    console.log(url);
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(obj,url);
      var data=JSON.parse(rtn.stdout);
      return data;
    }catch(e){
      return System.getResult2(null,null);
    }
  }
}
module.exports=tmqueryApi;
