var System=require("../../../system");
var settings=require("../../../../config/settings");
const querystring = require('querystring');
const ApiBase =require("../../api.base");

class ChinaAffairSearchApi extends ApiBase{
    constructor(){
        super();
        this.affairUrl = settings.reqEsAddrIc()+"bigdata_patent_affair_op/_search";
    };
    buildDate(date){
        var date = new Date(date);
        var time = Date.parse(date);
        time=time / 1000;
        return time;
    };

    async SearchbyFilingno(obj){//根据申请号查询并根据法律状态日期排序
        var pagesize = obj.pagesize==null?10:obj.pagesize;
        if(obj.page==null){
          var from = 0;
        }else{
          var from = Number((obj.page-1)*obj.pagesize);
        }
        
        var filingno = obj.filingno==null?"":obj.filingno;
        if(filingno==""){
            return {status:-1,msg:"传入申请号信息为空",data:null,buckets:null};
        }

        var params= {
            "query": {
                "bool": {
                    "must": [
                    ]
                }
            },
            "sort": [
                {
                    "aff_date": "asc"
                }
            ]
        };

        var param = {
            "term": {
              "filing_no": filingno
            }
        }
        params.query.bool.must.push(param);

        var rc=System.getObject("util.execClient");
        var rtn=null;
        var requrl = this.affairUrl;
        try{
          rtn=await rc.execPost(params,requrl);
          var j=JSON.parse(rtn.stdout);
          return System.getResult2(j.hits,null);
        }catch(e){
          return rtn=System.getResult2(null,null);
        }

    };

}
module.exports = ChinaAffairSearchApi;