var APIBase = require("../../api.base");
var system = require("../../../system");
class TmToolsAPI extends APIBase {
    constructor() {
        super();
        this.toolSve = system.getObject("service.trademark.toolSve");
        this.toolApi = system.getObject("api.tool.toolApi");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = null;
        switch (pobj.actionProcess) {
            case "jd"://京东
                result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody);
                break;
            case "1688":
                result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody);
                break;
            default:
                result = system.getResult(null, "actionProcess参数错误");
                break;
        }
        return result;
    }
    async opActionProcess(action_process, action_type, action_body) {
        var opResult = null;
        switch (action_type) {
            // sy
            case "test"://测试
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "getOssConfig"://
                opResult = await this.toolSve.getOssConfig();
                break;
            case "getNcl"://尼斯查询（一）
                opResult = await this.toolSve.getNcl(action_body);
                break;

            case "getNclByLikeNameAndNcl"://尼斯查询（二）
                opResult = await this.toolSve.getNclByLikeNameAndNcl(action_body);
                break;

            case "word2pic"://文字转图片
                opResult = await this.toolSve.word2pic(action_body);
                break;

            case "uploadStandardTm"://商标样式转换
                opResult = await this.toolSve.uploadStandardTm(action_body);
                break;

            case "pic2pdf"://图片转pdf
                opResult = await this.toolSve.pic2pdf(action_body);
                break;

            case "getCompanyInfoByLikeName"://企业近似查询
                opResult = await this.toolSve.getCompanyInfoByLikeName(action_body);
                break;

            case "getEntregistryByCompanyName"://企业精确查询
                opResult = await this.toolSve.getEntregistryByCompanyName(action_body);
                break;

            case "adjustWTSSize"://调整委托书
                opResult = await this.toolSve.adjustWTSSize(action_body);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = TmToolsAPI;