const system = require("../../../system");
var settings = require("../../../../config/settings");
const crypto = require('crypto');
const cryptoJS = require("crypto-js");
var fs = require("fs");
var accesskey = 'DHmRtFlw2Zr3KaRwUFeiu7FWATnmla';
var accessKeyId = 'LTAIyAUK8AD04P5S';
var url = "https://gsb-zc.oss-cn-beijing.aliyuncs.com";
class ToolService {
  constructor() {
    this.zcApiUrl = settings.reqZcApi();
    this.execClient = system.getObject("util.execClient");
  }
  async getCropperPic(obj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/getCropperPic";
    return await this.opReqResult(url, queryobj, req);
  }
  //智能分析 bycquerytm.html
  async bycznfx(obj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/bycznfx";
    return await this.opReqResult(url, queryobj, req);
  }
  //根据尼斯编号获取尼斯子类，尼斯树节点点击时触发调用
  async getNcl(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/getNcl";
    return await this.opReqResult(url, queryobj, req);
  }
  //根据大类、名称查询尼斯信息
  async getNclByLikeNameAndNcl(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/getNclByLikeNameAndNcl";
    return await this.opReqResult(url, queryobj, req);
  }
  //文字转图片
  async word2pic(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/word2pic";
    return await this.opReqResult(url, queryobj, req);
  }
  //商标样式转换 彩色商标图样转黑白，调整图样宽高，生成符合商标局规范的标准商标图样
  async uploadStandardTm(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/uploadStandardTm";
    return await this.opReqResult(url, queryobj, req);
  }
  //营业执照（身份证明）图片文件转为符合商标局要求的pdf文件
  async pic2pdf(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/pic2pdf";
    return await this.opReqResult(url, queryobj, req);
  }
  //企业近似查询
  async getCompanyInfoByLikeName(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/getCompanyInfoByLikeName";
    return await this.opReqResult(url, queryobj, req);
  }
  //企业注册信息查询
  async getEntregistryByCompanyName(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/getEntregistryByCompanyName";
    return await this.opReqResult(url, queryobj, req);
  }
  //调整委托书 调整委托书大小使其符合商标局规范
  async adjustWTSSize(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/adjustWTSSize";
    return await this.opReqResult(url, queryobj, req);
  }

  async opReqResult(reqUrl, queryobj, req) {
    var rtn = await this.execClient.execPushDataPost(queryobj, reqUrl, req.headers["token"], req.headers["request-id"]);
    var data = JSON.parse(rtn.stdout);
    return data;
  }

  async getOssConfig(queryobj, req) {
    var policyText = {
      "expiration": "2119-12-31T16:00:00.000Z",
      "conditions": [
        ["content-length-range", 0, 1048576000],
        ["starts-with", "$key", "zc"]
      ]
    };
    var b = new Buffer(JSON.stringify(policyText));
    var policyBase64 = b.toString('base64');
    var signature = crypto.createHmac('sha1', accesskey).update(policyBase64).digest().toString('base64'); //base64

    var data = {
      OSSAccessKeyId: accessKeyId,
      policy: policyBase64,
      Signature: signature,
      Bucket: 'gsb-zc',
      success_action_status: 201,
      url: url
    };

    return system.getResultSuccess(data);
  };
  //加密信息
  async encryptStr(app, opStr) {
    let keyHex = cryptoJS.enc.Utf8.parse(app.uappKey);
    let ivHex = cryptoJS.enc.Utf8.parse(app.appSecret.substring(0, 8));
    var cipherStr = cryptoJS.TripleDES.encrypt(opStr, keyHex, { iv: ivHex }).toString();
    return system.getResultSuccess(cipherStr);
  }
  //解密信息
  async decryptStr(app, opStr) {
    let keyHex = cryptoJS.enc.Utf8.parse(app.uappKey);
    let ivHex = cryptoJS.enc.Utf8.parse(app.appSecret.substring(0, 8));
    var bytes = cryptoJS.TripleDES.decrypt(opStr, keyHex, {
      iv: ivHex
    });
    var plaintext = bytes.toString(cryptoJS.enc.Utf8);
    return system.getResultSuccess(plaintext);
  }
}
module.exports = ToolService;

