const system = require("../../../system");
var settings = require("../../../../config/settings");
class TmqueryService {
  constructor() {
    this.zcApiUrl = settings.reqZcApi();
    this.execClient = system.getObject("util.execClient");
  }
  async findTrademarkNameAccurate(queryobj, req) {//通过商标名来进行精准查询
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/findTrademarkNameAccurate";
    return await this.opReqResult(url, queryobj, req);
  }
  async findTrademarkNameIndex(queryobj, req) {//根据商标名称模糊查询,首次查询,
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/findTrademarkNameIndex";
    return await this.opReqResult(url, queryobj, req);
  }
  async findTrademarkName(queryobj, req) {//根据商标名称模糊查询
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/findTrademarkName";
    return await this.opReqResult(url, queryobj, req);
  }
  async findTrademarkzchAccurate(queryobj, req) {//通过商标号来进行精准查询
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/findTrademarkzchAccurate";
    return await this.opReqResult(url, queryobj, req);
  }
  async findTrademarkzcr(queryobj, req) {//通过注册人模糊查询
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/findTrademarkzcr";
    return await this.opReqResult(url, queryobj, req);
  }
  async imagequery(queryobj, req) {//图像检索
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/imagequery";
    return await this.opReqResult(url, queryobj, req);
  }
  async findImageSearch(queryobj, req) { //图像检索查询，
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/findImageSearch";
    return await this.opReqResult(url, queryobj, req);
  }
  async tradeMarkDetail(queryobj, req) {//商标详情
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/tradeMarkDetail";
    return await this.opReqResult(url, queryobj, req);
  }
  async sbzuixinsearch(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/sbzuixinsearch";
    return await this.opReqResult(url, queryobj, req);
  }
  async noticequeryTMZCSQ(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/noticequeryTMZCSQ";
    return await this.opReqResult(url, queryobj, req);
  }
  async noticequery(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/noticequery";
    return await this.opReqResult(url, queryobj, req);
  }
  async noticezcggsearch(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/noticezcggsearch";
    return await this.opReqResult(url, queryobj, req);
  }
  async noticesearch(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/noticesearch";
    return await this.opReqResult(url, queryobj, req);
  }
  async getCompanyInfoNoUser(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/getCompanyInfoNoUser";
    return await this.opReqResult(url, queryobj, req);
  }
  async getNclDetail(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/getNclDetail";
    return await this.opReqResult(url, queryobj, req);
  }
  async gettwoNcl(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/gettwoNcl";
    return await this.opReqResult(url, queryobj, req);
  }
  async nclFuwuSearch(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/nclFuwuSearch";
    return await this.opReqResult(url, queryobj, req);
  }

  async opReqResult(reqUrl, queryobj, req) {
    var rtn = await this.execClient.execPushDataPost(queryobj, reqUrl, req.headers["token"], req.headers["request-id"]);
    var data = JSON.parse(rtn.stdout);
    return data;
  }

}
module.exports = TmqueryService;
