const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class OrderTmProductService extends ServiceBase {
  constructor() {
    super("dborder", ServiceBase.getDaoName(OrderTmProductService));
    this.appproductDao = system.getObject("db.dbapp.appproductDao");
    this.ordertmproductDao = system.getObject("db.dborder.ordertmproductDao");
    this.orderDao = system.getObject("db.dborder.orderDao");
    this.customerinfoDao = system.getObject("db.dborder.customerinfoDao");
    this.customercontactsDao = system.getObject("db.dborder.customercontactsDao");
    this.orderflowDao = system.getObject("db.dborder.orderflowDao");
    this.trademarkDao = system.getObject("db.dbtrademark.trademarkDao");
    this.receiptvoucherDao = system.getObject("db.dborder.receiptvoucherDao");
    this.tmofficialDao = system.getObject("db.dbtrademark.tmofficialDao");
    this.userDao = system.getObject("db.dbapp.appuserDao");
    this.appDao = system.getObject("db.dbapp.appDao");

  }
  //------------------------------------------创建订单-------------------开始-------------------------
  async addExistTmOrder(params) {//创建商标订单信息
    var self = this;
    var itemCode = params.itemCode;//产品编码
    var tm = params.tm;//增加sourceType || "00";//来源类型：00订单，10需求，20服务商
    var apply = params.apply;
    var app = params.app;
    var user = params.user;
    var nclones = params.nclones || null;
    var channelUser = params.channelUser || null;
    var channelOrder = params.channelOrder || null;
    var orderType = params.orderType || "dkxd";//订单类型，zzdd: 自主订单,dkxd: 代客下单

    if (!nclones || nclones.length < 1) {
      return system.getResult(null, "尼斯大类不能为空");
    }
    if (!itemCode) {
      return system.getResult(null, "itemCode参数错误");
    }
    var productItem = await this.appproductDao.findOneByCode(itemCode, user.app_id);//通过ChannelItemCode获取产品
    if (!productItem) {
      return system.getResult(null, "未知的产品");
    }
    if (productItem.status != 1) {
      return system.getResult(null, "产品已禁用");
    }
    if (productItem && productItem.verifyPrice == 1) {
      var verifyResult = await self.isOrderVerify(user, 1, tm, productItem, nclones, null);
      if (verifyResult) {
        return verifyResult;
      }
    } else {
      tm.nclOneCodes = [];
      tm.nclCount = 0;
      for (var i = 0; i < nclones.length; i++) {
        var tbcode = await self.getBusUid("tb");
        var nclone = nclones[i];
        var nclthreeobj = nclone.nclThree;
        if (nclone) {
          tm.nclOneCodes.push(nclone.code);
          tm.nclCount = tm.nclCount + nclthreeobj.length;
        }
      }
    }
    if (tm.tmFormType == "4") {//图形商标
      tm["name"] = "图形";
    }
    return await self.db.transaction(async function (t) {
      var orderTm = await self.dao.getItemByChannelServiceNo(channelOrder.channelServiceNo, app.id, t);
      if (!orderTm) {
        return system.getResult(null, "交付单数据不存在");
      }
      var orderAmount = tm;
      orderAmount.salesNum = tm.nclOneCodes.length;
      orderAmount.minitermNum = tm.nclCount;
      var orderResult = await self.orderDao.addOrder(orderTm.sourceOrderNo, orderType, user, app, productItem, channelOrder, channelUser, apply, orderAmount, t);
      if (orderResult.status != 0) {
        return orderResult;
      }
      var order = orderResult.data;
      var orderProductObj = {
        tmName: tm.tmName,//商标名称
        tmType: "p",//"p": "普通商标", "j": "集体商标", "z": "证明商标", "t": "特殊商标"
        tmFormType: tm.tmFormType,//商标类型形式："1": "立体", "3": "字", "4": "图", "5": "字图", "6": "颜色", "7": "彩色" 
        nclOneCodes: tm.nclOneCodes ? tm.nclOneCodes.join(",") : null,//尼斯大类列表：格式以,隔开                                                                                                                        
        deliveryStatus: "dsccl",//商标交付状态：dsccl: 待上传材料, dsh: 待审核, ddj: 待递交, ywc: 已完成                    
        picUrl: tm.picUrl || null,//商标图样
        colorizedPicUrl: tm.colorizedPicUrl || null,//商标彩色图样
        sywjUrl: apply.sywjUrl || null,//声音文件
        gzwtsUrl: apply.gzwtsUrl || null,//盖章委托书      
        smwjUrl: apply.smwjUrl || null,//说明文件
        updateuser_id: user.id,//                                                                                                                           
        updateuser: user.nickname,//                                                                                            
        notes: tm.notes || "", // 备注信息
        nclOneCount: tm.nclOneCodes.length,
        nclCount: tm.nclCount,
        deliveryOrderNo: orderTm.deliveryOrderNo
      };
      var flowContent = "";
      if (apply.customerType == "person") {
        if (!apply.businessLicensePic || !apply.identityCardPic || !apply.gzwtsUrl) {
          orderProductObj["deliveryStatus"] = "dsccl";
          flowContent = channelOrder.payStatus == "yfk" ? "订单已付款待上传材料" : "订单已创建待付款";
        } else {
          orderProductObj["deliveryStatus"] = "dsh";
          flowContent = channelOrder.payStatus == "yfk" ? "订单已付款待审核" : "订单已创建待付款";
        }
      }
      if (apply.customerType == "ent") {
        if (!apply.businessLicensePic || !apply.gzwtsUrl) {
          orderProductObj["deliveryStatus"] = "dsccl";
          flowContent = channelOrder.payStatus == "yfk" ? "订单已付款待上传材料" : "订单已创建待付款";
        } else {
          orderProductObj["deliveryStatus"] = "dsh";
          flowContent = channelOrder.payStatus == "yfk" ? "订单已付款待审核" : "订单已创建待付款";
        }
      }
      //订单客户档案添加和修改
      await self.opCustomerInfo(user, apply, orderProductObj, t);
      //创建服务单
      var putWhere = { where: { channelServiceNo: channelOrder.channelServiceNo } };
      await self.dao.updateByWhere(orderProductObj, putWhere, t);//创建商标订单--------put
      var flowObj = {
        app_id: user.app_id,
        createuser_id: user.id,
        sourceOrderNo: orderTm.sourceOrderNo,
        opContent: flowContent
      };
      await self.orderflowDao.create(flowObj, t);//创建订单流程
      flowObj.sourceOrderNo = orderProductObj.deliveryOrderNo;
      await self.orderflowDao.create(flowObj, t);//创建交付流程     
      var returnTm = await self.opTmInfo(user, tm, apply, nclones, orderTm, JSON.stringify(productItem), t);
      return system.getResultSuccess({
        deliveryOrderNo: orderProductObj.deliveryOrderNo,
        channelServiceNo: channelOrder.channelServiceNo,
        channelParams: params.channelParams,
        tm: returnTm
      });
    })
  }


  async addTmOrder(params) {//创建商标订单信息
    var self = this;
    var itemCode = params.itemCode;//产品编码
    var tm = params.tm;//增加sourceType || "00";//来源类型：00订单，10需求，20服务商
    var apply = params.apply;
    var app = params.app;
    var user = params.user;
    var nclones = params.nclones || null;
    var channelUser = params.channelUser || null;
    var channelOrder = params.channelOrder || null;
    var orderType = params.orderType || "dkxd";//订单类型，zzdd: 自主订单,dkxd: 代客下单

    if (!nclones || nclones.length < 1) {
      return system.getResult(null, "尼斯大类不能为空");
    }
    if (!itemCode) {
      return system.getResult(null, "itemCode参数错误");
    }
    var productItem = await this.appproductDao.findOneByChannelItemCode(itemCode, user.app_id);//通过ChannelItemCode获取产品
    if (!productItem) {
      return system.getResult(null, "未知的产品");
    }
    if (productItem.status != 1) {
      return system.getResult(null, "产品已禁用");
    }
    if (productItem && productItem.verifyPrice == 1) {
      var verifyResult = await self.isOrderVerify(user, 1, tm, productItem, nclones, null);
      if (verifyResult) {
        return verifyResult;
      }
    } else {
      tm.nclOneCodes = [];
      tm.nclCount = 0;
      for (var i = 0; i < nclones.length; i++) {
        var tbcode = await self.getBusUid("tb");
        var nclone = nclones[i];
        var nclthreeobj = nclone.nclThree;
        if (nclone) {
          tm.nclOneCodes.push(nclone.code);
          tm.nclCount = tm.nclCount + nclthreeobj.length;
        }
      }
    }
    if (tm.tmFormType == "4") {//图形商标
      tm["name"] = "图形";
    }
    return await self.db.transaction(async function (t) {
      //创建订单
      var ordercode = await self.getBusUid("tm");
      var orderAmount = tm;
      orderAmount.salesNum = tm.nclOneCodes.length;
      orderAmount.minitermNum = tm.nclCount;
      var orderResult = await self.orderDao.addOrder(ordercode, orderType, user, app, productItem, channelOrder, channelUser, apply, orderAmount, t);
      if (orderResult.status != 0) {
        return orderResult;
      }
      var order = orderResult.data;

      var orderProductObj = {
        app_id: user.app_id,//   
        productType_id: productItem.productType_id,//产品类型Id                                                                                                               
        productOneType_id: productItem.productOneType_id,//产品大类Id      
        itemCode: productItem.itemCode,//                                                                                                                                                                                                 
        itemName: productItem.itemName,//     
        tmName: tm.tmName,//商标名称
        tmType: "p",//"p": "普通商标", "j": "集体商标", "z": "证明商标", "t": "特殊商标"
        tmFormType: tm.tmFormType,//商标类型形式："1": "立体", "3": "字", "4": "图", "5": "字图", "6": "颜色", "7": "彩色" 
        nclOneCodes: tm.nclOneCodes ? tm.nclOneCodes.join(",") : null,//尼斯大类列表：格式以,隔开                                                                                                                        
        orderServicePayStatus: channelOrder.payStatus,//支付状态:dfk: 待付款, yfk: 已支付                                                                                  
        deliveryStatus: "dsccl",//商标交付状态：dsccl: 待上传材料, dsh: 待审核, ddj: 待递交, ywc: 已完成  
        appDataOpType: app.appDataOpType,// 应用数据操作类型：00独立，10全委托，20部分委托     
        sourceOrderNo: ordercode,//来源单号   
        deliveryOrderNo: await self.getBusUid("jf"),
        channelServiceNo: channelOrder.channelServiceNo,// 渠道服务单号                                                                                                                                                                               
        channelOrderNo: channelOrder.channelOrderNo,//渠道订单号列表，多个以,隔开   
        needNo: channelOrder.needNo || null,//需求单号
        sourceType: tm.sourceType || "00",
        picUrl: tm.picUrl || null,//商标图样
        colorizedPicUrl: tm.colorizedPicUrl || null,//商标彩色图样
        sywjUrl: tm.sywjUrl || null,//声音文件
        gzwtsUrl: tm.gzwtsUrl || null,//盖章委托书      
        smwjUrl: tm.smwjUrl || null,//说明文件
        channelUserId: channelUser.channelUserId,// 渠道用户id  
        createuser_id: user.id,//                                                                                                                           
        createuser: user.nickname,//                                                                                            
        notes: tm.notes || "", // 备注信息
        nclOneCount: tm.nclOneCodes.length,
        nclCount: tm.nclCount,
      };
      var flowContent = "";
      if (apply.customerType == "person") {
        if (!apply.businessLicensePic || !apply.identityCardPic || !tm.gzwtsUrl) {
          orderProductObj["deliveryStatus"] = "dsccl";
          flowContent = channelOrder.payStatus == "yfk" ? "订单已付款待上传材料" : "订单已创建待付款";
        } else {
          orderProductObj["deliveryStatus"] = "dsh";
          flowContent = channelOrder.payStatus == "yfk" ? "订单已付款待审核" : "订单已创建待付款";
        }
      }
      if (apply.customerType == "ent") {
        if (!apply.businessLicensePic || !tm.gzwtsUrl) {
          orderProductObj["deliveryStatus"] = "dsccl";
          flowContent = channelOrder.payStatus == "yfk" ? "订单已付款待上传材料" : "订单已创建待付款";
        } else {
          orderProductObj["deliveryStatus"] = "dsh";
          flowContent = channelOrder.payStatus == "yfk" ? "订单已付款待审核" : "订单已创建待付款";
        }
      }
      //订单客户档案添加和修改
      await self.opCustomerInfo(user, apply, orderProductObj, t);
      //创建服务单
      var orderTm = await self.dao.create(orderProductObj, t);//创建商标订单
      var flowObj = {
        app_id: user.app_id,
        createuser_id: user.id,
        sourceOrderNo: ordercode,
        opContent: flowContent
      };
      await self.orderflowDao.create(flowObj, t);//创建订单流程
      flowObj.sourceOrderNo = orderProductObj.deliveryOrderNo;
      await self.orderflowDao.create(flowObj, t);//创建交付流程      
      orderTm.needNo = channelOrder.needNo || null;//需求单号
      var returnTm = await self.opTmInfo(user, tm, apply, nclones, orderTm, JSON.stringify(productItem), t);
      return system.getResultSuccess({
        deliveryOrderNo: orderProductObj.deliveryOrderNo,
        channelServiceNo: channelOrder.channelServiceNo,
        channelParams: params.channelParams,
        tm: returnTm
      });
    })
  }
  async isOrderVerify(user, verifyType, tm, serviceitem, nclones, buyProductCount) {  //订单验证
    /*
      verifyType==1为商标注册验证，2为其他订单验证
    */
    tm.nclOneCodes = [];
    var sveItemRateConfig = serviceitem.rateConfig ? Number(serviceitem.rateConfig) : 0;//产品费率
    var fwf = serviceitem.serviceCharge ? Number(serviceitem.serviceCharge) : 0;//服务费
    var yhfl = serviceitem.discountsRateConfig ? Number(serviceitem.discountsRateConfig) : 0;//最大优惠费率
    var gf = serviceitem.publicExpense ? Number(serviceitem.publicExpense) : 0;//产品官费
    var nclSmallPrice = gf / 10;//单个小类官费
    nclSmallPrice = Number(nclSmallPrice.toFixed(2));
    var productCount = 1;//产品数量
    var gfze = 0;//官费总额
    if (verifyType == 1) {
      tm.nclOneCodes = [];
      tm.nclCount = 0;
      productCount = nclones.length;
      for (var a = 0; a < nclones.length; a++) {
        var nclone = nclones[a];
        tm.nclOneCodes.push(nclone.code);
        tm.nclCount = tm.nclCount + nclthreeobj.length;
        var nclthreeobj = nclone.nclThree;
        gfze = gfze + gf;
        if (nclthreeobj.length > 10) {
          gfze = gfze + (nclthreeobj.length - 10) * nclSmallPrice;
        }
      }
    }
    else if (verifyType == 2) {
      productCount = buyProductCount;
      gfze = gf * Number(productCount);
    }
    var fwfze = Number(fwf) * Number(productCount);//服务费总额
    var sfze = Number(tm.totalSum) / (sveItemRateConfig + 100) * sveItemRateConfig; //totalTaxes 税费总额
    sfze = sfze.toFixed(2);
    sfze = Number(sfze);
    var zdyhe = (gfze + fwfze) * yhfl / 100;//最大优惠额
    zdyhe = zdyhe.toFixed(2);
    zdyhe = Number(zdyhe);
    //毛利总额=应付总额-官费总额
    var mlze = Number(tm.totalSum) - gfze;//totalProfitSum 毛利总额
    mlze = mlze.toFixed(2);
    mlze = Number(mlze);
    //优惠金额=服务费+官费总额-应付总额(服务费、官费之和小于等于应付总额时，优惠金额为零)
    var yhje = fwfze + gfze - Number(tm.totalSum);
    if (yhje < 0) {
      yhje = 0;
    }
    yhje = yhje.toFixed(2);
    yhje = Number(yhje);
    if (fwfze != Number(tm.totalServiceCharge)) {
      return { code: -201, msg: "服务费总额有误" };
    }
    if (gfze != Number(tm.totalPublicExpense)) {
      return { code: -202, msg: "官费总额有误" };
    }
    if (sfze != Number(tm.totalTaxes)) {
      return { code: -203, msg: "税费总额有误" };
    }
    if (mlze != Number(tm.totalProfitSum)) {
      return { code: -204, msg: "毛利总额有误" };
    }
    if (yhje != Number(tm.totalDiscounts) || yhje > zdyhe) {
      return { code: -205, msg: "优惠总额有误" };
    }
    // var channelProfitSum = 0;//订单渠道分成毛利润总额
    // var pfProfitSum = 0;//订单平台毛利润总额
    // var totalProfitSum = Number(tm.totalProfitSum);//订单毛利润总额
    // if (totalProfitSum > 0) {
    //   var tmpChannelProfitRate = Number(serviceitem.channelProfitRate);
    //   if (tmpChannelProfitRate > 0) {
    //     var channelProfitRate = tmpChannelProfitRate / 100;
    //     channelProfitSum = totalProfitSum * channelProfitRate;
    //     pfProfitSum = totalProfitSum - channelProfitSum;
    //     channelProfitSum = channelProfitSum.toFixed(2);
    //     pfProfitSum = pfProfitSum.toFixed(2);
    //     if (channelProfitSum < 0 || pfProfitSum < 0) {
    //       return { code: -206, msg: "利润计算有误" };
    //     }
    //     tm["channelProfitSum"] = channelProfitSum;
    //     tm["pfProfitSum"] = pfProfitSum;
    //   } else if (tmpChannelProfitRate == 0) {
    //     pfProfitSum = mlze;//毛利总额
    //   }
    // }//渠道利润分成比率(只分订单中毛利润总额的分成)
    return "";
  }
  async opCustomerInfo(user, apply, orderObj, t) {//订单客户档案添加和修改
    var customerInfoObj = {
      deliveryOrderNo: orderObj.deliveryOrderNo,//交付订单号    
      app_id: user.app_id,
      code: apply.code,
      name: apply.name,
      applyAddr: apply.applyAddr,//申请地址
      applyArea: apply.applyArea,//申请区域
      customerType: apply.customerType,//申请人类型 ent person
      businessLicensePic: apply.businessLicensePic || "",  //营业执照图片
      businessLicensePdf: apply.businessLicensePdf || "",  //营业执pdf
      identityCardPic: apply.identityCardPic || "",  //身份证图片
      identityCardPdf: apply.identityCardPdf || "",  //身份证pdf      
      owner_id: user.id,
      createuser_id: user.id,
      zipCode: apply.zipCode,//邮政编码

    };
    if (apply.customerType == "person") {
      customerInfoObj["identityCardNo"] = apply.identityCardNo;
      customerInfoObj["identityCardPic"] = apply.identityCardPic || "";
      customerInfoObj["identityCardPdf"] = apply.identityCardPdf || "";
      //身份证号、身份证图片
      if (!apply.identityCardNo || !apply.identityCardPic) {
        orderObj.deliveryStatus = "dsccl";
      }
      else {
        if (!orderObj.deliveryStatus) {
          orderObj.deliveryStatus = "dsh";
        }
      }
    }
    // var customer = await this.customerinfoDao.findOneByCodeAndUserId(apply.code, user.id);//查询客户档案
    var customer = await this.customerinfoDao.model.findOne({
      where: { deliveryOrderNo: orderObj.deliveryOrderNo },
      raw: true
    });
    if (customer && customer.id) {//客户已存在 则更新
      customerInfoObj["id"] = customer.id;
      await this.customerinfoDao.update(customerInfoObj, t);
    } else {//客户不存在 则创建
      customer = await this.customerinfoDao.create(customerInfoObj, t);
    }
    var customerContactObj = {
      deliveryOrderNo: orderObj.deliveryOrderNo,//交付订单号    
      app_id: user.app_id,
      customerinfo_id: customer.id,
      name: apply.contacts,//联系人
      mobile: apply.mobile,//手机号
      email: apply.email,//邮箱
      tel: apply.tel,//座机
      fax: apply.fax//传真

    };
    // var customercontacts = await this.customercontactsDao.findOneByMobile(apply.mobile, customer.id);
    var customercontacts = await this.customercontactsDao.model.findOne({
      where: { deliveryOrderNo: orderObj.deliveryOrderNo },
      raw: true
    });
    if (!customercontacts) {//客户联系人不存在 则创建
      customercontacts = await this.customercontactsDao.create(customerContactObj, t);//创建订单联系人
    }
  }
  async opTmInfo(user, tm, apply, nclones, orderTm, serviceItemSnapshot, t, ) {//商标（商标注册）添加操作
    //获取产品快照
    var productItem = serviceItemSnapshot;
    if (productItem) {
      productItem = JSON.parse(productItem);
    }
    var gf = productItem.publicExpense ? Number(productItem.publicExpense) : 0;//产品官费
    var nclSmallPrice = gf / 10;//单个小类官费
    nclSmallPrice = Number(nclSmallPrice.toFixed(2));
    var self = this;
    var returnTm = [];
    await this.trademarkDao.bulkDeleteByWhere({ where: { deliveryOrderNo: orderTm.deliveryOrderNo, nclOneCodes: { [self.db.Op.in]: tm.nclOneCodes } } }, t);
    for (var i = 0; i < nclones.length; i++) {
      var tbcode = await self.getBusUid("tb");
      var nclone = nclones[i];
      if (nclone.tbCode) {//用于辅助注册推送数据
        tbcode = nclone.tbCode;
      }
      var nclthreeobj = nclone.nclThree;
      var nclthreeobjCount = nclone.nclThree.length;
      //计算尼斯小类官方总额
      var nclgfze = 300;
      if (nclthreeobj.length > 10) {
        nclgfze = nclgfze + (nclthreeobj.length - 10) * nclSmallPrice;
      }
      nclthreeobj = JSON.stringify(nclthreeobj);
      var trademarkobj = {
        tbCode: tbcode,//提报号(自动生成)     
        deliveryOrderNo: orderTm.deliveryOrderNo,
        needNo: orderTm.needNo,//需求单号          
        officialType: orderTm.deliveryStatus,//"dsccl": "待上传材料", "dsh": "待审核"
        app_id: user.app_id,
        createuser_id: user.id,
        owner_id: user.id,
        owner: user.nickname,
        ownerMoblie: user.userMoblie,
        creator: user.nickname,
        nclOneCodes: nclone.code,//尼斯大类
        nclSmallCodes: nclthreeobj,//尼斯小类
        nclCount: nclthreeobjCount,//尼斯数量
        nclPublicExpense: nclgfze,
        itemCode: productItem.itemCode,//                                                                                                                                                                                                 
        itemName: productItem.itemName,//  
        channelUserId: user.channelUserId
      };
      var trademark = await self.trademarkDao.create(trademarkobj, t);//创建商标
      var returnObj = {
        nclOne: nclone.code, tbCode: tbcode
      };
      returnTm.push(returnObj);
    }
    return returnTm;
  }
  //------------------------------------------创建订单--------------------结束------------------------

  async op1688ChannelPushOrder(action_body) {
    return system.getResultSuccess();
  }

  async get1688ChannelOrder(action_body) {
    var orderItem = await this.orderDao.getItemByChannelServiceNo(action_body.channelOrderNo, action_body.app.id);
    if (!orderItem) {
      return system.getResult(null, "暂无订单信息");
    }
    var salesDiliverNum = Number(orderItem.salesNum) - Number(orderItem.salesDiliverNum);
    if (salesDiliverNum <= 0) {
      return system.getResult(null, "服务单交付数量有误，数量为:" + orderItem.salesNum + "，已交付数量为：" + orderItem.salesDiliverNum);
    }
    var minitermDiliverNum = Number(orderItem.minitermNum) - Number(orderItem.minitermDiliverNum);
    if (minitermDiliverNum <= 0) {
      return system.getResult(null, "服务单交付小项数量有误，小项数量为:" + orderItem.minitermNum + "，已交付小项数量为：" + orderItem.minitermDiliverNum);
    }
    var param = {
      itemCode: orderItem.itemCode,
      channelParams: "",
      channelUser: {
        channelUserId: orderItem.channelUserId || "",
        channelUserName: "",
        channelUserMoblie: "",
        nickname: "",
        orgName: "",
        orgPath: "",
      },
      channelOrder: {
        channelServiceNo: orderItem.channelServiceNo || "",
        channelOrderNo: orderItem.channelOrderNo || "",
        needNo: orderItem.needNo || "",
        quantity: salesDiliverNum,
        nclCount: minitermDiliverNum,
        payStatus: orderItem.orderPayStatus || "",
        payTime: orderItem.payTime || "",
      }
    };
    return system.getResultSuccess(param);
  }

  /**
   * 商标交付列表
   * @param {*} params 格式：{channelServiceNo:XX, app:{ appId:XX}}
   */
  async getTmOrderList(params, req) {//商标交付列表
    var pageSize = Number(params.pageSize || 20);
    var pageInde = Number(params.pageInde || 1);
    var from = pageInde == 1 ? 0 : Number((pageInde - 1) * pageSize);
    if (pageSize > 50) {
      pageSize = 50;
    }
    var sql = "SELECT tm.`channelServiceNo`,tm.`deliveryOrderNo`,tm.`tmName`,tm.`nclOneCount`,tm.`nclOneCodes`,tm.itemCode,tm.itemName," +
      " o.`totalSum`,c.`name`,tm.`deliveryStatus`,tm.`deliveryStatusName`,tm.payStatus,tm.payStatusName,o.payTime AS CreateDate,tm.submitTime," +
      " c.`customerType`,c.`businessLicensePic`,c.`identityCardPic`,tm.`gzwtsUrl`,tm.`smwjUrl`" +
      " FROM `b_order_tm_product` AS tm LEFT JOIN `b_order` AS o ON tm.`sourceOrderNo`=o.`orderNo` LEFT JOIN" +
      " `b_customerinfo` AS c ON tm.`deliveryOrderNo`=c.`deliveryOrderNo` where tm.deleted_at is null ";
    var paramWhere = {};
    if (req.user) {
      sql += " and tm.createuser_id=:createuser_id";
      paramWhere.createuser_id = req.user.id;
    }
    if (params.channelServiceNo) {
      sql += " and tm.channelServiceNo like :channelServiceNo";
      paramWhere.channelServiceNo = "%" + params.channelServiceNo.trim() + "%";
    }
    if (params.deliveryOrderNo) {
      sql += " and tm.deliveryOrderNo like :deliveryOrderNo";
      paramWhere.deliveryOrderNo = "%" + params.deliveryOrderNo.trim() + "%";
    }
    if (params.itemCode) {
      sql += " and tm.itemCode=:itemCode";
      paramWhere.itemCode = params.itemCode;
    }
    if (params.deliveryStatus) {
      sql += " and tm.deliveryStatus=:deliveryStatus";
      paramWhere.deliveryStatus = params.deliveryStatus;
    }
    if (params.payStatus) {
      sql += " and tm.payStatus=:payStatus";
      paramWhere.payStatus = params.payStatus;
    }
    if (params.tmName) {
      sql += " and tm.tmName like :tmName";
      paramWhere.tmName = +"%" + params.tmName.trim() + "%";
    }
    if (params.name) {
      sql += " and c.name like :name";
      paramWhere.name = "%" + params.name.trim() + "%";
    }
    if (params.startTime && params.entTime) {
      var startTime = params.startTime.trim() + " 00:00:00";
      var entTime = params.entTime + " 23:59:59";
      sql += " and o.created_at >=:startTime and  o.created_at<=:entTime";
      paramWhere.startTime = startTime;
      paramWhere.entTime = entTime;
    }
    sql += " order by tm.id desc LIMIT " + pageSize + " OFFSET " + from + "";

    var tmpResult = await this.customQuery(sql, paramWhere);
    if (!tmpResult || tmpResult.length == 0) {
      return system.getResultSuccess(null, "暂无数据");
    }
    return system.getResultSuccess(tmpResult);
  }
  /**
   * 商标交付信息
   * @param {*} params 格式：{deliveryOrderNo:XX}
   */
  async getTmOrder(params) {//商标交付信息
    var deliveryOrderNo = params.deliveryOrderNo;
    var item = await this.ordertmproductDao.getTmItemByDeliveryOrderNo(deliveryOrderNo);
    if (!item) {
      return system.getResultSuccess(null, "暂无数据");
    }
    var resultData = {
      tm: {
        itemCode: item.itemCode,
        itemName: item.itemName,
        tmName: item.tmName,
        picUrl: item.picUrl,
        colorizedPicUrl: item.colorizedPicUrl,
        tmType: item.tmType,
        tmFormType: item.tmFormType,
        nclOneCodes: item.nclOneCodes,
        gzwtsUrl: item.gzwtsUrl,
        smwjUrl: item.smwjUrl,
        deliveryStatus: item.deliveryStatus,
        notes: item.notes
      }, orderFlow: [], receiptVoucher: []
    };
    var flowList = await this.orderflowDao.getListBySourceOrderNo(deliveryOrderNo);
    if (flowList && flowList.length > 0) {
      for (let index = 0; index < flowList.length; index++) {
        const element = flowList[index];
        if (element) {
          resultData.orderFlow.push({
            opContent: element.opContent,
            createDate: element.created_at
          });
        }
      }
    }
    var rItemList = await this.receiptvoucherDao.getItemSourceOrderNo(item.sourceOrderNo);
    if (rItemList && rItemList.length > 0) {
      for (let j = 0; j < rItemList.length; j++) {
        const rItem = rItemList[j];
        if (rItem) {
          resultData.receiptVoucher.push({
            payAccountType: rItem.payAccountType,
            payDate: rItem.payDate,
            wxPayOrderCode: rItem.wxPayOrderCode,
            aliPayOrderCode: rItem.aliPayOrderCode,
            busPayOrderCode: rItem.busPayOrderCode,
            certifyFileUrl: rItem.certifyFileUrl,
            totalSum: rItem.totalSum
          });
        }
      }
    }
    return system.getResultSuccess(resultData);
  }
  /**
  * 商标订单-申请信息
  * @param {*} params 格式：{deliveryOrderNo:XX}
  */
  async getTmApply(params) {//商标订单-申请信息
    var deliveryOrderNo = params.deliveryOrderNo;
    var item = await this.customerinfoDao.findOneByDeliveryOrderNo(deliveryOrderNo);
    if (!item) {
      return system.getResultSuccess(null, "暂无数据");
    }
    var resultData = {
      applyAddr: item.applyAddr,
      applyArea: item.applyArea,
      businessLicensePic: item.businessLicensePic,
      businessLicensePdf: item.businessLicensePdf,
      code: item.code,
      customerType: item.customerType,
      identityCardNo: item.identityCardNo,
      identityCardPic: item.identityCardPic,
      identityCardPdf: item.identityCardPdf,
      name: item.name,
      zipCode: item.zipCode,
      notes: item.notes
    };
    var contactsItem = await this.customercontactsDao.findOneByCustomerinfoId(item.id);
    if (contactsItem) {
      resultData.contacts = contactsItem.name;
      resultData.mobile = contactsItem.mobile;
      resultData.email = contactsItem.email;
      resultData.fax = contactsItem.fax;
    }
    return system.getResultSuccess(resultData);
  }
  /**
  * 商标订单-商标尼斯信息
  * @param {*} params 格式：{deliveryOrderNo:XX}
  */
  async getTmNclList(params) {//商标订单-商标尼斯信息
    var deliveryOrderNo = params.deliveryOrderNo;
    var self = this;
    var tmList = await this.trademarkDao.getListByDeliveryOrderNo(deliveryOrderNo);
    if (!tmList || tmList.length == 0) {
      return system.getResultSuccess(null, "暂无数据");
    }
    var resultData = [];
    for (let index = 0; index < tmList.length; index++) {
      const item = tmList[index];
      if (item) {
        var tm = {
          tbCode: item.tbCode,
          nclOneCodes: item.nclOneCodes,
          nclOneCodesName: item.nclOneCodesName,
          nclSmallCodes: item.nclSmallCodes,
          officialType: item.officialType,
          officialTypeName: item.officialTypeName,
          tmRegistNum: item.tmRegistNum,
          submitTime: item.submitTime,
          tmOfficials: []
        };
        if (item.tmRegistNum) {
          var tmOfficialsList = await self.tmofficialDao.getListByTmRegistNum(item.tmRegistNum);
          if (tmOfficialsList && tmOfficialsList.length > 0) {
            for (let i = 0; i < tmOfficialsList.length; i++) {
              const element = tmOfficialsList[i];
              if (element) {
                tm.push({
                  officialType: element.officialType,
                  officialTypeName: element.officialTypeName,
                  officialFileUrl: element.officialFileUrl,
                  createDate: element.created_at
                });
              }
            }
          }
        }
        resultData.push(tm);
      }
    }
    return system.getResultSuccess(resultData);
  }

  //-------------------------接收辅助注册商标数据-------start--------------------------------------------------------
  /**
   * 接收辅助注册商标数据
   */
  async addAssistTm(params) {
    // return system.getResultSuccess(null, "接口开发中");
    var self = this;
    var itemCode = params.itemCode;//产品编码
    var tm = params.tm;//增加sourceType || "00";//来源类型：00订单，10需求，20服务商
    var apply = params.apply;
    var nclones = params.nclones || null;
    var channelOrder = params.channelOrder || null;
    var orderType = params.orderType || "dkxd";//订单类型，zzdd: 自主订单,dkxd: 代客下单
    var needNo = channelOrder.needNo;
    if (!needNo) {
      return system.getResult(null, "需求编号不能为空");
    }
    var order = await this.orderDao.model.findOne({
      where: { needNo: needNo },
      raw: true
    });
    if (!order || !order.id) {
      return system.getResult(null, "未知订单");
    }
    //获取渠道用户数据
    var user = await this.userDao.model.findOne({
      where: { channelUserId: order.channelUserId, app_id: order.app_id },
      raw: true
    });
    var app = await this.appDao.model.findOne({
      where: { id: order.app_id },
      raw: true
    });
    // channelOrder["channelServiceNo"]=order.channelServiceNo;
    channelOrder["payTime"] = order.payTime;
    if (!nclones || nclones.length < 1) {
      return system.getResult(null, "尼斯大类不能为空");
    }
    if (!itemCode) {
      return system.getResult(null, "itemCode参数错误");
    }
    // itemCode="zzsbzc";//测试
    var productItem = await this.appproductDao.findOneByCode(itemCode, user.app_id);//获取产品
    if (!productItem) {
      return system.getResult(null, "未知的产品");
    }
    if (productItem.status != 1) {
      return system.getResult(null, "产品已禁用");
    }
    if (productItem && productItem.verifyPrice == 1) {
      var verifyResult = await self.isOrderVerify(user, 1, tm, productItem, nclones, null);
      if (verifyResult) {
        return verifyResult;
      }
    } else {
      tm.nclOneCodes = [];
      tm.nclCount = 0;
      for (var i = 0; i < nclones.length; i++) {
        var nclone = nclones[i];
        var nclthreeobj = nclone.nclThree;
        if (nclone) {
          tm.nclOneCodes.push(nclone.code);
          tm.nclCount = tm.nclCount + nclthreeobj.length;
        }
      }
    }
    if (tm.tmFormType == "4") {//图形商标
      tm["name"] = "图形";
    }
    return await self.db.transaction(async function (t) {
      //创建订单
      var ordercode = await self.getBusUid("tm");
      if (order.orderNo) {
        ordercode = order.orderNo;
      }
      var orderAmount = tm;
      orderAmount.salesNum = tm.nclOneCodes.length;
      orderAmount.minitermNum = tm.nclCount;
      var jfcode = await self.getBusUid("jf");
      var orderProductObj = {
        app_id: user.app_id,//   
        productType_id: productItem.picUrl,//产品类型Id                                                                                                               
        productOneType_id: productItem.picUrl,//产品大类Id      
        itemCode: productItem.itemCode,//                                                                                                                                                                                                 
        itemName: productItem.itemName,//     
        tmName: tm.tmName,//商标名称
        tmType: "p",//"p": "普通商标", "j": "集体商标", "z": "证明商标", "t": "特殊商标"
        tmFormType: tm.tmFormType,//商标类型形式："1": "立体", "3": "字", "4": "图", "5": "字图", "6": "颜色", "7": "彩色" 
        nclOneCodes: tm.nclOneCodes ? tm.nclOneCodes.join(",") : null,//尼斯大类列表：格式以,隔开                                                                                                                        
        orderServicePayStatus: channelOrder.payStatus,//支付状态:dfk: 待付款, yfk: 已支付                                                                                  
        deliveryStatus: "dsccl",//商标交付状态：dsccl: 待上传材料, dsh: 待审核, ddj: 待递交, ywc: 已完成  
        appDataOpType: app.appDataOpType,// 应用数据操作类型：00独立，10全委托，20部分委托     
        sourceOrderNo: ordercode,//来源单号   
        deliveryOrderNo: channelOrder.deliveryOrderNo || jfcode,
        channelServiceNo: channelOrder.channelServiceNo,// 渠道服务单号                                                                                                                                                                               
        channelOrderNo: channelOrder.channelOrderNo,//渠道订单号列表，多个以,隔开   
        needNo: channelOrder.needNo || null,//需求单号
        sourceType: order.sourceType || "00",
        picUrl: tm.picUrl || null,//商标图样
        colorizedPicUrl: tm.colorizedPicUrl || null,//商标彩色图样
        sywjUrl: tm.sywjUrl || null,//声音文件
        gzwtsUrl: tm.gzwtsUrl || null,//盖章委托书      
        smwjUrl: tm.smwjUrl || null,//说明文件
        channelUserId: user.channelUserId,// 渠道用户id  
        createuser_id: user.id,//                                                                                                                           
        createuser: user.nickname,//                                                                                            
        notes: tm.notes || "", // 备注信息
        nclOneCount: tm.nclOneCodes.length,
        nclCount: tm.nclCount,
      };
      var flowContent = "";
      if (apply.customerType == "person") {
        if (!apply.businessLicensePic || !apply.identityCardPic || !tm.gzwtsUrl) {
          orderProductObj["deliveryStatus"] = "dsccl";
          flowContent = channelOrder.payStatus == "yfk" ? "订单已付款待上传材料" : "订单已创建待付款";
        } else {
          orderProductObj["deliveryStatus"] = "dsh";
          if (tm.tmStatus && tm.tmStatus == "SUBALITMOK") {
            orderProductObj["deliveryStatus"] = "dqrfa";
          }
          flowContent = channelOrder.payStatus == "yfk" ? "订单已付款待审核" : "订单已创建待付款";
        }
      }
      if (apply.customerType == "ent") {
        if (!apply.businessLicensePic || !tm.gzwtsUrl) {
          orderProductObj["deliveryStatus"] = "dsccl";
          flowContent = channelOrder.payStatus == "yfk" ? "订单已付款待上传材料" : "订单已创建待付款";
        } else {
          orderProductObj["deliveryStatus"] = "dsh";
          if (tm.tmStatus && tm.tmStatus == "SUBALITMOK") {
            orderProductObj["deliveryStatus"] = "dqrfa";
          }
          flowContent = channelOrder.payStatus == "yfk" ? "订单已付款待审核" : "订单已创建待付款";
        }
      }
      //订单客户档案添加和修改
      await self.opCustomerInfo(user, apply, orderProductObj, t);
      //获取历史交付单信息
      var beforeOtp = await self.ordertmproductDao.model.findOne({
        where: { deliveryOrderNo: channelOrder.deliveryOrderNo },
        raw: true
      });
      var orderTm = null;
      if (beforeOtp && beforeOtp.id) {//更新交付单
        orderProductObj["id"] = beforeOtp.id;
        await self.dao.update(orderProductObj, t);
        orderTm = await self.ordertmproductDao.model.findOne({
          where: { id: beforeOtp.id },
          raw: true
        });
      } else {//创建服务单
        orderTm = await self.dao.create(orderProductObj, t);//创建商标订单
      }
      var flowObj = {
        app_id: user.app_id,
        createuser_id: user.id,
        sourceOrderNo: ordercode,
        opContent: flowContent
      };
      await self.orderflowDao.create(flowObj, t);//创建订单流程
      flowObj.sourceOrderNo = orderProductObj.deliveryOrderNo;
      await self.orderflowDao.create(flowObj, t);//创建交付流程      
      orderTm.needNo = channelOrder.needNo || null;//需求单号
      var returnTm = await self.opTmInfo(user, tm, apply, nclones, orderTm, JSON.stringify(productItem), t);
      var orderObj = {
        id: order.id
      };
      if (channelOrder.channelServiceNo) {
        orderObj["channelServiceNo"] = channelOrder.channelServiceNo;
      }
      if (channelOrder.channelOrderNo) {
        orderObj["channelOrderNo"] = channelOrder.channelOrderNo;
      }
      await self.orderDao.update(orderObj, t);
      return system.getResultSuccess({
        deliveryOrderNo: orderProductObj.deliveryOrderNo,
        channelServiceNo: channelOrder.channelServiceNo,
        channelParams: params.channelParams,
        tm: returnTm
      });
    })
  }
  /**
   * 接收辅助注册商标修改数据
   */
  async editAssistTm(obj) {
    // return system.getResultSuccess(null, "接口开发中");
    var self = this;
    var needNo = obj.needId;
    if (!needNo) {
      return system.getResultFail(-101, "needNo参数错误");
    }
    //获取交付单信息
    var ordertmproduct = await this.ordertmproductDao.model.findOne({
      where: { needNo: needNo },
      raw: true
    });
    if (!ordertmproduct || !ordertmproduct.id) {
      return system.getResultFail(-102, "商标交付单不存在");
    }
    var deliveryOrderNo = ordertmproduct.deliveryOrderNo;
    //获取交付单状态，判断是否可修改
    if (ordertmproduct.deliveryStatus == 'ddj' || ordertmproduct.deliveryStatus == 'ywc') {
      var deliveryStatusName = "待递交";
      if (ordertmproduct.deliveryStatus == 'ywc') {
        deliveryStatusName = "已完成";
      }
      return system.getResultFail(-103, "该商标交付单状态为" + deliveryStatusName + ",不能进行修改");
    }
    //获取渠道用户数据
    var user = await this.userDao.model.findOne({
      where: { id: ordertmproduct.createuser_id },
      raw: true
    });
    if (!user) {
      return system.getResultFail(-104, "未知的用户");
    }
    //获取渠道数据
    var app = await this.appDao.model.findOne({
      where: { id: ordertmproduct.app_id },
      raw: true
    });
    if (!app) {
      return system.getResultFail(-105, "未知的渠道");
    }
    var itemCode = obj.itemCode;//产品编码
    if (!itemCode) {
      return system.getResultFail(-106, "产品编码参数错误");
    }
    var productItem = await this.appproductDao.findOneByCode(itemCode, app.id);//获取产品
    if (!productItem) {
      return system.getResultFail(-107, "未知的产品");
    }
    return await self.db.transaction(async function (t) {
      var whereObj = { where: { deliveryOrderNo: deliveryOrderNo, app_id: app.id }, transaction: t };
      //申请人
      var applyObj = obj.apply;
      applyObj["updated_at"] = new Date();
      await self.customerinfoDao.model.update(applyObj, whereObj);
      //联系人
      var contactObj = obj.contacts;
      contactObj["updated_at"] = new Date();
      await self.customercontactsDao.model.update(contactObj, whereObj);
      //商标信息
      var tmsList = obj.tms;
      await self.trademarkDao.bulkDeleteByWhere(whereObj, t);
      for (var i = 0; i < tmsList.length; i++) {
        var tm = tmsList[i];
        tm["needNo"] = needNo;
        tm["deliveryOrderNo"] = deliveryOrderNo;
        tm["app_id"] = app.id;
        tm["createuser_id"] = user.id;
        tm["owner_id"] = user.id;
        tm["owner"] = user.nickname;
        tm["ownerMoblie"] = user.ownerMoblie;
        tm["creator"] = user.nickname;
        tm["itemCode"] = itemCode;
        tm["itemName"] = productItem.itemName;
        tm["channelUserId"] = user.channelUserId;
        tm["updated_at"] = new Date();
        if (tm.officialType == "WAITARTIFICIALEXAMINE") {
          tm.officialType = "dsh"
        }
        else if (tm.officialType == "FILLEXCEPTION") {
          tm.officialType = "shbtg"
        }
        else if (tm.officialType == "WAITCOMMIT") {
          tm.officialType = "ddj"
        }
        else if (tm.officialType == "ROBOT") {
          tm.officialType = "ydj"
        } else {
          tm.officialType = "dsccl";
        }
        await self.trademarkDao.create(tm, t);
      }
      //交付单
      var otp = obj.order;
      if (otp.tmStatus && otp.tmStatus == "SUBALITMOK") {
        otp["deliveryStatus"] = "dqrfa";
      }
      otp["updated_at"] = new Date();

      await self.dao.model.update(otp, whereObj);
      return system.getResultSuccess();
    })
  }
  async tmConfirm(obj) {
    var self = this;
    var channelUserId = obj.channelUserId;
    var deliveryOrderNo = obj.deliveryOrderNo;
    var isConfirm = obj.isConfirm;
    if (!channelUserId) {
      return system.getResultFail(-101, "渠道用户id不能为空");
    }
    if (!deliveryOrderNo) {
      return system.getResultFail(-102, "交付单号不能为空");
    }
    if (!isConfirm) {
      return system.getResultFail(-103, "确认码不能为空");
    }
    //获取交付单信息
    var ordertmproduct = await this.ordertmproductDao.model.findOne({
      where: { deliveryOrderNo: deliveryOrderNo },
      raw: true
    });
    if (!ordertmproduct || !ordertmproduct.id) {
      return system.getResultFail(-104, "未知支付单");
    }
    if (ordertmproduct.deliveryStatus != "dqrfa") {
      return system.getResultFail(-105, "方案确认失败，该方案交付状态为" + ordertmproduct.deliveryStatusName);
    }
    // if(ordertmproduct.channelUserId!=channelUserId){
    //   return system.getResultFail(-105, "方案确认失败，只能确认自己的商标方案");
    // }
    return await self.db.transaction(async function (t) {
      var otpObj = { id: ordertmproduct.id };
      if (isConfirm == "0") {
        if (!obj.notes) {
          return system.getResultFail(-106, "方案确认失败，不通过原因不能为空");
        }
        otpObj["deliveryStatus"] = "fabtg";
        otpObj["notes"] = obj.notes;
      }
      if (isConfirm == "1") {
        otpObj["deliveryStatus"] = "dsh";
        otpObj["notes"] = obj.notes || "";
        var tmObj = { deliveryOrderNo: deliveryOrderNo, officialType: "dsh" };
        await self.trademarkDao.model.update(tmObj, { where: { deliveryOrderNo: deliveryOrderNo }, transaction: t });
      }
      await self.dao.update(otpObj, t);
      return system.getResultSuccess();
    })
  }
  //------------------------接收辅助注册商标数据--------end---------------------------------------------------------
}



module.exports = OrderTmProductService;
